/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.bx.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysRemindProvideService;
import cn.smarthse.modules.health.bx.entity.BxLastMonthZybSummary;
import cn.smarthse.modules.health.bx.service.IBxLastMonthZybSummaryService;
import cn.smarthse.services.bx.mapper.BxLastMonthZybSummaryMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@DubboService
public class BxLastMonthZybSummaryServiceImpl
extends ServiceImpl<BxLastMonthZybSummaryMapper, BxLastMonthZybSummary>
implements IBxLastMonthZybSummaryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BxLastMonthZybSummaryServiceImpl.class);
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyService;
    @Autowired
    private DataSourceTransactionManager txManager;
    @DubboReference
    private ISysRemindProvideService remindProvideService;

    public List<String> saveOrUpdateData(List<BxLastMonthZybSummary> lastMonthZybSummaryList) {
        if (CollectionUtils.isEmpty(lastMonthZybSummaryList)) {
            return null;
        }
        for (BxLastMonthZybSummary bxLastMonthZybSummary : lastMonthZybSummaryList) {
            bxLastMonthZybSummary.setIsSync(Boolean.valueOf(false));
            bxLastMonthZybSummary.setIsValid(Boolean.valueOf(true));
            bxLastMonthZybSummary.setCreateDate(new Date());
        }
        int batchSize = 1000;
        ArrayList<String> failIds = new ArrayList<String>();
        for (List bxLastMonthZybSummaries : ListUtil.partition(lastMonthZybSummaryList, (int)1000)) {
            List codeList = bxLastMonthZybSummaries.stream().map(BxLastMonthZybSummary::getCreditCode).collect(Collectors.toList());
            List nameCodeByCodes = this.companyService.getNameCodeByCodes(codeList);
            if (CollectionUtils.isNotEmpty((Collection)nameCodeByCodes)) {
                Map<String, List<CompanySuperviseModel>> codeCompanyList = nameCodeByCodes.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
                for (BxLastMonthZybSummary bxLastMonthZybSummary : bxLastMonthZybSummaries) {
                    List<CompanySuperviseModel> companySuperviseModels = codeCompanyList.get(bxLastMonthZybSummary.getCreditCode());
                    for (CompanySuperviseModel companySuperviseModel : companySuperviseModels) {
                        String companyName = companySuperviseModel.getName();
                        String companyName2 = bxLastMonthZybSummary.getCompanyName();
                        companyName = StringUtils.toDBC((String)companyName).replaceAll("\uff08", "(").replaceAll("\uff09", ")");
                        companyName2 = StringUtils.toDBC((String)companyName2).replaceAll("\uff08", "(").replaceAll("\uff09", ")");
                        if (!Objects.equals(StringUtils.trim((String)companyName), StringUtils.trim((String)companyName2))) continue;
                        bxLastMonthZybSummary.setCompanyId(companySuperviseModel.getId());
                    }
                }
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                this.saveOrUpdateBatch(bxLastMonthZybSummaries, batchSize);
                this.txManager.commit(status);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)e);
                failIds.addAll(bxLastMonthZybSummaries.stream().map(BxLastMonthZybSummary::getRiskMainpartId).collect(Collectors.toList()));
                this.txManager.rollback(status);
            }
        }
        this.remindProvideService.sendRemind("monitorservice:BxLastMonthZybSummaryServiceImpl:saveOrUpdateData", "\u3010\u63d0\u9192\u3011\uff08\u7591\u4f3c\uff09\u804c\u4e1a\u75c5\u75c5\u4eba\u7ebf\u7d22\u6709\u65b0\u63a8\u9001\u8bb0\u5f55\uff0c\u8bf7\u5373\u65f6\u5904\u7406\uff01", "\u3010\u63d0\u9192\u3011\uff08\u7591\u4f3c\uff09\u804c\u4e1a\u75c5\u75c5\u4eba\u7ebf\u7d22\u6709\u65b0\u63a8\u9001\u8bb0\u5f55\uff0c\u8bf7\u5373\u65f6\u5904\u7406\uff01");
        return failIds;
    }

    public BxLastMonthZybSummary getBxLastMonthZybSummary(Long id) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(BxLastMonthZybSummary.class);
        queryWrapper.eq(BxLastMonthZybSummary::getId, (Object)id);
        return (BxLastMonthZybSummary)((BxLastMonthZybSummaryMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    public void saveCompanyData(BxLastMonthZybSummary bx) {
        ((BxLastMonthZybSummaryMapper)this.baseMapper).updateById(bx);
    }

    public List<BxLastMonthZybSummary> listWaitInCompany() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(BxLastMonthZybSummary.class);
        queryWrapper.isNull(BxLastMonthZybSummary::getCompanyId);
        queryWrapper.eq(BxLastMonthZybSummary::getIsValid, (Object)true);
        return ((BxLastMonthZybSummaryMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    public void updateBxLastMonthZybSummary(List<BxLastMonthZybSummary> lastMonthZybSummaryList) {
        if (CollectionUtils.isEmpty(lastMonthZybSummaryList)) {
            return;
        }
        for (BxLastMonthZybSummary bxLastMonthZybSummary : lastMonthZybSummaryList) {
            ((BxLastMonthZybSummaryMapper)this.baseMapper).updateById(bxLastMonthZybSummary);
        }
    }
}

