/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.bx.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.crypto.digest.MD5;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.file.FileUploadSimple;
import cn.smarthse.common.framework.file.UploadFileParameter;
import cn.smarthse.common.framework.file.UploadFilePathEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.bx.entity.BxFileInfo;
import cn.smarthse.modules.health.bx.entity.BxFxhj;
import cn.smarthse.modules.health.bx.entity.BxReformAccept;
import cn.smarthse.modules.health.bx.model.CompanyRegionModel;
import cn.smarthse.modules.health.bx.param.BxFileInfoParam;
import cn.smarthse.modules.health.bx.param.BxFxhjAppendParam;
import cn.smarthse.modules.health.bx.param.BxFxhjSearchParam;
import cn.smarthse.modules.health.bx.service.IBxFileInfoService;
import cn.smarthse.modules.health.bx.service.IBxFxhjService;
import cn.smarthse.modules.health.bx.service.IBxReformAcceptService;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformItemTypeEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.OnlineDeviceHomeData;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.RiskWarningCompanyArea;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.sys.model.SysFile;
import cn.smarthse.modules.sys.enumd.BusinessStatusEnum;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.services.bx.mapper.BxFxhjMapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Service(value="bxFxhjService")
@DubboService
public class BxFxhjServiceImpl
extends ServiceImpl<BxFxhjMapper, BxFxhj>
implements IBxFxhjService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BxFxhjServiceImpl.class);
    private ThreadPoolExecutor homeCountThreadpool = new ThreadPoolExecutor(4, 30, 2L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(50), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    @Autowired
    private BxFxhjMapper bxFxhjMapper;
    @Autowired
    private IBxReformAcceptService bxReformAcceptService;
    @Autowired
    private IBxFileInfoService bxFileInfoService;
    @Autowired
    private DataSourceTransactionManager txManager;
    @Autowired
    private OssClientBean ossClientBean;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    public Cache<String, List<AreaModel>> areaCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.DAYS).maximumSize(Integer.MAX_VALUE).build();

    public String appendData(List<BxFxhjAppendParam> paramList, HttpServletRequest request, HttpServletResponse response) {
        Date nowDate = new Date();
        ArrayList failIds = new ArrayList();
        AtomicReference msg = new AtomicReference();
        ArrayList<BxFxhj> bxFxhjList = new ArrayList<BxFxhj>();
        ArrayList<BxReformAccept> bxReformAcceptList = new ArrayList<BxReformAccept>();
        ArrayList bxReformList = new ArrayList();
        ArrayList bxAcceptList = new ArrayList();
        ArrayList bxBackgroundList = new ArrayList();
        ArrayList<BxFileInfo> bxRiskVedioList = new ArrayList<BxFileInfo>();
        for (BxFxhjAppendParam param : paramList) {
            boolean complete;
            BxFxhj bxFxhj = new BxFxhj();
            cn.smarthse.common.util.BeanUtils.copyBeanProp((Object)bxFxhj, (Object)param);
            boolean bl = complete = Objects.equals(ReformStatusEnum.WC.getValue(), (byte)bxFxhj.getStatus().intValue()) || Objects.equals(ReformStatusEnum.WXZG.getValue(), (byte)bxFxhj.getStatus().intValue()) || Objects.equals(ReformStatusEnum.QDZF.getValue(), (byte)bxFxhj.getStatus().intValue());
            if (!complete) {
                return "\u65e0\u6cd5\u63a5\u6536\u6b64\u6574\u6539\u72b6\u6001\uff1a" + bxFxhj.getStatus();
            }
            bxFxhj.setId(Long.valueOf(IdWorker.getId()));
            bxFxhj.setCreateDate(nowDate);
            bxFxhj.setUpdateDate(nowDate);
            bxFxhj.setIsValid(Boolean.valueOf(true));
            bxFxhj.setCreateBy(Long.valueOf(0L));
            bxFxhj.setUpdateBy(Long.valueOf(0L));
            if (param.getReformList() == null) {
                return "\u6574\u6539\u53ca\u9a8c\u6536\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a\uff01";
            }
            List reformAcceptListParam = param.getReformList();
            reformAcceptListParam.forEach(reformAcceptParam -> {
                BxReformAccept reformAccept = new BxReformAccept();
                cn.smarthse.common.util.BeanUtils.copyBeanProp((Object)reformAccept, (Object)reformAcceptParam);
                reformAccept.setId(Long.valueOf(IdWorker.getId()));
                reformAccept.setRiskId(bxFxhj.getId());
                reformAccept.setCreateDate(nowDate);
                reformAccept.setUpdateDate(nowDate);
                reformAccept.setIsValid(Boolean.valueOf(true));
                reformAccept.setCreateBy(Long.valueOf(0L));
                reformAccept.setUpdateBy(Long.valueOf(0L));
                bxReformAcceptList.add(reformAccept);
                if (reformAcceptParam.getReformFiles() == null) {
                    msg.set("\u6574\u6539\u4f50\u8bc1\u6750\u6599\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                    return;
                }
                List reformFileListParam = reformAcceptParam.getReformFiles();
                reformFileListParam.forEach(reformFileParam -> {
                    BxFileInfo reformFile = new BxFileInfo();
                    cn.smarthse.common.util.BeanUtils.copyBeanProp((Object)reformFile, (Object)reformFileParam);
                    reformFile.setId(Long.valueOf(IdWorker.getId()));
                    reformFile.setType(Integer.valueOf(1));
                    reformFile.setFkId(reformAccept.getId());
                    reformFile.setCreateDate(nowDate);
                    reformFile.setUpdateDate(nowDate);
                    reformFile.setIsValid(Boolean.valueOf(true));
                    reformFile.setCreateBy(Long.valueOf(0L));
                    reformFile.setUpdateBy(Long.valueOf(0L));
                    bxReformList.add(reformFile);
                });
                if (reformAcceptParam.getAcceptanceFiles() == null) {
                    msg.set("\u9a8c\u6536\u4f50\u8bc1\u6750\u6599\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                    return;
                }
                List acceptanceFileListParam = reformAcceptParam.getAcceptanceFiles();
                acceptanceFileListParam.forEach(acceptanceFileParam -> {
                    BxFileInfo acceptanceFile = new BxFileInfo();
                    cn.smarthse.common.util.BeanUtils.copyBeanProp((Object)acceptanceFile, (Object)acceptanceFileParam);
                    acceptanceFile.setId(Long.valueOf(IdWorker.getId()));
                    acceptanceFile.setType(Integer.valueOf(2));
                    acceptanceFile.setFkId(reformAccept.getId());
                    acceptanceFile.setCreateDate(nowDate);
                    acceptanceFile.setUpdateDate(nowDate);
                    acceptanceFile.setIsValid(Boolean.valueOf(true));
                    acceptanceFile.setCreateBy(Long.valueOf(0L));
                    acceptanceFile.setUpdateBy(Long.valueOf(0L));
                    bxAcceptList.add(acceptanceFile);
                });
            });
            if (param.getRiskBackgroud() == null) {
                return "\u4ea7\u751f\u98ce\u9669\u65f6\u7684\u76f8\u5173\u56fe\u7247\u4e0d\u53ef\u4e3a\u7a7a\uff01";
            }
            List backgroundListParam = param.getRiskBackgroud();
            backgroundListParam.forEach(backgroundParam -> {
                BxFileInfo background = new BxFileInfo();
                cn.smarthse.common.util.BeanUtils.copyBeanProp((Object)background, (Object)backgroundParam);
                background.setId(Long.valueOf(IdWorker.getId()));
                background.setType(Integer.valueOf(3));
                background.setFkId(bxFxhj.getId());
                background.setCreateDate(nowDate);
                background.setUpdateDate(nowDate);
                background.setIsValid(Boolean.valueOf(true));
                background.setCreateBy(Long.valueOf(0L));
                background.setUpdateBy(Long.valueOf(0L));
                bxBackgroundList.add(background);
            });
            if (param.getRiskVedio() != null) {
                BxFileInfoParam riskVideoParam = param.getRiskVedio();
                BxFileInfo riskVideo = new BxFileInfo();
                cn.smarthse.common.util.BeanUtils.copyBeanProp((Object)riskVideo, (Object)riskVideoParam);
                riskVideo.setId(Long.valueOf(IdWorker.getId()));
                riskVideo.setType(Integer.valueOf(4));
                riskVideo.setFkId(bxFxhj.getId());
                riskVideo.setCreateDate(nowDate);
                riskVideo.setUpdateDate(nowDate);
                riskVideo.setIsValid(Boolean.valueOf(true));
                riskVideo.setCreateBy(Long.valueOf(0L));
                riskVideo.setUpdateBy(Long.valueOf(0L));
                bxRiskVedioList.add(riskVideo);
            }
            bxFxhjList.add(bxFxhj);
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            int totalSize = bxFxhjList.size();
            int batchSize = 1000;
            for (int i = 0; i < totalSize; i += batchSize) {
                List batch = bxFxhjList.subList(i, Math.min(i + batchSize, totalSize));
                try {
                    this.saveOrUpdateBatch(batch, batchSize);
                    continue;
                }
                catch (Exception e) {
                    failIds.addAll(batch.stream().map(BxFxhj::getId).collect(Collectors.toList()));
                }
            }
            ArrayList<BxFileInfo> bxFileInfoList = new ArrayList<BxFileInfo>();
            bxFileInfoList.addAll(bxReformList);
            bxFileInfoList.addAll(bxAcceptList);
            bxFileInfoList.addAll(bxBackgroundList);
            bxFileInfoList.addAll(bxRiskVedioList);
            for (BxFileInfo bxFileInfo : bxFileInfoList) {
                String fileUrl = bxFileInfo.getFileUrl();
                String fileName = bxFileInfo.getFileName();
                InputStream fileUrlIs = BxFxhjServiceImpl.getInputStreamByUrl(fileUrl);
                if (fileUrlIs == null) {
                    return fileUrl + " \u6587\u4ef6\u5730\u5740\u89e3\u6790\u5931\u8d25\uff01";
                }
                ByteArrayOutputStream baOs = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = fileUrlIs.read(buffer)) != -1) {
                    baOs.write(buffer, 0, bytesRead);
                }
                byte[] fileBytes = baOs.toByteArray();
                if (ObjectUtils.isEmpty((Object)fileUrlIs)) continue;
                int dotIdx = fileName.lastIndexOf(".");
                if (dotIdx == -1) {
                    return "\u8bf7\u4f20\u5165\u6587\u4ef6\u540e\u7f00\u540d\uff01[" + fileName + "]";
                }
                String name = fileName.substring(0, dotIdx);
                MockMultipartFile multipartFile = new MockMultipartFile(name, fileName, "", fileBytes);
                SysFileModel ossFile = this.uploadMultipartFileToOss(request, (MultipartFile)multipartFile);
                bxFileInfo.setId(ossFile.getId());
                bxFileInfo.setFileUrl(ossFile.getOssUrl());
                bxFileInfo.setFileName(ossFile.getFileName());
            }
            List errIds1 = this.bxReformAcceptService.saveOrUpdateData(bxReformAcceptList);
            List errIds2 = this.bxFileInfoService.saveOrUpdateData(bxFileInfoList);
            if (!errIds1.isEmpty() || !errIds2.isEmpty()) {
                this.txManager.rollback(status);
                return "\u5bf9\u63a5\u6570\u636e\u5b8c\u6210\uff0c\u5b58\u50a8\u4e1a\u52a1\u6570\u636e\u5931\u8d25";
            }
            this.putDataIntoReformTable(bxFxhjList, bxReformAcceptList, bxFileInfoList, nowDate);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            log.error("error", (Throwable)e);
            return e.toString();
        }
        return BusinessStatusEnum.SUCCESS.getName();
    }

    public void saveFileByDirectory(MultipartFile file) {
        try {
            String uuid = UUID.randomUUID().toString();
            String originalName = file.getOriginalFilename();
            String ext = "." + FilenameUtils.getExtension((String)originalName);
            String fileName = uuid + ext;
            File targetFile = new File("C:\\Users\\26632\\Pictures\\JianAn", fileName);
            FileUtils.writeByteArrayToFile((File)targetFile, (byte[])file.getBytes());
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58\u6587\u4ef6\u5230\u670d\u52a1\u5668\uff08\u672c\u5730\uff09\u5931\u8d25", (Throwable)e);
        }
    }

    public SysFileModel uploadMultipartFileToOss(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) throws IOException {
        String fileHash = String.valueOf(MD5.create().digestHex(fileData.getBytes()));
        SysFileModel existSysFile = this.getFileByHash(fileHash);
        String ossFileName = FileUploadSimple.getNumberName((String)FileUtil.getSuffix((String)fileData.getOriginalFilename()));
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.supervise_05.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator;
        String realPath = this.ossClientBean.getLocal() + uploadDir + ossFileName;
        String ossUrl = (uploadDir + ossFileName).replace("\\", "/");
        cn.smarthse.common.framework.file.FileUtil.writeFromStream((InputStream)fileData.getInputStream(), (String)realPath);
        SysFileModel file = new SysFileModel();
        file.setResource(Integer.valueOf(FileResourceEnum.supervise_05.getValue()));
        file.setFileName(fileData.getOriginalFilename());
        file.setFileSize(String.valueOf(fileData.getSize()));
        file.setFileExt(FileUtil.getSuffix((String)fileData.getOriginalFilename()));
        file.setFileHash(fileHash);
        file.setCreatorIp(StringUtils.getRemoteAddr((HttpServletRequest)request));
        file.setOssUrl(ossUrl);
        log.debug("\u4e0a\u4f20\u6587\u4ef6\uff1a{}", (Object)file.getFileName());
        if (this.ossClientBean.isAsynch()) {
            this.ossClientBean.OSSPutObject(ossFileName, new File(realPath), uploadDir, file.getFileName());
            log.debug("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\uff1a{}", (Object)realPath);
            FileUtil.del((String)realPath);
        }
        file = this.addSysFile(file, 0L);
        return file;
    }

    public SysFileModel addSysFile(SysFileModel fileModel, Long adminId) {
        SysFile sysFile = new SysFile();
        BeanUtils.copyProperties((Object)fileModel, (Object)sysFile);
        SysFile result = this.add(sysFile, adminId);
        if (result != null) {
            fileModel.setId(result.getId());
        }
        fileModel.setFullOssurl(this.ossClientBean.getUrl(result.getOssUrl()));
        fileModel.setOssUrl(fileModel.getFullOssurl());
        return fileModel;
    }

    public SysFile add(SysFile entity, Long createBy) {
        Date date = new Date();
        entity.setId(Long.valueOf(IdWorker.getId()));
        entity.setCreateBy(createBy);
        entity.setCreateDate(date);
        entity.setUpdateBy(createBy);
        entity.setUpdateDate(date);
        entity.setIsValid(Global.TRUE);
        this.bxFxhjMapper.insertSysFile(entity);
        return entity;
    }

    public SysFileModel getFileByHash(String fileHash) {
        if (StringUtils.isEmpty((CharSequence)fileHash)) {
            throw new ServiceException("\u6587\u4ef6hash\u503c\u4e3a\u7a7a\uff01");
        }
        SysFile sysFile = this.getFileByHash1(fileHash);
        if (sysFile == null) {
            return null;
        }
        sysFile.setFullOssurl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        return this.toggleSysFile(sysFile);
    }

    public SysFile getFileByHash1(String filehash) {
        SysFile file = new SysFile();
        file.setFileHash(filehash);
        file.setIsValid(Boolean.valueOf(true));
        List<SysFile> sysFiles = this.bxFxhjMapper.selectSysFileCondition(file);
        return CollectionUtils.isEmpty(sysFiles) ? null : sysFiles.get(0);
    }

    private SysFileModel toggleSysFile(SysFile record) {
        if (record == null) {
            return null;
        }
        SysFileModel model = new SysFileModel();
        model.setId(record.getId());
        model.setFileName(record.getFileName());
        model.setFileSize(record.getFileSize());
        model.setFileExt(record.getFileExt());
        model.setOssUrl(record.getOssUrl());
        model.setFullOssurl(record.getFullOssurl());
        model.setOssUrl(record.getOssUrl());
        model.setCreateDate(record.getCreateDate());
        model.setUpdateDate(record.getUpdateDate());
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getInputStreamByUrl(String strUrl) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(strUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(1500);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)output);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5730\u5740\u83b7\u5f97\u6570\u636e\u7684\u8f93\u5165\u6d41\u5f02\u5e38 Exception\uff0c", (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Exception e) {
                log.error("\u65ad\u5f00\u8f93\u5165\u6d41\u5f02\u5e38 Exception\uff0c", (Throwable)e);
            }
        }
        return null;
    }

    private void putDataIntoReformTable(List<BxFxhj> bxFxhjList, List<BxReformAccept> bxReformAcceptList, List<BxFileInfo> bxFileInfoList, Date nowDate) {
        List<Long> cidList = bxFxhjList.stream().map(BxFxhj::getCid).collect(Collectors.toList());
        List<Object> allTypeList = this.bxFxhjMapper.getReformItemSourceList2(cidList);
        allTypeList = allTypeList.parallelStream().filter(Objects::nonNull).peek(item -> {
            if (CollectionUtils.isNotEmpty((Collection)item.getAceptanceList())) {
                Map collect = item.getAceptanceList().parallelStream().filter(temp -> temp != null && temp.getCreateDate() != null && temp.getCid() != null).collect(Collectors.toMap(ReformItemAcceptanceRecord::getCid, Function.identity(), (k1, k2) -> k1.getCreateDate().after(k2.getCreateDate()) ? k1 : k2));
                item.setAcceptance((ReformItemAcceptanceRecord)collect.get(item.getCid()));
            }
        }).collect(Collectors.toList());
        Map<Object, Object> comRegionMap = new HashMap();
        if (CollUtil.isNotEmpty(cidList)) {
            List<CompanyRegionModel> comRegionList = this.bxFxhjMapper.getRegionByCidBatch(cidList);
            comRegionMap = comRegionList.stream().collect(Collectors.toMap(CompanyRegionModel::getCid, Function.identity(), (v1, v2) -> v1));
        }
        ArrayList<ReformItemBasic> reformBasicList = new ArrayList<ReformItemBasic>();
        ArrayList<ReformItemAcceptanceRecord> reformAcceptList = new ArrayList<ReformItemAcceptanceRecord>();
        for (BxFxhj bxFxhj : bxFxhjList) {
            SysArea region;
            Long cid = bxFxhj.getCid();
            ReformItemBasic basic = new ReformItemBasic();
            basic.setId(Long.valueOf(IdWorker.getId()));
            basic.setCid(cid);
            basic.setName(bxFxhj.getRiskName());
            CompanyRegionModel cr = (CompanyRegionModel)comRegionMap.get(cid);
            if (cr != null && (region = cr.getRegion()) != null) {
                basic.setAreaId(region.getId());
                basic.setAreaId1(region.getProvinceId());
                basic.setAreaId2(region.getCityId());
                basic.setAreaId3(region.getAreaId());
                basic.setAreaId4(region.getStreetId());
            }
            basic.setFinderName(bxFxhj.getFinder());
            basic.setFindTime(bxFxhj.getFindTime());
            basic.setGenerationSource(Byte.valueOf(bxFxhj.getRiskType() == null ? ReformGenerationSourceEnum.ZXJCJK.getValue() : (byte)bxFxhj.getRiskType().intValue()));
            basic.setDescription(bxFxhj.getRiskDesc());
            basic.setStatus(Byte.valueOf((byte)bxFxhj.getStatus().intValue()));
            basic.setReformItemSource(Byte.valueOf(bxFxhj.getReformItemSource() == null ? ReformSourceLiteEnum.ZXJCJK.getValue() : (byte)bxFxhj.getReformItemSource().intValue()));
            basic.setCreateDate(nowDate);
            basic.setUpdateDate(nowDate);
            basic.setIsValid(Boolean.valueOf(true));
            String reformItemFiles = bxFileInfoList.stream().filter(f -> Objects.equals(f.getFkId(), bxFxhj.getId())).map(f -> String.valueOf(f.getId())).collect(Collectors.joining(","));
            basic.setReformItemFiles(reformItemFiles);
            reformBasicList.add(basic);
            List bxReformAcceptSubList = bxReformAcceptList.stream().filter(bxRa -> Objects.equals(bxRa.getRiskId(), bxFxhj.getId())).collect(Collectors.toList());
            for (BxReformAccept bxRa2 : bxReformAcceptSubList) {
                ReformItemAcceptanceRecord acce = new ReformItemAcceptanceRecord();
                acce.setId(Long.valueOf(IdWorker.getId()));
                acce.setCid(basic.getCid());
                acce.setReformItemId(basic.getId());
                acce.setReformDirectorName(bxRa2.getReformDirector());
                acce.setReformMeasure(bxRa2.getReformSolution());
                acce.setRequireFinishTime(bxRa2.getRequireFinishTime());
                acce.setActualFinishTime(bxRa2.getActualFinishTime());
                acce.setAcceptanceDirectorName(bxRa2.getAcceptanceDirector());
                acce.setAcceptanceDate(bxRa2.getAcceptanceDate());
                acce.setAcceptanceResult(Byte.valueOf((byte)bxRa2.getAcceptanceResult().intValue()));
                acce.setStatus(Byte.valueOf((byte)bxRa2.getStatus().intValue()));
                acce.setCreateDate(nowDate);
                acce.setUpdateDate(nowDate);
                acce.setIsValid(Boolean.valueOf(true));
                String reformFinishedFiles = bxFileInfoList.stream().filter(f -> Objects.equals(f.getFkId(), bxRa2.getId()) && Objects.equals(f.getType(), 1)).map(f -> String.valueOf(f.getId())).collect(Collectors.joining(","));
                String acceptanceFiles = bxFileInfoList.stream().filter(f -> Objects.equals(f.getFkId(), bxRa2.getId()) && Objects.equals(f.getType(), 2)).map(f -> String.valueOf(f.getId())).collect(Collectors.joining(","));
                acce.setReformFinishedFiles(reformFinishedFiles);
                acce.setAcceptanceFiles(acceptanceFiles);
                reformAcceptList.add(acce);
            }
        }
        this.bxFxhjMapper.insertReformItemBasicBatch(reformBasicList);
        this.bxFxhjMapper.insertReformItemAcceptanceRecordBatch(reformAcceptList);
    }

    public void processDataAndAutoGenerateReform(List<ReformItemBasic> reformBasicList, List<ReformItemAcceptanceRecord> reformAcceptList, List<ReformItemBasic> allTypeList) {
        for (ReformItemBasic basic : reformBasicList) {
            basic.setBusinessStatus(StatusEnum.none.getValue());
            basic.setReformItemSourceId(null);
            basic.setIsAutoGeneration(Boolean.valueOf(true));
            basic.setDataSource(Byte.valueOf((byte)10));
            basic.setIsShowInReformModular(Boolean.valueOf(true));
            String descriptionMore = "";
            ReformGenerationSourceEnum source = ReformGenerationSourceEnum.getByType((Byte)basic.getGenerationSource());
            List reformAcceptSubList = reformAcceptList.stream().filter(ra -> Objects.equals(ra.getReformItemId(), basic.getId())).collect(Collectors.toList());
            for (ReformItemAcceptanceRecord acce : reformAcceptSubList) {
                acce.setStatus(Byte.valueOf((byte)3));
            }
            switch (source) {
                case ZRZC: {
                    basic.setAcceptanceObject(Byte.valueOf((byte)1));
                    break;
                }
                case SFTG: {
                    basic.setAcceptanceObject(Byte.valueOf((byte)3));
                    break;
                }
                case JCCB: {
                    basic.setAcceptanceObject(Byte.valueOf((byte)2));
                    basic.setReformItemType(ReformItemTypeEnum.workPlace.getValue());
                    basic.setIsShowInReformModular(Boolean.valueOf(true));
                    break;
                }
                case JJZ: 
                case YSZYB: 
                case FC: 
                case ZYB: {
                    basic.setAcceptanceObject(Byte.valueOf((byte)2));
                    basic.setReformItemType(ReformItemTypeEnum.employees.getValue());
                    break;
                }
                case ZXJC: {
                    basic.setAcceptanceObject(Byte.valueOf((byte)2));
                    basic.setReformItemPositionName("/");
                    break;
                }
                case ZXJK: {
                    basic.setAcceptanceObject(Byte.valueOf((byte)2));
                    basic.setReformItemPositionName("/");
                    break;
                }
                case TJ: 
                case DECLARE: 
                case THREE_TIME: 
                case DETECTION: 
                case PROTECTION: 
                case WARNING_SIGNS: 
                case TRAIN: 
                case ARCHIVES: 
                case NOZYFZR: 
                case NOGLRY: {
                    basic.setAcceptanceObject(Byte.valueOf((byte)1));
                    basic.setDescription(basic.getDescription() + descriptionMore);
                    break;
                }
            }
        }
    }

    public List<Byte> getGenerationSourceValue() {
        return Arrays.asList(ReformGenerationSourceEnum.TJ.getValue(), ReformGenerationSourceEnum.DECLARE.getValue(), ReformGenerationSourceEnum.THREE_TIME.getValue(), ReformGenerationSourceEnum.DETECTION.getValue(), ReformGenerationSourceEnum.PROTECTION.getValue(), ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), ReformGenerationSourceEnum.TRAIN.getValue(), ReformGenerationSourceEnum.ARCHIVES.getValue(), ReformGenerationSourceEnum.NOZYFZR.getValue(), ReformGenerationSourceEnum.NOGLRY.getValue());
    }

    public List<ReformItemBasic> getReformItemSourceList2(ReformItemBasic reform, Integer type, List<ReformItemBasic> allTypeList) {
        if (reform == null || reform.getCid() == null || reform.getGenerationSource() == null) {
            return Collections.emptyList();
        }
        List<Byte> generationSourceValueList = this.getGenerationSourceValue();
        List<Byte> tjGenerationSourceValueList = this.getTjGenerationSourceValue();
        List<Object> list = new ArrayList<ReformItemBasic>();
        if (generationSourceValueList.contains(reform.getGenerationSource())) {
            List allList = allTypeList.parallelStream().filter(Objects::nonNull).filter(item -> {
                if (item.getCid().equals(reform.getCid()) && item.getGenerationSource() != null && reform.getGenerationSource() != null && item.getGenerationSource().equals(reform.getGenerationSource())) {
                    return reform.getBatchNum() == null || reform.getBatchNum() != null && reform.getBatchNum().equals(item.getBatchNum());
                }
                return false;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(allList)) {
                allList = new ArrayList();
            } else {
                allTypeList.removeAll(allList);
            }
            if (type == 0) {
                list = allList;
            } else if (type == 1) {
                list = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() != 7).collect(Collectors.toList());
                ReformItemBasic townshipReform = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() == 7).max((o1, o2) -> o1.getFindTime().compareTo(o2.getFindTime())).orElse(null);
                if (townshipReform != null) {
                    list.add(townshipReform);
                }
            } else if (type == 2) {
                list = allList.stream().filter(item -> item.getReformItemSource() != null && item.getReformItemSource().intValue() == 7 && Objects.equals(item.getId(), reform.getId())).collect(Collectors.toList());
            }
            Date date = list.stream().map(ReformItemBasic::getFindTime).min(Comparator.comparing(x -> x)).orElse(null);
            if (date != null) {
                for (ReformItemBasic reformItemBasic : list) {
                    reformItemBasic.setFindTime(date);
                }
            }
        } else if (tjGenerationSourceValueList.contains(reform.getGenerationSource())) {
            list.add(reform);
        } else {
            reform.setGenerationSourceStr("\u5176\u4ed6");
            list.add(reform);
        }
        return list;
    }

    private List<Byte> getTjGenerationSourceValue() {
        return Arrays.asList(ReformGenerationSourceEnum.YSZYB.getValue(), ReformGenerationSourceEnum.ZYB.getValue(), ReformGenerationSourceEnum.JJZ.getValue(), ReformGenerationSourceEnum.JCCB.getValue(), ReformGenerationSourceEnum.FC.getValue(), ReformGenerationSourceEnum.JCCB.getValue());
    }

    public OnlineDeviceHomeData getReformData(HomeIndexSearchVo searchVo) {
        OnlineDeviceHomeData reformData = ((BxFxhjMapper)this.baseMapper).getReformData(searchVo);
        reformData.setDefuseNumRate(reformData.getDefuseNumRateStr());
        return reformData;
    }

    public OnlineDeviceHomeData getMonitorRiskDataHeadRank(BxFxhjSearchParam searchVo) {
        List<OnlineDeviceHomeData> list;
        if (searchVo.getAreaLevel().intValue() >= 3) {
            searchVo.setIsCurrent(Boolean.valueOf(true));
        }
        if (CollectionUtils.isNotEmpty(list = ((BxFxhjMapper)this.baseMapper).getMonitorRiskDataHeadRank(searchVo)) && list.get(0).getProvinceId() != null) {
            OnlineDeviceHomeData data = list.get(0);
            if (searchVo.getAreaLevel().intValue() == 1) {
                data.setCurrentHeadAreaName(data.getProvinceName());
                data.setCurrentHeadAreaId(data.getProvinceId());
            } else if (searchVo.getAreaLevel().intValue() == 2) {
                if (searchVo.getIsCurrent() != null && searchVo.getIsCurrent().booleanValue()) {
                    data.setCurrentHeadAreaName(data.getCityName() + "\u672c\u7ea7");
                    data.setCurrentHeadAreaId(data.getCityId());
                    data.setOnlyThisLevelArea(Boolean.valueOf(true));
                    data.setOnlyThisLevelAreaId(data.getCityId());
                } else {
                    data.setCurrentHeadAreaName(data.getCityName());
                    data.setCurrentHeadAreaId(data.getCityId());
                }
            } else if (searchVo.getAreaLevel().intValue() == 3) {
                data.setCurrentHeadAreaName(data.getAreaName());
                data.setCurrentHeadAreaId(data.getAreaId());
            } else if (searchVo.getAreaLevel().intValue() == 4) {
                data.setCurrentHeadAreaName(data.getStreetName());
                data.setCurrentHeadAreaId(data.getStreetId());
            }
            data.setDefuseNumRate(data.getDefuseNumRateStr() + "%");
            data.setLawNumRate(data.getLawNumRateStr() + "%");
            return data;
        }
        AreaModel model = this.sysAreaProvideService.getAreaById(searchVo.getAreaId());
        OnlineDeviceHomeData data = new OnlineDeviceHomeData().setProvinceId(model.getProvinceId()).setProvinceName(model.getProvinceName()).setCityId(model.getCityId()).setCityName(model.getCityName()).setAreaId(model.getAreaId()).setAreaName(model.getAreaName()).setStreetId(model.getStreetId()).setStreetName(model.getStreetName()).setRiskNum(Integer.valueOf(0)).setDefuseNum(Integer.valueOf(0)).setLawNum(Integer.valueOf(0)).setLawCompanyNum(Integer.valueOf(0)).setDefuseNumRate("0.00%").setLawNumRate("0.00%").setCurrentHeadAreaName(model.getName()).setCurrentHeadAreaId(model.getId());
        return data;
    }

    public List<OnlineDeviceHomeData> getMonitorRiskDataListRank(BxFxhjSearchParam searchVo) {
        List<OnlineDeviceHomeData> list;
        if (searchVo.getAreaLevel().intValue() > 3) {
            return Collections.emptyList();
        }
        if (searchVo.getIsCity().booleanValue() || searchVo.getIsCounty().booleanValue()) {
            list = ((BxFxhjMapper)this.baseMapper).getMonitorRiskDataListRankAll(searchVo);
            if (searchVo.getIsCity().booleanValue()) {
                this.setSupplementAreaInfo(searchVo.getAreaId(), searchVo.getAreaLevel().intValue(), list, searchVo);
            }
            if (searchVo.getIsCounty().booleanValue()) {
                this.setSupplementAreaInfo(searchVo.getAreaId(), 5, list, searchVo);
            }
        } else if (searchVo.getAreaLevel().intValue() == 2 && searchVo.getIsCurrent() != null && searchVo.getIsCurrent().booleanValue()) {
            list = ((BxFxhjMapper)this.baseMapper).getMonitorRiskDataListRank(searchVo);
        } else {
            list = ((BxFxhjMapper)this.baseMapper).getMonitorRiskDataListRank(searchVo);
            this.setSupplementAreaInfo(searchVo.getAreaId(), searchVo.getAreaLevel().intValue(), list, searchVo);
            if (CollectionUtils.isNotEmpty(list) && list.get(0).getProvinceId() != null && searchVo.getAreaLevel().intValue() == 2) {
                Boolean isCurrent = searchVo.getIsCurrent();
                searchVo.setIsCurrent(Boolean.valueOf(true));
                List<OnlineDeviceHomeData> supplementList = ((BxFxhjMapper)this.baseMapper).getMonitorRiskDataHeadRank(searchVo);
                if (CollectionUtils.isNotEmpty(supplementList) && supplementList.get(0).getProvinceId() != null) {
                    OnlineDeviceHomeData temp = supplementList.get(0);
                    temp.setAreaName(temp.getCityName() + "\u672c\u7ea7");
                    list.add(temp);
                }
                searchVo.setIsCurrent(isCurrent);
            }
        }
        int i = 1;
        for (OnlineDeviceHomeData item : list) {
            if (item == null) continue;
            if (searchVo.getIsCity().booleanValue()) {
                item.setCurrentHeadAreaName(item.getProvinceName());
                item.setCurrentHeadAreaId(item.getProvinceId());
                item.setCurrentListAreaName(item.getCityName());
                item.setCurrentListAreaId(item.getCityId());
            } else if (searchVo.getIsCounty().booleanValue()) {
                item.setCurrentHeadAreaName(item.getProvinceName());
                item.setCurrentHeadAreaId(item.getProvinceId());
                item.setCurrentListAreaName(item.getAreaName());
                item.setCurrentListAreaId(item.getAreaId());
            } else if (searchVo.getAreaLevel().intValue() == 1) {
                item.setCurrentHeadAreaName(item.getProvinceName());
                item.setCurrentHeadAreaId(item.getProvinceId());
                item.setCurrentListAreaName(item.getCityName());
                item.setCurrentListAreaId(item.getCityId());
            } else if (searchVo.getAreaLevel().intValue() == 2) {
                item.setCurrentHeadAreaName(item.getCityName());
                item.setCurrentHeadAreaId(item.getCityId());
                if (searchVo.getIsCurrent() != null && searchVo.getIsCurrent().booleanValue()) {
                    item.setOnlyThisLevelArea(Boolean.valueOf(true));
                    item.setCurrentListAreaName(item.getStreetName());
                    item.setCurrentListAreaId(item.getStreetId());
                    item.setOnlyThisLevelAreaId(item.getStreetId());
                } else {
                    item.setCurrentListAreaName(item.getAreaName());
                    item.setCurrentListAreaId(item.getAreaId());
                }
            } else if (searchVo.getAreaLevel().intValue() == 3) {
                item.setCurrentHeadAreaName(item.getAreaName());
                item.setCurrentHeadAreaId(item.getAreaId());
                item.setCurrentListAreaName(item.getStreetName());
                item.setCurrentListAreaId(item.getStreetId());
            }
            item.setIdx(i++);
            item.setDefuseNumRate(item.getDefuseNumRateStr() + "%");
            item.setLawNumRate(item.getLawNumRateStr() + "%");
        }
        return this.setOderOnlineDeviceHomeDataList(list, searchVo);
    }

    private List<OnlineDeviceHomeData> setOderOnlineDeviceHomeDataList(List<OnlineDeviceHomeData> list, BxFxhjSearchParam searchVo) {
        if (StringUtils.isBlank((CharSequence)searchVo.getSort())) {
            list = list.parallelStream().filter(Objects::nonNull).sorted(Comparator.comparing(OnlineDeviceHomeData::getCurrentListAreaId)).collect(Collectors.toList());
        } else if (searchVo.getSort().equals("lawCompanyNum")) {
            list = searchVo.getSortOrder() == 2 ? list.parallelStream().filter(Objects::nonNull).sorted(Comparator.comparing(OnlineDeviceHomeData::getLawCompanyNum).reversed()).collect(Collectors.toList()) : list.parallelStream().filter(Objects::nonNull).sorted(Comparator.comparing(OnlineDeviceHomeData::getLawCompanyNum)).collect(Collectors.toList());
        } else if (searchVo.getSort().equals("lawNum")) {
            list = searchVo.getSortOrder() == 2 ? list.parallelStream().filter(Objects::nonNull).sorted(Comparator.comparing(OnlineDeviceHomeData::getLawNum).reversed()).collect(Collectors.toList()) : list.parallelStream().filter(Objects::nonNull).sorted(Comparator.comparing(OnlineDeviceHomeData::getLawNum)).collect(Collectors.toList());
        } else if (searchVo.getSort().equals("defuseNumRate")) {
            list = searchVo.getSortOrder() == 2 ? list.parallelStream().filter(Objects::nonNull).sorted(Comparator.comparing(v -> Double.parseDouble(v.getDefuseNumRate().replace("%", "")), Comparator.reverseOrder())).collect(Collectors.toList()) : list.parallelStream().filter(Objects::nonNull).sorted(Comparator.comparing(v -> Double.parseDouble(v.getDefuseNumRate().replace("%", "")))).collect(Collectors.toList());
        }
        int i = 1;
        for (OnlineDeviceHomeData item : list) {
            item.setIdx(i++);
        }
        return list;
    }

    private void setSupplementAreaInfo(Long parentId, Integer areaLevel, List<OnlineDeviceHomeData> list, BxFxhjSearchParam searchParam) {
        List<Object> areaInfo = new ArrayList();
        Set<Object> collect = new HashSet();
        if (areaLevel == 1) {
            areaInfo = (List)this.areaCache.getIfPresent((Object)("areaInfocity" + parentId));
            if (CollectionUtils.isEmpty(areaInfo)) {
                areaInfo = this.sysAreaProvideService.getCityList(parentId);
                this.areaCache.put((Object)("areaInfocity" + parentId), areaInfo);
            }
            collect = list.stream().filter(Objects::nonNull).map(OnlineDeviceHomeData::getCityId).collect(Collectors.toSet());
        } else if (areaLevel == 2) {
            areaInfo = (List)this.areaCache.getIfPresent((Object)("areaInfoarea" + parentId));
            if (CollectionUtils.isEmpty(areaInfo)) {
                areaInfo = this.sysAreaProvideService.getAreaList(parentId);
                this.areaCache.put((Object)("areaInfoarea" + parentId), areaInfo);
            }
            collect = list.stream().filter(Objects::nonNull).map(OnlineDeviceHomeData::getAreaId).collect(Collectors.toSet());
        } else if (areaLevel == 3) {
            areaInfo = (List)this.areaCache.getIfPresent((Object)("areaInfostreet" + parentId));
            if (CollectionUtils.isEmpty(areaInfo)) {
                areaInfo = this.sysAreaProvideService.getStreetList(parentId);
                this.areaCache.put((Object)("areaInfostreet" + parentId), areaInfo);
            }
            collect = list.stream().filter(Objects::nonNull).map(OnlineDeviceHomeData::getStreetId).collect(Collectors.toSet());
        } else if (areaLevel == 5) {
            areaInfo = (List)this.areaCache.getIfPresent((Object)"areaInfoareaAll");
            if (CollectionUtils.isEmpty(areaInfo)) {
                areaInfo = this.sysAreaProvideService.getListByLevel(parentId, Byte.valueOf((byte)3), Byte.valueOf((byte)1));
                this.areaCache.put((Object)"areaInfoareaAll", areaInfo);
            }
            collect = list.stream().filter(Objects::nonNull).map(OnlineDeviceHomeData::getAreaId).collect(Collectors.toSet());
        } else if (areaLevel == 6) {
            areaInfo = (List)this.areaCache.getIfPresent((Object)"areaInfoareaAll");
            if (CollectionUtils.isEmpty(areaInfo)) {
                areaInfo = this.sysAreaProvideService.getListByLevel(parentId, Byte.valueOf((byte)3), Byte.valueOf((byte)1));
                this.areaCache.put((Object)"areaInfoareaAll", areaInfo);
            }
            collect = list.stream().filter(Objects::nonNull).map(OnlineDeviceHomeData::getAreaId).collect(Collectors.toSet());
            areaInfo = areaInfo.stream().filter(item -> {
                if (item == null) {
                    return false;
                }
                if (item.getAreaName().contains(searchParam.getKeyWord())) {
                    if (searchParam.getAreaLevel().intValue() == 1 && searchParam.getAreaId().equals(item.getProvinceId())) {
                        return true;
                    }
                    if (searchParam.getAreaLevel().intValue() == 2 && searchParam.getAreaId().equals(item.getCityId())) {
                        return true;
                    }
                    if (searchParam.getAreaLevel().intValue() == 3 && searchParam.getAreaId().equals(item.getAreaId())) {
                        return true;
                    }
                    if (searchParam.getAreaLevel().intValue() == 4 && searchParam.getAreaId().equals(item.getStreetId())) {
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (areaInfo.size() == collect.size()) {
            return;
        }
        for (AreaModel model : areaInfo) {
            if (model == null) continue;
            Long area = null;
            if (areaLevel == 1) {
                area = model.getCityId();
            } else if (areaLevel == 2 || areaLevel == 5 || areaLevel == 6) {
                area = model.getAreaId();
            } else if (areaLevel == 3) {
                area = model.getStreetId();
            }
            if (collect.contains(area)) continue;
            OnlineDeviceHomeData data = new OnlineDeviceHomeData().setProvinceId(model.getProvinceId()).setProvinceName(model.getProvinceName()).setCityId(model.getCityId()).setCityName(model.getCityName()).setAreaId(model.getAreaId()).setAreaName(model.getAreaName()).setStreetId(model.getStreetId()).setStreetName(model.getStreetName()).setRiskNum(Integer.valueOf(0)).setDefuseNum(Integer.valueOf(0)).setLawNum(Integer.valueOf(0)).setLawCompanyNum(Integer.valueOf(0)).setDefuseNumRate("0.00").setLawNumRate("0.00").setCurrentHeadAreaName(model.getName());
            list.add(data);
        }
    }

    public PageInfo<OnlineDeviceHomeData> getMonitorRiskDataPageListRank(JqGridParam jqGridParam, BxFxhjSearchParam searchVo) {
        List<OnlineDeviceHomeData> list = this.getMonitorRiskDataListRank(searchVo);
        return PageUtil.getPageInfo(list, (int)jqGridParam.getPage(), (int)jqGridParam.getRows());
    }

    public List<OnlineDeviceHomeData> getMonitorRiskDataCompanyNum(BxFxhjSearchParam searchVo) {
        return ((BxFxhjMapper)this.baseMapper).getMonitorRiskDataCompanyNum(searchVo);
    }

    public PageInfo<OnlineDeviceHomeData> getMonitorRiskDataCompanyNumPage(JqGridParam jqGridParam, BxFxhjSearchParam searchVo) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        List<OnlineDeviceHomeData> list = this.getMonitorRiskDataCompanyNum(searchVo);
        return new PageInfo(list);
    }

    public List<RiskWarningCompanyArea> warningCompanyArea(HomeIndexSearchVo searchVo) {
        ArrayList<RiskWarningCompanyArea> warningCompanyAreaList = new ArrayList<RiskWarningCompanyArea>();
        BxFxhjSearchParam searchParam = new BxFxhjSearchParam().setAreaId(searchVo.getAreaId()).setAreaLevel(searchVo.getAreaLevel()).setIsCurrent(searchVo.getIsCurrent()).setBelongType(searchVo.getBelongType());
        PageHelper.startPage((int)1, (int)8, (boolean)false);
        List<OnlineDeviceHomeData> list = this.getMonitorRiskDataCompanyNum(searchParam);
        for (OnlineDeviceHomeData item : list) {
            if (item == null) continue;
            RiskWarningCompanyArea temp = new RiskWarningCompanyArea().setCid(item.getCid()).setCompanyName(item.getCompanyName()).setNum(item.getLawNum());
            warningCompanyAreaList.add(temp);
        }
        return warningCompanyAreaList;
    }

    public Integer waitRiskCompanyNum(HomeIndexSearchVo searchVo) {
        return ((BxFxhjMapper)this.baseMapper).waitRiskNum(searchVo);
    }

    public List<OnlineDeviceHomeData> getRiskChangeTrend(HomeIndexSearchVo searchVo) {
        List<OnlineDeviceHomeData> list = ((BxFxhjMapper)this.baseMapper).getRiskChangeTrend(searchVo);
        Set collect = list.parallelStream().filter(Objects::nonNull).map(OnlineDeviceHomeData::getMonth).collect(Collectors.toSet());
        for (int i = 1; i < 13; ++i) {
            if (collect.contains(i)) continue;
            OnlineDeviceHomeData data = new OnlineDeviceHomeData().setMonth(Integer.valueOf(i)).setRiskNum(Integer.valueOf(0)).setDefuseNum(Integer.valueOf(0)).setLawNum(Integer.valueOf(0)).setLawCompanyNum(Integer.valueOf(0));
            list.add(data);
        }
        list.forEach(item -> {
            item.setLawNumRate(item.getLawNumRateStr());
            item.setDefuseNumRate(item.getDefuseNumRateStr());
        });
        return list.stream().filter(Objects::nonNull).sorted(Comparator.comparing(OnlineDeviceHomeData::getMonth)).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOne(BxFxhj bxFxhj) {
        bxFxhj.setIsValid(Boolean.valueOf(true));
        bxFxhj.setCreateBy(Long.valueOf(0L));
        bxFxhj.setCreateDate(new Date());
        bxFxhj.setUpdateBy(Long.valueOf(0L));
        bxFxhj.setUpdateDate(new Date());
        this.save(bxFxhj);
    }
}

