/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.advice;

import cn.smarthse.services.support.ResponseData2;
import cn.smarthse.web.common.enums.StatusCodeEnum;
import jakarta.validation.ConstraintViolationException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(basePackages={"cn.smarthse.services.onlinemonitoring.controller", "cn.smarthse.services.dataref.controller", "cn.smarthse.services.ycq.controller", "cn.smarthse.services.dataservice.controller", "cn.smarthse.services.gj.controller"})
public class ControllerExceptionAdvice {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseData2<Object> handleException(Exception e) {
        this.logger.error("Controller\u5f02\u5e38=>:", (Throwable)e);
        if (e instanceof BusinessException || e instanceof HealthException) {
            return ResponseData2.fail(e.getMessage());
        }
        if (e instanceof ConstraintViolationException) {
            Set message = ((ConstraintViolationException)e).getConstraintViolations();
            HashMap map = new HashMap();
            message.forEach(msg -> {
                String path = msg.getPropertyPath().toString();
                String field = path.substring(path.indexOf(".") + 1);
                map.put(field, msg.getMessage());
            });
            ResponseData2<Object> r = ResponseData2.fail("");
            r.setState(StatusCodeEnum.REQUEST_ERROR);
            r.setContent(StatusCodeEnum.REQUEST_ERROR.getMsg());
            r.setResult(map);
            return r;
        }
        if (e instanceof MethodArgumentNotValidException) {
            List allErrors = ((MethodArgumentNotValidException)e).getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            ResponseData2<Object> r = ResponseData2.fail("");
            r.setState(StatusCodeEnum.REQUEST_ERROR);
            r.setContent(StatusCodeEnum.REQUEST_ERROR.getMsg());
            r.setResult(map);
            return r;
        }
        if (e instanceof BindException) {
            List allErrors = ((BindException)e).getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            ResponseData2<Object> r = ResponseData2.fail("");
            r.setState(StatusCodeEnum.REQUEST_ERROR);
            r.setContent(StatusCodeEnum.REQUEST_ERROR.getMsg());
            r.setResult(map);
            return r;
        }
        return ResponseData2.fail("\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u89e3\u51b3");
    }

    @ResponseBody
    @ExceptionHandler(value={ConstraintViolationException.class, MethodArgumentNotValidException.class, BindException.class})
    public ResponseData2<Object> handleException2(Exception e) {
        this.logger.error("Controller\u5f02\u5e38=>:", (Throwable)e);
        if (e instanceof ConstraintViolationException) {
            Set message = ((ConstraintViolationException)e).getConstraintViolations();
            HashMap map = new HashMap();
            message.forEach(msg -> {
                String path = msg.getPropertyPath().toString();
                String field = path.substring(path.indexOf(".") + 1);
                map.put(field, msg.getMessage());
            });
            ResponseData2<Object> r = ResponseData2.fail("");
            r.setState(StatusCodeEnum.REQUEST_ERROR);
            r.setContent(StatusCodeEnum.REQUEST_ERROR.getMsg());
            r.setResult(map);
            return r;
        }
        if (e instanceof MethodArgumentNotValidException) {
            List allErrors = ((MethodArgumentNotValidException)e).getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            ResponseData2<Object> r = ResponseData2.fail("");
            r.setState(StatusCodeEnum.REQUEST_ERROR);
            r.setContent(StatusCodeEnum.REQUEST_ERROR.getMsg());
            r.setResult(map);
            return r;
        }
        if (e instanceof BindException) {
            List allErrors = ((BindException)e).getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            ResponseData2<Object> r = ResponseData2.fail("");
            r.setState(StatusCodeEnum.REQUEST_ERROR);
            r.setContent(StatusCodeEnum.REQUEST_ERROR.getMsg());
            r.setResult(map);
            return r;
        }
        return ResponseData2.fail("\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u89e3\u51b3");
    }
}

