/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.snowflake.config;

import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.snowflake.SnowflakeIDGenImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration
public class SnowflakeConfig {
    @Value(value="${dubbo.registry.address}")
    private String registryAddress;
    @Value(value="${spring.application.name}")
    private String serviceName;

    @Bean
    public SnowflakeIDGenImpl getSnowflakeIDGenImpl() {
        if (StringUtils.isEmpty((Object)this.registryAddress)) {
            this.registryAddress = "";
        }
        this.registryAddress = this.registryAddress.replace("zookeeper://", "");
        SnowflakeIDGenImpl idgen = new SnowflakeIDGenImpl(this.registryAddress, this.serviceName);
        return idgen;
    }

    @Bean
    public IdWorker getIdWorker(SnowflakeIDGenImpl idgen) {
        return new IdWorker(idgen);
    }
}

