/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.snowflake;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.RetryUntilElapsed;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeZookeeperHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnowflakeZookeeperHolder.class);
    private static final String PREFIX_ZK_PATH = "/snowflake/idworker";
    private static final String PATH_FOREVER = "/snowflake/idworker/forever";
    private String serviceName;
    private String connectionString;
    private static final int CONNECTION_TIMEOUT_MS = 10000;
    private static final int SESSION_TIMEOUT_MS = 6000;
    private static final int MAX_RETRIES = 3;
    private final long workerIdBits = 10L;
    private final long maxWorkerId = 1023L;

    public SnowflakeZookeeperHolder(String serviceName, String connectionString) {
        this.serviceName = serviceName;
        this.connectionString = connectionString;
    }

    public int getWorkId() {
        CuratorFramework curator = null;
        try {
            curator = this.createWithOptions(this.connectionString, (RetryPolicy)new RetryUntilElapsed(1000, 3), 10000, 6000);
            curator.start();
            int i = 1;
            while ((long)i < 1023L) {
                String zkPath = PATH_FOREVER + this.getServiceName() + i;
                Stat stat = (Stat)curator.checkExists().forPath(zkPath);
                if (stat == null) {
                    ((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(zkPath);
                    LOGGER.info("\u5f53\u524d\u542f\u52a8\u73af\u5883\u83b7\u53d6workId: {}", (Object)i);
                    return i;
                }
                ++i;
            }
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Start node ERROR", (Throwable)e);
            return 1;
        }
    }

    private CuratorFramework createWithOptions(String connectionString, RetryPolicy retryPolicy, int connectionTimeoutMs, int sessionTimeoutMs) {
        return CuratorFrameworkFactory.builder().connectString(connectionString).retryPolicy(retryPolicy).connectionTimeoutMs(connectionTimeoutMs).sessionTimeoutMs(sessionTimeoutMs).build();
    }

    public String getServiceName() {
        if (this.serviceName != null && this.serviceName != "") {
            return "/" + this.serviceName;
        }
        return "";
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

