/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.snowflake;

import cn.smarthse.snowflake.IDGen;
import cn.smarthse.snowflake.SnowflakeZookeeperHolder;
import cn.smarthse.snowflake.common.Result;
import cn.smarthse.snowflake.common.Status;
import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.zookeeper.common.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIDGenImpl
implements IDGen {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnowflakeIDGenImpl.class);
    private final long twepoch;
    private final long workerIdBits = 10L;
    private final long maxWorkerId = 1023L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static final Random RANDOM = new Random();

    @Override
    public boolean init() {
        return true;
    }

    public SnowflakeIDGenImpl(String zkAddress, String serviceName) {
        this(zkAddress, serviceName, 1288834974657L);
    }

    public SnowflakeIDGenImpl(String zkAddress, String serviceName, long twepoch) {
        this.twepoch = twepoch;
        Preconditions.checkArgument((this.timeGen() > twepoch ? 1 : 0) != 0, (Object)"Snowflake not support twepoch gt currentTime");
        if (!StringUtils.isBlank((String)zkAddress)) {
            SnowflakeZookeeperHolder holder = new SnowflakeZookeeperHolder(serviceName, zkAddress);
            LOGGER.info("twepoch:{} ,serviceName:{} ,zkAddress:{}", new Object[]{twepoch, serviceName, zkAddress});
            this.workerId = holder.getWorkId();
        } else {
            this.workerId = RANDOM.nextInt(1023);
        }
        LOGGER.debug("\u83b7\u53d6\u5230\u65b0workid:{}", (Object)this.workerId);
        Preconditions.checkArgument((this.workerId >= 0L && this.workerId <= 1023L ? 1 : 0) != 0, (Object)"workerID must gte 0 and lte 1023");
    }

    @Override
    public synchronized Result get(String key) {
        long timestamp;
        block8: {
            timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - timestamp;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        timestamp = this.timeGen();
                        if (timestamp < this.lastTimestamp) {
                            return new Result(-1L, Status.EXCEPTION);
                        }
                        break block8;
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("idworker wait interrupted");
                        return new Result(-2L, Status.EXCEPTION);
                    }
                }
                return new Result(-3L, Status.EXCEPTION);
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                this.sequence = RANDOM.nextInt(100);
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = RANDOM.nextInt(100);
        }
        this.lastTimestamp = timestamp;
        long id = timestamp - this.twepoch << 22 | this.workerId << 12 | this.sequence;
        return new Result(id, Status.SUCCESS);
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public long getWorkerId() {
        return this.workerId;
    }
}

