/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.util;

import cn.smarthse.db.common.entity.BaseEntity;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.PropertyDescriptor;
import java.time.LocalDateTime;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtils {
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);

    private WebUtils() {
    }

    public static boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
    }

    public static Integer getCurrentUserId() {
        return 0;
    }

    public static void setCreateCommonProperties(BaseEntity entity) {
        Integer userId = WebUtils.getCurrentUserId();
        PropertyDescriptor createBy = org.springframework.beans.BeanUtils.getPropertyDescriptor(entity.getClass(), (String)"createBy");
        try {
            if (Long.class.equals(createBy.getPropertyType())) {
                Objects.requireNonNull(createBy).getWriteMethod().invoke((Object)entity, userId.longValue());
            } else {
                Objects.requireNonNull(createBy).getWriteMethod().invoke((Object)entity, userId);
            }
            BeanUtils.copyProperty((Object)entity, (String)"id", null);
            BeanUtils.copyProperty((Object)entity, (String)"isValid", (Object)true);
            BeanUtils.copyProperty((Object)entity, (String)"createDate", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("setCreateCommonProperties", (Throwable)e);
            throw new RuntimeException(e);
        }
        WebUtils.setUpdateCommonProperties(entity);
    }

    public static void setUpdateCommonProperties(BaseEntity entity) {
        Integer userId = WebUtils.getCurrentUserId();
        PropertyDescriptor updateBy = org.springframework.beans.BeanUtils.getPropertyDescriptor(entity.getClass(), (String)"updateBy");
        try {
            if (Long.class.equals(updateBy.getPropertyType())) {
                Objects.requireNonNull(updateBy).getWriteMethod().invoke((Object)entity, userId.longValue());
            } else {
                Objects.requireNonNull(updateBy).getWriteMethod().invoke((Object)entity, userId);
            }
            BeanUtils.copyProperty((Object)entity, (String)"updateDate", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("setUpdateCommonProperties", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void setCreateOrUpdateCommonProperties(BaseEntity entity) {
        Long id = entity.getId();
        if (id != null) {
            WebUtils.setUpdateCommonProperties(entity);
        } else {
            WebUtils.setCreateCommonProperties(entity);
        }
    }
}

