/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.util;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.TouchLimitValueEnum;
import cn.smarthse.services.hfi.api.pojo.bo.ResultNoBo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CheckUtils {
    private CheckUtils() {
    }

    public static String getCheckResult(List<String> checkValues) {
        boolean havePass = false;
        boolean haveNoJudge = false;
        for (String checkValue : checkValues) {
            if ("3".equals(checkValue)) {
                return "3";
            }
            if ("2".equals(checkValue)) {
                havePass = true;
            }
            if (!"1".equals(checkValue)) continue;
            haveNoJudge = true;
        }
        if (haveNoJudge) {
            return "1";
        }
        if (havePass) {
            return "2";
        }
        return "";
    }

    public static String getStrJudgeResult(String resultCode) {
        switch (resultCode) {
            case "1": {
                return "\u4e0d\u5224\u65ad";
            }
            case "2": {
                return "\u7b26\u5408";
            }
            case "3": {
                return "\u4e0d\u7b26\u5408";
            }
        }
        return "";
    }

    public static String getStrRangeType(String rangeCode) {
        switch (rangeCode) {
            case "2": {
                return "<";
            }
            case "3": {
                return "\u2264";
            }
        }
        return "-";
    }

    public static String getNoiseType(String checkValue) {
        switch (checkValue) {
            case "1": {
                return "\u4e2a\u4f53";
            }
            case "2": {
                return "\u573a\u6240\uff08\u7a33\u6001\u566a\u58f0\uff09";
            }
            case "3": {
                return "\u573a\u6240\uff08\u975e\u7a33\u6001\u566a\u58f0\uff09";
            }
            case "4": {
                return "\u573a\u6240\uff08\u8109\u51b2\u566a\u58f0\uff09";
            }
        }
        return "";
    }

    public static String getValue35(String checkValue) {
        switch (checkValue) {
            case "1": {
                return "\u2160";
            }
            case "2": {
                return "\u2161";
            }
            case "3": {
                return "\u2162";
            }
            case "4": {
                return "\u2163";
            }
        }
        return "";
    }

    public static String getValue39(String checkValue) {
        switch (checkValue) {
            case "1": {
                return "\u4e2d\u6ce2\u7d2b\u5916\u7ebf";
            }
            case "2": {
                return "\u77ed\u6ce2\u7d2b\u5916\u7ebf";
            }
            case "3": {
                return "\u7535\u710a\u5f27\u5149";
            }
        }
        return "";
    }

    public static String getValue58(String checkValue) {
        if (checkValue == null || checkValue.isEmpty()) {
            return "";
        }
        String v1 = "";
        String v2 = "";
        if (checkValue.equals("1")) {
            return "\u5168\u8eab\u8f90\u5c04";
        }
        if (checkValue.equals("2")) {
            return "\u80a2\u4f53\u5c40\u90e8\u8f90\u5c04";
        }
        String[] split = checkValue.split(",");
        if (split[0].equals("1")) {
            v1 = "\u5168\u8eab\u8f90\u5c04";
        } else if (split[0].equals("2")) {
            v1 = "\u80a2\u4f53\u5c40\u90e8\u8f90\u5c04";
        }
        if (split[1].equals("1")) {
            v2 = "\u8fde\u7eed\u5fae\u6ce2";
        } else if (split[1].equals("2")) {
            v2 = "\u8109\u51b2\u5fae\u6ce2";
        }
        return v1 + "-" + v2;
    }

    public static String getValue71(String checkValue) {
        switch (checkValue) {
            case "1": {
                return "\u8fde\u7eed\u6ce2";
            }
            case "2": {
                return "\u8109\u51b2\u6ce2";
            }
        }
        return "";
    }

    public static String getValue89(String checkValue) {
        switch (checkValue) {
            case "1": {
                return "\u773c";
            }
            case "2": {
                return "\u76ae\u80a4";
            }
        }
        return "";
    }

    public static String getValue91(String checkValue) {
        switch (checkValue) {
            case "1": {
                return "\u7d2b\u5916\u7ebf";
            }
            case "2": {
                return "\u53ef\u89c1\u5149";
            }
            case "3": {
                return "\u7ea2\u5916\u7ebf";
            }
            case "4": {
                return "\u8fdc\u7ea2\u5916\u7ebf";
            }
        }
        return "";
    }

    public static String getValue117(String checkValue) {
        switch (checkValue) {
            case "1": {
                return "\u662f";
            }
            case "2": {
                return "\u4e0d\u662f";
            }
        }
        return "";
    }

    public static TouchLimitValueEnum getFactorLimit(String factorName, Integer targetId) {
        for (TouchLimitValueEnum value : TouchLimitValueEnum.values()) {
            if (!value.factorName.equals(factorName) || !value.targetId.equals(targetId)) continue;
            return value;
        }
        return null;
    }

    public static <T extends ResultNoBo> List<List<T>> groupByResultNo(List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        Long currentResultNo = ((ResultNoBo)list.get(0)).getResultNo();
        LinkedList<List<T>> rList = new LinkedList<List<T>>();
        LinkedList<ResultNoBo> currentList = new LinkedList<ResultNoBo>();
        for (ResultNoBo o : list) {
            Long resultNo = o.getResultNo();
            if (!currentResultNo.equals(resultNo)) {
                rList.add(currentList);
                currentResultNo = resultNo;
                currentList = new LinkedList();
            }
            currentList.add(o);
        }
        rList.add(currentList);
        return rList;
    }

    public static List<List<CheckResult>> groupCheckResultByResultNo(List<CheckResult> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        Long currentResultNo = list.get(0).getResultNo();
        LinkedList<List<CheckResult>> rList = new LinkedList<List<CheckResult>>();
        LinkedList<CheckResult> currentList = new LinkedList<CheckResult>();
        for (CheckResult o : list) {
            Long resultNo = o.getResultNo();
            if (!currentResultNo.equals(resultNo)) {
                rList.add(currentList);
                currentResultNo = resultNo;
                currentList = new LinkedList();
            }
            currentList.add(o);
        }
        rList.add(currentList);
        return rList;
    }

    public static List<Long> parseStrIds(String ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Long> list = new LinkedList<Long>();
        for (String s : ids.split(",")) {
            list.add(Long.parseLong(s));
        }
        return list;
    }

    public static String formatListIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id);
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

