/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp.riskev;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.entity.riskev.RiskPickUpReports;
import cn.smarthse.services.hfi.api.enums.HazardsExposureRiskLevelEnum;
import cn.smarthse.services.hfi.api.model.grade.CompanyOccTypeVo;
import cn.smarthse.services.hfi.api.model.grade.GradeSearchBaseModel;
import cn.smarthse.services.hfi.api.model.riskev.ComEvModel;
import cn.smarthse.services.hfi.api.model.riskev.ComEvModelParam;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.model.riskev.QueryPageListReportsParam;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.FactorTouchNumVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.HazardsExposureRiskLevelVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskDecisionVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskEvaluateSelfCheckVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskExposeEvaluateVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.services.hfi.cache.RiskTouchNumStatCache;
import cn.smarthse.services.hfi.mapper.riskev.RiskExposeEvaluateMapper;
import cn.smarthse.services.hfi.serviceimp.FactorService;
import cn.smarthse.services.wanda.api.entity.WandaCheckReturn;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportInfo;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportPoint;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportResult;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.enums.WandDealStateEnm;
import cn.smarthse.services.wanda.api.enums.WandaReportCheckItemEnm;
import cn.smarthse.services.wanda.api.enums.WandaReportCheckTypeEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckReturnService;
import cn.smarthse.services.wanda.api.service.IWandaZywsReportInfoService;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=5000000)
public class RiskExposeEvaluateServiceImpl
extends BaseServiceImp<RiskExposeEvaluateMapper, RiskExposeEvaluate>
implements IRiskExposeEvaluateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskExposeEvaluateServiceImpl.class);
    @Autowired
    private ICheckPlanService checkPlanService;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    @Lazy
    private IRiskExposeEvaluateDataService exposeEvaluateDataService;
    @DubboReference(check=false)
    private IWandaCheckReturnService wandaCheckReturnService;
    @DubboReference(check=false)
    private IWandaZywsReportInfoService wandaReportInfoService;
    @Autowired
    private FactorService factorService;
    @Autowired
    private RiskTouchNumStatCache riskTouchNumStatCache;
    @Autowired
    protected IdWorker idworker;
    @Resource
    private PlatformTransactionManager platformTransactionManager;
    @Resource
    private SqlSessionTemplate sqlSessionTemplate;
    private Set<Long> checkIds = new HashSet<Long>();
    private Set<Long> evIds = new HashSet<Long>();

    public synchronized RiskExposeEvaluate autoAddByOrgAndCom(Long orgId, Long cid) {
        CheckPlan checkPlan = this.checkPlanService.getLatestByOrgAndCom(orgId, cid);
        if (checkPlan == null) {
            return null;
        }
        if (checkPlan.getRiskExposeEvaluateId() != null) {
            this.logger.info("\u66b4\u9732\u98ce\u9669\u8bc4\u4f30\u5df2\u5b58\u5728 checkId:{}", (Object)checkPlan.getId());
            return null;
        }
        if (this.checkIds.contains(checkPlan.getId())) {
            this.logger.info("\u66b4\u9732\u98ce\u9669\u8bc4\u4f30\u5df2\u5b58\u5728 checkId:{}", (Object)checkPlan.getId());
            return null;
        }
        RiskExposeEvaluate e = this.getByCheckId(checkPlan.getId());
        if (e != null) {
            this.logger.info("\u68c0\u6d4b\u7684\u8bc4\u4f30\u5df2\u5b58\u5728 checkId:{}", (Object)checkPlan.getId());
            return e;
        }
        this.logger.info("\u68c0\u6d4b\u7684\u8bc4\u4f30\u4e0d\u5b58\u5728 checkId:{}", (Object)checkPlan.getId());
        log.info("\u6839\u636e\u68c0\u6d4b{}\u6dfb\u52a0\u98ce\u9669\u66b4\u9732\u8bc4\u4f30", (Object)checkPlan.getId());
        return this.addByCheckPlan(checkPlan);
    }

    public void autoAddByOrg(Long orgId) {
    }

    public void autoAddRiskExposeEvaluateFromCheck() {
        List orgIds = this.checkPlanService.getThirdOrgId(null, null, null);
        for (Long orgId : orgIds) {
            List cids = this.checkPlanService.getCidByOrgId(orgId);
            for (Long cid : cids) {
                RiskExposeEvaluate e;
                CheckPlan checkPlan = this.checkPlanService.getLatestByOrgAndCom(orgId, cid);
                if (checkPlan == null || checkPlan.getCheckFrom() == 3 || checkPlan.getRiskExposeEvaluateId() != null || (e = this.getByCheckId(checkPlan.getId())) != null) continue;
                e = this.addByCheckPlan(checkPlan);
                this.exposeEvaluateDataService.addDataFromCheckPlan(e);
            }
        }
    }

    private synchronized RiskExposeEvaluate addByCheckPlan(CheckPlan plan) {
        if (this.checkIds.contains(plan.getId())) {
            return this.getByCheckId(plan.getId());
        }
        this.checkIds.addAll(((RiskExposeEvaluateMapper)this.baseMapper).getCheckIds());
        if (this.checkIds.contains(plan.getId())) {
            return this.getByCheckId(plan.getId());
        }
        RiskExposeEvaluate obj = new RiskExposeEvaluate();
        obj.setCid(plan.getCid());
        obj.setOrgId(plan.getThirdOrgId());
        obj.setCheckPlanId(plan.getId());
        obj.setType(Integer.valueOf(1));
        obj.setWorkNo(plan.getCheckWorkNo());
        obj.setProjectName(plan.getProjectName());
        obj.setCheckDate(plan.getCheckDateBegin());
        obj.setCheckDateEnd(plan.getCheckDateEnd());
        obj.setTargetStandardId(plan.getTargetStandardId());
        obj.setProjectAreaId(plan.getProjectAreaId());
        obj.setProjectAddress(plan.getProjectAddress());
        obj.setReportStatus(Integer.valueOf(2));
        obj.setDataUpdateDate(LocalDateTime.now());
        obj.setIsValid(Boolean.valueOf(true));
        obj.setCreateBy(Long.valueOf(0L));
        obj.setCreateDate(LocalDateTime.now());
        obj.setUpdateDate(LocalDateTime.now());
        obj.setUpdateBy(Long.valueOf(0L));
        this.add((BaseEntity)obj);
        this.checkIds.add(plan.getId());
        return obj;
    }

    @Transactional
    public void autoAddRiskExposeEvaluateFromWandaCheck(List<CheckPlan> checkPlanList, Map<Long, Long> checkIdKeyRiskIdValue) {
        for (CheckPlan checkPlan : checkPlanList) {
            RiskExposeEvaluate e = this.addByCheckPlan2(checkPlan, checkIdKeyRiskIdValue.get(checkPlan.getId()));
            this.exposeEvaluateDataService.addDataFromCheckPlan(e);
            if (!checkIdKeyRiskIdValue.containsKey(checkPlan.getId())) continue;
            this.updateMergerTableByChildRisk(e);
        }
    }

    private synchronized RiskExposeEvaluate addByCheckPlan2(CheckPlan plan, Long riskId) {
        RiskExposeEvaluate obj = new RiskExposeEvaluate();
        obj.setCid(plan.getCid());
        obj.setOrgId(plan.getThirdOrgId());
        obj.setOrgName(plan.getThirdOrgName());
        obj.setCheckPlanId(plan.getId());
        obj.setType(Integer.valueOf(1));
        obj.setCheckType(plan.getCheckType());
        obj.setWorkNo(plan.getCheckWorkNo());
        obj.setProjectName(plan.getProjectName());
        obj.setRiskType(plan.getRiskLevel());
        obj.setWandaZywsCheckId(plan.getWandaZywsCheckId());
        obj.setCheckDate(plan.getCheckDateBegin());
        obj.setCheckDateEnd(plan.getCheckDateEnd());
        obj.setTargetStandardId(plan.getTargetStandardId());
        obj.setProjectAreaId(plan.getProjectAreaId());
        obj.setProjectAddress(plan.getProjectAddress());
        obj.setReportStatus(plan.getReportStatus());
        obj.setDataUpdateDate(plan.getCreateDate());
        obj.setIsValid(Boolean.valueOf(true));
        obj.setCreateBy(Long.valueOf(0L));
        obj.setCreateDate(plan.getCreateDate());
        obj.setUpdateDate(plan.getCreateDate());
        obj.setUpdateBy(Long.valueOf(0L));
        if (riskId != null) {
            obj.setId(riskId);
            RiskExposeEvaluate temp = (RiskExposeEvaluate)this.getById(obj.getId());
            if (temp.getReportStatus() == 3) {
                ((RiskExposeEvaluateMapper)this.dao).addLog(this.idworker.nextId(), obj.getId(), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), null, obj.getOrgId(), obj.getOrgName(), WorkOperateLogStatusEnum.report.getVal(), obj.getOrgName(), plan.getCreateDate());
            }
        } else {
            obj.setId(Long.valueOf(this.idworker.nextId()));
            ((RiskExposeEvaluateMapper)this.dao).addLog(this.idworker.nextId(), obj.getId(), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), null, obj.getOrgId(), obj.getOrgName(), WorkOperateLogStatusEnum.report.getVal(), obj.getOrgName(), plan.getCreateDate());
        }
        this.saveOrUpdate(obj);
        return obj;
    }

    @Transactional
    public void autoAddRiskExposeEvaluateFromWandaZywsReport(String sourceId) {
        List needConvertToRiskData;
        this.logger.error("\u6c5d\u57ce\u68c0\u6d4b4.1--8.1\u53f7\u8f6c\u6362\u66b4\u9732\u98ce\u9669\u5f00\u59cb");
        long s = System.currentTimeMillis();
        List allList = this.wandaReportInfoService.getNeedConvertToRiskData(sourceId);
        List split = ListUtils.split((List)allList, (int)300);
        Iterator iterator = split.iterator();
        while (iterator.hasNext() && !CollectionUtils.isEmpty((Collection)(needConvertToRiskData = (List)iterator.next()))) {
            ArrayList<RiskExposeEvaluate> needAddRiskList = new ArrayList<RiskExposeEvaluate>();
            ArrayList<RiskExposeEvaluateData> needAddRiskDataList = new ArrayList<RiskExposeEvaluateData>();
            List wandaReportInfoSourceIdList = needConvertToRiskData.parallelStream().map(WandaZywsReportInfo::getSourceId).collect(Collectors.toList());
            Map<String, List<WandaZywsReportPoint>> pointAndResultMap = this.wandaReportInfoService.getWandaReportPointAndResult(wandaReportInfoSourceIdList).parallelStream().filter(Objects::nonNull).collect(Collectors.groupingBy(WandaZywsReportPoint::getReportId));
            for (WandaZywsReportInfo reportInfo : needConvertToRiskData) {
                if (reportInfo == null) continue;
                RiskExposeEvaluate exposeEvaluate = this.addRiskByWandaReport(reportInfo);
                needAddRiskList.add(exposeEvaluate);
                List<WandaZywsReportPoint> wandaReportPointList = pointAndResultMap.get(reportInfo.getSourceId());
                if (CollectionUtils.isEmpty(wandaReportPointList)) continue;
                for (WandaZywsReportPoint reportPoint : wandaReportPointList) {
                    RiskExposeEvaluateData riskExposeEvaluateData;
                    if (reportPoint == null || (riskExposeEvaluateData = this.addRiskDataByWandaReportPoint(reportPoint, exposeEvaluate)) == null) continue;
                    needAddRiskDataList.add(riskExposeEvaluateData);
                }
            }
            this.saveBatch(needAddRiskList);
            this.exposeEvaluateDataService.saveBatch(needAddRiskDataList);
        }
        long e = System.currentTimeMillis();
        this.logger.error("\u6c5d\u57ce\u68c0\u6d4b4.1--8.1\u53f7\u8f6c\u6362\u66b4\u9732\u98ce\u9669\u5b8c\u6bd5,\u8017\u65f6:" + (e - s) / 1000L + "\u79d2");
    }

    private RiskExposeEvaluate addRiskByWandaReport(WandaZywsReportInfo reportInfo) {
        RiskExposeEvaluate obj = new RiskExposeEvaluate();
        obj.setCid(reportInfo.getCid());
        obj.setOrgId(reportInfo.getOrgId());
        obj.setOrgName(reportInfo.getOrgName());
        obj.setType(Integer.valueOf(2));
        obj.setCheckType(WandaReportCheckTypeEnm.getOwnCodeByWandaCode((String)reportInfo.getCheckType()));
        obj.setWorkNo(reportInfo.getReportCode());
        String projectName = null;
        try {
            projectName = DateUtils.getYear((Date)reportInfo.getBeginSamplingDate()) + reportInfo.getCompanyName() + WandaReportCheckTypeEnm.getNameByWandaCode((String)reportInfo.getCheckType());
        }
        catch (Exception e) {
            this.logger.error("\u6c5d\u57ce\u68c0\u6d4b\u6570\u636e4.1-8.1\u53f7\u8f6c\u6362\uff0c\u9879\u76ee\u540d\u79f0\u62fc\u63a5\u683c\u5f0f\u5316\u9519\u8bef(\u6d4b\u91cf\u5f00\u59cb\u65e5\u671f,\u68c0\u6d4b\u7c7b\u578b)");
            e.printStackTrace();
        }
        obj.setProjectName(projectName);
        obj.setWandaZywsReportId(reportInfo.getSourceId());
        obj.setCheckDate(DateUtil.getFromDate((Date)reportInfo.getBeginSamplingDate()));
        obj.setCheckDateEnd(DateUtil.getFromDate((Date)reportInfo.getEndSamplingDate()));
        obj.setTargetStandardId(Long.valueOf(2L));
        obj.setProjectAreaId(reportInfo.getAreaId());
        obj.setReportStatus(Integer.valueOf(1));
        obj.setDataUpdateDate(LocalDateTime.now());
        obj.setIsValid(Boolean.valueOf(true));
        obj.setCreateBy(null);
        obj.setCreateDate(LocalDateTime.now());
        obj.setUpdateDate(LocalDateTime.now());
        obj.setUpdateBy(null);
        obj.setId(Long.valueOf(this.idworker.nextId()));
        return obj;
    }

    private RiskExposeEvaluateData addRiskDataByWandaReportPoint(WandaZywsReportPoint reportPoint, RiskExposeEvaluate riskExposeEvaluate) {
        List reportResultList;
        RiskExposeEvaluateData data = new RiskExposeEvaluateData();
        data.setId(Long.valueOf(this.idworker.nextId()));
        data.setRiskExposeEvaluateId(riskExposeEvaluate.getId());
        data.setIsValid(Boolean.valueOf(true));
        data.setDataSource(Integer.valueOf(2));
        data.setCreateDate(LocalDateTime.now());
        data.setUpdateDate(LocalDateTime.now());
        data.setWorkshop(reportPoint.getOperationArea());
        data.setWorkName(reportPoint.getMonitoringPoint());
        data.setCheckPoint(reportPoint.getPointName());
        if (reportPoint.getFactorId() != null) {
            data.setFactorId(reportPoint.getFactorId().toString());
        }
        if (StringUtils.isBlank((CharSequence)reportPoint.getFactorName())) {
            return null;
        }
        data.setFactorName(reportPoint.getFactorName());
        data.setFactorNature(reportPoint.getFactorNature());
        data.setCanEdit(Boolean.valueOf(true));
        if (StringUtils.isNotBlank((CharSequence)reportPoint.getConclusion())) {
            if ("true".equals(reportPoint.getConclusion().toLowerCase(Locale.ROOT))) {
                data.setTouchLevel(Integer.valueOf(2));
                data.setCheckTouchLevel(Integer.valueOf(2));
            }
            if ("false".equals(reportPoint.getConclusion().toLowerCase(Locale.ROOT))) {
                data.setTouchLevel(Integer.valueOf(1));
                data.setCheckTouchLevel(Integer.valueOf(1));
            }
        }
        if (CollectionUtils.isEmpty((Collection)(reportResultList = reportPoint.getReportResultList()))) {
            return data;
        }
        StringBuilder otherResult = new StringBuilder();
        for (WandaZywsReportResult reportResult : reportResultList) {
            if (reportResult == null || StringUtils.isBlank((CharSequence)reportResult.getResultItemCode())) continue;
            String resultItemCode = reportResult.getResultItemCode();
            if (resultItemCode.equals(WandaReportCheckItemEnm.wandaItem101.getWandaCode())) {
                data.setCmac(this.reportResultVerify(reportResult.getResult()));
                continue;
            }
            if (resultItemCode.equals(WandaReportCheckItemEnm.wandaItem103.getWandaCode())) {
                data.setCstel(this.reportResultVerify(reportResult.getResult()));
                data.setCste(this.reportResultVerify(reportResult.getResult()));
                continue;
            }
            if (Arrays.asList("102", "104", "105").contains(resultItemCode)) {
                data.setCtwa(this.reportResultVerify(reportResult.getResult()));
                continue;
            }
            if (Arrays.asList("126", "127", "128").contains(resultItemCode)) {
                data.setPePcTwa(this.reportResultVerify(reportResult.getResult()));
                continue;
            }
            if (resultItemCode.equals(WandaReportCheckItemEnm.wandaItem115.getWandaCode())) {
                data.setNoiseLevel(this.reportResultVerify(reportResult.getResult()));
                continue;
            }
            if (resultItemCode.equals(WandaReportCheckItemEnm.wandaItem116.getWandaCode())) {
                data.setNoiseLevel(this.reportResultVerify(reportResult.getResult()));
                continue;
            }
            if (WandaReportCheckItemEnm.getNameByWandaCode((String)resultItemCode) == null) continue;
            if (StringUtils.isNotBlank((CharSequence)otherResult.toString())) {
                otherResult.append("/");
            }
            otherResult.append(WandaReportCheckItemEnm.getNameByWandaCode((String)resultItemCode)).append(":").append(reportResult.getResult());
        }
        if (StringUtils.isNotBlank((CharSequence)otherResult.toString())) {
            data.setOtherFactorValue(otherResult.toString());
        }
        return data;
    }

    public String reportResultVerify(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        Set collect = Arrays.asList("-", "--", "/", "0", "\u2014").parallelStream().collect(Collectors.toSet());
        if (collect.contains(str)) {
            return null;
        }
        return str.replaceFirst("\u5927\u4e8e", "").replaceFirst("\u5c0f\u4e8e", "").replaceFirst(",<", "").replaceFirst("<", "").replaceFirst("\uff1c", "").replaceFirst(">", "").replaceFirst("\uff1e", "");
    }

    public RiskExposeEvaluate getByCheckId(Long checkId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(RiskExposeEvaluate::getCheckPlanId, (Object)checkId)).eq(BaseEntity::getIsValid, (Object)true);
        List list = this.list((Wrapper)wrapper);
        return list == null || list.isEmpty() ? null : (RiskExposeEvaluate)list.get(0);
    }

    public void deleteByCheckId(Long checkId) {
        if (checkId == null) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(RiskExposeEvaluate::getCheckPlanId, (Object)checkId)).eq(BaseEntity::getIsValid, (Object)true);
        List list = this.list((Wrapper)wrapper);
        if (list != null) {
            for (RiskExposeEvaluate eve : list) {
                eve.setIsValid(Boolean.valueOf(false));
                this.updateById(eve);
                this.exposeEvaluateDataService.logicDelByEvId(eve.getId());
            }
        }
    }

    public RiskExposeEvaluate getLatestByOrgAndCom(Long orgId, Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(RiskExposeEvaluate::getOrgId, (Object)orgId)).eq(RiskExposeEvaluate::getCid, (Object)cid)).orderByDesc(BaseEntity::getUpdateDate);
        List list = this.list((Wrapper)wrapper);
        return list == null || list.isEmpty() ? null : (RiskExposeEvaluate)list.get(0);
    }

    public RiskExposeEvaluate getFromCheckPlanByOrgAndCom(Long orgId, Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(RiskExposeEvaluate::getOrgId, (Object)orgId)).eq(RiskExposeEvaluate::getCid, (Object)cid)).eq(RiskExposeEvaluate::getType, (Object)1)).isNotNull(RiskExposeEvaluate::getCheckPlanId);
        List list = this.list((Wrapper)wrapper);
        return list == null || list.isEmpty() ? null : (RiskExposeEvaluate)list.get(0);
    }

    public PageInfo<RiskExposeEvaluateVo> queryPage(EvQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<RiskExposeEvaluateVo> list = ((RiskExposeEvaluateMapper)this.baseMapper).queryPage(param);
        return new PageInfo(list);
    }

    public RiskDecisionVo queryTouchNumAndLevel(Long evId) {
        RiskExposeEvaluate ev = (RiskExposeEvaluate)this.getById(evId);
        if (ev == null) {
            return null;
        }
        if (ev.getType().equals(1)) {
            return this.stateByCheckPoint(ev);
        }
        return this.statByWorkName(ev);
    }

    private RiskDecisionVo stateByCheckPoint(RiskExposeEvaluate ev) {
        return this.doStateRiskDecisionVo(ev);
    }

    private RiskDecisionVo statByWorkName(RiskExposeEvaluate ev) {
        return this.doStateRiskDecisionVo(ev);
    }

    private RiskDecisionVo doStateRiskDecisionVo(RiskExposeEvaluate ev) {
        RiskDecisionVo vo = new RiskDecisionVo();
        List<RiskExposeEvaluateData> list = this.exposeEvaluateDataService.queryByEvId(ev.getId());
        list = this.removeDuplicateDust(list);
        list = this.removeDuplicateCount(list);
        HashMap<String, Map> map = new HashMap<String, Map>();
        for (RiskExposeEvaluateData riskExposeEvaluateData : list) {
            Integer checkTouchLevel;
            Integer nature;
            Integer workNum = riskExposeEvaluateData.getWorkNum();
            if (workNum == null || riskExposeEvaluateData.getFactorNature() == null || riskExposeEvaluateData.getTouchLevel() == null) continue;
            String workName = riskExposeEvaluateData.getWorkName();
            String checkPoint = riskExposeEvaluateData.getCheckPoint();
            String factorId = riskExposeEvaluateData.getFactorId() == null ? "0" : riskExposeEvaluateData.getFactorId();
            String key = workName + factorId;
            if (ev.getType().equals(1)) {
                key = checkPoint + factorId;
            }
            if (key == null || key.isEmpty()) continue;
            Map workNameMap = map.computeIfAbsent(key, k -> new HashMap());
            Map natureMap = workNameMap.computeIfAbsent(nature = riskExposeEvaluateData.getFactorNature(), k -> new HashMap());
            Integer userNum = (Integer)natureMap.get(checkTouchLevel = riskExposeEvaluateData.getCheckTouchLevel());
            if (userNum != null) {
                natureMap.put(checkTouchLevel, userNum + workNum);
                continue;
            }
            natureMap.put(checkTouchLevel, riskExposeEvaluateData.getWorkNum());
        }
        for (Map.Entry entry : map.entrySet()) {
            Map value = (Map)entry.getValue();
            for (Map.Entry natureEntry : value.entrySet()) {
                Integer nature = (Integer)natureEntry.getKey();
                Map touchLevelNum = (Map)natureEntry.getValue();
                if (nature.equals(1)) {
                    vo.setGeneralOverStaffCount(Integer.valueOf(vo.getGeneralOverStaffCount() + (touchLevelNum.get(1) == null ? 0 : (Integer)touchLevelNum.get(1))));
                    vo.setGeneralNotOverStaffCount(Integer.valueOf(vo.getGeneralNotOverStaffCount() + (touchLevelNum.get(2) == null ? 0 : (Integer)touchLevelNum.get(2))));
                    continue;
                }
                vo.setSeriousOverStaffCount(Integer.valueOf(vo.getSeriousOverStaffCount() + (touchLevelNum.get(1) == null ? 0 : (Integer)touchLevelNum.get(1))));
                vo.setSeriousNotOverStaffCount(Integer.valueOf(vo.getSeriousNotOverStaffCount() + (touchLevelNum.get(2) == null ? 0 : (Integer)touchLevelNum.get(2))));
            }
        }
        this.setRiskLevel(vo, ev);
        return vo;
    }

    private List<RiskExposeEvaluateData> removeDuplicateDust(List<RiskExposeEvaluateData> list) {
        HashMap<CallSite, RiskExposeEvaluateData> dustMap = new HashMap<CallSite, RiskExposeEvaluateData>();
        ArrayList<RiskExposeEvaluateData> newList = new ArrayList<RiskExposeEvaluateData>();
        for (RiskExposeEvaluateData ev : list) {
            if (ev.getFactorId() != null && ev.getWorkshop() != null && ev.getWorkName() != null) {
                String key = ev.getFactorId() + "-" + ev.getWorkshop() + "-" + ev.getWorkName();
                RiskExposeEvaluateData ev1 = (RiskExposeEvaluateData)dustMap.get(key);
                if (ev1 == null) {
                    dustMap.put((CallSite)((Object)key), ev);
                    continue;
                }
                if (ev.getWorkNum() != null && ev1.getWorkNum() != null && ev.getWorkNum() > ev1.getWorkNum()) {
                    ev1.setWorkNum(ev.getWorkNum());
                }
                if (ev.getWorkNum() == null) {
                    ev1.setWorkNum(ev.getWorkNum());
                }
                if (ev.getCheckTouchLevel() != null && ev.getCheckTouchLevel() == 1) {
                    ev1.setCheckTouchLevel(ev.getCheckTouchLevel());
                }
                dustMap.put((CallSite)((Object)key), ev1);
                continue;
            }
            newList.add(ev);
        }
        ArrayList dustList = new ArrayList(dustMap.values());
        if (dustList.size() > 0) {
            newList.addAll(dustList);
        }
        return newList;
    }

    private List<RiskExposeEvaluateData> removeDuplicateCount(List<RiskExposeEvaluateData> list) {
        HashMap<CallSite, RiskExposeEvaluateData> dustMap = new HashMap<CallSite, RiskExposeEvaluateData>();
        ArrayList<RiskExposeEvaluateData> newList = new ArrayList<RiskExposeEvaluateData>();
        for (RiskExposeEvaluateData ev : list) {
            if (ev.getWorkshop() != null && ev.getWorkName() != null && ev.getWorkNum() != null && ev.getFactorNature() != null && ev.getCheckTouchLevel() != null) {
                String key = ev.getWorkshop() + "-" + ev.getWorkName() + "-" + ev.getWorkNum() + "-" + ev.getFactorNature() + "-" + ev.getCheckTouchLevel();
                dustMap.putIfAbsent((CallSite)((Object)key), ev);
                continue;
            }
            newList.add(ev);
        }
        ArrayList dustList = new ArrayList(dustMap.values());
        if (dustList.size() > 0) {
            newList.addAll(dustList);
        }
        return newList;
    }

    private void setRiskLevel(RiskDecisionVo vo, RiskExposeEvaluate ev) {
        HazardsExposureRiskLevelVo level = new HazardsExposureRiskLevelVo();
        Date newRiskLevelDate = DateUtils.parseDate((Object)"2022-11-28 00:00:00");
        level = DateUtils.compareDate((Date)DateUtils.localDateTimeToDate((LocalDateTime)ev.getDataUpdateDate()), (Date)newRiskLevelDate) < 0L ? HazardsExposureRiskLevelEnum.getFinalThisEnumByStaffCountOld((int)vo.getGeneralOverStaffCount(), (int)vo.getGeneralNotOverStaffCount(), (int)vo.getSeriousOverStaffCount(), (int)vo.getSeriousNotOverStaffCount()) : HazardsExposureRiskLevelEnum.getFinalThisEnumByStaffCountNew((int)vo.getGeneralOverStaffCount(), (int)vo.getGeneralNotOverStaffCount(), (int)vo.getSeriousOverStaffCount(), (int)vo.getSeriousNotOverStaffCount());
        vo.setRiskLevel(level.getRiskLevel());
        vo.setGeneralNotOverRiskLevel(level.getGeneralNotOverRiskLevel());
        vo.setGeneralOverRiskLevel(level.getGeneralOverRiskLevel());
        vo.setSeriousNotOverRiskLevel(level.getSeriousNotOverRiskLevel());
        vo.setSeriousOverRiskLevel(level.getSeriousOverRiskLevel());
    }

    public PageInfo<RiskEvaluateSelfCheckVo> queryPageListReports(QueryPageListReportsParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<RiskEvaluateSelfCheckVo> selfCheck = ((RiskExposeEvaluateMapper)this.baseMapper).querySelfCheck(param.getCid());
        for (RiskEvaluateSelfCheckVo vo : selfCheck) {
            if (vo.getCheckDate() == null) continue;
            if (vo.getCheckDate().getYear() <= 2022) {
                vo.setEvaluateYear("2022\u5e74\u5ea6");
                continue;
            }
            vo.setEvaluateYear(Integer.toString(LocalDateTime.now().getYear()));
        }
        return new PageInfo(selfCheck);
    }

    @Transactional(readOnly=false)
    public RiskExposeEvaluate getLatestEv(Long cid, Integer year, Integer reportStatus) {
        RiskExposeEvaluate riskExposeEvaluate = null;
        ArrayList<Integer> yearsOut = new ArrayList<Integer>();
        if (year == null) {
            int currYear = LocalDateTime.now().getYear();
            yearsOut.addAll(Arrays.asList(currYear - 3, currYear - 2, currYear - 1, currYear));
        } else {
            yearsOut.add(year);
        }
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company.getIsExistRadioactivity().booleanValue()) {
            riskExposeEvaluate = ((RiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, yearsOut, null, reportStatus);
            if (riskExposeEvaluate == null) {
                return riskExposeEvaluate;
            }
            ArrayList<Integer> yearsIn = new ArrayList<Integer>(Arrays.asList(riskExposeEvaluate.getCheckDate().getYear() - 2, riskExposeEvaluate.getCheckDate().getYear() - 1, riskExposeEvaluate.getCheckDate().getYear()));
            if (StringUtils.isEmpty((CharSequence)riskExposeEvaluate.getRedundantSourceTablesIds())) {
                RiskExposeEvaluate temp = this.mergerAdiationAndWandaRisk2(cid, null, yearsIn, reportStatus);
                if (temp != null) {
                    riskExposeEvaluate = temp;
                }
            } else {
                riskExposeEvaluate = this.mergerAdiationAndWandaRisk2(cid, riskExposeEvaluate.getId(), yearsIn, reportStatus);
            }
        } else {
            riskExposeEvaluate = ((RiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, yearsOut, null, reportStatus);
        }
        return riskExposeEvaluate;
    }

    @Transactional(readOnly=false)
    public RiskExposeEvaluate getLatestNeedReportEv(Long cid) {
        RiskExposeEvaluate riskExposeEvaluate = null;
        int currYear = LocalDateTime.now().getYear();
        ArrayList<Integer> yearsOut = new ArrayList<Integer>(Arrays.asList(currYear - 3, currYear - 2, currYear - 1, currYear));
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company.getIsExistRadioactivity().booleanValue()) {
            riskExposeEvaluate = this.getLatestNeedReportEvByType(cid, null, yearsOut);
            if (riskExposeEvaluate == null) {
                return riskExposeEvaluate;
            }
            ArrayList<Integer> yearsIn = new ArrayList<Integer>(Arrays.asList(riskExposeEvaluate.getCheckDate().getYear() - 2, riskExposeEvaluate.getCheckDate().getYear() - 1, riskExposeEvaluate.getCheckDate().getYear()));
            if (StringUtils.isEmpty((CharSequence)riskExposeEvaluate.getRedundantSourceTablesIds())) {
                RiskExposeEvaluate temp = this.mergerAdiationAndWandaRisk(cid, null, yearsIn);
                if (temp != null) {
                    riskExposeEvaluate = temp;
                }
            } else {
                riskExposeEvaluate = this.mergerAdiationAndWandaRisk(cid, riskExposeEvaluate.getId(), yearsIn);
            }
        } else {
            riskExposeEvaluate = this.getLatestNeedReportEvByType(cid, null, yearsOut);
        }
        return riskExposeEvaluate;
    }

    public RiskExposeEvaluate getLatestNeedReportEvByType(Long cid, Integer type, List<Integer> years) {
        RiskExposeEvaluate finalData = null;
        RiskExposeEvaluate completeStatus = ((RiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, years, type, 4);
        RiskExposeEvaluate reportStatus = ((RiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, years, type, 2);
        if (completeStatus == null) {
            finalData = reportStatus;
        } else {
            if (reportStatus == null) {
                return null;
            }
            if (reportStatus.getCheckDate() != null && reportStatus.getCheckDate().isAfter(completeStatus.getCheckDate()) || reportStatus.getCheckDate() != null && reportStatus.getCheckDate().isEqual(completeStatus.getCheckDate()) && completeStatus.getUpdateDate() == null || reportStatus.getCheckDate() != null && reportStatus.getCheckDate().isEqual(completeStatus.getCheckDate()) && reportStatus.getCreateDate() != null && reportStatus.getCreateDate().isAfter(completeStatus.getUpdateDate())) {
                finalData = reportStatus;
            }
        }
        return finalData;
    }

    public List<ComEvModel> comEvModel(ComEvModelParam param) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).ne(RiskExposeEvaluate::getReportStatus, (Object)1);
        if (param.getCid() != null) {
            wrapper.eq(RiskExposeEvaluate::getCid, (Object)param.getCid());
        }
        if (param.getStartTime() != null) {
            wrapper.ge(RiskExposeEvaluate::getCheckDate, (Object)param.getStartTime());
        }
        if (param.getEndTime() != null) {
            wrapper.le(RiskExposeEvaluate::getCheckDate, (Object)param.getEndTime());
        }
        List list = this.list((Wrapper)wrapper);
        return this.toComEvModel(list);
    }

    public Map<Long, RiskExposeEvaluate> queryByIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new HashMap<Long, RiskExposeEvaluate>();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).in(BaseEntity::getId, ids);
        List list = this.list((Wrapper)wrapper);
        HashMap<Long, RiskExposeEvaluate> map = new HashMap<Long, RiskExposeEvaluate>();
        for (RiskExposeEvaluate evaluate : list) {
            map.put(evaluate.getId(), evaluate);
        }
        return map;
    }

    public void updateRiskLevel(Long evId) {
        RiskExposeEvaluate evaluate = (RiskExposeEvaluate)this.get(evId);
        RiskDecisionVo riskDecisionVo = this.queryTouchNumAndLevel(evId);
        if (riskDecisionVo != null) {
            String riskLevel = riskDecisionVo.getRiskLevel();
            if ("\u2160\u7ea7".equals(riskLevel)) {
                evaluate.setRiskLevel(Integer.valueOf(1));
            } else if ("\u2161\u7ea7".equals(riskLevel)) {
                evaluate.setRiskLevel(Integer.valueOf(2));
            } else if ("\u2162\u7ea7".equals(riskLevel)) {
                evaluate.setRiskLevel(Integer.valueOf(3));
            }
            this.updateById(evaluate);
        }
    }

    public FactorTouchNumVo deleteKey(GradeSearchBaseModel gradeSearchBaseModel) {
        String key = gradeSearchBaseModel.getAreaId() + "-" + gradeSearchBaseModel.getIsBelongType() + "-" + gradeSearchBaseModel.getOrgAreaId();
        FactorTouchNumVo vo = this.riskTouchNumStatCache.get(key);
        this.riskTouchNumStatCache.delete(key);
        return vo;
    }

    public FactorTouchNumVo touchNumStatByReport(GradeSearchBaseModel gradeSearchBaseModel) {
        return ((RiskExposeEvaluateMapper)this.baseMapper).collectFactorTouchNumVo(gradeSearchBaseModel);
    }

    public FactorTouchNumVo touchNumStat(GradeSearchBaseModel gradeSearchBaseModel) {
        String key = gradeSearchBaseModel.getAreaId() + "-" + gradeSearchBaseModel.getIsBelongType() + "-" + gradeSearchBaseModel.getOrgAreaId();
        FactorTouchNumVo vo = null;
        try {
            vo = this.riskTouchNumStatCache.get(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vo != null) {
            return vo;
        }
        vo = new FactorTouchNumVo();
        Map<Long, String> idAndTypeMap = this.factorService.doGetAllIdAndTypeMap();
        List<RiskExposeEvaluateData> dataList = ((RiskExposeEvaluateMapper)this.baseMapper).dataListByArea(gradeSearchBaseModel);
        if (dataList != null && dataList.size() > 0) {
            for (RiskExposeEvaluateData data : dataList) {
                if (data == null || !StringUtils.isNotEmpty((String)data.getFactorId()) || data.getWorkNum() == null) continue;
                vo.setTouchTotalNum(Integer.valueOf(vo.getTouchTotalNum() + data.getWorkNum()));
                if (data.getFactorId().equals("567")) {
                    vo.setTouchNoiseNum(Integer.valueOf(vo.getTouchNoiseNum() + data.getWorkNum()));
                }
                String s = null;
                if (!data.getFactorId().contains(",")) {
                    s = idAndTypeMap.get(Long.parseLong(data.getFactorId()));
                }
                if ("\u5316\u5b66\u56e0\u7d20".equals(s)) {
                    vo.setTouchChemicalNum(Integer.valueOf(vo.getTouchChemicalNum() + data.getWorkNum()));
                }
                if ("\u7c89\u5c18".equals(s)) {
                    vo.setTouchFenChenNum(Integer.valueOf(vo.getTouchFenChenNum() + data.getWorkNum()));
                }
                if (data.getFactorNature() == null) continue;
                if (data.getFactorNature().equals(1)) {
                    vo.setGeneraFactorTouchNum(Integer.valueOf(vo.getGeneraFactorTouchNum() + data.getWorkNum()));
                }
                if (!data.getFactorNature().equals(2)) continue;
                vo.setSeriousFactorTouchNum(Integer.valueOf(vo.getSeriousFactorTouchNum() + data.getWorkNum()));
            }
        }
        this.riskTouchNumStatCache.put(key, vo);
        return vo;
    }

    public FactorTouchNumVo touchNumStat2(GradeSearchBaseModel gradeSearchBaseModel) {
        FactorTouchNumVo vo = new FactorTouchNumVo();
        Map<Long, String> idAndTypeMap = this.factorService.doGetAllIdAndTypeMap();
        List<RiskExposeEvaluateData> dataList = ((RiskExposeEvaluateMapper)this.baseMapper).dataListByArea(gradeSearchBaseModel);
        if (dataList != null && dataList.size() > 0) {
            for (RiskExposeEvaluateData data : dataList) {
                if (data == null || !StringUtils.isNotEmpty((String)data.getFactorId()) || data.getWorkNum() == null) continue;
                vo.setTouchTotalNum(Integer.valueOf(vo.getTouchTotalNum() + data.getWorkNum()));
                if (data.getFactorId().equals("567")) {
                    vo.setTouchNoiseNum(Integer.valueOf(vo.getTouchNoiseNum() + data.getWorkNum()));
                }
                String s = null;
                if (!data.getFactorId().contains(",")) {
                    s = idAndTypeMap.get(Long.parseLong(data.getFactorId()));
                }
                if ("\u5316\u5b66\u56e0\u7d20".equals(s)) {
                    vo.setTouchChemicalNum(Integer.valueOf(vo.getTouchChemicalNum() + data.getWorkNum()));
                }
                if ("\u7c89\u5c18".equals(s)) {
                    vo.setTouchFenChenNum(Integer.valueOf(vo.getTouchFenChenNum() + data.getWorkNum()));
                }
                if (data.getFactorNature() == null) continue;
                if (data.getFactorNature().equals(1)) {
                    vo.setGeneraFactorTouchNum(Integer.valueOf(vo.getGeneraFactorTouchNum() + data.getWorkNum()));
                }
                if (!data.getFactorNature().equals(2)) continue;
                vo.setSeriousFactorTouchNum(Integer.valueOf(vo.getSeriousFactorTouchNum() + data.getWorkNum()));
            }
        }
        return vo;
    }

    public Map<Long, Integer> queryRiskLevelList(List<Long> evIds) {
        if (evIds == null || evIds.isEmpty()) {
            return new HashMap<Long, Integer>();
        }
        List<RiskExposeEvaluate> list = ((RiskExposeEvaluateMapper)this.baseMapper).queryRiskLevelList(evIds);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (RiskExposeEvaluate ev : list) {
            map.put(ev.getCid(), ev.getRiskLevel());
        }
        return map;
    }

    public Map<Long, Integer> queryRiskIdLevelMapList(List<Long> evIds) {
        if (evIds == null || evIds.isEmpty()) {
            return new HashMap<Long, Integer>();
        }
        List<RiskExposeEvaluate> list = ((RiskExposeEvaluateMapper)this.baseMapper).queryRiskLevelList(evIds);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (RiskExposeEvaluate ev : list) {
            map.put(ev.getId(), ev.getRiskLevel());
        }
        return map;
    }

    public List<RiskExposeEvaluate> getbyOrgId(Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(RiskExposeEvaluate::getOrgId, (Object)orgId);
        return this.list((Wrapper)wrapper);
    }

    private List<ComEvModel> toComEvModel(List<RiskExposeEvaluate> list) {
        LinkedList<ComEvModel> rList = new LinkedList<ComEvModel>();
        Map<Long, List<RiskExposeEvaluate>> comMap = this.groupByCom(list);
        for (Map.Entry<Long, List<RiskExposeEvaluate>> entry : comMap.entrySet()) {
            ComEvModel model = this.toComEvModelByComList(entry.getValue());
            if (model == null) continue;
            rList.add(model);
        }
        return rList;
    }

    private ComEvModel toComEvModelByComList(List<RiskExposeEvaluate> value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        value.sort((o1, o2) -> {
            if (o1.getCheckDate() == null) {
                return 1;
            }
            if (o2.getCheckDate() == null) {
                return -1;
            }
            return o2.getCheckDate().compareTo(o1.getCheckDate());
        });
        ComEvModel comEvModel = new ComEvModel();
        comEvModel.setReportStatus(Integer.valueOf(4));
        for (RiskExposeEvaluate evaluate : value) {
            if (comEvModel.getRiskLevel() == null) {
                comEvModel.setRiskLevel(evaluate.getRiskLevel());
                comEvModel.setCid(evaluate.getCid());
                comEvModel.setEvId(evaluate.getId());
            }
            if (evaluate.getReportStatus().equals(2)) {
                comEvModel.setReportStatus(Integer.valueOf(2));
            }
            if (!evaluate.getReportStatus().equals(3) || comEvModel.getReportStatus().equals(2)) continue;
            comEvModel.setReportStatus(Integer.valueOf(3));
        }
        return comEvModel;
    }

    private Map<Long, List<RiskExposeEvaluate>> groupByCom(List<RiskExposeEvaluate> list) {
        HashMap<Long, List<RiskExposeEvaluate>> map = new HashMap<Long, List<RiskExposeEvaluate>>();
        for (RiskExposeEvaluate riskExposeEvaluate : list) {
            List l = map.computeIfAbsent(riskExposeEvaluate.getCid(), k -> new LinkedList());
            l.add(riskExposeEvaluate);
        }
        return map;
    }

    @Transactional(readOnly=false)
    public int updateRiskExposeCheckState(Long evId, Integer state, Long userId, String reason, String backType) {
        LocalDateTime now = LocalDateTime.now();
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(RiskExposeEvaluate::getReportStatus, (Object)state);
        wrapper.ne(RiskExposeEvaluate::getReportStatus, (Object)state);
        wrapper.set(BaseEntity::getUpdateDate, (Object)now);
        wrapper.set(BaseEntity::getUpdateBy, (Object)userId);
        wrapper.eq(BaseEntity::getId, (Object)evId);
        boolean update = this.update((Wrapper)wrapper);
        RiskExposeEvaluate oldRisk = (RiskExposeEvaluate)this.getById(evId);
        if (update) {
            if (state == 3) {
                String[] split;
                if (StringUtils.isEmpty((CharSequence)oldRisk.getRedundantSourceTablesIds()) && StringUtils.isEmpty((CharSequence)oldRisk.getWandaZywsCheckId())) {
                    Long oldRiskId = evId;
                    Long newRiskId = this.idworker.nextId();
                    RiskExposeEvaluate newRisk = new RiskExposeEvaluate();
                    BeanUtils.copyProperties((Object)oldRisk, (Object)newRisk);
                    newRisk.setId(newRiskId);
                    newRisk.setFlag(Integer.valueOf(1));
                    newRisk.setSourceId(oldRiskId);
                    oldRisk = new RiskExposeEvaluate();
                    oldRisk.setId(oldRiskId);
                    oldRisk.setFlag(Integer.valueOf(0));
                    oldRisk.setSourceId(newRiskId);
                    this.save(newRisk);
                    this.updateById(oldRisk);
                    List riskExposeEvaluateDataList = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().eq(RiskExposeEvaluateData::getRiskExposeEvaluateId, (Object)oldRiskId)).list();
                    for (RiskExposeEvaluateData riskExposeEvaluateData : riskExposeEvaluateDataList) {
                        riskExposeEvaluateData.setId(Long.valueOf(this.idworker.nextId()));
                        riskExposeEvaluateData.setRiskExposeEvaluateId(newRiskId);
                    }
                    this.exposeEvaluateDataService.saveBatch((Collection)riskExposeEvaluateDataList);
                }
                this.backToWanda(oldRisk, reason);
                if (StringUtils.isNotBlank((CharSequence)oldRisk.getRedundantSourceTablesIds())) {
                    if (StringUtils.isBlank((CharSequence)backType)) {
                        backType = "1,2";
                    }
                    if ((split = oldRisk.getRedundantSourceTablesIds().split(",")).length == 2) {
                        List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                        List evaluateList = this.getByIds(collect);
                        for (RiskExposeEvaluate riskExposeEvaluate : evaluateList) {
                            LambdaUpdateWrapper updateWrapper;
                            if (riskExposeEvaluate.getWandaZywsCheckId() == null && backType.contains("1")) {
                                updateWrapper = Wrappers.lambdaUpdate();
                                updateWrapper.set(RiskExposeEvaluate::getReportStatus, (Object)state);
                                updateWrapper.set(BaseEntity::getUpdateDate, (Object)now);
                                updateWrapper.set(BaseEntity::getUpdateBy, (Object)userId);
                                updateWrapper.eq(BaseEntity::getId, (Object)riskExposeEvaluate.getId());
                                updateWrapper.ne(RiskExposeEvaluate::getReportStatus, (Object)state);
                                boolean bl = this.update((Wrapper)updateWrapper);
                            }
                            if (riskExposeEvaluate.getWandaZywsCheckId() == null || !backType.contains("2")) continue;
                            updateWrapper = Wrappers.lambdaUpdate();
                            updateWrapper.set(RiskExposeEvaluate::getReportStatus, (Object)state);
                            updateWrapper.set(BaseEntity::getUpdateDate, (Object)now);
                            updateWrapper.set(BaseEntity::getUpdateBy, (Object)userId);
                            updateWrapper.eq(BaseEntity::getId, (Object)riskExposeEvaluate.getId());
                            updateWrapper.ne(RiskExposeEvaluate::getReportStatus, (Object)state);
                            boolean temp = this.update((Wrapper)updateWrapper);
                            this.backToWanda(riskExposeEvaluate, reason);
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)oldRisk.getRedundantSourceTablesIds()) && StringUtils.isNotBlank((CharSequence)backType) && !backType.equals("1,2") && (split = backType.split(",")).length == 1) {
                    LambdaUpdateWrapper wrapper2 = Wrappers.lambdaUpdate();
                    wrapper2.set(RiskExposeEvaluate::getReportStatus, (Object)state);
                    wrapper2.set(BaseEntity::getUpdateDate, (Object)now.plusMinutes(1L));
                    wrapper2.set(BaseEntity::getUpdateBy, (Object)userId);
                    wrapper2.eq(BaseEntity::getId, (Object)Long.parseLong(split[0]));
                    this.update((Wrapper)wrapper2);
                }
                return 1;
            }
            if (state == 4) {
                if (StringUtils.isNotEmpty((String)oldRisk.getRedundantSourceTablesIds())) {
                    String[] split = oldRisk.getRedundantSourceTablesIds().split(",");
                    if (split.length == 2) {
                        List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                        List evaluateList = this.getByIds(collect);
                        for (RiskExposeEvaluate riskExposeEvaluate : evaluateList) {
                            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                            updateWrapper.set(RiskExposeEvaluate::getReportStatus, (Object)state);
                            updateWrapper.set(BaseEntity::getUpdateDate, (Object)now.minusMinutes(1L));
                            updateWrapper.set(BaseEntity::getUpdateBy, (Object)userId);
                            updateWrapper.eq(BaseEntity::getId, (Object)riskExposeEvaluate.getId());
                            boolean bl = this.update((Wrapper)updateWrapper);
                        }
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        return 0;
    }

    private void backToWanda(RiskExposeEvaluate oldRisk, String reason) {
        WandaCheckReturn wandaCheckReturn = new WandaCheckReturn();
        wandaCheckReturn.setCheckId(oldRisk.getWandaZywsCheckId());
        wandaCheckReturn.setId(Long.valueOf(this.idworker.nextId()));
        wandaCheckReturn.setReturnTime(new Date());
        wandaCheckReturn.setDealState(WandDealStateEnm.five.getCode().toString());
        wandaCheckReturn.setReason(WandCheckBackTypeEnm.normal.getName() + ":" + reason);
        wandaCheckReturn.setType(WandCheckBackTypeEnm.normal.getCode());
        if (StringUtils.isEmpty((CharSequence)oldRisk.getRedundantSourceTablesIds()) && StringUtils.isNotEmpty((String)oldRisk.getWandaZywsCheckId())) {
            this.wandaCheckReturnService.backToWanda(wandaCheckReturn);
        }
        if (StringUtils.isEmpty((CharSequence)oldRisk.getRedundantSourceTablesIds()) && StringUtils.isNotEmpty((String)oldRisk.getWandaZywsReportId())) {
            this.wandaCheckReturnService.backToGiian4181(wandaCheckReturn);
        }
    }

    public List<RiskExposeEvaluate> listRiskEvaluateLasted(Date beginDate, Date endDate, List<Long> cids) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BaseEntity::getIsValid, (Object)true);
        Long totol = 1000L;
        if (CollectionUtils.isNotEmpty(cids)) {
            cids = cids.stream().filter(cid -> Objects.nonNull(cid)).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(cids)) {
            queryWrapper.in(RiskExposeEvaluate::getCid, cids);
        } else {
            totol = ((RiskExposeEvaluateMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        }
        return ((RiskExposeEvaluateMapper)this.baseMapper).listRiskEvaluateLasted(beginDate, endDate, cids, totol);
    }

    public List<String> updateRiskLevel() {
        this.logger.info("\u67e5\u8be2\u5f02\u5e38\u66b4\u9732\u98ce\u9669");
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BaseEntity::getIsValid, (Object)true);
        queryWrapper.between(RiskExposeEvaluate::getReportStatus, (Object)2, (Object)4);
        List list = ((RiskExposeEvaluateMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        ArrayList<String> resList = new ArrayList<String>();
        if (list != null) {
            for (RiskExposeEvaluate risk : list) {
                RiskDecisionVo riskDecisionVo = this.queryTouchNumAndLevel(risk.getId());
                if (riskDecisionVo == null) continue;
                Integer level = 1;
                String riskLevel = riskDecisionVo.getRiskLevel();
                if ("\u2160\u7ea7".equals(riskLevel)) {
                    level = 1;
                } else if ("\u2161\u7ea7".equals(riskLevel)) {
                    level = 2;
                } else if ("\u2162\u7ea7".equals(riskLevel)) {
                    level = 3;
                }
                if (risk.getRiskLevel() != null && risk.getRiskLevel().equals(level)) continue;
                String error = "\u4f01\u4e1aid\uff1a" + risk.getCid() + "\u66b4\u9732\u98ce\u9669id\uff1a" + risk.getId() + "\u66b4\u9732\u98ce\u9669\u6c34\u5e73\u4e0d\u7b26,\u5e94\u4e3a" + level + "\u7ea7\uff0c\u6570\u636e\u5e93\u4e3a" + risk.getRiskLevel() + "\u7ea7\u3002";
                risk.setRiskLevel(level);
                resList.add(error);
                this.logger.info("updateRiskLevel-" + error);
            }
            this.logger.info("\u67e5\u8be2\u5f02\u5e38\u66b4\u9732\u98ce\u9669\u7ed3\u675f");
            return resList;
        }
        return null;
    }

    public List<Map> listRiskEvaluateCompanyInfo(Long areaId, Byte areaLevel) {
        return ((RiskExposeEvaluateMapper)this.baseMapper).listRiskEvaluateCompanyInfo(areaId, areaLevel);
    }

    public List<RiskExposeEvaluate> updateRiskLevelAndLog(Integer page, Integer size) {
        this.logger.info("\u67e5\u8be2\u5f02\u5e38\u66b4\u9732\u98ce\u9669");
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BaseEntity::getIsValid, (Object)true);
        queryWrapper.eq(RiskExposeEvaluate::getReportStatus, (Object)2);
        queryWrapper.isNull(RiskExposeEvaluate::getRiskLevel);
        PageHelper.startPage((int)page, (int)size);
        List list = ((RiskExposeEvaluateMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list != null) {
            for (RiskExposeEvaluate risk : list) {
                RiskDecisionVo riskDecisionVo = this.queryTouchNumAndLevel(risk.getId());
                if (riskDecisionVo == null) continue;
                Integer level = 1;
                String riskLevel = riskDecisionVo.getRiskLevel();
                if ("\u2160\u7ea7".equals(riskLevel)) {
                    level = 1;
                } else if ("\u2161\u7ea7".equals(riskLevel)) {
                    level = 2;
                } else if ("\u2162\u7ea7".equals(riskLevel)) {
                    level = 3;
                }
                risk.setRiskLevel(level);
                this.updateById(risk);
            }
            this.logger.info("\u67e5\u8be2\u5f02\u5e38\u66b4\u9732\u98ce\u9669\u7ed3\u675f");
            return list;
        }
        return null;
    }

    public List<RiskExposeEvaluate> updateRiskLevelNew(List<RiskExposeEvaluate> list) {
        if (list != null) {
            for (RiskExposeEvaluate risk : list) {
                RiskDecisionVo riskDecisionVo = this.queryTouchNumAndLevel(risk.getId());
                if (riskDecisionVo == null) continue;
                Integer level = 1;
                String riskLevel = riskDecisionVo.getRiskLevel();
                if ("\u2160\u7ea7".equals(riskLevel)) {
                    level = 1;
                } else if ("\u2161\u7ea7".equals(riskLevel)) {
                    level = 2;
                } else if ("\u2162\u7ea7".equals(riskLevel)) {
                    level = 3;
                }
                risk.setRiskLevel(level);
                this.updateById(risk);
            }
            this.logger.info("\u67e5\u8be2\u5f02\u5e38\u66b4\u9732\u98ce\u9669\u7ed3\u675f");
            return list;
        }
        return null;
    }

    public Integer getContactHarmComNumByArea(Long areaId, Byte areaLevel, Boolean isBelongType) {
        Set<Long> list = this.getContactHarmComCidByArea(areaId, areaLevel, isBelongType);
        return CollectionUtils.isNotEmpty(list) ? list.size() : 0;
    }

    public Set<Long> getContactHarmComCidByArea(Long areaId, Byte areaLevel, Boolean isBelongType) {
        return ((RiskExposeEvaluateMapper)this.baseMapper).getContactHarmComCidByArea(areaId, areaLevel, isBelongType);
    }

    public Map<String, Integer> getContactHarmTypeComNumByArea(Long areaId, Byte areaLevel, Boolean isBelongType, Integer isFcImportanceCompany) {
        RiskPickUpReports riskPickUpReports = ((RiskExposeEvaluateMapper)this.baseMapper).harmComNumListByArea(areaId, areaLevel, isBelongType, isFcImportanceCompany);
        HashMap<String, Integer> resMap = new HashMap<String, Integer>();
        resMap.put("\u7c89\u5c18", riskPickUpReports.getFc());
        resMap.put("\u5316\u5b66", riskPickUpReports.getHx());
        resMap.put("\u7269\u7406", riskPickUpReports.getWl());
        resMap.put("\u751f\u7269", riskPickUpReports.getSw());
        resMap.put("\u5176\u4ed6", riskPickUpReports.getFs() + riskPickUpReports.getQt() + riskPickUpReports.getQtzdy());
        resMap.put("\u603b\u6570", riskPickUpReports.getTotal());
        return resMap;
    }

    public Map<String, Integer> getContactHarmTypeStaffNumByArea(GradeSearchBaseModel searchBaseModel) {
        RiskPickUpReports data = ((RiskExposeEvaluateMapper)this.baseMapper).dataListByArea2(searchBaseModel);
        HashMap<String, Integer> resMap = new HashMap<String, Integer>();
        resMap.put("\u7c89\u5c18", data.getFc());
        resMap.put("\u5316\u5b66", data.getHx());
        resMap.put("\u7269\u7406", data.getWl());
        resMap.put("\u751f\u7269", data.getSw());
        resMap.put("\u5176\u4ed6", data.getQt() + data.getQtzdy() + data.getFs());
        resMap.put("\u603b\u6570", data.getJhrs());
        return resMap;
    }

    public Integer getRiskComNumByArea(Long areaId, Byte areaLevel, Boolean isBelongType) {
        return ((RiskExposeEvaluateMapper)this.baseMapper).getRiskComNumByArea(areaId, areaLevel, isBelongType);
    }

    public void invalidRiskEv(Long cid, Long evId) {
        if (evId == null) {
            return;
        }
        RiskExposeEvaluate ev = (RiskExposeEvaluate)this.get(evId);
        if (ev == null) {
            return;
        }
        if (cid == null) {
            cid = ev.getId();
        }
        ((RiskExposeEvaluateMapper)this.baseMapper).invalidRiskEv(cid, ev.getCheckDateEnd(), evId);
    }

    public Set<Long> getIsGovern(List<Long> cids) {
        List<Long> count = ((RiskExposeEvaluateMapper)this.baseMapper).getIsGovernByCid(cids);
        if (CollectionUtils.isNotEmpty(count)) {
            Set<Long> cidSet = count.stream().collect(Collectors.toSet());
            return cidSet;
        }
        return null;
    }

    public Map<String, RiskExposeEvaluateData> getComConcatWorkAndDept(Long cid) {
        List dataList;
        if (cid == null) {
            return null;
        }
        HashMap<String, RiskExposeEvaluateData> map = new HashMap<String, RiskExposeEvaluateData>();
        RiskExposeEvaluate risk = ((RiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, null, null, 4);
        if (risk != null && (dataList = this.exposeEvaluateDataService.queryByEvId(risk.getId())) != null && dataList.size() > 0) {
            for (RiskExposeEvaluateData data : dataList) {
                RiskExposeEvaluateData data1 = (RiskExposeEvaluateData)map.get(data.getWorkshop() + "-" + data.getWorkName());
                if (data1 != null) {
                    data.setFactorId(data1.getFactorId() + "," + data.getFactorId());
                }
                map.put(data.getWorkshop() + "-" + data.getWorkName(), data);
            }
        }
        return map;
    }

    public List<Long> getAllRiskByNoChecked() {
        return ((RiskExposeEvaluateMapper)this.baseMapper).getAllRiskByNoChecked();
    }

    public List<RiskExposeEvaluate> getInfoList(List riskId) {
        return ((RiskExposeEvaluateMapper)this.baseMapper).getInfoList(riskId);
    }

    public Map<Long, CompanyOccTypeVo> getCompanyOccTypeMap(List<Long> cids, Date begin, Date end, Byte status) {
        HashMap<Long, CompanyOccTypeVo> map = new HashMap<Long, CompanyOccTypeVo>();
        List<CompanyOccTypeVo> occList = ((RiskExposeEvaluateMapper)this.baseMapper).getCompanyOccTypeList2(cids, begin, end, status);
        if (occList != null && occList.size() > 0) {
            for (CompanyOccTypeVo data : occList) {
                if (data.getOccType() != null) {
                    if (Objects.equals(data.getOccType(), (byte)1)) {
                        data.setOccType(Byte.valueOf(CompanyOccTypeEnum.SERIOUS.getCode().byteValue()));
                    } else {
                        data.setOccType(Byte.valueOf(CompanyOccTypeEnum.COMMON.getCode().byteValue()));
                    }
                }
                map.put(data.getCid(), data);
            }
        }
        return map;
    }

    public RiskExposeEvaluate getLastInfoToBeReviewedByCid(Long cid) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RiskExposeEvaluate::getCid, (Object)cid)).eq(RiskExposeEvaluate::getReportStatus, (Object)2)).eq(BaseEntity::getIsValid, (Object)true)).orderByDesc(RiskExposeEvaluate::getDataUpdateDate);
        List list = ((RiskExposeEvaluateMapper)this.dao).selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (RiskExposeEvaluate)list.get(0);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public List<RiskExposeEvaluate> getTouchHarmPeopleNumber(List<Long> cidList) {
        List<RiskExposeEvaluate> list = this.getLastEv(new EvQueryParam().setCidList(cidList).setIsOderByCheckDate(Boolean.valueOf(true)));
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<Long> riskIdList = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        List<RiskExposeEvaluate> tempList = ((RiskExposeEvaluateMapper)this.dao).getTouchHarmPeople(riskIdList);
        Iterator<RiskExposeEvaluate> iterator = tempList.iterator();
        RiskExposeEvaluate front = null;
        String flag = "first";
        while (iterator.hasNext()) {
            if (flag.equals("first")) {
                flag = "";
                front = iterator.next();
                continue;
            }
            RiskExposeEvaluate after = iterator.next();
            if (after.getCid().equals(front.getCid())) {
                if (!after.getWorkShopName().equals(front.getWorkShopName())) {
                    front.setWorkShopName(after.getWorkShopName());
                    front.setWorkNum(Integer.valueOf(front.getWorkNum() + after.getWorkNum()));
                }
                iterator.remove();
                continue;
            }
            front = after;
        }
        return tempList;
    }

    @Transactional
    public void insertTouchHarmPeopleNumber() {
        List<RiskExposeEvaluate> touchHarmPeopleNumber = this.getTouchHarmPeopleNumber(null);
        List splits = ListUtils.split(touchHarmPeopleNumber, (int)1000);
        try {
            ((RiskExposeEvaluateMapper)this.dao).delTouchHarmPeopleNumber();
            log.error("\u603b\u5171\u9700\u5904\u7406\u6570\u636e\u884c\u6570\uff1a{}", (Object)touchHarmPeopleNumber.size());
            for (List split : splits) {
                ((RiskExposeEvaluateMapper)this.dao).insertTouchHarmPeopleNumber(split);
                log.error("\u5904\u7406\u6570\u636e\u884c\u6570\uff1a{}", (Object)split.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int excuteSql(String sql) {
        PreparedStatement pst = null;
        SqlSession session = this.getSqlSession();
        int row = 0;
        try {
            pst = session.getConnection().prepareStatement(sql);
            row = pst.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.closeSqlSession(session);
        }
        return row;
    }

    public SqlSession getSqlSession() {
        return SqlSessionUtils.getSqlSession((SqlSessionFactory)this.sqlSessionTemplate.getSqlSessionFactory(), (ExecutorType)this.sqlSessionTemplate.getExecutorType(), (PersistenceExceptionTranslator)this.sqlSessionTemplate.getPersistenceExceptionTranslator());
    }

    public void closeSqlSession(SqlSession session) {
        SqlSessionUtils.closeSqlSession((SqlSession)session, (SqlSessionFactory)this.sqlSessionTemplate.getSqlSessionFactory());
    }

    @Transactional(readOnly=false)
    public Long backSubmitChangeOldId(RiskExposeEvaluate exposeEvaluate) {
        Long oldRiskId = exposeEvaluate.getSourceId();
        Long newRiskId = exposeEvaluate.getId();
        Long tempId = this.idworker.nextId();
        ((RiskExposeEvaluateMapper)this.dao).updateRiskId(tempId, oldRiskId);
        ((RiskExposeEvaluateMapper)this.dao).updateRiskDataId(tempId, oldRiskId);
        ((RiskExposeEvaluateMapper)this.dao).updateRiskId(oldRiskId, newRiskId);
        ((RiskExposeEvaluateMapper)this.dao).updateRiskDataId(oldRiskId, newRiskId);
        ((RiskExposeEvaluateMapper)this.dao).updateRiskId(newRiskId, tempId);
        ((RiskExposeEvaluateMapper)this.dao).updateRiskDataId(newRiskId, tempId);
        RiskExposeEvaluate riskExposeEvaluate = new RiskExposeEvaluate();
        riskExposeEvaluate.setId(newRiskId);
        riskExposeEvaluate.setIsValid(Boolean.valueOf(false));
        riskExposeEvaluate.setSourceId(oldRiskId);
        riskExposeEvaluate.setFlag(Integer.valueOf(2));
        this.updateById(riskExposeEvaluate);
        return oldRiskId;
    }

    @Transactional(readOnly=false)
    public List<RiskExposeEvaluate> getRiskByCheckIdAndDeleteOther(List<Long> checkPlanIdList) {
        ArrayList<RiskExposeEvaluate> list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(RiskExposeEvaluate::getCheckPlanId, checkPlanIdList)).eq(BaseEntity::getIsValid, (Object)true)).isNull(RiskExposeEvaluate::getRedundantSourceTablesIds)).notIn(RiskExposeEvaluate::getReportStatus, Arrays.asList(4, 5))).select(new SFunction[]{BaseEntity::getId, RiskExposeEvaluate::getCheckPlanId, BaseEntity::getCreateDate}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        list = new ArrayList<RiskExposeEvaluate>(list.stream().collect(Collectors.toMap(RiskExposeEvaluate::getCheckPlanId, Function.identity(), (a, b) -> {
            int dateCompare = a.getCreateDate().compareTo(b.getCreateDate());
            if (dateCompare != 0) {
                return dateCompare > 0 ? a : b;
            }
            return a.getId() > b.getId() ? a : b;
        })).values());
        List riskId = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.exposeEvaluateDataService.remove((Wrapper)new QueryWrapper().lambda().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, riskId));
        return list;
    }

    @Transactional(readOnly=false)
    public RiskExposeEvaluate mergerAdiationAndWandaRisk(Long cid, Long riskId, List<Integer> years) {
        final RiskExposeEvaluate riskMaster = new RiskExposeEvaluate();
        ArrayList riskData = new ArrayList();
        Object redundantSourceTablesIds = "";
        LocalDateTime maxCreateDate = null;
        LocalDateTime maxUpdateDate = null;
        LocalDateTime maxCheckDate = null;
        Integer reportStatus = null;
        RiskExposeEvaluate latestWandaEv = this.getLatestNeedReportEvByType(cid, 1, years);
        if (latestWandaEv != null) {
            redundantSourceTablesIds = latestWandaEv.getId().toString() + ",";
            maxCreateDate = latestWandaEv.getCreateDate();
            maxUpdateDate = latestWandaEv.getUpdateDate();
            maxCheckDate = latestWandaEv.getCheckDate();
            reportStatus = latestWandaEv.getReportStatus();
            BeanUtils.copyProperties((Object)latestWandaEv, (Object)riskMaster);
            List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{latestWandaEv.getId()})).list();
            riskData.addAll(list);
        }
        if (latestWandaEv == null) {
            return null;
        }
        RiskExposeEvaluate latestFangSheEv = this.getLatestNeedReportEvByType(cid, 2, years);
        if (latestFangSheEv != null) {
            redundantSourceTablesIds = (String)redundantSourceTablesIds + latestFangSheEv.getId().toString();
            if (maxCreateDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u521b\u5efa\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getCreateDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u521b\u5efa\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxCreateDate.isBefore(latestFangSheEv.getCreateDate())) {
                maxCreateDate = latestFangSheEv.getCreateDate();
            }
            if (maxUpdateDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u4fee\u6539\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getUpdateDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u4fee\u6539\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxUpdateDate.isBefore(latestFangSheEv.getUpdateDate())) {
                maxUpdateDate = latestFangSheEv.getUpdateDate();
            }
            if (maxCheckDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u68c0\u6d4b\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getCheckDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u68c0\u6d4b\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxCheckDate.isBefore(latestFangSheEv.getCheckDate())) {
                maxCheckDate = latestFangSheEv.getCheckDate();
            }
            if (reportStatus == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u72b6\u6001,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getReportStatus() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u72b6\u6001,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (!reportStatus.equals(latestFangSheEv.getReportStatus())) {
                reportStatus = 2;
            }
            BeanUtils.copyProperties((Object)latestFangSheEv, (Object)riskMaster);
            List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{latestFangSheEv.getId()})).list();
            riskData.addAll(list);
        }
        if (latestFangSheEv == null) {
            return null;
        }
        Integer ifFangShe = ((RiskExposeEvaluateMapper)this.dao).getRiskDataCountByIfFangShe(latestFangSheEv.getId(), true);
        if (ifFangShe == 0) {
            return null;
        }
        riskMaster.setId(Long.valueOf(this.idworker.nextId()));
        if (riskId != null) {
            riskMaster.setId(riskId);
        }
        riskMaster.setRedundantSourceTablesIds((String)redundantSourceTablesIds);
        riskMaster.setCreateDate(maxCreateDate.plusMinutes(1L));
        riskMaster.setUpdateDate(maxUpdateDate.plusMinutes(1L));
        riskMaster.setCheckDate(maxCheckDate);
        riskMaster.setReportStatus(reportStatus);
        riskMaster.setFlag(Integer.valueOf(0));
        this.saveOrUpdate(riskMaster);
        if (riskId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{riskId});
            this.exposeEvaluateDataService.remove((Wrapper)queryWrapper);
        }
        for (RiskExposeEvaluateData riskExposeEvaluateData : riskData) {
            riskExposeEvaluateData.setId(Long.valueOf(this.idworker.nextId()));
            riskExposeEvaluateData.setRiskExposeEvaluateId(riskMaster.getId());
        }
        Map collect = riskData.parallelStream().filter(Objects::nonNull).collect(Collectors.toMap(v -> v.getWorkshop() + v.getWorkName() + v.getWorkNum() + v.getCheckPoint() + v.getFactorId(), Function.identity(), (v1, v2) -> v2));
        this.exposeEvaluateDataService.saveBatch(collect.values());
        new Thread(new Runnable(){

            @Override
            public void run() {
                RiskExposeEvaluateServiceImpl.this.updateRiskLevel(riskMaster.getId());
            }
        }).start();
        return riskMaster;
    }

    public RiskExposeEvaluate mergerAdiationAndWandaRisk2(Long cid, Long riskId, List<Integer> years, Integer reportStatus) {
        final RiskExposeEvaluate riskMaster = new RiskExposeEvaluate();
        ArrayList riskData = new ArrayList();
        Object redundantSourceTablesIds = "";
        LocalDateTime maxCreateDate = null;
        LocalDateTime maxUpdateDate = null;
        LocalDateTime maxCheckDate = null;
        RiskExposeEvaluate latestWandaEv = ((RiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, years, 1, reportStatus);
        if (latestWandaEv != null) {
            redundantSourceTablesIds = latestWandaEv.getId().toString() + ",";
            maxCreateDate = latestWandaEv.getCreateDate();
            maxUpdateDate = latestWandaEv.getUpdateDate();
            maxCheckDate = latestWandaEv.getCheckDate();
            BeanUtils.copyProperties((Object)latestWandaEv, (Object)riskMaster);
            List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{latestWandaEv.getId()})).list();
            riskData.addAll(list);
        }
        if (latestWandaEv == null) {
            return null;
        }
        RiskExposeEvaluate latestFangSheEv = ((RiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, years, 2, reportStatus);
        if (latestFangSheEv != null) {
            redundantSourceTablesIds = (String)redundantSourceTablesIds + latestFangSheEv.getId().toString();
            if (maxCreateDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u521b\u5efa\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getCreateDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u521b\u5efa\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxCreateDate.isBefore(latestFangSheEv.getCreateDate())) {
                maxCreateDate = latestFangSheEv.getCreateDate();
            }
            if (maxUpdateDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u4fee\u6539\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getUpdateDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u4fee\u6539\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxUpdateDate.isBefore(latestFangSheEv.getUpdateDate())) {
                maxUpdateDate = latestFangSheEv.getUpdateDate();
            }
            if (maxCheckDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u68c0\u6d4b\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getCheckDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u68c0\u6d4b\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxCheckDate.isBefore(latestFangSheEv.getCheckDate())) {
                maxCheckDate = latestFangSheEv.getCheckDate();
            }
            BeanUtils.copyProperties((Object)latestFangSheEv, (Object)riskMaster);
            List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{latestFangSheEv.getId()})).list();
            riskData.addAll(list);
        }
        if (latestFangSheEv == null) {
            return null;
        }
        Integer ifFangShe = ((RiskExposeEvaluateMapper)this.dao).getRiskDataCountByIfFangShe(latestFangSheEv.getId(), true);
        if (ifFangShe == 0) {
            return null;
        }
        riskMaster.setId(Long.valueOf(this.idworker.nextId()));
        if (riskId != null) {
            riskMaster.setId(riskId);
        }
        riskMaster.setRedundantSourceTablesIds((String)redundantSourceTablesIds);
        riskMaster.setCreateDate(maxCreateDate.plusMinutes(1L));
        riskMaster.setUpdateDate(maxUpdateDate.plusMinutes(1L));
        riskMaster.setCheckDate(maxCheckDate);
        riskMaster.setFlag(Integer.valueOf(0));
        this.saveOrUpdate(riskMaster);
        if (riskId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{riskId});
            this.exposeEvaluateDataService.remove((Wrapper)queryWrapper);
        }
        for (RiskExposeEvaluateData riskExposeEvaluateData : riskData) {
            riskExposeEvaluateData.setId(Long.valueOf(this.idworker.nextId()));
            riskExposeEvaluateData.setRiskExposeEvaluateId(riskMaster.getId());
        }
        Map collect = riskData.parallelStream().filter(Objects::nonNull).collect(Collectors.toMap(v -> v.getWorkshop() + v.getWorkName() + v.getWorkNum() + v.getCheckPoint() + v.getFactorId(), Function.identity(), (v1, v2) -> v2));
        this.exposeEvaluateDataService.saveBatch(collect.values());
        new Thread(new Runnable(){

            @Override
            public void run() {
                RiskExposeEvaluateServiceImpl.this.updateRiskLevel(riskMaster.getId());
            }
        }).start();
        return riskMaster;
    }

    @Transactional(readOnly=false)
    public Integer updateMergerTableByChildRisk(RiskExposeEvaluate evaluate) {
        if (evaluate == null) {
            return -1;
        }
        CompanySuperviseModel companyInfoById = this.companyProvideBySuperviseService.getCompanyInfoById(evaluate.getCid());
        if (companyInfoById == null) {
            return -1;
        }
        if (!companyInfoById.getIsExistRadioactivity().booleanValue()) {
            return -1;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(RiskExposeEvaluate::getCid, (Object)evaluate.getCid())).eq(RiskExposeEvaluate::getReportStatus, (Object)3)).like(RiskExposeEvaluate::getRedundantSourceTablesIds, (Object)evaluate.getId())).list();
        for (RiskExposeEvaluate temp : list) {
            String[] split = temp.getRedundantSourceTablesIds().split(",");
            if (split.length != 2) continue;
            this.updateMergerTableContent(Long.parseLong(split[0]), Long.parseLong(split[1]), temp.getId());
            for (String s : split) {
                RiskExposeEvaluate otherRisk;
                if (s.equals(evaluate.getId().toString()) || (otherRisk = (RiskExposeEvaluate)this.getById(Long.valueOf(Long.parseLong(s)))).getReportStatus() != 2 && otherRisk.getReportStatus() != 4) continue;
                LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                wrapper.set(RiskExposeEvaluate::getReportStatus, (Object)2);
                wrapper.set(BaseEntity::getUpdateDate, (Object)LocalDateTime.now());
                wrapper.set(BaseEntity::getUpdateBy, (Object)evaluate.getUpdateBy());
                wrapper.eq(BaseEntity::getId, (Object)temp.getId());
                boolean bl = this.update((Wrapper)wrapper);
            }
        }
        return 0;
    }

    public void updateMergerTableContent(Long riskId1, Long riskId2, Long riskIdMaster) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{riskIdMaster});
        this.exposeEvaluateDataService.remove((Wrapper)queryWrapper);
        ArrayList riskData = new ArrayList();
        List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{riskId1})).list();
        riskData.addAll(list);
        List list2 = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{riskId2})).list();
        riskData.addAll(list2);
        for (RiskExposeEvaluateData riskExposeEvaluateData : riskData) {
            riskExposeEvaluateData.setId(Long.valueOf(this.idworker.nextId()));
            riskExposeEvaluateData.setRiskExposeEvaluateId(riskIdMaster);
        }
        this.exposeEvaluateDataService.saveBatch(riskData);
        this.updateRiskLevel(riskIdMaster);
    }

    public Integer getIsFangSheRiskInfoComplete(Long riskId, Long cid) {
        if (riskId == null || cid == null) {
            return null;
        }
        Integer fangShe = ((RiskExposeEvaluateMapper)this.dao).getRiskDataCountByIfFangShe(riskId, true);
        Integer noFangShe = ((RiskExposeEvaluateMapper)this.dao).getRiskDataCountByIfFangShe(riskId, false);
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company == null) {
            return -1;
        }
        if (company.getIsExistRadioactivity().booleanValue()) {
            if (fangShe > 0 && noFangShe == 0) {
                Integer before = ((RiskExposeEvaluateMapper)this.dao).getLastReportInfoByIfFangShe(cid, false);
                if (before == 0) {
                    return 0;
                }
                return 1;
            }
            if (fangShe == 0) {
                return 2;
            }
            return 4;
        }
        if (noFangShe == 0) {
            return 3;
        }
        return 4;
    }

    public List<Long> getRedundantSourceTablesIdsIsNotNullByCid(Long cid) {
        ArrayList mergerRiskTableIdList = new ArrayList();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(RiskExposeEvaluate::getCid, (Object)cid)).isNotNull(RiskExposeEvaluate::getRedundantSourceTablesIds)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (RiskExposeEvaluate evaluate : list) {
                String[] split = evaluate.getRedundantSourceTablesIds().split(",");
                if (split.length <= 0) continue;
                List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                mergerRiskTableIdList.addAll(collect);
            }
            List<Long> collect = mergerRiskTableIdList.stream().distinct().collect(Collectors.toList());
            return collect;
        }
        return Collections.emptyList();
    }

    public List<RiskExposeEvaluate> getLastEv(EvQueryParam param) {
        List<RiskExposeEvaluate> lastEv = ((RiskExposeEvaluateMapper)this.dao).getLastEv(param);
        if (param.getIsQueryRiskData().booleanValue()) {
            this.setExposeEvaluateData(lastEv);
        }
        if (Objects.equals(true, param.getIsIgnore())) {
            List<Long> noCheckPlanRiskId;
            List collect = lastEv.stream().filter(item -> item != null && item.getCheckPlanId() == null && StringUtils.isNotBlank((CharSequence)item.getRedundantSourceTablesIds())).map(RiskExposeEvaluate::getRedundantSourceTablesIds).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                List riskIdList = collect.stream().flatMap(ids -> StringUtils.parseToLongList((String)ids).stream()).toList();
                Map<Long, Long> riskCheckIdMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseEntity::getId, riskIdList)).isNotNull(RiskExposeEvaluate::getCheckPlanId)).select(new SFunction[]{BaseEntity::getId, RiskExposeEvaluate::getCheckPlanId}).list().stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseEntity::getId, RiskExposeEvaluate::getCheckPlanId));
                if (MapUtils.isNotEmpty(riskCheckIdMap)) {
                    for (RiskExposeEvaluate evaluate : lastEv) {
                        if (evaluate == null || StringUtils.isBlank((CharSequence)evaluate.getRedundantSourceTablesIds())) continue;
                        List longs = StringUtils.parseToLongList((String)evaluate.getRedundantSourceTablesIds());
                        for (Long riskId : longs) {
                            if (!riskCheckIdMap.containsKey(riskId)) continue;
                            evaluate.setCheckPlanId(riskCheckIdMap.get(riskId));
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(noCheckPlanRiskId = lastEv.stream().filter(item -> item != null && item.getCheckPlanId() == null).map(BaseEntity::getId).collect(Collectors.toList()))) {
                Map checkIdAndRiskIdMap = ((RiskExposeEvaluateMapper)this.dao).getCheckIdAndRiskId(noCheckPlanRiskId).stream().filter(Objects::nonNull).collect(Collectors.toMap(CheckPlan::getRiskExposeEvaluateId, Function.identity(), (k1, k2) -> k1.getUpdateDate().isAfter(k2.getUpdateDate()) ? k1 : k2));
                lastEv.stream().filter(Objects::nonNull).filter(item -> checkIdAndRiskIdMap.containsKey(item.getId())).forEach(item -> item.setCheckPlanId(((CheckPlan)checkIdAndRiskIdMap.get(item.getId())).getId()));
            }
        }
        return lastEv;
    }

    public List<RiskExposeEvaluate> getListByParam(EvQueryParam param, Map<String, Object> paramMap) {
        List<Long> noCheckPlanRiskId;
        List<RiskExposeEvaluate> list = ((RiskExposeEvaluateMapper)this.dao).getListByParam(param);
        if (param.getIsQueryRiskData().booleanValue()) {
            this.setExposeEvaluateData(list);
        }
        if (Objects.equals(true, param.getIsIgnore()) && CollectionUtils.isNotEmpty(noCheckPlanRiskId = list.stream().filter(item -> item != null && item.getCheckPlanId() == null).map(BaseEntity::getId).collect(Collectors.toList()))) {
            Map checkIdAndRiskIdMap = ((RiskExposeEvaluateMapper)this.dao).getCheckIdAndRiskId(noCheckPlanRiskId).stream().filter(Objects::nonNull).collect(Collectors.toMap(CheckPlan::getRiskExposeEvaluateId, Function.identity(), (k1, k2) -> k1.getUpdateDate().isAfter(k2.getUpdateDate()) ? k1 : k2));
            for (RiskExposeEvaluate item2 : list) {
                if (item2 == null || checkIdAndRiskIdMap.get(item2.getId()) == null) continue;
                item2.setCheckPlanId(((CheckPlan)checkIdAndRiskIdMap.get(item2.getId())).getId());
            }
        }
        return list;
    }

    public void setExposeEvaluateData(List<RiskExposeEvaluate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List dataList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, (Collection)list.stream().filter(Objects::nonNull).map(BaseEntity::getId).collect(Collectors.toList()))).eq(BaseEntity::getIsValid, (Object)true)).list();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        Map<String, String> factorMap = this.factorService.getAllIdAndNameMapForCheckPlan();
        dataList.forEach(item -> {
            if (item != null && StringUtils.isNotEmpty((String)((String)factorMap.get(item.getFactorId())))) {
                item.setFactorName((String)factorMap.get(item.getFactorId()));
            }
        });
        Map<Long, List<RiskExposeEvaluateData>> dataMap = dataList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(RiskExposeEvaluateData::getRiskExposeEvaluateId));
        for (RiskExposeEvaluate riskExposeEvaluate : list) {
            if (riskExposeEvaluate == null || CollectionUtils.isEmpty((Collection)dataMap.get(riskExposeEvaluate.getId()))) continue;
            riskExposeEvaluate.setDataList(dataMap.get(riskExposeEvaluate.getId()));
        }
    }

    public List<String> getWorkShopNameAndNumDiffer(Long evId) {
        List<RiskExposeEvaluateData> list = ((RiskExposeEvaluateMapper)this.dao).getWorkShopNameAndNumDiffer(evId);
        if (CollectionUtils.isEmpty(list) || StringUtils.isEmpty((CharSequence)list.get(0).getCheckPoint())) {
            return Collections.emptyList();
        }
        return list.parallelStream().filter(item -> item != null && StringUtils.isNotEmpty((String)item.getCheckPoint())).map(RiskExposeEvaluateData::getCheckPoint).collect(Collectors.toList());
    }

    public Integer countHazardFactorHarmfulInconformityNum(Long cid, Byte factorNature) {
        return ((RiskExposeEvaluateMapper)this.dao).countHazardFactorHarmfulInconformityNum(cid, factorNature);
    }
}

