/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp.riskev;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.model.CheckResultParseQueryModel;
import cn.smarthse.services.hfi.api.model.result.ListParamModel;
import cn.smarthse.services.hfi.api.model.result.RadiateRiskListModel;
import cn.smarthse.services.hfi.api.model.riskev.EvDataStatModel;
import cn.smarthse.services.hfi.api.model.riskev.EvFactorTouchNum;
import cn.smarthse.services.hfi.api.model.riskev.EvTouchNumStat;
import cn.smarthse.services.hfi.api.model.riskev.QueryPageRiskEvDataParam;
import cn.smarthse.services.hfi.api.pojo.vo.CheckFileVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileCheckResultVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskDecisionVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultParseService;
import cn.smarthse.services.hfi.api.service.IFactorLimitValueService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.services.hfi.mapper.riskev.RiskExposeEvaluateDataMapper;
import cn.smarthse.services.hfi.serviceimp.FactorService;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.util.common.excel.model.ExcelModel;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.RowModel2;
import cn.smarthse.util.common.excel.model.SheetModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@DubboService(timeout=60000)
public class RiskExposeEvaluateDataServiceImpl
extends BaseServiceImp<RiskExposeEvaluateDataMapper, RiskExposeEvaluateData>
implements IRiskExposeEvaluateDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskExposeEvaluateDataServiceImpl.class);
    @Autowired
    private ICheckResultParseService checkResultParseService;
    @Autowired
    @Lazy
    private IRiskExposeEvaluateService evaluateService;
    @Autowired
    private IRiskExposeEvaluateDataService evaluateDataService;
    @Autowired
    @Lazy
    private ICheckPlanService checkPlanService;
    @Autowired
    private FactorService factorService;
    @Autowired
    private IFactorLimitValueService factorLimitValueService;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    @DubboReference(version="1.0.0", timeout=60000)
    ISysAreaProvideService areaProvideService;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    private final Set<Long> evIdSet = new HashSet<Long>();
    @DubboReference(timeout=30000, version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    private static Set<String> rays = new HashSet<String>(Arrays.asList("\u03b1\u8868\u9762\u6c61\u67d3", "\u03b2\u8868\u9762\u6c61\u67d3", "X\u5c04\u7ebf", "\u03b3\u5c04\u7ebf", "\u4e2d\u5b50", "\u6c21"));
    private static final String MUTIL_FACTOR_NAME_SPLIT = "\uff1b";
    public Cache<String, Set<Long>> factoryCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.DAYS).build();

    public void getFactoryCache() {
        this.factoryCache.invalidateAll();
        this.factoryCache.cleanUp();
        this.factoryCache.put((Object)"\u653e\u5c04\u56e0\u7d20", ((RiskExposeEvaluateDataMapper)this.dao).getFactoryByType("\u653e\u5c04\u56e0\u7d20"));
    }

    public synchronized void importDataFromCheck(Long orgId) {
        List<Long> evIds = ((RiskExposeEvaluateDataMapper)this.baseMapper).getAllEvId(orgId);
        this.evIdSet.addAll(evIds);
        List all = this.evaluateService.getbyOrgId(orgId);
        List evs = all.stream().filter(i -> i.getType().equals(1)).collect(Collectors.toList());
        evs = evs.stream().filter(i -> !this.evIdSet.contains(i.getId())).collect(Collectors.toList());
        for (RiskExposeEvaluate ev : evs) {
            this.threadPoolExecutor.execute(() -> this.addByCheckPlan(ev));
        }
    }

    public synchronized void addByCheckPlan(RiskExposeEvaluate obj) {
        if (this.evIdSet.contains(obj.getId())) {
            return;
        }
        CheckResultParseQueryModel queryModel = new CheckResultParseQueryModel();
        queryModel.setCheckId(obj.getCheckPlanId());
        List checkFileVos = this.checkResultParseService.queryCheckFileVos(queryModel);
        if (checkFileVos == null || checkFileVos.isEmpty()) {
            return;
        }
        List<RiskExposeEvaluateData> list = this.checkFileVoToEvListData(obj, checkFileVos);
        this.saveOrUpdateList(list, true);
        this.evIdSet.add(obj.getId());
    }

    public void addDataFromCheckPlan(RiskExposeEvaluate obj) {
        CheckResultParseQueryModel queryModel = new CheckResultParseQueryModel();
        queryModel.setCheckId(obj.getCheckPlanId());
        List checkFileVos = this.checkResultParseService.queryCheckFileVos(queryModel);
        if (checkFileVos == null || checkFileVos.isEmpty()) {
            return;
        }
        List<RiskExposeEvaluateData> list = this.checkFileVoToEvListData(obj, checkFileVos);
        this.saveOrUpdateList2(list);
        RiskDecisionVo riskDecisionVo = this.evaluateService.queryTouchNumAndLevel(obj.getId());
        RiskExposeEvaluate temp = new RiskExposeEvaluate();
        temp.setId(obj.getId());
        if (riskDecisionVo != null) {
            String riskLevel = riskDecisionVo.getRiskLevel();
            if ("\u2160\u7ea7".equals(riskLevel)) {
                temp.setRiskLevel(Integer.valueOf(1));
                this.evaluateService.updateById((Object)temp);
            } else if ("\u2161\u7ea7".equals(riskLevel)) {
                temp.setRiskLevel(Integer.valueOf(2));
                this.evaluateService.updateById((Object)temp);
            } else if ("\u2162\u7ea7".equals(riskLevel)) {
                temp.setRiskLevel(Integer.valueOf(3));
                this.evaluateService.updateById((Object)temp);
            }
        }
    }

    public List<RiskExposeEvaluateData> checkFileVoToEvListData(RiskExposeEvaluate obj, List<CheckFileVo> checkFileVos) {
        LinkedList<RiskExposeEvaluateData> rList = new LinkedList<RiskExposeEvaluateData>();
        for (CheckFileVo checkFileVo : checkFileVos) {
            List pointResults = checkFileVo.getPointResults();
            Map<Long, String> natureMap = this.factorService.getNatureMap();
            for (CheckRecordFileVo pointResult : pointResults) {
                RiskExposeEvaluateData data = new RiskExposeEvaluateData();
                data.setCanEdit(Boolean.valueOf(false));
                data.setCheckPoint(pointResult.getCheckPointName());
                data.setRiskExposeEvaluateId(obj.getId());
                data.setWorkNum(pointResult.getWorkNum());
                data.setWorkshop(pointResult.getWorkshop());
                data.setWorkName(pointResult.getWorkName());
                data.setSourceId(pointResult.getSourceId());
                if (pointResult.getFactorId() == null || pointResult.getFactorId().isEmpty()) continue;
                try {
                    HarmFactor thisById;
                    String natureStr;
                    data.setFactorId(pointResult.getFactorId());
                    Long facId = null;
                    if (StringUtils.isNotEmpty((String)data.getFactorId())) {
                        if (!data.getFactorId().contains(",")) {
                            facId = Long.parseLong(data.getFactorId());
                        } else {
                            List facIds = StringUtils.parseToLongList((String)data.getFactorId(), (String)",");
                            if (facIds.size() > 0) {
                                facId = (Long)facIds.get(0);
                            }
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)(natureStr = natureMap.get(facId))) && (thisById = this.harmFactorService.getThisById(facId)) != null && StringUtils.isNotBlank((CharSequence)thisById.getHazardNature())) {
                        natureStr = thisById.getHazardNature();
                    }
                    if ("1".equals(natureStr)) {
                        data.setFactorNature(Integer.valueOf(2));
                    } else {
                        data.setFactorNature(Integer.valueOf(1));
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    log.error("checkFileVoToEvListData::\u5371\u5bb3\u56e0\u7d20id\u5f02\u5e38", (Throwable)e);
                }
                data.setCheckTouchLevel(this.getTouchLevel(pointResult.getJudgeResult()));
                data.setIsValid(Boolean.valueOf(true));
                data.setCreateBy(Long.valueOf(0L));
                data.setCreateDate(LocalDateTime.now());
                data.setUpdateDate(LocalDateTime.now());
                data.setUpdateBy(Long.valueOf(0L));
                List resultList = pointResult.getResultList();
                data.setFactorName(this.getFactorName(pointResult, resultList));
                if (data.getFactorName() == null) continue;
                if (!pointResult.getItemId().equals(2L) && data.getFactorName().contains("\u5176\u4ed6")) {
                    data.setFactorAbnormal(Boolean.valueOf(true));
                }
                if (pointResult.getItemId().equals(3L)) {
                    data.setNoiseLevel(this.getValue(resultList, 29));
                } else if (pointResult.getItemId().equals(1L)) {
                    data.setCtwa(this.getValue(resultList, 3));
                    data.setCstel(this.getValue(resultList, 4));
                    data.setCste(this.getValue(resultList, 7));
                    data.setCmac(this.getValue(resultList, 5));
                    data.setCme(this.getValue(resultList, 6));
                    data.setExceedLimit(this.getValue(resultList, 9));
                    data.setPePcTwa(this.getValue(resultList, 8));
                    data.setReductionFactor(this.getValue(resultList, 192));
                    if (data.getFactorName() != null && data.getFactorName().contains("\u5176\u4ed6")) {
                        data.setCanEdit(Boolean.valueOf(true));
                    }
                } else if (pointResult.getItemId().equals(2L)) {
                    List factorLimitKeys = this.factorLimitValueService.getFactorLimitKeys(Long.valueOf(Long.parseLong(data.getFactorId())));
                    if (factorLimitKeys.contains("twa_total") && factorLimitKeys.contains("twa_respirabel")) {
                        data.setCtwa(this.getValue(resultList, 13));
                        data.setCmac(this.getValue(resultList, 14));
                        data.setExceedLimit(this.getValue(resultList, 16));
                        data.setPePcTwa(this.getValue(resultList, 15));
                        data.setReductionFactor(this.getValue(resultList, 193));
                        data.setFactorName(pointResult.getFactorName() + "(\u603b\u5c18)");
                        RiskExposeEvaluateData huChen = new RiskExposeEvaluateData();
                        BeanUtils.copyProperties((Object)data, (Object)huChen);
                        huChen.setCtwa(this.getValue(resultList, 18));
                        huChen.setCmac(this.getValue(resultList, 19));
                        huChen.setExceedLimit(this.getValue(resultList, 21));
                        huChen.setPePcTwa(this.getValue(resultList, 20));
                        data.setReductionFactor(this.getValue(resultList, 195));
                        huChen.setFactorName(pointResult.getFactorName() + "(\u547c\u5c18)");
                        rList.add(huChen);
                    } else if (factorLimitKeys.contains("twa_total")) {
                        data.setCtwa(this.getValue(resultList, 13));
                        data.setCmac(this.getValue(resultList, 14));
                        data.setExceedLimit(this.getValue(resultList, 16));
                        data.setPePcTwa(this.getValue(resultList, 15));
                        data.setReductionFactor(this.getValue(resultList, 193));
                        data.setFactorName(pointResult.getFactorName() + "(\u603b\u5c18)");
                    } else {
                        data.setCtwa(this.getValue(resultList, 18));
                        data.setCmac(this.getValue(resultList, 19));
                        data.setExceedLimit(this.getValue(resultList, 21));
                        data.setPePcTwa(this.getValue(resultList, 20));
                        data.setReductionFactor(this.getValue(resultList, 195));
                        data.setFactorName(pointResult.getFactorName() + "(\u547c\u5c18)");
                    }
                } else if (pointResult.getItemId().equals(13L)) {
                    data.setCtwa(this.getValue(resultList, 101));
                    data.setCstel(this.getValue(resultList, 102));
                    data.setCste(this.getValue(resultList, 103));
                    data.setCmac(this.getValue(resultList, 99));
                    data.setCme(this.getValue(resultList, 100));
                    data.setReductionFactor(this.getValue(resultList, 194));
                } else {
                    data.setOtherFactorValue(this.getOtherFactorValue(resultList));
                }
                rList.add(data);
            }
        }
        return rList;
    }

    private String getFactorName(CheckRecordFileVo pointResult, List<CheckRecordFileCheckResultVo> resultList) {
        if (pointResult.getFactorId().equals("576")) {
            for (CheckRecordFileCheckResultVo vo : resultList) {
                if (vo.getTargetId() == null || !vo.getTargetId().equals(39)) continue;
                switch (vo.getCheckValue()) {
                    case "1": {
                        return "\u7d2b\u5916\u8f90\u5c04\uff08\u4e2d\u6ce2\u7d2b\u5916\u7ebf\uff09";
                    }
                    case "2": {
                        return "\u7d2b\u5916\u8f90\u5c04\uff08\u77ed\u6ce2\u7d2b\u5916\u7ebf\uff09";
                    }
                    case "3": {
                        return "\u7535\u710a\u5f27\u5149";
                    }
                }
                return pointResult.getFactorName();
            }
        }
        return pointResult.getFactorName();
    }

    private Integer getTouchLevelByFactor(CheckRecordFileVo pointResult) {
        List resultList = pointResult.getResultList();
        for (CheckRecordFileCheckResultVo vo : resultList) {
            if (vo.getFactorId() == null) continue;
            try {
                if (vo.getTargetId() != null && vo.getTargetId().equals(8) && Double.parseDouble(vo.getCheckValueMax()) > 3.0) {
                    return 1;
                }
                if (vo.getTargetId() != null && vo.getTargetId().equals(29) && Double.parseDouble(vo.getCheckValueMax()) > 85.0) {
                    return 1;
                }
                String value = this.factorLimitValueService.getByFactorAndTargetId(vo.getFactorId(), vo.getTargetId());
                if (value == null || !(Double.parseDouble(vo.getCheckValueMax()) < Double.parseDouble(value))) continue;
                return 1;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 2;
    }

    public List<RiskExposeEvaluateData> queryByEvId(Long evId) {
        List<RiskExposeEvaluateData> list = ((RiskExposeEvaluateDataMapper)this.baseMapper).getListByEvId(evId);
        return list;
    }

    private String formatHarmName(String facname) {
        if (StringUtils.isNotBlank((CharSequence)facname)) {
            facname = facname.replace("\uff09", ")");
            facname = facname.replace("\uff08", "(");
            facname = facname.replaceAll("\\s", "");
            facname = facname.replace("\uff1c", "<");
            facname = cn.smarthse.common.util.StringUtils.toDBC((String)facname);
            facname = StringUtils.replaceIgnoreCase((String)facname, (String)"SiO2", (String)"SiO\u2082");
            facname = StringUtils.replaceIgnoreCase((String)facname, (String)"MnO2", (String)"MnO\u2082");
            return facname;
        }
        return "";
    }

    public Set<String> validHarmNameErro(List<RowModel2> rows, Map<String, String> map, Set<String> harmIdSet) {
        if (CollectionUtils.isNotEmpty(rows)) {
            HashSet<String> errSet = new HashSet<String>();
            for (int rowi = 4; rowi < rows.size(); ++rowi) {
                RowModel2 row = rows.get(rowi);
                RowModel col = row.getCol();
                Integer rowNum = row.getRowNum();
                String fname = (String)col.get(4);
                fname = fname.replaceAll("\\s", "");
                if ("\u5176\u4ed6\u7c89\u5c18".equals(fname = cn.smarthse.common.util.StringUtils.toDBC((String)fname))) {
                    errSet.add("\u7b2c" + rowNum + "\u884c\uff0c\u5371\u5bb3\u56e0\u7d20\u540d\u79f0\u9519\u8bef\uff0c\u8bf7\u6838\u5b9e");
                    continue;
                }
                Set<String> harmIdSet4Map = this.getHarmIdSet4Map(fname, map);
                if (CollectionUtils.isNotEmpty(harmIdSet4Map)) {
                    harmIdSet.addAll(harmIdSet4Map);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)fname) || fname.startsWith("\u5176\u4ed6\u7c89\u5c18(") || fname.startsWith("\u5176\u4ed6\u7c89\u5c18\uff08")) continue;
                errSet.add("\u7b2c" + rowNum + "\u884c\uff0c\u5371\u5bb3\u56e0\u7d20\u540d\u79f0\u9519\u8bef\uff0c\u8bf7\u6838\u5b9e");
            }
            return errSet;
        }
        return Collections.emptySet();
    }

    public Set<String> validHarmResultErro(List<RowModel2> rows, Long targetStandardId) {
        if (CollectionUtils.isNotEmpty(rows)) {
            HashSet<String> errSet = new HashSet<String>();
            for (int rowi = 4; rowi < rows.size(); ++rowi) {
                String reductionFactor;
                boolean reductionFlag;
                RowModel2 row = rows.get(rowi);
                RowModel col = row.getCol();
                Integer rowNum = row.getRowNum();
                String workNum = (String)col.get(2);
                String value5 = (String)col.get(5);
                String value6 = (String)col.get(6);
                String value7 = (String)col.get(7);
                String value8 = (String)col.get(8);
                String value9 = (String)col.get(9);
                String rowInfo = "\u7b2c" + rowNum + "\u884c";
                boolean isErrFlag = false;
                if (!StringUtils.isInteger((String)workNum) || Integer.valueOf(workNum) <= 0) {
                    isErrFlag = true;
                    rowInfo = rowInfo + "\uff0c\u5b9a\u5458\u9700\u4e3a\u6574\u6570";
                }
                boolean numberNotNull = this.isNumberNotNull(value5, value6, value7, value8, value9);
                if (!numberNotNull) {
                    isErrFlag = true;
                    rowInfo = rowInfo + "\uff0c\u68c0\u6d4b\u7ed3\u679c\u53ea\u80fd\u586b\u5199\u6570\u5b57";
                }
                if (Objects.equals(targetStandardId, 2L) && !(reductionFlag = this.isNumberNotNull(reductionFactor = (String)col.get(11)))) {
                    isErrFlag = true;
                    rowInfo = rowInfo + "\uff0c\u6298\u51cf\u56e0\u5b50\u53ea\u80fd\u586b\u5199\u6570\u5b57";
                }
                if (!isErrFlag) continue;
                errSet.add(rowInfo);
            }
            return errSet;
        }
        return Collections.emptySet();
    }

    private boolean isNumberNotNull(String ... values) {
        if (values.length > 0) {
            for (String value : values) {
                if ((!StringUtils.isNotBlank((CharSequence)value) || StringUtils.isNumber((String)value)) && !value.endsWith("f") && !value.endsWith("F") && !value.endsWith("d") && !value.endsWith("D")) continue;
                return false;
            }
        }
        return true;
    }

    private static String formatCheckResult(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNumber((String)value)) {
            BigDecimal a = new BigDecimal(value);
            if (a.compareTo(new BigDecimal("0.01")) == -1) {
                Pattern p = Pattern.compile("0\\.0+[1-9]+?");
                Matcher matcher = p.matcher(value);
                if (matcher.find()) {
                    String group1 = matcher.group(0);
                    return group1;
                }
            } else {
                return a.setScale(5, RoundingMode.DOWN).stripTrailingZeros().toPlainString();
            }
        }
        return "";
    }

    public void doImportEvData(ExcelModel excelModel, Long evId, Long userId) throws ParseException {
        StringBuilder sb = new StringBuilder();
        LinkedList<RiskExposeEvaluateData> datas = new LinkedList<RiskExposeEvaluateData>();
        RiskExposeEvaluate riskExposeEvaluate = (RiskExposeEvaluate)this.evaluateService.get((Number)evId);
        SheetModel sheetModel = (SheetModel)excelModel.getSheets().get(0);
        List rows = sheetModel.getRows();
        HashMap<String, String> map = new HashMap();
        this.validRiskExposeInfo(rows, riskExposeEvaluate);
        List<String> errSet = this.validRiskExposeRaysData(sheetModel.getRows2());
        if (CollectionUtils.isNotEmpty(errSet)) {
            throw new ParseException(StringUtils.join(errSet, (String)"\n<br>"));
        }
        errSet = this.validWorkShopWorkNameSame(sheetModel.getRows2());
        if (CollectionUtils.isNotEmpty(errSet)) {
            throw new ParseException(StringUtils.join(errSet, (String)"\n<br>"));
        }
        Map<Long, String> natureMap = this.factorService.getNatureMap();
        if (riskExposeEvaluate.getTargetStandardId().equals(1L)) {
            map = this.factorService.getAllNameAndIdMap2007ContailRay(riskExposeEvaluate.getCid());
        } else if (riskExposeEvaluate.getTargetStandardId().equals(2L)) {
            map = this.factorService.getAllNameAndIdMap2019ContailRay(riskExposeEvaluate.getCid());
        }
        HashSet<String> harmIdSet = new HashSet<String>();
        Set<String> harmNameErro = this.validHarmNameErro(sheetModel.getRows2(), map, harmIdSet);
        if (CollectionUtils.isNotEmpty(harmNameErro)) {
            throw new ParseException(StringUtils.join(harmNameErro, (String)"\n<br>"));
        }
        Map<String, String> harmTypeMap = this.factorService.getHarmTypeByIds(StringUtils.join(harmIdSet, (String)","));
        Set<String> limitErrSet = this.validHarmLimit(sheetModel.getRows2(), map, riskExposeEvaluate, harmTypeMap);
        if (CollectionUtils.isNotEmpty(limitErrSet)) {
            throw new ParseException(StringUtils.join(limitErrSet, (String)"\n<br>"));
        }
        limitErrSet = this.validHarmResultErro(sheetModel.getRows2(), riskExposeEvaluate.getTargetStandardId());
        if (CollectionUtils.isNotEmpty(limitErrSet)) {
            throw new ParseException(StringUtils.join(limitErrSet, (String)"\n<br>"));
        }
        for (int row = 4; row < rows.size(); ++row) {
            String workname;
            RiskExposeEvaluateData data = new RiskExposeEvaluateData();
            RowModel rowModel = (RowModel)rows.get(row);
            String workshop = ((String)rowModel.get(0)).trim();
            if (StringUtils.isNotBlank((CharSequence)workshop)) {
                workshop = workshop.replaceAll(" ", "");
                data.setWorkshop(workshop);
            }
            if (StringUtils.isNotBlank((CharSequence)(workname = ((String)rowModel.get(1)).trim()))) {
                workname = workname.replaceAll(" ", "");
                data.setWorkName(workname);
            }
            if (StringUtils.isInteger((String)((String)rowModel.get(2)))) {
                data.setWorkNum(Integer.valueOf(((String)rowModel.get(2)).trim()));
            }
            data.setCheckPoint(((String)rowModel.get(3)).trim());
            String facname = ((String)rowModel.get(4)).trim();
            data.setFactorName(this.formatHarmName(facname));
            data.setCtwa(RiskExposeEvaluateDataServiceImpl.formatCheckResult(((String)rowModel.get(5)).trim()));
            if (riskExposeEvaluate.getTargetStandardId().equals(1L)) {
                data.setCstel(RiskExposeEvaluateDataServiceImpl.formatCheckResult(((String)rowModel.get(6)).trim()));
                data.setCmac(RiskExposeEvaluateDataServiceImpl.formatCheckResult(((String)rowModel.get(7)).trim()));
                data.setExceedLimit(RiskExposeEvaluateDataServiceImpl.formatCheckResult(((String)rowModel.get(8)).trim()));
            } else {
                data.setCste(RiskExposeEvaluateDataServiceImpl.formatCheckResult(((String)rowModel.get(6)).trim()));
                data.setCme(RiskExposeEvaluateDataServiceImpl.formatCheckResult(((String)rowModel.get(7)).trim()));
                data.setPePcTwa(RiskExposeEvaluateDataServiceImpl.formatCheckResult(((String)rowModel.get(8)).trim()));
            }
            data.setNoiseLevel(RiskExposeEvaluateDataServiceImpl.formatCheckResult(((String)rowModel.get(9)).trim()));
            data.setOtherFactorValue(((String)rowModel.get(10)).trim());
            if (riskExposeEvaluate.getTargetStandardId().equals(2L)) {
                String reductionFactor = (String)rowModel.get(11);
                data.setReductionFactor((String)rowModel.get(11));
                String level = ((String)rowModel.get(12)).replaceAll("\\s*", "");
                if (level.contains("\u4e0d\u7b26\u5408")) {
                    data.setCheckTouchLevel(Integer.valueOf(1));
                } else if (level.contains("\u7b26\u5408")) {
                    data.setCheckTouchLevel(Integer.valueOf(2));
                }
                if (level.contains("\u4e0d\u8d85\u6807")) {
                    data.setCheckTouchLevel(Integer.valueOf(2));
                } else if (level.contains("\u8d85\u6807")) {
                    data.setCheckTouchLevel(Integer.valueOf(1));
                }
                String idtemp = (String)rowModel.get(13);
                if (StringUtils.isNumber((String)idtemp)) {
                    data.setId(Long.valueOf(Long.parseLong(idtemp)));
                }
            } else {
                String level = ((String)rowModel.get(11)).replaceAll("\\s*", "");
                if (level.contains("\u4e0d\u7b26\u5408")) {
                    data.setCheckTouchLevel(Integer.valueOf(1));
                } else if (level.contains("\u7b26\u5408")) {
                    data.setCheckTouchLevel(Integer.valueOf(2));
                }
                if (level.contains("\u4e0d\u8d85\u6807")) {
                    data.setCheckTouchLevel(Integer.valueOf(2));
                } else if (level.contains("\u8d85\u6807")) {
                    data.setCheckTouchLevel(Integer.valueOf(1));
                }
                String idtemp = (String)rowModel.get(12);
                if (StringUtils.isNumber((String)idtemp)) {
                    data.setId(Long.valueOf(Long.parseLong(idtemp)));
                }
            }
            try {
                this.verifyImportData(riskExposeEvaluate, row, data, map, natureMap);
            }
            catch (ParseException e) {
                log.error(e.getMessage());
                sb.append(e.getMessage() + "<br/>");
            }
            data.setIsValid(Boolean.valueOf(true));
            data.setRiskExposeEvaluateId(evId);
            data.setCreateDate(LocalDateTime.now());
            data.setUpdateDate(LocalDateTime.now());
            data.setCreateBy(userId);
            data.setUpdateBy(userId);
            datas.add(data);
        }
        if (sb.length() > 5) {
            throw new ParseException(sb.toString());
        }
        AreaModel area = this.areaProvideService.getAreaById(riskExposeEvaluate.getProjectAreaId());
        LocalDateTime date = DateUtils.parseDateTime((String)"2023-04-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
        if (riskExposeEvaluate != null && riskExposeEvaluate.getCheckDate().isAfter(date) && StringUtils.isBlank((CharSequence)riskExposeEvaluate.getWandaZywsReportId()) && area != null && area.getProvinceId() == 330000000000L) {
            List collect1;
            Set collect = this.harmFactorService.selectList(riskExposeEvaluate.getCid(), null, "\u653e\u5c04\u56e0\u7d20").parallelStream().map(HarmFactor::getId).map(String::valueOf).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(datas) && (collect1 = datas.parallelStream().filter(item -> {
                if (cn.smarthse.common.util.StringUtils.isNotBlank((CharSequence)item.getFactorId())) {
                    if (item.getFactorId().split(",").length > 1) {
                        return !collect.contains(item.getFactorId().split(",")[0]);
                    }
                    return !collect.contains(item.getFactorId());
                }
                return false;
            }).collect(Collectors.toList())).size() > 0) {
                throw new ParseException("\u5bfc\u5165\u5931\u8d25\uff1a\u68c0\u6d4b\u65f6\u95f4\u5df2\u665a\u4e8e2023\u5e744\u67081\u65e5,\u901a\u8fc7\u672c\u7cfb\u7edf\u53ea\u80fd\u4e0a\u62a5\u653e\u5c04\u56e0\u7d20\uff0c\u5176\u4f59\u975e\u653e\u5c04\u56e0\u7d20\u8bf7\u7ecf\u7531\u6d59\u6c5f\u7701\u75be\u63a7\u7684\u804c\u4e1a\u536b\u751f\u68c0\u6d4b\u7ba1\u7406\u7cfb\u7edf\u8fdb\u884c\u4e0a\u62a5");
            }
        }
        List list = this.evaluateDataService.queryByEvId(evId);
        if (riskExposeEvaluate.getType().equals(2)) {
            this.removeByEvId(evId);
            datas.forEach(d -> d.setId(null));
            this.saveOrUpdateList(datas, false);
        } else if (riskExposeEvaluate.getType().equals(1)) {
            Map<Long, RiskExposeEvaluateData> dbDataMap = list.stream().collect(Collectors.toMap(k -> k.getId(), v -> v));
            ArrayList<RiskExposeEvaluateData> updteList = new ArrayList<RiskExposeEvaluateData>();
            for (RiskExposeEvaluateData data : datas) {
                RiskExposeEvaluateData riskExposeEvaluateData = dbDataMap.get(data.getId());
                if (riskExposeEvaluateData == null) continue;
                riskExposeEvaluateData.setWorkshop(data.getWorkshop());
                riskExposeEvaluateData.setWorkName(data.getWorkName());
                riskExposeEvaluateData.setWorkNum(data.getWorkNum());
                riskExposeEvaluateData.setUpdateDate(LocalDateTime.now());
                riskExposeEvaluateData.setUpdateBy(userId);
                updteList.add(riskExposeEvaluateData);
            }
            this.updateBatchById(updteList);
        }
    }

    private Set<String> getHarmIdSet4Map(String factorName, Map<String, String> map) {
        boolean allIsRayFlag = this.allIsRayFactor(factorName);
        if (allIsRayFlag) {
            factorName = this.formatFactorName(factorName);
            String[] factorNameArr = StringUtils.splitByWholeSeparator((String)factorName, (String)MUTIL_FACTOR_NAME_SPLIT);
            HashSet<String> factorIdSet = new HashSet<String>();
            for (String s : factorNameArr) {
                String factorId = map.get(s);
                factorIdSet.add(factorId);
            }
            return factorIdSet;
        }
        factorName = factorName.replaceAll("\uff08\u547c\u5c18\uff09", "");
        factorName = factorName.replaceAll("\uff08\u603b\u5c18\uff09", "");
        factorName = factorName.replaceAll("\\(\u547c\u5c18\\)", "");
        factorName = factorName.replaceAll("\\(\u603b\u5c18\\)", "");
        String id = map.get(factorName = this.formatHarmName(factorName));
        if (StringUtils.isNumber((String)id)) {
            return new HashSet<String>(Arrays.asList(id));
        }
        return null;
    }

    private Set<String> validHarmLimit(List<RowModel2> rows2, Map<String, String> map, RiskExposeEvaluate riskExposeEvaluate, Map<String, String> harmTypeMap) {
        HashSet<String> errInfoSet = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(rows2) && rows2.size() > 4) {
            List<RowModel2> rowsTemp = rows2.subList(4, rows2.size());
            for (RowModel2 rowModel2 : rowsTemp) {
                RowModel col = rowModel2.getCol();
                Integer rowNum = rowModel2.getRowNum();
                String harmNameCol = ((String)col.get(4)).trim();
                harmNameCol = this.formatHarmName(harmNameCol);
                String fname = ((String)col.get(4)).trim();
                if ((fname = this.formatHarmName(fname)).contains("\u603b\u5c18") || fname.contains("\u547c\u5c18")) {
                    fname = fname.substring(0, fname.length() - 4);
                }
                String Ctwa = ((String)col.get(5)).trim();
                String Cstel = "";
                String Cmac = "";
                String ExceedLimit = "";
                String Cste = "";
                String Cme = "";
                String PePcTwa = "";
                String NoiseLevel = "";
                String OtherFactorValue = "";
                if (riskExposeEvaluate.getTargetStandardId().equals(1L)) {
                    Cstel = ((String)col.get(6)).trim();
                    Cmac = ((String)col.get(7)).trim();
                    ExceedLimit = ((String)col.get(8)).trim();
                } else {
                    Cste = ((String)col.get(6)).trim();
                    Cme = ((String)col.get(7)).trim();
                    PePcTwa = ((String)col.get(8)).trim();
                }
                NoiseLevel = ((String)col.get(9)).trim();
                OtherFactorValue = ((String)col.get(10)).trim();
                Set<String> harmIdSet4Map = this.getHarmIdSet4Map(fname, map);
                HashSet<String> canInputSet = new HashSet<String>();
                if (CollectionUtils.isEmpty(harmIdSet4Map)) {
                    harmIdSet4Map = new HashSet<String>();
                    this.handlerCustomeFactor(map, fname, riskExposeEvaluate.getCid());
                    String harmId = map.get(fname);
                    if (StringUtils.isNotBlank((CharSequence)harmId)) {
                        harmIdSet4Map.add(harmId);
                        harmTypeMap.put(harmId, "\u7c89\u5c18");
                    }
                }
                if (CollectionUtils.isNotEmpty(harmIdSet4Map)) {
                    for (String harmId : harmIdSet4Map) {
                        if (!StringUtils.isNumber((String)harmId)) continue;
                        List limitKeys = this.factorLimitValueService.getFactorLimitKeys(Long.valueOf(Long.parseLong(harmId)));
                        if (CollectionUtils.isNotEmpty((Collection)limitKeys)) {
                            if (limitKeys.contains("twa_total")) {
                                // empty if block
                            }
                            if (limitKeys.contains("twa_respirabel") && harmNameCol.indexOf("(\u603b\u5c18)") == -1 && harmNameCol.indexOf("(\u547c\u5c18)") == -1) {
                                errInfoSet.add("\u7b2c" + rowNum + "\u884c\uff0c\u5371\u5bb3\u56e0\u7d20\u540d\u79f0\u9519\u8bef\uff08\u672a\u586b\u603b\u5c18\u6216\u547c\u5c18\uff09\uff0c\u8bf7\u6838\u5b9e");
                            }
                            if (this.canInput(limitKeys, "mac")) {
                                canInputSet.add("Cmac");
                                canInputSet.add("Cme");
                            }
                            if (this.canInput(limitKeys, "twa")) {
                                canInputSet.add("Ctwa");
                                canInputSet.add("PePcTwa");
                                canInputSet.add("ExceedLimit");
                            }
                            if (this.canInput(limitKeys, "twa") && this.canInput(limitKeys, "stel")) {
                                canInputSet.clear();
                                canInputSet.add("Ctwa");
                                canInputSet.add("Cstel");
                                canInputSet.add("Cste");
                            }
                        } else if (fname.startsWith("\u5176\u4ed6\u7c89\u5c18")) {
                            canInputSet.add("Ctwa");
                            canInputSet.add("PePcTwa");
                            canInputSet.add("ExceedLimit");
                        }
                        if (StringUtils.equals((CharSequence)fname, (CharSequence)"\u566a\u58f0")) {
                            canInputSet.clear();
                            canInputSet.add("NoiseLevel");
                        }
                        if (!Objects.equals(harmTypeMap.get(harmId), "\u7c89\u5c18")) continue;
                        canInputSet.remove("Cstel");
                        canInputSet.remove("Cste");
                    }
                }
                boolean iserr = false;
                if (!canInputSet.contains("Ctwa") && StringUtils.isNotBlank((CharSequence)Ctwa)) {
                    iserr = true;
                }
                if (!canInputSet.contains("Cstel") && StringUtils.isNotBlank((CharSequence)Cstel)) {
                    iserr = true;
                }
                if (!canInputSet.contains("Cmac") && StringUtils.isNotBlank((CharSequence)Cmac)) {
                    iserr = true;
                }
                if (!canInputSet.contains("ExceedLimit") && StringUtils.isNotBlank((CharSequence)ExceedLimit)) {
                    iserr = true;
                }
                if (!canInputSet.contains("PePcTwa") && StringUtils.isNotBlank((CharSequence)PePcTwa)) {
                    iserr = true;
                }
                if (!canInputSet.contains("NoiseLevel") && StringUtils.isNotBlank((CharSequence)NoiseLevel)) {
                    iserr = true;
                }
                if (!canInputSet.contains("Cme") && StringUtils.isNotBlank((CharSequence)Cme)) {
                    iserr = true;
                }
                if (!canInputSet.contains("Cste") && StringUtils.isNotBlank((CharSequence)Cste)) {
                    iserr = true;
                }
                if (!iserr) continue;
                errInfoSet.add("\u7b2c" + rowNum + "\u884c\uff0c\u68c0\u6d4b\u7ed3\u679c\u586b\u5199\u4f4d\u7f6e\u6709\u8bef\uff0c\u8bf7\u6838\u5b9e");
            }
            return errInfoSet;
        }
        return null;
    }

    private void handlerCustomeFactor(Map<String, String> map, String fname, Long cid) {
        if (StringUtils.isNotBlank((CharSequence)fname) && fname.startsWith("\u5176\u4ed6\u7c89\u5c18(")) {
            HarmFactor newf = this.harmFactorService.addByNameAndType(fname, "\u7c89\u5c18", cid, Long.valueOf(110L));
            map.put(fname, "" + newf.getId());
        }
    }

    private boolean canInput(List<String> limitKeys, String t) {
        if (CollectionUtils.isNotEmpty(limitKeys)) {
            for (String limitKey : limitKeys) {
                if (limitKey.indexOf(t) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private void validRiskExposeInfo(List<RowModel> rows, RiskExposeEvaluate riskExposeEvaluate) throws ParseException {
        if (rows.size() < 4) {
            throw new ParseException("\u8bf7\u4f7f\u7528\u6b63\u786e\u6a21\u677f\uff1b\u8bf7\u52ff\u4fee\u6539\u6a21\u677f\u56fa\u5b9a\u5185\u5bb9");
        }
        String companyName = (String)rows.get(0).get(1);
        String companyUniCode = (String)rows.get(1).get(1);
        String standard = (String)rows.get(2).get(1);
        if (riskExposeEvaluate != null) {
            CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(riskExposeEvaluate.getCid());
            if (companyBaseInfoModel != null) {
                if (!Objects.equals(companyName, companyBaseInfoModel.getName())) {
                    throw new ParseException("\u5bfc\u5165\u6a21\u677f\u4e2d\u7684\u4f01\u4e1a\u540d\u79f0\u4e0e\u9875\u9762\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u5bfc\u5165");
                }
                if (!Objects.equals(companyUniCode, companyBaseInfoModel.getUnifiedSocialCc())) {
                    throw new ParseException("\u5bfc\u5165\u6a21\u677f\u4e2d\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u9875\u9762\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u5bfc\u5165");
                }
            }
            if (Objects.equals(riskExposeEvaluate.getTargetStandardId(), 2L) && standard.indexOf("2019") == -1) {
                throw new ParseException("\u5bfc\u5165\u6a21\u677f\u4e2d\u7684\u5bf9\u5e94\u6807\u51c6\u4e0e\u9875\u9762\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u5bfc\u5165");
            }
            if (Objects.equals(riskExposeEvaluate.getTargetStandardId(), 1L) && standard.indexOf("2007") == -1) {
                throw new ParseException("\u5bfc\u5165\u6a21\u677f\u4e2d\u7684\u5bf9\u5e94\u6807\u51c6\u4e0e\u9875\u9762\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u5bfc\u5165");
            }
            RowModel strings = rows.get(3);
            String[] titleArr = new String[]{"\u8f66\u95f4\u540d\u79f0", "\u5de5\u79cd/\u5c97\u4f4d\u540d\u79f0", "\u5b9a\u5458", "\u68c0\u6d4b\u70b9/\u68c0\u6d4b\u5bf9\u8c61\u540d\u79f0", "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u540d\u79f0", "CTWA", "CSTE", "CME", "CPE", "\u566a\u58f0\u7b49\u6548\u58f0\u7ea7", "\u5176\u4ed6\u56e0\u7d20", "\u6298\u51cf\u56e0\u5b50\uff08RF)", "\u63a5\u89e6\u6c34\u5e73"};
            if (Objects.equals(riskExposeEvaluate.getTargetStandardId(), 1L)) {
                titleArr = new String[]{"\u8f66\u95f4\u540d\u79f0", "\u5de5\u79cd/\u5c97\u4f4d\u540d\u79f0", "\u5b9a\u5458", "\u68c0\u6d4b\u70b9/\u68c0\u6d4b\u5bf9\u8c61\u540d\u79f0", "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u540d\u79f0", "CTWA", "CSTEL", "Cmax", "\u8d85\u9650\u500d\u6570", "\u566a\u58f0\u7b49\u6548\u58f0\u7ea7", "\u5176\u4ed6\u56e0\u7d20", "\u63a5\u89e6\u6c34\u5e73"};
            }
            boolean allequal = true;
            for (int i = 0; i < titleArr.length; ++i) {
                String s1 = (String)strings.get(i);
                String s2 = titleArr[i];
                if (StringUtils.equalsIgnoreCase((CharSequence)(s1 = s1.replaceAll("\\n", "")), (CharSequence)s2)) continue;
                allequal = false;
            }
            if (!allequal) {
                throw new ParseException("\u8bf7\u4f7f\u7528\u6b63\u786e\u6a21\u677f\uff1b\u8bf7\u52ff\u4fee\u6539\u6a21\u677f\u56fa\u5b9a\u5185\u5bb9");
            }
        }
    }

    private List<String> validRiskExposeRaysData(List<RowModel2> rowsData) {
        if (CollectionUtils.isNotEmpty(rowsData) && rowsData.size() > 4) {
            List<RowModel2> rows = rowsData.subList(4, rowsData.size());
            LinkedList<String> errInfoResult = new LinkedList<String>();
            for (RowModel2 row : rows) {
                RowModel col = row.getCol();
                String factorName = ((String)col.get(4)).trim();
                if (!StringUtils.isNotBlank((CharSequence)factorName)) continue;
                boolean allIsRayFactor = this.allIsRayFactor(factorName);
                boolean allIsNotRayFlag = this.allIsNotRayFactor(factorName);
                if (allIsRayFactor || allIsNotRayFlag) continue;
                Integer rowNum = row.getRowNum();
                errInfoResult.add("\u7b2c" + rowNum + "\u884c\uff0c \u6709\u591a\u4e2a\u5371\u5bb3\u56e0\u7d20\u4e14\u4e0d\u5168\u662f\u5c04\u7ebf\u5371\u5bb3\u56e0\u7d20");
            }
            return errInfoResult;
        }
        return Collections.emptyList();
    }

    private boolean allIsRayFactor(String factorName) {
        if (StringUtils.isBlank((CharSequence)factorName)) {
            return false;
        }
        Object[] factorNameArr = StringUtils.splitByWholeSeparator((String)(factorName = this.formatFactorName(factorName)), (String)MUTIL_FACTOR_NAME_SPLIT);
        if (ArrayUtils.isNotEmpty((Object[])factorNameArr)) {
            HashSet<Object> result = new HashSet<Object>();
            HashSet<Object> factorNameSet = new HashSet<Object>(Arrays.asList(factorNameArr));
            result.addAll(factorNameSet);
            result.removeAll(rays);
            if (result.size() == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean allIsNotRayFactor(String factorName) {
        if (StringUtils.isBlank((CharSequence)factorName)) {
            return false;
        }
        Object[] factorNameArr = StringUtils.splitByWholeSeparator((String)(factorName = this.formatFactorName(factorName)), (String)MUTIL_FACTOR_NAME_SPLIT);
        if (ArrayUtils.isNotEmpty((Object[])factorNameArr)) {
            HashSet<Object> result = new HashSet<Object>();
            HashSet<Object> factorNameSet = new HashSet<Object>(Arrays.asList(factorNameArr));
            result.addAll(factorNameSet);
            result.removeAll(rays);
            if (result.size() == factorNameSet.size()) {
                return true;
            }
        }
        return false;
    }

    private String formatFactorName(String factorName) {
        if (StringUtils.isBlank((CharSequence)factorName)) {
            return "";
        }
        factorName = factorName.replaceAll(";", MUTIL_FACTOR_NAME_SPLIT);
        factorName = factorName.replaceAll("\u3001", MUTIL_FACTOR_NAME_SPLIT);
        factorName = factorName.replaceAll(",", MUTIL_FACTOR_NAME_SPLIT);
        factorName = factorName.replaceAll("\uff0c", MUTIL_FACTOR_NAME_SPLIT);
        return factorName;
    }

    private List<String> validRiskExposeEvaluateData(List<RowModel2> rowsData) {
        if (CollectionUtils.isNotEmpty(rowsData) && rowsData.size() > 4) {
            List<Object> rows = rowsData.subList(4, rowsData.size());
            rows = rows.stream().filter(f -> {
                String factorName = ((String)f.getCol().get(4)).trim();
                return StringUtils.isNotBlank((CharSequence)factorName) && (factorName.indexOf("(\u603b\u5c18)") > -1 || factorName.indexOf("(\u547c\u5c18)") > -1);
            }).collect(Collectors.toList());
            Map<String, List<RowModel2>> groupListMap = rows.stream().collect(Collectors.groupingBy(row -> {
                RowModel col = row.getCol();
                String checkPoint = ((String)col.get(3)).trim();
                String factorName = ((String)col.get(4)).trim();
                factorName = factorName.replaceAll("\\(\u603b\u5c18\\)", "");
                factorName = factorName.replaceAll("\\(\u547c\u5c18\\)", "");
                return checkPoint + factorName;
            }));
            Set<String> keySet = groupListMap.keySet();
            LinkedList<List<Object>> errSet = new LinkedList<List<Object>>();
            for (String mapKey : keySet) {
                List<RowModel2> list = groupListMap.get(mapKey);
                Set workPlaceSet = list.stream().map(r -> (String)r.getCol().get(0)).collect(Collectors.toSet());
                Set workNameSet = list.stream().map(r -> (String)r.getCol().get(1)).collect(Collectors.toSet());
                Set workNumSet = list.stream().map(r -> (String)r.getCol().get(2)).collect(Collectors.toSet());
                Set factorNameSet = list.stream().map(r -> (String)r.getCol().get(4)).collect(Collectors.toSet());
                list.sort(Comparator.comparingInt(RowModel2::getRowNum));
                List rInfoSet = list.stream().map(r -> r.getRowNum()).collect(Collectors.toList());
                if (factorNameSet.size() <= 1 || workPlaceSet.size() <= 1 && workNameSet.size() <= 1 && workNumSet.size() <= 1) continue;
                errSet.add(rInfoSet);
            }
            errSet.sort(new Comparator<List<Integer>>(){

                @Override
                public int compare(List<Integer> o1, List<Integer> o2) {
                    Integer o1sort = o1.get(0);
                    Integer o2sort = o2.get(0);
                    return o1sort - o2sort;
                }
            });
            LinkedList<String> errInfoResult = new LinkedList<String>();
            for (List list : errSet) {
                LinkedList<CallSite> errInfo = new LinkedList<CallSite>();
                for (Integer integer : list) {
                    errInfo.add((CallSite)((Object)("\u7b2c" + integer + "\u5217")));
                }
                errInfoResult.add(StringUtils.join(errInfo, (String)"\u548c") + "\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u68c0\u6d4b\u70b9\u5371\u5bb3\u56e0\u7d20\u7684\u603b\u5c18\u548c\u547c\u5c18\u7684\u8f66\u95f4\u540d\u79f0\uff0c\u5c97\u4f4d\u548c\u5b9a\u5458\u5e94\u8be5\u76f8\u540c");
            }
            return errInfoResult;
        }
        return Collections.emptyList();
    }

    private List<String> validWorkShopWorkNameSame(List<RowModel2> rowsData) {
        if (CollectionUtils.isNotEmpty(rowsData) && rowsData.size() > 4) {
            Map<String, List<RowModel2>> result;
            Set<String> strings;
            List<RowModel2> rows = rowsData.subList(4, rowsData.size());
            LinkedList<String> errInfoResult = new LinkedList<String>();
            if (CollectionUtils.isNotEmpty(rows) && CollectionUtils.isNotEmpty(strings = (result = rows.stream().collect(Collectors.groupingBy(row -> {
                String workshop = StringUtils.replace((String)((String)row.getCol().get(0)), (String)" ", (String)"");
                String workname = StringUtils.replace((String)((String)row.getCol().get(1)), (String)" ", (String)"");
                return workshop + workname;
            }))).keySet())) {
                for (String key : strings) {
                    Set workNumSet;
                    List<RowModel2> rowModel2s = result.get(key);
                    if (!CollectionUtils.isNotEmpty(rowModel2s) || (workNumSet = rowModel2s.stream().map(r -> (String)r.getCol().get(2)).collect(Collectors.toSet())).size() <= 1) continue;
                    Set rowNumSet = rowModel2s.stream().map(r -> "\u7b2c" + r.getRowNum() + "\u884c").collect(Collectors.toSet());
                    errInfoResult.add(StringUtils.join(rowNumSet, (String)"\u4e0e") + ",\u76f8\u540c\u8f66\u95f4\u76f8\u540c\u5c97\u4f4d\u7684\u5b9a\u5458\u6570\u5e94\u76f8\u540c");
                }
            }
            return errInfoResult;
        }
        return Collections.emptyList();
    }

    private void removeByEvId(Long evId) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(RiskExposeEvaluateData::getRiskExposeEvaluateId, (Object)evId);
        updateWrapper.set(BaseEntity::getIsValid, (Object)false);
        this.update((Wrapper)updateWrapper);
    }

    public List<EvDataStatModel> queryEvDataStat(Long evId) {
        Map<Long, String> factorIdToTypeMap = this.factorService.doGetAllIdAndTypeFactorMap();
        List<RiskExposeEvaluateData> dataList = this.queryByEvId(evId);
        dataList = this.removeDuplicateCount(dataList);
        EvDataStatModel model = null;
        HashMap<String, EvDataStatModel> map = new HashMap<String, EvDataStatModel>();
        String[] arr = new String[]{"\u7c89\u5c18", "\u5316\u5b66\u56e0\u7d20", "\u7269\u7406\u56e0\u7d20", "\u653e\u5c04\u56e0\u7d20", "\u751f\u7269\u56e0\u7d20"};
        for (String type : arr) {
            model = new EvDataStatModel();
            model.setFactorType(type);
            map.put(type, model);
        }
        for (RiskExposeEvaluateData data : dataList) {
            String type;
            EvDataStatModel evDataStatModel;
            String factorId = data.getFactorId();
            if (factorId == null) continue;
            Object facId = null;
            if (StringUtils.isNotEmpty((String)factorId)) {
                if (!factorId.contains(",")) {
                    facId = Long.parseLong(factorId);
                } else {
                    List facIds = StringUtils.parseToLongList((String)factorId, (String)",");
                    if (facIds != null && facIds.size() > 0) {
                        facId = (Long)facIds.get(0);
                    }
                }
            }
            if ((evDataStatModel = (EvDataStatModel)map.get(type = factorIdToTypeMap.get(facId))) == null) continue;
            List nums = evDataStatModel.getNums();
            boolean isExist = false;
            for (EvFactorTouchNum num : nums) {
                if (!data.getFactorId().equals(num.getFactorId()) || !data.getFactorName().equals(num.getFactorName())) continue;
                num.setTouchNum(Integer.valueOf((data.getWorkNum() == null ? 0 : data.getWorkNum()) + (num.getTouchNum() == null ? 0 : num.getTouchNum())));
                isExist = true;
                break;
            }
            if (isExist) continue;
            EvFactorTouchNum touchNum = new EvFactorTouchNum();
            touchNum.setFactorId(factorId);
            touchNum.setTouchNum(data.getWorkNum());
            touchNum.setFactorType(type);
            touchNum.setFactorName(data.getFactorName());
            nums.add(touchNum);
        }
        EvDataStatModel dustModel = (EvDataStatModel)map.get("\u7c89\u5c18");
        List nums = dustModel.getNums();
        HashMap<String, EvFactorTouchNum> dustMap = new HashMap<String, EvFactorTouchNum>();
        for (EvFactorTouchNum ev : nums) {
            EvFactorTouchNum ev1 = (EvFactorTouchNum)dustMap.get(ev.getFactorId());
            if (ev1 == null) {
                if (ev.getFactorId().contains(",")) {
                    ev.setFactorName(ev.getFactorName());
                } else {
                    HarmFactor facName = this.harmFactorService.getThisById(Long.valueOf(Long.parseLong(ev.getFactorId())));
                    ev.setFactorName(facName.getNameCh());
                }
                dustMap.put(ev.getFactorId(), ev);
                continue;
            }
            if (ev.getTouchNum() <= ev1.getTouchNum()) continue;
            ev1.setTouchNum(ev.getTouchNum());
            dustMap.put(ev.getFactorId(), ev1);
        }
        ArrayList newList = new ArrayList(dustMap.values());
        dustModel.setNums(newList);
        map.put("\u7c89\u5c18", dustModel);
        return new ArrayList<EvDataStatModel>(map.values());
    }

    private List<RiskExposeEvaluateData> removeDuplicateDust(List<RiskExposeEvaluateData> list) {
        HashMap<CallSite, RiskExposeEvaluateData> dustMap = new HashMap<CallSite, RiskExposeEvaluateData>();
        ArrayList<RiskExposeEvaluateData> newList = new ArrayList<RiskExposeEvaluateData>();
        for (RiskExposeEvaluateData ev : list) {
            if (ev.getFactorName() != null && (ev.getFactorName().contains("\u603b\u5c18") || ev.getFactorName().contains("\u547c\u5c18"))) {
                String key = ev.getFactorId() + "-" + ev.getCheckPoint();
                RiskExposeEvaluateData ev1 = (RiskExposeEvaluateData)dustMap.get(key);
                if (ev1 == null) {
                    dustMap.put((CallSite)((Object)key), ev);
                    continue;
                }
                if (ev.getWorkNum() != null && ev.getWorkNum() != null && ev.getWorkNum() > ev1.getWorkNum()) {
                    ev1.setWorkNum(ev.getWorkNum());
                }
                if (ev.getWorkNum() == null) {
                    ev1.setWorkNum(ev.getWorkNum());
                }
                if (ev.getCheckTouchLevel() != null && ev.getCheckTouchLevel() == 1) {
                    ev1.setCheckTouchLevel(ev.getCheckTouchLevel());
                }
                dustMap.put((CallSite)((Object)key), ev1);
                continue;
            }
            newList.add(ev);
        }
        ArrayList dustList = new ArrayList(dustMap.values());
        if (dustList.size() > 0) {
            newList.addAll(dustList);
        }
        return newList;
    }

    private List<RiskExposeEvaluateData> removeDuplicateCount(List<RiskExposeEvaluateData> list) {
        HashMap<CallSite, RiskExposeEvaluateData> dustMap = new HashMap<CallSite, RiskExposeEvaluateData>();
        ArrayList<RiskExposeEvaluateData> newList = new ArrayList<RiskExposeEvaluateData>();
        for (RiskExposeEvaluateData ev : list) {
            if (ev.getWorkshop() != null && ev.getWorkName() != null && ev.getWorkNum() != null && ev.getFactorId() != null) {
                String key = ev.getWorkshop() + "-" + ev.getWorkName() + "-" + ev.getWorkNum() + "-" + ev.getFactorId();
                dustMap.putIfAbsent((CallSite)((Object)key), ev);
                continue;
            }
            newList.add(ev);
        }
        ArrayList dustList = new ArrayList(dustMap.values());
        if (dustList.size() > 0) {
            newList.addAll(dustList);
        }
        return newList;
    }

    public PageInfo<RiskExposeEvaluateData> queryPageDataList(QueryPageRiskEvDataParam param) {
        Set fangSheSet;
        if (this.factoryCache.estimatedSize() == 0L) {
            this.getFactoryCache();
        }
        if (CollectionUtils.isEmpty((Collection)(fangSheSet = (Set)this.factoryCache.getIfPresent((Object)"\u653e\u5c04\u56e0\u7d20")))) {
            this.getFactoryCache();
            fangSheSet = (Set)this.factoryCache.getIfPresent((Object)"\u653e\u5c04\u56e0\u7d20");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<RiskExposeEvaluateData> list = ((RiskExposeEvaluateDataMapper)this.baseMapper).queryPageDataList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            for (RiskExposeEvaluateData item : list) {
                if (item == null) continue;
                if (item.getDataSource().equals(2) && StringUtils.isBlank((CharSequence)item.getFactorId())) {
                    item.setFactorAbnormal(Boolean.valueOf(true));
                }
                String factorIds = item.getFactorId();
                Long facId = null;
                if (StringUtils.isNotEmpty((String)factorIds)) {
                    if (!factorIds.contains(",")) {
                        facId = Long.parseLong(factorIds);
                    } else {
                        List facIds = StringUtils.parseToLongList((String)factorIds, (String)",");
                        if (facIds.size() > 0) {
                            facId = (Long)facIds.get(0);
                        }
                    }
                }
                if (facId == null || fangSheSet == null || !fangSheSet.contains(facId)) continue;
                item.setIsFangShe(Boolean.valueOf(true));
            }
        }
        return new PageInfo(list);
    }

    public PageInfo<RiskExposeEvaluateData> queryPageDataListOrderByLevel(QueryPageRiskEvDataParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<RiskExposeEvaluateData> list = ((RiskExposeEvaluateDataMapper)this.baseMapper).queryPageDataListOrderByLevel(param);
        return new PageInfo(list);
    }

    private void verifyImportData(RiskExposeEvaluate ev, int row, RiskExposeEvaluateData data, Map<String, String> map, Map<Long, String> natureMap) throws ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append("\u7b2c" + (row + 2) + "\u884c:");
        HashSet<String> errInfoSet = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)data.getWorkshop())) {
            errInfoSet.add("\u8f66\u95f4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)data.getWorkName())) {
            errInfoSet.add("\u5de5\u79cd/\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (data.getWorkNum() == null) {
            errInfoSet.add("\u5b9a\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ev.getType().equals(2)) {
            if (StringUtils.isBlank((CharSequence)data.getCheckPoint())) {
                errInfoSet.add("\u68c0\u6d4b\u70b9/\u68c0\u6d4b\u5bf9\u8c61\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)data.getFactorName())) {
                errInfoSet.add("\u5371\u5bb3\u56e0\u7d20\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)data.getFactorName())) {
                Set<String> harmIdSet4Map;
                String fname = data.getFactorName();
                if (fname.contains("\u603b\u5c18") || fname.contains("\u547c\u5c18")) {
                    fname = fname.substring(0, fname.length() - 4);
                }
                if (CollectionUtils.isEmpty(harmIdSet4Map = this.getHarmIdSet4Map(fname, map))) {
                    errInfoSet.add("\u5371\u5bb3\u56e0\u7d20\u4e0d\u5b58\u5728");
                } else {
                    String natureStr;
                    String firstId = new ArrayList<String>(harmIdSet4Map).get(0);
                    data.setFactorId(StringUtils.join(harmIdSet4Map, (String)","));
                    Long facId = null;
                    if (StringUtils.isNotEmpty((String)firstId)) {
                        if (!firstId.contains(",")) {
                            facId = Long.parseLong(firstId);
                        } else {
                            List facIds = StringUtils.parseToLongList((String)firstId, (String)",");
                            if (facIds.size() > 0) {
                                facId = (Long)facIds.get(0);
                            }
                        }
                    }
                    if ("1".equals(natureStr = natureMap.get(facId))) {
                        data.setFactorNature(Integer.valueOf(2));
                    } else {
                        data.setFactorNature(Integer.valueOf(1));
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(errInfoSet)) {
            sb.append(StringUtils.join(errInfoSet, (String)","));
            throw new ParseException(sb.toString());
        }
    }

    private String getOtherFactorValue(List<CheckRecordFileCheckResultVo> resultList) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (CheckRecordFileCheckResultVo vo : resultList) {
            Integer targetId;
            Long factorId = vo.getFactorId();
            if (factorId == null || (targetId = vo.getTargetId()) == null) continue;
            int tId = targetId;
            if (vo.getItemId().equals(4L) && tId != 36 || vo.getItemId().equals(5L) && tId != 41 && tId != 42 && tId != 44 && tId != 45 && tId != 47 && tId != 48 || vo.getItemId().equals(6L) && tId != 55 || vo.getItemId().equals(7L) && tId != 60 && tId != 61 && tId != 62 || vo.getItemId().equals(8L) && tId != 67 && tId != 68 || vo.getItemId().equals(9L) && tId != 73 && tId != 74 || vo.getItemId().equals(10L) && tId != 78 && tId != 82 || vo.getItemId().equals(11L) && tId != 86 || vo.getItemId().equals(12L) && tId != 94 && tId != 95 || vo.getShowCheckValue() == null || vo.getShowCheckValue().isEmpty()) continue;
            sb.append(vo.getTargetName());
            sb.append(":");
            sb.append(vo.getShowCheckValue());
            if (vo.getUnit() != null && !vo.getUnit().isEmpty()) {
                sb.append("(").append(vo.getUnit()).append(")");
            }
            sb.append("/");
            ++count;
        }
        if (count == 1) {
            return sb.substring(sb.indexOf(":") + 1, sb.length() - 1);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    private String getValue(List<CheckRecordFileCheckResultVo> resultList, Integer targetId) {
        for (CheckRecordFileCheckResultVo vo : resultList) {
            if (!vo.getTargetId().equals(targetId)) continue;
            if (StringUtils.isNotEmpty((String)vo.getCheckValueMax())) {
                return vo.getCheckValueMax();
            }
            if (StringUtils.isNotEmpty((String)vo.getCheckValue())) {
                return vo.getCheckValue();
            }
            if (StringUtils.isNotEmpty((String)vo.getCheckValueMin())) {
                return vo.getCheckValueMin();
            }
            return "";
        }
        return "";
    }

    private Integer getTouchLevel(String judgeResult) {
        if ("3".equals(judgeResult)) {
            return 1;
        }
        return 2;
    }

    public Integer selfCheckSixResult(Long evId) {
        RiskExposeEvaluate exposeEvaluate = (RiskExposeEvaluate)this.evaluateService.getById((Serializable)evId);
        if (exposeEvaluate == null || exposeEvaluate.getReportStatus() == 1) {
            return 1;
        }
        List<RiskExposeEvaluateData> list = this.queryByEvId(evId);
        Map<Long, String> natureMap = this.factorService.getNatureMap();
        boolean flag = false;
        for (RiskExposeEvaluateData data : list) {
            if (data.getFactorId() == null) continue;
            String factorId = data.getFactorId();
            Long facId = null;
            if (StringUtils.isNotEmpty((String)factorId)) {
                if (!factorId.contains(",")) {
                    facId = Long.parseLong(factorId);
                } else {
                    List facIds = StringUtils.parseToLongList((String)factorId, (String)",");
                    if (facIds.size() > 0) {
                        facId = (Long)facIds.get(0);
                    }
                }
            }
            String nature = natureMap.get(facId);
            if (!data.getCheckTouchLevel().equals(1)) continue;
            if ("1".equals(nature)) {
                return 3;
            }
            flag = true;
        }
        if (flag) {
            return 2;
        }
        return 1;
    }

    public boolean touchLevelCompare(Long evId) {
        List list = this.evaluateDataService.queryByEvId(evId);
        for (RiskExposeEvaluateData data : list) {
            if (data.getTouchLevel() == null || data.getCheckTouchLevel() == null || data.getTouchLevel().equals(data.getCheckTouchLevel())) continue;
            return false;
        }
        return true;
    }

    public void logicDelByIds(List<Long> dataIds) {
        if (dataIds == null || dataIds.size() == 0) {
            return;
        }
        ((RiskExposeEvaluateDataMapper)this.baseMapper).logicDelByIds(dataIds);
    }

    public void logicDelByEvId(Long evId) {
        if (evId == null) {
            return;
        }
        List<RiskExposeEvaluateData> list = this.queryByEvId(evId);
        if (list != null) {
            for (RiskExposeEvaluateData data : list) {
                data.setIsValid(Boolean.valueOf(false));
                this.updateById(data);
            }
        }
    }

    public void saveOrUpdateList(List<RiskExposeEvaluateData> list, Boolean resetPePcTwa) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Long evId = list.get(0).getRiskExposeEvaluateId();
        Map<Long, String> natureMap = this.factorService.getNatureMap();
        RiskExposeEvaluate ev = (RiskExposeEvaluate)this.evaluateService.getById((Serializable)evId);
        List factorIds = list.stream().map(RiskExposeEvaluateData::getFactorId).collect(Collectors.toList());
        Map factorAttrMap = this.factorLimitValueService.queryLimitValues(factorIds);
        List<RiskExposeEvaluateData> rDataList = this.perfectDataList(list, factorAttrMap, natureMap);
        this.evaluateDataService.saveOrUpdateBatch(rDataList);
        ev.setDataUpdateDate(LocalDateTime.now());
        this.evaluateService.updateById((Object)ev);
    }

    public void saveOrUpdateList2(List<RiskExposeEvaluateData> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Long evId = list.get(0).getRiskExposeEvaluateId();
        Map<Long, String> natureMap = this.factorService.getNatureMap();
        RiskExposeEvaluate ev = (RiskExposeEvaluate)this.evaluateService.getById((Serializable)evId);
        List factorIds = list.stream().map(RiskExposeEvaluateData::getFactorId).collect(Collectors.toList());
        Map factorAttrMap = this.factorLimitValueService.queryLimitValues(factorIds);
        List<RiskExposeEvaluateData> rDataList = this.perfectDataList(list, factorAttrMap, natureMap);
        this.evaluateDataService.saveOrUpdateBatch(rDataList);
    }

    private void supplementDate(RiskExposeEvaluateData data) {
        if (data.getTouchLevel() == null) {
            data.setTouchLevel(Integer.valueOf(2));
        }
        if (data.getCtwa() == null) {
            data.setCtwa("");
        }
        if (data.getCste() == null) {
            data.setCste("");
        }
        if (data.getCstel() == null) {
            data.setCstel("");
        }
        if (data.getCme() == null) {
            data.setCme("");
        }
        if (data.getCmac() == null) {
            data.setCmac("");
        }
        if (data.getExceedLimit() == null) {
            data.setExceedLimit("");
        }
        if (data.getPePcTwa() == null) {
            data.setPePcTwa("");
        }
    }

    public Integer queryTouchLevel(RiskExposeEvaluateData data) {
        Map factorAttrMap = this.factorLimitValueService.queryLimitValues(Arrays.asList(data.getFactorId()));
        Map attrMap = (Map)factorAttrMap.get(data.getFactorId());
        data.setFactorAttrTwa(this.getFactorAttrTwa(data.getFactorId(), data.getFactorName(), attrMap));
        data.setTouchLevel(this.getTouchLevel(data, attrMap));
        if (data.getTouchLevel() == null) {
            return 2;
        }
        return data.getTouchLevel();
    }

    public Boolean factorAbnormal(RiskExposeEvaluateData data) {
        if (data == null) {
            return false;
        }
        this.setFactorAbnormal(Collections.singletonList(data));
        return data.getFactorAbnormal();
    }

    public Map<Long, EvTouchNumStat> evTouchStat(List<Long> evIds) {
        if (evIds == null || evIds.isEmpty()) {
            return new HashMap<Long, EvTouchNumStat>(0);
        }
        HashMap<Long, EvTouchNumStat> map = new HashMap<Long, EvTouchNumStat>();
        for (Long evId : evIds) {
            RiskDecisionVo decVo = this.evaluateService.queryTouchNumAndLevel(evId);
            EvTouchNumStat stat = new EvTouchNumStat();
            if (decVo == null) continue;
            if (decVo.getGeneralOverStaffCount() > 0) {
                stat.setOneOver(Boolean.valueOf(true));
            }
            if (decVo.getSeriousOverStaffCount() > 0) {
                stat.setTwoOver(Boolean.valueOf(true));
            }
            stat.setOneTouchNum(Integer.valueOf(decVo.getGeneralOverStaffCount() + decVo.getGeneralNotOverStaffCount()));
            stat.setTwoTouchNum(Integer.valueOf(decVo.getSeriousOverStaffCount() + decVo.getSeriousNotOverStaffCount()));
            stat.setEvId(evId);
            map.put(stat.getEvId(), stat);
        }
        return map;
    }

    private List<RiskExposeEvaluateData> perfectDataList(List<RiskExposeEvaluateData> list, Map<String, Map<String, String>> factorAttrMap, Map<Long, String> natureMap) {
        Set fangSheSet;
        if (this.factoryCache.estimatedSize() == 0L) {
            this.getFactoryCache();
        }
        if (CollectionUtils.isEmpty((Collection)(fangSheSet = (Set)this.factoryCache.getIfPresent((Object)"\u653e\u5c04\u56e0\u7d20")))) {
            this.getFactoryCache();
            fangSheSet = (Set)this.factoryCache.getIfPresent((Object)"\u653e\u5c04\u56e0\u7d20");
            if (fangSheSet == null) {
                this.logger.error("factoryCache.getIfPresent(\u653e\u5c04\u56e0\u7d20)\u83b7\u53d6\u7f13\u5b58\u51fa\u9519\uff1f\uff1f");
            }
        }
        LinkedList<RiskExposeEvaluateData> rDataList = new LinkedList<RiskExposeEvaluateData>();
        for (RiskExposeEvaluateData data : list) {
            Map<String, String> attrMap;
            String factorIds = data.getFactorId();
            Long facId = null;
            if (StringUtils.isNotEmpty((String)factorIds)) {
                if (!factorIds.contains(",")) {
                    facId = Long.parseLong(factorIds);
                } else {
                    List facIds = StringUtils.parseToLongList((String)factorIds, (String)",");
                    if (facIds.size() > 0) {
                        facId = (Long)facIds.get(0);
                    }
                }
            }
            if (facId != null && fangSheSet != null && fangSheSet.contains(facId)) {
                if (data.getFactorNature() == null) {
                    data.setFactorNature(Integer.valueOf(2));
                } else {
                    data.setFactorNature(data.getFactorNature());
                }
            } else {
                String nature = natureMap.get(facId);
                if ("1".equals(nature)) {
                    data.setFactorNature(Integer.valueOf(2));
                } else {
                    data.setFactorNature(Integer.valueOf(1));
                }
            }
            data.setCanEdit(Boolean.valueOf(true));
            boolean addflag = false;
            if (!data.getFactorName().contains("\u603b\u5c18") && !data.getFactorName().contains("\u547c\u5c18") && (attrMap = factorAttrMap.get(data.getFactorId())) != null) {
                if (attrMap.get("twa_total") != null) {
                    if (attrMap.get("twa_respirabel") != null) {
                        d2 = new RiskExposeEvaluateData();
                        BeanUtils.copyProperties((Object)data, (Object)d2);
                        d2.setFactorName(d2.getFactorName() + "(\u547c\u5c18)");
                        d2.setId(null);
                        d2.setFactorAttrTwa(this.getFactorAttrTwa(d2.getFactorId(), d2.getFactorName(), attrMap));
                        d2.setTouchLevel(this.getTouchLevel(d2, attrMap));
                        this.supplementDate(d2);
                        rDataList.add(d2);
                    }
                    addflag = true;
                    data.setFactorName(data.getFactorName() + "(\u603b\u5c18)");
                    data.setFactorAttrTwa(this.getFactorAttrTwa(data.getFactorId(), data.getFactorName(), attrMap));
                    data.setTouchLevel(this.getTouchLevel(data, attrMap));
                    this.supplementDate(data);
                    rDataList.add(data);
                } else if (attrMap.get("twa_respirabel") != null) {
                    if (attrMap.get("twa_total") != null) {
                        d2 = new RiskExposeEvaluateData();
                        BeanUtils.copyProperties((Object)data, (Object)d2);
                        d2.setFactorName(d2.getFactorName() + "(\u603b\u5c18)");
                        d2.setId(null);
                        d2.setTouchLevel(this.getTouchLevel(d2, attrMap));
                        d2.setFactorAttrTwa(this.getFactorAttrTwa(d2.getFactorId(), d2.getFactorName(), attrMap));
                        this.supplementDate(d2);
                        rDataList.add(d2);
                    }
                    addflag = true;
                    data.setFactorName(data.getFactorName() + "(\u547c\u5c18)");
                    data.setFactorAttrTwa(this.getFactorAttrTwa(data.getFactorId(), data.getFactorName(), attrMap));
                    data.setTouchLevel(this.getTouchLevel(data, attrMap));
                    this.supplementDate(data);
                    rDataList.add(data);
                }
            }
            if (addflag) continue;
            if (data.getFactorId() != null) {
                attrMap = factorAttrMap.get(data.getFactorId());
                data.setFactorAttrTwa(this.getFactorAttrTwa(data.getFactorId(), data.getFactorName(), attrMap));
                data.setTouchLevel(this.getTouchLevel(data, attrMap));
            }
            this.supplementDate(data);
            rDataList.add(data);
        }
        return rDataList;
    }

    private List<RiskExposeEvaluateData> rDataList(List<RiskExposeEvaluateData> list, Map<String, Map<String, String>> factorAttrMap, Map<Long, String> natureMap) {
        LinkedList<RiskExposeEvaluateData> rDataList = new LinkedList<RiskExposeEvaluateData>();
        for (RiskExposeEvaluateData data : list) {
            Map<String, String> attrMap;
            String nature;
            String factorIds = data.getFactorId();
            Long facId = null;
            if (StringUtils.isNotEmpty((String)factorIds)) {
                if (!factorIds.contains(",")) {
                    facId = Long.parseLong(factorIds);
                } else {
                    List facIds = StringUtils.parseToLongList((String)factorIds, (String)",");
                    if (facIds.size() > 0) {
                        facId = (Long)facIds.get(0);
                    }
                }
            }
            if ("1".equals(nature = natureMap.get(facId))) {
                data.setFactorNature(Integer.valueOf(2));
            } else {
                data.setFactorNature(Integer.valueOf(1));
            }
            data.setCanEdit(Boolean.valueOf(true));
            boolean addflag = false;
            if (!data.getFactorName().contains("\u603b\u5c18") && !data.getFactorName().contains("\u547c\u5c18") && (attrMap = factorAttrMap.get(data.getFactorId())) != null) {
                if (attrMap.get("twa_total") != null) {
                    if (attrMap.get("twa_respirabel") != null) {
                        d2 = new RiskExposeEvaluateData();
                        BeanUtils.copyProperties((Object)data, (Object)d2);
                        d2.setFactorName(d2.getFactorName() + "(\u547c\u5c18)");
                        d2.setId(null);
                        rDataList.add(d2);
                    }
                    addflag = true;
                    data.setFactorName(data.getFactorName() + "(\u603b\u5c18)");
                    rDataList.add(data);
                } else if (attrMap.get("twa_respirabel") != null) {
                    if (attrMap.get("twa_total") != null) {
                        d2 = new RiskExposeEvaluateData();
                        BeanUtils.copyProperties((Object)data, (Object)d2);
                        d2.setFactorName(d2.getFactorName() + "(\u603b\u5c18)");
                        d2.setId(null);
                        rDataList.add(d2);
                    }
                    addflag = true;
                    data.setFactorName(data.getFactorName() + "(\u547c\u5c18)");
                    rDataList.add(data);
                }
            }
            if (addflag) continue;
            rDataList.add(data);
        }
        return rDataList;
    }

    private Integer getTouchLevel(RiskExposeEvaluateData data, Map<String, String> attrMap) {
        String twaVal;
        Double att;
        String attrVal;
        data.setTouchLevel(null);
        if (data.getFactorId() == null) {
            return 3;
        }
        if (data.getFactorId().equals("96")) {
            return 3;
        }
        if (data.getFactorId().equals("567")) {
            try {
                if (data.getNoiseLevel() != null) {
                    if (Double.parseDouble(data.getNoiseLevel()) > 85.0) {
                        return 1;
                    }
                    if (Double.parseDouble(data.getNoiseLevel()) <= 85.0 && Double.parseDouble(data.getNoiseLevel()) >= 60.0) {
                        return 3;
                    }
                    return 2;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (attrMap == null) {
            if (!data.getFactorId().equals("567")) {
                return 3;
            }
            return 2;
        }
        String ctwa = data.getCtwa();
        String reductionFactor = data.getReductionFactor();
        if (StringUtils.isBlank((CharSequence)reductionFactor)) {
            reductionFactor = "1";
        }
        if (data.getFactorName().contains("\u603b\u5c18")) {
            attrVal = attrMap.get("twa_total");
            if (attrVal != null) {
                att = Double.parseDouble(attrVal) * Double.parseDouble(reductionFactor);
                attrVal = att.toString();
            }
            if (this.exceed(ctwa, attrVal)) {
                return 1;
            }
        }
        if (data.getFactorName().contains("\u547c\u5c18")) {
            attrVal = attrMap.get("twa_respirabel");
            if (attrVal != null) {
                att = Double.parseDouble(attrVal) * Double.parseDouble(reductionFactor);
                attrVal = att.toString();
            }
            if (this.exceed(ctwa, attrVal)) {
                return 1;
            }
        }
        if ((twaVal = attrMap.get("twa")) != null) {
            att = Double.parseDouble(twaVal) * Double.parseDouble(reductionFactor);
            twaVal = att.toString();
        }
        if (this.exceed(ctwa, twaVal)) {
            return 1;
        }
        String cstel = data.getCstel();
        if (this.exceed(cstel, attrMap.get("stel"))) {
            return 1;
        }
        String cste = data.getCste();
        if (this.exceed(cste, attrMap.get("stel"))) {
            return 1;
        }
        String cmac = data.getCmac();
        if (this.exceed(cmac, attrMap.get("mac"))) {
            return 1;
        }
        String cme = data.getCme();
        if (this.exceed(cme, attrMap.get("mac"))) {
            return 1;
        }
        String exceedLimit = data.getExceedLimit();
        if (this.exceed(exceedLimit, attrMap.get("max_excursion_limit"))) {
            return 1;
        }
        String pepctwa = data.getPePcTwa();
        if (pepctwa != null && data.getFactorAttrTwa() != null) {
            Double att2 = Double.parseDouble(data.getFactorAttrTwa()) * Double.parseDouble(reductionFactor) * 5.0;
            Double att22 = Double.parseDouble(data.getFactorAttrTwa()) * Double.parseDouble(reductionFactor) * 3.0;
            if (this.exceed(pepctwa, att2.toString())) {
                return 1;
            }
            if (this.exceed(pepctwa, att22.toString())) {
                return 3;
            }
        }
        return 2;
    }

    private void setFactorAbnormal(List<RiskExposeEvaluateData> rDataList) {
        Map<Long, String> idAndTypeMap = this.factorService.doGetAllIdAndTypeMap();
        for (RiskExposeEvaluateData data : rDataList) {
            data.setFactorAbnormal(Boolean.valueOf(false));
            if (data.getFactorId() == null || data.getFactorName() == null) continue;
            String s = idAndTypeMap.get(data.getFactorId());
            String factorId = data.getFactorId();
            Long facId = null;
            if (StringUtils.isNotEmpty((String)factorId)) {
                if (!factorId.contains(",")) {
                    facId = Long.parseLong(factorId);
                } else {
                    List facIds = StringUtils.parseToLongList((String)factorId, (String)",");
                    if (facIds != null && facIds.size() > 0) {
                        facId = (Long)facIds.get(0);
                    }
                }
            }
            List limitAttrs = this.factorLimitValueService.getFactorLimitKeys(facId);
            if ("\u7c89\u5c18".equals(s)) {
                if (data.getFactorName().contains("\u547c\u5c18") && !limitAttrs.contains("twa_respirabel")) {
                    data.setFactorAbnormal(Boolean.valueOf(true));
                }
                if (data.getFactorName().contains("\u603b\u5c18") && !limitAttrs.contains("twa_total")) {
                    data.setFactorAbnormal(Boolean.valueOf(true));
                }
            }
            if ("\u7c89\u5c18".equals(s) || !data.getFactorName().contains("\u5176\u4ed6")) continue;
            data.setFactorAbnormal(Boolean.valueOf(true));
        }
    }

    private String getFactorAttrTwa(String factorId, String factorName, Map<String, String> attrMap) {
        String twa_total;
        if (factorId == null || attrMap == null) {
            return null;
        }
        String twa = attrMap.get("twa");
        if (twa != null) {
            return twa;
        }
        if (factorName != null) {
            String twa_respirabel;
            if (factorName.contains("\u603b\u5c18") && (twa_total = attrMap.get("twa_total")) != null) {
                return twa_total;
            }
            if (factorName.contains("\u547c\u5c18") && (twa_respirabel = attrMap.get("twa_respirabel")) != null) {
                return twa_respirabel;
            }
        }
        if ((twa_total = attrMap.get("twa_total")) != null) {
            return twa_total;
        }
        String twa_respirabel = attrMap.get("twa_respirabel");
        if (twa_respirabel != null) {
            return twa_respirabel;
        }
        return null;
    }

    private boolean exceed(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        if ((v1 = v1.trim()).startsWith("-") || v1.startsWith(">") || v1.startsWith("<") || v1.startsWith("\uff1c") || v1.startsWith("\u2264")) {
            v1 = v1.substring(1);
        }
        try {
            return Double.parseDouble(v1) > Double.parseDouble(v2);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isOverQuotaByEvId(Long evId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(RiskExposeEvaluateData::getRiskExposeEvaluateId, (Object)evId)).eq(BaseEntity::getIsValid, (Object)true)).eq(RiskExposeEvaluateData::getCheckTouchLevel, (Object)1)).orderByAsc(BaseEntity::getId);
        Long count = ((RiskExposeEvaluateDataMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        return count != null && count > 0L;
    }

    public List<RiskExposeEvaluateData> getRiskDataByShopAndNameGroup(Long evId) {
        if (evId == null) {
            return Collections.emptyList();
        }
        return ((RiskExposeEvaluateDataMapper)this.baseMapper).getRiskDataByShopAndNameGroup(evId);
    }

    public List<RiskExposeEvaluateData> getRiskDataByShopAndPointGroup(Long evId) {
        if (evId == null) {
            return Collections.emptyList();
        }
        return ((RiskExposeEvaluateDataMapper)this.baseMapper).getRiskDataByShopAndPointGroup(evId);
    }

    public List<RadiateRiskListModel> getRadiateRiskList(ListParamModel param) {
        if (!param.getIsValid().booleanValue() || StringUtils.isNotBlank((CharSequence)param.getOldItemId())) {
            return new ArrayList<RadiateRiskListModel>();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getIsValid, (Object)true)).eq(RiskExposeEvaluateData::getRiskExposeEvaluateId, (Object)param.getCheckId())).list();
        ArrayList<RadiateRiskListModel> modelList = new ArrayList<RadiateRiskListModel>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (RiskExposeEvaluateData data : list) {
                if (data == null) continue;
                RadiateRiskListModel model = new RadiateRiskListModel();
                model.setCheckObject(data.getCheckPoint());
                model.setCheckProject(data.getFactorName());
                model.setCenter(data.getOtherFactorValue());
                model.setRiskId(data.getRiskExposeEvaluateId());
                if (data.getCheckTouchLevel() == 1) {
                    model.setJudged("\u4e0d\u7b26\u5408");
                } else if (data.getCheckTouchLevel() == 2) {
                    model.setJudged("\u7b26\u5408");
                }
                if (StringUtils.isNotBlank((CharSequence)param.getJudgeResult()) && (param.getJudgeResult().equals("1") || param.getJudgeResult().equals("2") && !Objects.equals("\u7b26\u5408", model.getJudged()) || param.getJudgeResult().equals("3") && !Objects.equals("\u4e0d\u7b26\u5408", model.getJudged()))) continue;
                modelList.add(model);
            }
        }
        return modelList;
    }

    public Map<Long, List<RiskExposeEvaluateData>> getEvaluateDataListByCheckIdList(List<Long> checkIdList, Boolean isOver) {
        HashMap<Long, List<RiskExposeEvaluateData>> map = new HashMap<Long, List<RiskExposeEvaluateData>>();
        if (CollectionUtils.isEmpty(checkIdList)) {
            return map;
        }
        Map<Long, Long> checkAndRiskId1 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.checkPlanService.lambdaQuery().in(BaseEntity::getId, checkIdList)).eq(BaseEntity::getIsValid, (Object)true)).select(new SFunction[]{CheckPlan::getRiskExposeEvaluateId, BaseEntity::getId}).list().stream().filter(item -> item != null && item.getRiskExposeEvaluateId() != null).collect(Collectors.toMap(BaseEntity::getId, CheckPlan::getRiskExposeEvaluateId, (k1, k2) -> k1));
        Map<Long, Long> checkAndRiskId2 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.evaluateService.lambdaQuery().in(RiskExposeEvaluate::getCheckPlanId, checkIdList)).eq(BaseEntity::getIsValid, (Object)true)).select(new SFunction[]{BaseEntity::getId, RiskExposeEvaluate::getCheckPlanId}).orderByDesc(BaseEntity::getCreateDate)).list().stream().filter(Objects::nonNull).collect(Collectors.toMap(RiskExposeEvaluate::getCheckPlanId, BaseEntity::getId, (k1, k2) -> k1));
        ArrayList<Long> riskIdList = new ArrayList<Long>();
        riskIdList.addAll(checkAndRiskId1.values());
        riskIdList.addAll(checkAndRiskId2.values());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(RiskExposeEvaluateData::getRiskExposeEvaluateId, riskIdList)).eq(BaseEntity::getIsValid, (Object)true);
        if (Objects.equals(true, isOver)) {
            wrapper.eq(RiskExposeEvaluateData::getCheckTouchLevel, (Object)1);
        }
        Map<Long, List<RiskExposeEvaluateData>> detailMap = this.list((Wrapper)wrapper).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(RiskExposeEvaluateData::getRiskExposeEvaluateId));
        checkAndRiskId1.forEach((checkId, riskId) -> {
            List dataList = (List)detailMap.get(riskId);
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return;
            }
            map.put((Long)checkId, dataList);
        });
        checkAndRiskId2.forEach((checkId, riskId) -> {
            List dataList = (List)detailMap.get(riskId);
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return;
            }
            map.put((Long)checkId, dataList);
        });
        return map;
    }
}

