/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp.riskev;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.enums.HazardsExposureRiskLevelEnum;
import cn.smarthse.services.hfi.api.model.riskev.MicroCompanyEvQueryParam;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.HazardsExposureRiskLevelVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.MicroCompanyRiskDecisionVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.MicroCompanyRiskExposeEvaluateVo;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.mapper.riskev.MicroCompanyRiskExposeEvaluateMapper;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=5000000)
public class MicroCompanyRiskExposeEvaluateServiceImpl
extends BaseServiceImp<MicroCompanyRiskExposeEvaluateMapper, MicroCompanyRiskExposeEvaluate>
implements IMicroCompanyRiskExposeEvaluateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicroCompanyRiskExposeEvaluateServiceImpl.class);
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    @Lazy
    private IMicroCompanyRiskExposeEvaluateDataService exposeEvaluateDataService;
    @Autowired
    @Lazy
    private IRiskExposeEvaluateDataService oldExposeEvaluateDataService;
    @Autowired
    protected IdWorker idworker;

    @Transactional
    public void syncData(List<Long> cidList) {
        ArrayList<MicroCompanyRiskExposeEvaluate> evaluateList = new ArrayList<MicroCompanyRiskExposeEvaluate>();
        List<MicroCompanyRiskExposeEvaluate> unSyncDataList = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getUnSyncData(cidList, "\u672a\u540c\u6b65");
        List<MicroCompanyRiskExposeEvaluate> unSyncDataList2 = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getUnSyncData(cidList, "\u5df2\u540c\u6b65(\u6392\u9664\u5df2\u5ba1\u6838)");
        if (CollectionUtils.isNotEmpty(unSyncDataList2)) {
            List<Long> unSyncDataIdList2 = unSyncDataList2.stream().filter(Objects::nonNull).map(BaseEntity::getId).toList();
            this.exposeEvaluateDataService.remove((Wrapper)new LambdaUpdateWrapper().in(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, unSyncDataIdList2));
            this.removeByIds(unSyncDataIdList2);
        }
        evaluateList.addAll(unSyncDataList);
        evaluateList.addAll(unSyncDataList2);
        evaluateList.stream().filter(Objects::nonNull).forEach(item -> {
            item.setReportStatus(Integer.valueOf(2));
            item.setUpdateDate(item.getCreateDate());
            item.setUpdateBy(item.getCreateBy());
        });
        if (CollectionUtils.isEmpty(evaluateList)) {
            return;
        }
        this.saveBatch(evaluateList);
        List<Long> riskIdList = evaluateList.stream().filter(Objects::nonNull).map(BaseEntity::getId).toList();
        List oldEvaluateDataList = ((LambdaQueryChainWrapper)this.oldExposeEvaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, riskIdList)).list();
        if (CollectionUtils.isNotEmpty((Collection)oldEvaluateDataList)) {
            List evaluateDataList = oldEvaluateDataList.stream().map(detail -> {
                MicroCompanyRiskExposeEvaluateData newDetail = new MicroCompanyRiskExposeEvaluateData();
                BeanUtils.copyProperties((Object)detail, (Object)newDetail);
                return newDetail;
            }).collect(Collectors.toList());
            this.exposeEvaluateDataService.saveBatch(evaluateDataList);
        }
        unSyncDataList.forEach(obj -> ((MicroCompanyRiskExposeEvaluateMapper)this.dao).addLog(this.idworker.nextId(), obj.getId(), WorkOperateLogEnum.ycqInvestigationRiskAssessment.getTypeVal(), null, obj.getOrgId(), obj.getOrgName(), WorkOperateLogStatusEnum.report.getVal(), obj.getOrgName(), obj.getCreateDate()));
    }

    public List<MicroCompanyRiskExposeEvaluate> getInfoList(List<Long> riskId) {
        return ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getInfoList(riskId);
    }

    public Integer getIsFangSheRiskInfoComplete(Long riskId, Long cid) {
        if (riskId == null || cid == null) {
            return null;
        }
        Integer fangShe = ((MicroCompanyRiskExposeEvaluateMapper)this.dao).getRiskDataCountByIfFangShe(riskId, true);
        Integer noFangShe = ((MicroCompanyRiskExposeEvaluateMapper)this.dao).getRiskDataCountByIfFangShe(riskId, false);
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company == null) {
            return -1;
        }
        if (company.getIsExistRadioactivity().booleanValue()) {
            if (fangShe > 0 && noFangShe == 0) {
                Integer before = ((MicroCompanyRiskExposeEvaluateMapper)this.dao).getLastReportInfoByIfFangShe(cid, false);
                if (before == 0) {
                    return 0;
                }
                return 1;
            }
            if (fangShe == 0) {
                return 2;
            }
            return 4;
        }
        if (noFangShe == 0) {
            return 3;
        }
        return 4;
    }

    public MicroCompanyRiskDecisionVo queryTouchNumAndLevel(Long evId) {
        MicroCompanyRiskExposeEvaluate ev = (MicroCompanyRiskExposeEvaluate)this.getById(evId);
        if (ev == null) {
            return null;
        }
        if (ev.getType().equals(1)) {
            return this.stateByCheckPoint(ev);
        }
        return this.statByWorkName(ev);
    }

    private MicroCompanyRiskDecisionVo stateByCheckPoint(MicroCompanyRiskExposeEvaluate ev) {
        return this.doStateRiskDecisionVo(ev);
    }

    private MicroCompanyRiskDecisionVo statByWorkName(MicroCompanyRiskExposeEvaluate ev) {
        return this.doStateRiskDecisionVo(ev);
    }

    private MicroCompanyRiskDecisionVo doStateRiskDecisionVo(MicroCompanyRiskExposeEvaluate ev) {
        MicroCompanyRiskDecisionVo vo = new MicroCompanyRiskDecisionVo();
        List<MicroCompanyRiskExposeEvaluateData> list = this.exposeEvaluateDataService.queryByEvId(ev.getId());
        list = this.removeDuplicateDust(list);
        list = this.removeDuplicateCount(list);
        HashMap<String, Map> map = new HashMap<String, Map>();
        for (MicroCompanyRiskExposeEvaluateData microCompanyRiskExposeEvaluateData : list) {
            Integer checkTouchLevel;
            Integer nature;
            Integer workNum = microCompanyRiskExposeEvaluateData.getWorkNum();
            if (workNum == null || microCompanyRiskExposeEvaluateData.getFactorNature() == null || microCompanyRiskExposeEvaluateData.getTouchLevel() == null) continue;
            String workName = microCompanyRiskExposeEvaluateData.getWorkName();
            String checkPoint = microCompanyRiskExposeEvaluateData.getCheckPoint();
            String factorId = microCompanyRiskExposeEvaluateData.getFactorId() == null ? "0" : microCompanyRiskExposeEvaluateData.getFactorId();
            String key = workName + factorId;
            if (ev.getType().equals(1)) {
                key = checkPoint + factorId;
            }
            if (key == null || key.isEmpty()) continue;
            Map workNameMap = map.computeIfAbsent(key, k -> new HashMap());
            Map natureMap = workNameMap.computeIfAbsent(nature = microCompanyRiskExposeEvaluateData.getFactorNature(), k -> new HashMap());
            Integer userNum = (Integer)natureMap.get(checkTouchLevel = microCompanyRiskExposeEvaluateData.getCheckTouchLevel());
            if (userNum != null) {
                natureMap.put(checkTouchLevel, userNum + workNum);
                continue;
            }
            natureMap.put(checkTouchLevel, microCompanyRiskExposeEvaluateData.getWorkNum());
        }
        for (Map.Entry entry : map.entrySet()) {
            Map value = (Map)entry.getValue();
            for (Map.Entry natureEntry : value.entrySet()) {
                Integer nature = (Integer)natureEntry.getKey();
                Map touchLevelNum = (Map)natureEntry.getValue();
                if (nature.equals(1)) {
                    vo.setGeneralOverStaffCount(Integer.valueOf(vo.getGeneralOverStaffCount() + (touchLevelNum.get(1) == null ? 0 : (Integer)touchLevelNum.get(1))));
                    vo.setGeneralNotOverStaffCount(Integer.valueOf(vo.getGeneralNotOverStaffCount() + (touchLevelNum.get(2) == null ? 0 : (Integer)touchLevelNum.get(2))));
                    continue;
                }
                vo.setSeriousOverStaffCount(Integer.valueOf(vo.getSeriousOverStaffCount() + (touchLevelNum.get(1) == null ? 0 : (Integer)touchLevelNum.get(1))));
                vo.setSeriousNotOverStaffCount(Integer.valueOf(vo.getSeriousNotOverStaffCount() + (touchLevelNum.get(2) == null ? 0 : (Integer)touchLevelNum.get(2))));
            }
        }
        this.setRiskLevel(vo, ev);
        return vo;
    }

    private List<MicroCompanyRiskExposeEvaluateData> removeDuplicateDust(List<MicroCompanyRiskExposeEvaluateData> list) {
        HashMap<CallSite, MicroCompanyRiskExposeEvaluateData> dustMap = new HashMap<CallSite, MicroCompanyRiskExposeEvaluateData>();
        ArrayList<MicroCompanyRiskExposeEvaluateData> newList = new ArrayList<MicroCompanyRiskExposeEvaluateData>();
        for (MicroCompanyRiskExposeEvaluateData ev : list) {
            if (ev.getFactorId() != null && ev.getWorkshop() != null && ev.getWorkName() != null) {
                String key = ev.getFactorId() + "-" + ev.getWorkshop() + "-" + ev.getWorkName();
                MicroCompanyRiskExposeEvaluateData ev1 = (MicroCompanyRiskExposeEvaluateData)dustMap.get(key);
                if (ev1 == null) {
                    dustMap.put((CallSite)((Object)key), ev);
                    continue;
                }
                if (ev.getWorkNum() != null && ev1.getWorkNum() != null && ev.getWorkNum() > ev1.getWorkNum()) {
                    ev1.setWorkNum(ev.getWorkNum());
                }
                if (ev.getWorkNum() == null) {
                    ev1.setWorkNum(ev.getWorkNum());
                }
                if (ev.getCheckTouchLevel() != null && ev.getCheckTouchLevel() == 1) {
                    ev1.setCheckTouchLevel(ev.getCheckTouchLevel());
                }
                dustMap.put((CallSite)((Object)key), ev1);
                continue;
            }
            newList.add(ev);
        }
        ArrayList dustList = new ArrayList(dustMap.values());
        if (dustList.size() > 0) {
            newList.addAll(dustList);
        }
        return newList;
    }

    private List<MicroCompanyRiskExposeEvaluateData> removeDuplicateCount(List<MicroCompanyRiskExposeEvaluateData> list) {
        HashMap<CallSite, MicroCompanyRiskExposeEvaluateData> dustMap = new HashMap<CallSite, MicroCompanyRiskExposeEvaluateData>();
        ArrayList<MicroCompanyRiskExposeEvaluateData> newList = new ArrayList<MicroCompanyRiskExposeEvaluateData>();
        for (MicroCompanyRiskExposeEvaluateData ev : list) {
            if (ev.getWorkshop() != null && ev.getWorkName() != null && ev.getWorkNum() != null && ev.getFactorNature() != null && ev.getCheckTouchLevel() != null) {
                String key = ev.getWorkshop() + "-" + ev.getWorkName() + "-" + ev.getWorkNum() + "-" + ev.getFactorNature() + "-" + ev.getCheckTouchLevel();
                dustMap.putIfAbsent((CallSite)((Object)key), ev);
                continue;
            }
            newList.add(ev);
        }
        ArrayList dustList = new ArrayList(dustMap.values());
        if (dustList.size() > 0) {
            newList.addAll(dustList);
        }
        return newList;
    }

    private void setRiskLevel(MicroCompanyRiskDecisionVo vo, MicroCompanyRiskExposeEvaluate ev) {
        HazardsExposureRiskLevelVo level = new HazardsExposureRiskLevelVo();
        Date newRiskLevelDate = DateUtils.parseDate((Object)"2022-11-28 00:00:00");
        level = DateUtils.compareDate((Date)DateUtils.localDateTimeToDate((LocalDateTime)ev.getDataUpdateDate()), (Date)newRiskLevelDate) < 0L ? HazardsExposureRiskLevelEnum.getFinalThisEnumByStaffCountOld((int)vo.getGeneralOverStaffCount(), (int)vo.getGeneralNotOverStaffCount(), (int)vo.getSeriousOverStaffCount(), (int)vo.getSeriousNotOverStaffCount()) : HazardsExposureRiskLevelEnum.getFinalThisEnumByStaffCountNew((int)vo.getGeneralOverStaffCount(), (int)vo.getGeneralNotOverStaffCount(), (int)vo.getSeriousOverStaffCount(), (int)vo.getSeriousNotOverStaffCount());
        vo.setRiskLevel(level.getRiskLevel());
        vo.setGeneralNotOverRiskLevel(level.getGeneralNotOverRiskLevel());
        vo.setGeneralOverRiskLevel(level.getGeneralOverRiskLevel());
        vo.setSeriousNotOverRiskLevel(level.getSeriousNotOverRiskLevel());
        vo.setSeriousOverRiskLevel(level.getSeriousOverRiskLevel());
    }

    @Transactional(readOnly=false)
    public MicroCompanyRiskExposeEvaluate getLatestEv(Long cid, Integer year, Integer reportStatus) {
        MicroCompanyRiskExposeEvaluate riskExposeEvaluate = null;
        ArrayList<Integer> yearsOut = new ArrayList<Integer>();
        if (year == null) {
            int currYear = LocalDateTime.now().getYear();
            yearsOut.addAll(Arrays.asList(currYear - 3, currYear - 2, currYear - 1, currYear));
        } else {
            yearsOut.add(year);
        }
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company.getIsExistRadioactivity().booleanValue()) {
            riskExposeEvaluate = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, yearsOut, null, reportStatus);
            if (riskExposeEvaluate == null) {
                return riskExposeEvaluate;
            }
            ArrayList<Integer> yearsIn = new ArrayList<Integer>(Arrays.asList(riskExposeEvaluate.getCheckDate().getYear() - 2, riskExposeEvaluate.getCheckDate().getYear() - 1, riskExposeEvaluate.getCheckDate().getYear()));
            if (StringUtils.isEmpty((CharSequence)riskExposeEvaluate.getRedundantSourceTablesIds())) {
                MicroCompanyRiskExposeEvaluate temp = this.mergerAdiationAndWandaRisk2(cid, null, yearsIn, reportStatus);
                if (temp != null) {
                    riskExposeEvaluate = temp;
                }
            } else {
                riskExposeEvaluate = this.mergerAdiationAndWandaRisk2(cid, riskExposeEvaluate.getId(), yearsIn, reportStatus);
            }
        } else {
            riskExposeEvaluate = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, yearsOut, null, reportStatus);
        }
        return riskExposeEvaluate;
    }

    @Transactional(readOnly=false)
    public MicroCompanyRiskExposeEvaluate getLatestNeedReportEv(Long cid) {
        MicroCompanyRiskExposeEvaluate riskExposeEvaluate = null;
        int currYear = LocalDateTime.now().getYear();
        ArrayList<Integer> yearsOut = new ArrayList<Integer>(Arrays.asList(currYear - 3, currYear - 2, currYear - 1, currYear));
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company.getIsExistRadioactivity().booleanValue()) {
            riskExposeEvaluate = this.getLatestNeedReportEvByType(cid, null, yearsOut);
            if (riskExposeEvaluate == null) {
                return riskExposeEvaluate;
            }
            ArrayList<Integer> yearsIn = new ArrayList<Integer>(Arrays.asList(riskExposeEvaluate.getCheckDate().getYear() - 2, riskExposeEvaluate.getCheckDate().getYear() - 1, riskExposeEvaluate.getCheckDate().getYear()));
            if (StringUtils.isEmpty((CharSequence)riskExposeEvaluate.getRedundantSourceTablesIds())) {
                MicroCompanyRiskExposeEvaluate temp = this.mergerAdiationAndWandaRisk(cid, null, yearsIn);
                if (temp != null) {
                    riskExposeEvaluate = temp;
                }
            } else {
                riskExposeEvaluate = this.mergerAdiationAndWandaRisk(cid, riskExposeEvaluate.getId(), yearsIn);
            }
        } else {
            riskExposeEvaluate = this.getLatestNeedReportEvByType(cid, null, yearsOut);
        }
        return riskExposeEvaluate;
    }

    public MicroCompanyRiskExposeEvaluate getLatestNeedReportEvByType(Long cid, Integer type, List<Integer> years) {
        MicroCompanyRiskExposeEvaluate finalData = null;
        MicroCompanyRiskExposeEvaluate completeStatus = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, years, type, 4);
        MicroCompanyRiskExposeEvaluate reportStatus = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, years, type, 2);
        if (completeStatus == null) {
            finalData = reportStatus;
        } else {
            if (reportStatus == null) {
                return null;
            }
            if (reportStatus.getCheckDate() != null && reportStatus.getCheckDate().isAfter(completeStatus.getCheckDate()) || reportStatus.getCheckDate() != null && reportStatus.getCheckDate().isEqual(completeStatus.getCheckDate()) && completeStatus.getUpdateDate() == null || reportStatus.getCheckDate() != null && reportStatus.getCheckDate().isEqual(completeStatus.getCheckDate()) && reportStatus.getCreateDate() != null && reportStatus.getCreateDate().isAfter(completeStatus.getUpdateDate())) {
                finalData = reportStatus;
            }
        }
        return finalData;
    }

    public PageInfo<MicroCompanyRiskExposeEvaluateVo> queryPage(MicroCompanyEvQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<MicroCompanyRiskExposeEvaluateVo> list = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).queryPage(param);
        return new PageInfo(list);
    }

    public List<Long> getRedundantSourceTablesIdsIsNotNullByCid(Long cid) {
        ArrayList mergerRiskTableIdList = new ArrayList();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MicroCompanyRiskExposeEvaluate::getCid, (Object)cid)).isNotNull(MicroCompanyRiskExposeEvaluate::getRedundantSourceTablesIds)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (MicroCompanyRiskExposeEvaluate evaluate : list) {
                String[] split = evaluate.getRedundantSourceTablesIds().split(",");
                if (split.length <= 0) continue;
                List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                mergerRiskTableIdList.addAll(collect);
            }
            List<Long> collect = mergerRiskTableIdList.stream().distinct().collect(Collectors.toList());
            return collect;
        }
        return Collections.emptyList();
    }

    public List<MicroCompanyRiskExposeEvaluate> listRiskEvaluateLasted(Date beginDate, Date endDate, List<Long> cids) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BaseEntity::getIsValid, (Object)true);
        Long totol = 1000L;
        if (CollectionUtils.isNotEmpty(cids)) {
            cids = cids.stream().filter(cid -> Objects.nonNull(cid)).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(cids)) {
            queryWrapper.in(MicroCompanyRiskExposeEvaluate::getCid, cids);
        } else {
            totol = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        }
        return ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).listRiskEvaluateLasted(beginDate, endDate, cids, totol);
    }

    public Map<Long, MicroCompanyRiskExposeEvaluate> queryByIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new HashMap<Long, MicroCompanyRiskExposeEvaluate>();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).in(BaseEntity::getId, ids);
        List list = this.list((Wrapper)wrapper);
        HashMap<Long, MicroCompanyRiskExposeEvaluate> map = new HashMap<Long, MicroCompanyRiskExposeEvaluate>();
        for (MicroCompanyRiskExposeEvaluate evaluate : list) {
            map.put(evaluate.getId(), evaluate);
        }
        return map;
    }

    public MicroCompanyRiskExposeEvaluate mergerAdiationAndWandaRisk(Long cid, Long riskId, List<Integer> years) {
        final MicroCompanyRiskExposeEvaluate riskMaster = new MicroCompanyRiskExposeEvaluate();
        ArrayList riskData = new ArrayList();
        Object redundantSourceTablesIds = "";
        LocalDateTime maxCreateDate = null;
        LocalDateTime maxUpdateDate = null;
        LocalDateTime maxCheckDate = null;
        Integer reportStatus = null;
        MicroCompanyRiskExposeEvaluate latestWandaEv = this.getLatestNeedReportEvByType(cid, 1, years);
        if (latestWandaEv != null) {
            redundantSourceTablesIds = latestWandaEv.getId().toString() + ",";
            maxCreateDate = latestWandaEv.getCreateDate();
            maxUpdateDate = latestWandaEv.getUpdateDate();
            maxCheckDate = latestWandaEv.getCheckDate();
            reportStatus = latestWandaEv.getReportStatus();
            BeanUtils.copyProperties((Object)latestWandaEv, (Object)riskMaster);
            List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{latestWandaEv.getId()})).list();
            riskData.addAll(list);
        }
        if (latestWandaEv == null) {
            return null;
        }
        MicroCompanyRiskExposeEvaluate latestFangSheEv = this.getLatestNeedReportEvByType(cid, 2, years);
        if (latestFangSheEv != null) {
            redundantSourceTablesIds = (String)redundantSourceTablesIds + latestFangSheEv.getId().toString();
            if (maxCreateDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u521b\u5efa\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getCreateDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u521b\u5efa\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxCreateDate.isBefore(latestFangSheEv.getCreateDate())) {
                maxCreateDate = latestFangSheEv.getCreateDate();
            }
            if (maxUpdateDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u4fee\u6539\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getUpdateDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u4fee\u6539\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxUpdateDate.isBefore(latestFangSheEv.getUpdateDate())) {
                maxUpdateDate = latestFangSheEv.getUpdateDate();
            }
            if (maxCheckDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u68c0\u6d4b\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getCheckDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u68c0\u6d4b\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxCheckDate.isBefore(latestFangSheEv.getCheckDate())) {
                maxCheckDate = latestFangSheEv.getCheckDate();
            }
            if (reportStatus == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u72b6\u6001,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getReportStatus() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u72b6\u6001,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (!reportStatus.equals(latestFangSheEv.getReportStatus())) {
                reportStatus = 2;
            }
            BeanUtils.copyProperties((Object)latestFangSheEv, (Object)riskMaster);
            List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{latestFangSheEv.getId()})).list();
            riskData.addAll(list);
        }
        if (latestFangSheEv == null) {
            return null;
        }
        Integer ifFangShe = ((MicroCompanyRiskExposeEvaluateMapper)this.dao).getRiskDataCountByIfFangShe(latestFangSheEv.getId(), true);
        if (ifFangShe == 0) {
            return null;
        }
        riskMaster.setId(Long.valueOf(this.idworker.nextId()));
        if (riskId != null) {
            riskMaster.setId(riskId);
        }
        riskMaster.setRedundantSourceTablesIds((String)redundantSourceTablesIds);
        riskMaster.setCreateDate(maxCreateDate.plusMinutes(1L));
        riskMaster.setUpdateDate(maxUpdateDate.plusMinutes(1L));
        riskMaster.setCheckDate(maxCheckDate);
        riskMaster.setReportStatus(reportStatus);
        riskMaster.setFlag(Integer.valueOf(0));
        this.saveOrUpdate(riskMaster);
        if (riskId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{riskId});
            this.exposeEvaluateDataService.remove((Wrapper)queryWrapper);
        }
        for (MicroCompanyRiskExposeEvaluateData riskExposeEvaluateData : riskData) {
            riskExposeEvaluateData.setId(Long.valueOf(this.idworker.nextId()));
            riskExposeEvaluateData.setRiskExposeEvaluateId(riskMaster.getId());
        }
        Map collect = riskData.parallelStream().filter(Objects::nonNull).collect(Collectors.toMap(v -> v.getWorkshop() + v.getWorkName() + v.getWorkNum() + v.getCheckPoint() + v.getFactorId(), Function.identity(), (v1, v2) -> v2));
        this.exposeEvaluateDataService.saveBatch(collect.values());
        new Thread(new Runnable(){

            @Override
            public void run() {
                MicroCompanyRiskExposeEvaluateServiceImpl.this.updateRiskLevel(riskMaster.getId());
            }
        }).start();
        return riskMaster;
    }

    public void updateRiskLevel(Long evId) {
        MicroCompanyRiskExposeEvaluate evaluate = (MicroCompanyRiskExposeEvaluate)this.get(evId);
        MicroCompanyRiskDecisionVo riskDecisionVo = this.queryTouchNumAndLevel(evId);
        if (riskDecisionVo != null) {
            String riskLevel = riskDecisionVo.getRiskLevel();
            if ("\u2160\u7ea7".equals(riskLevel)) {
                evaluate.setRiskLevel(Integer.valueOf(1));
            } else if ("\u2161\u7ea7".equals(riskLevel)) {
                evaluate.setRiskLevel(Integer.valueOf(2));
            } else if ("\u2162\u7ea7".equals(riskLevel)) {
                evaluate.setRiskLevel(Integer.valueOf(3));
            }
            this.updateById(evaluate);
        }
    }

    public MicroCompanyRiskExposeEvaluate mergerAdiationAndWandaRisk2(Long cid, Long riskId, List<Integer> years, Integer reportStatus) {
        final MicroCompanyRiskExposeEvaluate riskMaster = new MicroCompanyRiskExposeEvaluate();
        ArrayList riskData = new ArrayList();
        Object redundantSourceTablesIds = "";
        LocalDateTime maxCreateDate = null;
        LocalDateTime maxUpdateDate = null;
        LocalDateTime maxCheckDate = null;
        MicroCompanyRiskExposeEvaluate latestWandaEv = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, years, 1, reportStatus);
        if (latestWandaEv != null) {
            redundantSourceTablesIds = latestWandaEv.getId().toString() + ",";
            maxCreateDate = latestWandaEv.getCreateDate();
            maxUpdateDate = latestWandaEv.getUpdateDate();
            maxCheckDate = latestWandaEv.getCheckDate();
            BeanUtils.copyProperties((Object)latestWandaEv, (Object)riskMaster);
            List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{latestWandaEv.getId()})).list();
            riskData.addAll(list);
        }
        if (latestWandaEv == null) {
            return null;
        }
        MicroCompanyRiskExposeEvaluate latestFangSheEv = ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).getLatestEvByType(cid, years, 2, reportStatus);
        if (latestFangSheEv != null) {
            redundantSourceTablesIds = (String)redundantSourceTablesIds + latestFangSheEv.getId().toString();
            if (maxCreateDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u521b\u5efa\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getCreateDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u521b\u5efa\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxCreateDate.isBefore(latestFangSheEv.getCreateDate())) {
                maxCreateDate = latestFangSheEv.getCreateDate();
            }
            if (maxUpdateDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u4fee\u6539\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getUpdateDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u4fee\u6539\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxUpdateDate.isBefore(latestFangSheEv.getUpdateDate())) {
                maxUpdateDate = latestFangSheEv.getUpdateDate();
            }
            if (maxCheckDate == null) {
                this.logger.error("\u6700\u65b0\u4e07\u8fbe\u6ca1\u6709\u68c0\u6d4b\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestWandaEv.getId());
                return null;
            }
            if (latestFangSheEv.getCheckDate() == null) {
                this.logger.error("\u6700\u65b0\u653e\u5c04\u6ca1\u6709\u68c0\u6d4b\u65f6\u95f4,\u672a\u5408\u5e76\u6570\u636e,\u66b4\u9732id\u4e3a{}", (Object)latestFangSheEv.getId());
                return null;
            }
            if (maxCheckDate.isBefore(latestFangSheEv.getCheckDate())) {
                maxCheckDate = latestFangSheEv.getCheckDate();
            }
            BeanUtils.copyProperties((Object)latestFangSheEv, (Object)riskMaster);
            List list = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().in(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{latestFangSheEv.getId()})).list();
            riskData.addAll(list);
        }
        if (latestFangSheEv == null) {
            return null;
        }
        Integer ifFangShe = ((MicroCompanyRiskExposeEvaluateMapper)this.dao).getRiskDataCountByIfFangShe(latestFangSheEv.getId(), true);
        if (ifFangShe == 0) {
            return null;
        }
        riskMaster.setId(Long.valueOf(this.idworker.nextId()));
        if (riskId != null) {
            riskMaster.setId(riskId);
        }
        riskMaster.setRedundantSourceTablesIds((String)redundantSourceTablesIds);
        riskMaster.setCreateDate(maxCreateDate.plusMinutes(1L));
        riskMaster.setUpdateDate(maxUpdateDate.plusMinutes(1L));
        riskMaster.setCheckDate(maxCheckDate);
        riskMaster.setFlag(Integer.valueOf(0));
        this.saveOrUpdate(riskMaster);
        if (riskId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, new Object[]{riskId});
            this.exposeEvaluateDataService.remove((Wrapper)queryWrapper);
        }
        for (MicroCompanyRiskExposeEvaluateData riskExposeEvaluateData : riskData) {
            riskExposeEvaluateData.setId(Long.valueOf(this.idworker.nextId()));
            riskExposeEvaluateData.setRiskExposeEvaluateId(riskMaster.getId());
        }
        Map collect = riskData.parallelStream().filter(Objects::nonNull).collect(Collectors.toMap(v -> v.getWorkshop() + v.getWorkName() + v.getWorkNum() + v.getCheckPoint() + v.getFactorId(), Function.identity(), (v1, v2) -> v2));
        this.exposeEvaluateDataService.saveBatch(collect.values());
        new Thread(new Runnable(){

            @Override
            public void run() {
                MicroCompanyRiskExposeEvaluateServiceImpl.this.updateRiskLevel(riskMaster.getId());
            }
        }).start();
        return riskMaster;
    }

    @Transactional(readOnly=false)
    public int updateRiskExposeCheckState(Long evId, Integer state, Long userId, String reason, String backType) {
        LocalDateTime now = LocalDateTime.now();
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(MicroCompanyRiskExposeEvaluate::getReportStatus, (Object)state);
        wrapper.ne(MicroCompanyRiskExposeEvaluate::getReportStatus, (Object)state);
        wrapper.set(BaseEntity::getUpdateDate, (Object)now);
        wrapper.set(BaseEntity::getUpdateBy, (Object)userId);
        wrapper.eq(BaseEntity::getId, (Object)evId);
        boolean update = this.update((Wrapper)wrapper);
        MicroCompanyRiskExposeEvaluate oldRisk = (MicroCompanyRiskExposeEvaluate)this.getById(evId);
        if (update) {
            if (state == 3) {
                String[] split;
                if (StringUtils.isEmpty((CharSequence)oldRisk.getRedundantSourceTablesIds()) && StringUtils.isEmpty((CharSequence)oldRisk.getWandaZywsCheckId())) {
                    Long oldRiskId = evId;
                    Long newRiskId = this.idworker.nextId();
                    MicroCompanyRiskExposeEvaluate newRisk = new MicroCompanyRiskExposeEvaluate();
                    BeanUtils.copyProperties((Object)oldRisk, (Object)newRisk);
                    newRisk.setId(newRiskId);
                    newRisk.setFlag(Integer.valueOf(1));
                    newRisk.setSourceId(oldRiskId);
                    oldRisk = new MicroCompanyRiskExposeEvaluate();
                    oldRisk.setId(oldRiskId);
                    oldRisk.setFlag(Integer.valueOf(0));
                    oldRisk.setSourceId(newRiskId);
                    this.save(newRisk);
                    this.updateById(oldRisk);
                    List riskExposeEvaluateDataList = ((LambdaQueryChainWrapper)this.exposeEvaluateDataService.lambdaQuery().eq(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, (Object)oldRiskId)).list();
                    for (MicroCompanyRiskExposeEvaluateData riskExposeEvaluateData : riskExposeEvaluateDataList) {
                        riskExposeEvaluateData.setId(Long.valueOf(this.idworker.nextId()));
                        riskExposeEvaluateData.setRiskExposeEvaluateId(newRiskId);
                    }
                    this.exposeEvaluateDataService.saveBatch((Collection)riskExposeEvaluateDataList);
                }
                if (StringUtils.isNotBlank((CharSequence)oldRisk.getRedundantSourceTablesIds())) {
                    if (StringUtils.isBlank((CharSequence)backType)) {
                        backType = "1,2";
                    }
                    if ((split = oldRisk.getRedundantSourceTablesIds().split(",")).length == 2) {
                        List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                        List evaluateList = this.getByIds(collect);
                        for (MicroCompanyRiskExposeEvaluate riskExposeEvaluate : evaluateList) {
                            boolean bl;
                            LambdaUpdateWrapper updateWrapper;
                            if (riskExposeEvaluate.getWandaZywsCheckId() == null && backType.contains("1")) {
                                updateWrapper = Wrappers.lambdaUpdate();
                                updateWrapper.set(MicroCompanyRiskExposeEvaluate::getReportStatus, (Object)state);
                                updateWrapper.set(BaseEntity::getUpdateDate, (Object)now);
                                updateWrapper.set(BaseEntity::getUpdateBy, (Object)userId);
                                updateWrapper.eq(BaseEntity::getId, (Object)riskExposeEvaluate.getId());
                                updateWrapper.ne(MicroCompanyRiskExposeEvaluate::getReportStatus, (Object)state);
                                bl = this.update((Wrapper)updateWrapper);
                            }
                            if (riskExposeEvaluate.getWandaZywsCheckId() == null || !backType.contains("2")) continue;
                            updateWrapper = Wrappers.lambdaUpdate();
                            updateWrapper.set(MicroCompanyRiskExposeEvaluate::getReportStatus, (Object)state);
                            updateWrapper.set(BaseEntity::getUpdateDate, (Object)now);
                            updateWrapper.set(BaseEntity::getUpdateBy, (Object)userId);
                            updateWrapper.eq(BaseEntity::getId, (Object)riskExposeEvaluate.getId());
                            updateWrapper.ne(MicroCompanyRiskExposeEvaluate::getReportStatus, (Object)state);
                            bl = this.update((Wrapper)updateWrapper);
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)oldRisk.getRedundantSourceTablesIds()) && StringUtils.isNotBlank((CharSequence)backType) && !backType.equals("1,2") && (split = backType.split(",")).length == 1) {
                    LambdaUpdateWrapper wrapper2 = Wrappers.lambdaUpdate();
                    wrapper2.set(MicroCompanyRiskExposeEvaluate::getReportStatus, (Object)state);
                    wrapper2.set(BaseEntity::getUpdateDate, (Object)now.plusMinutes(1L));
                    wrapper2.set(BaseEntity::getUpdateBy, (Object)userId);
                    wrapper2.eq(BaseEntity::getId, (Object)Long.parseLong(split[0]));
                    this.update((Wrapper)wrapper2);
                }
                return 1;
            }
            if (state == 4) {
                if (StringUtils.isNotEmpty((String)oldRisk.getRedundantSourceTablesIds())) {
                    String[] split = oldRisk.getRedundantSourceTablesIds().split(",");
                    if (split.length == 2) {
                        List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                        List evaluateList = this.getByIds(collect);
                        for (MicroCompanyRiskExposeEvaluate riskExposeEvaluate : evaluateList) {
                            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                            updateWrapper.set(MicroCompanyRiskExposeEvaluate::getReportStatus, (Object)state);
                            updateWrapper.set(BaseEntity::getUpdateDate, (Object)now.minusMinutes(1L));
                            updateWrapper.set(BaseEntity::getUpdateBy, (Object)userId);
                            updateWrapper.eq(BaseEntity::getId, (Object)riskExposeEvaluate.getId());
                            boolean bl = this.update((Wrapper)updateWrapper);
                        }
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        return 0;
    }

    public void invalidRiskEv(Long cid, Long evId) {
        if (evId == null) {
            return;
        }
        MicroCompanyRiskExposeEvaluate ev = (MicroCompanyRiskExposeEvaluate)this.get(evId);
        if (ev == null) {
            return;
        }
        if (cid == null) {
            cid = ev.getId();
        }
        ((MicroCompanyRiskExposeEvaluateMapper)this.baseMapper).invalidRiskEv(cid, ev.getCheckDateEnd(), evId);
    }
}

