/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp.riskev;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.riskev.MicroCompanyEvDataStatModel;
import cn.smarthse.services.hfi.api.model.riskev.MicroCompanyEvFactorTouchNum;
import cn.smarthse.services.hfi.api.model.riskev.MicroCompanyQueryPageRiskEvDataParam;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.mapper.riskev.MicroCompanyRiskExposeEvaluateDataMapper;
import cn.smarthse.services.hfi.serviceimp.FactorService;
import cn.smarthse.util.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService(timeout=60000)
public class MicroCompanyRiskExposeEvaluateDataServiceImpl
extends BaseServiceImp<MicroCompanyRiskExposeEvaluateDataMapper, MicroCompanyRiskExposeEvaluateData>
implements IMicroCompanyRiskExposeEvaluateDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicroCompanyRiskExposeEvaluateDataServiceImpl.class);
    @Autowired
    private FactorService factorService;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    public Cache<String, Set<Long>> factoryCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.DAYS).build();

    public void getFactoryCache() {
        this.factoryCache.invalidateAll();
        this.factoryCache.cleanUp();
        this.factoryCache.put((Object)"\u653e\u5c04\u56e0\u7d20", ((MicroCompanyRiskExposeEvaluateDataMapper)this.dao).getFactoryByType("\u653e\u5c04\u56e0\u7d20"));
    }

    public PageInfo<MicroCompanyRiskExposeEvaluateData> queryPageDataList(MicroCompanyQueryPageRiskEvDataParam param) {
        Set fangSheSet;
        if (this.factoryCache.estimatedSize() == 0L) {
            this.getFactoryCache();
        }
        if (CollectionUtils.isEmpty((Collection)(fangSheSet = (Set)this.factoryCache.getIfPresent((Object)"\u653e\u5c04\u56e0\u7d20")))) {
            this.getFactoryCache();
            fangSheSet = (Set)this.factoryCache.getIfPresent((Object)"\u653e\u5c04\u56e0\u7d20");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<MicroCompanyRiskExposeEvaluateData> list = ((MicroCompanyRiskExposeEvaluateDataMapper)this.baseMapper).queryPageDataList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            for (MicroCompanyRiskExposeEvaluateData item : list) {
                if (item == null) continue;
                if (item.getDataSource().equals(2) && StringUtils.isBlank((CharSequence)item.getFactorId())) {
                    item.setFactorAbnormal(Boolean.valueOf(true));
                }
                String factorIds = item.getFactorId();
                Long facId = null;
                if (StringUtils.isNotEmpty((String)factorIds)) {
                    if (!factorIds.contains(",")) {
                        facId = Long.parseLong(factorIds);
                    } else {
                        List facIds = StringUtils.parseToLongList((String)factorIds, (String)",");
                        if (facIds.size() > 0) {
                            facId = (Long)facIds.get(0);
                        }
                    }
                }
                if (facId == null || fangSheSet == null || !fangSheSet.contains(facId)) continue;
                item.setIsFangShe(Boolean.valueOf(true));
            }
        }
        return new PageInfo(list);
    }

    public List<MicroCompanyEvDataStatModel> queryEvDataStat(Long evId) {
        Map<Long, String> factorIdToTypeMap = this.factorService.doGetAllIdAndTypeFactorMap();
        List<MicroCompanyRiskExposeEvaluateData> dataList = this.queryByEvId(evId);
        dataList = this.removeDuplicateCount(dataList);
        MicroCompanyEvDataStatModel model = null;
        HashMap<String, MicroCompanyEvDataStatModel> map = new HashMap<String, MicroCompanyEvDataStatModel>();
        String[] arr = new String[]{"\u7c89\u5c18", "\u5316\u5b66\u56e0\u7d20", "\u7269\u7406\u56e0\u7d20", "\u653e\u5c04\u56e0\u7d20", "\u751f\u7269\u56e0\u7d20"};
        for (String type : arr) {
            model = new MicroCompanyEvDataStatModel();
            model.setFactorType(type);
            map.put(type, model);
        }
        for (MicroCompanyRiskExposeEvaluateData data : dataList) {
            String type;
            MicroCompanyEvDataStatModel evDataStatModel;
            String factorId = data.getFactorId();
            if (factorId == null) continue;
            Object facId = null;
            if (StringUtils.isNotEmpty((String)factorId)) {
                if (!factorId.contains(",")) {
                    facId = Long.parseLong(factorId);
                } else {
                    List facIds = StringUtils.parseToLongList((String)factorId, (String)",");
                    if (facIds != null && facIds.size() > 0) {
                        facId = (Long)facIds.get(0);
                    }
                }
            }
            if ((evDataStatModel = (MicroCompanyEvDataStatModel)map.get(type = factorIdToTypeMap.get(facId))) == null) continue;
            List nums = evDataStatModel.getNums();
            boolean isExist = false;
            for (MicroCompanyEvFactorTouchNum num : nums) {
                if (!data.getFactorId().equals(num.getFactorId()) || !data.getFactorName().equals(num.getFactorName())) continue;
                num.setTouchNum(Integer.valueOf((data.getWorkNum() == null ? 0 : data.getWorkNum()) + (num.getTouchNum() == null ? 0 : num.getTouchNum())));
                isExist = true;
                break;
            }
            if (isExist) continue;
            MicroCompanyEvFactorTouchNum touchNum = new MicroCompanyEvFactorTouchNum();
            touchNum.setFactorId(factorId);
            touchNum.setTouchNum(data.getWorkNum());
            touchNum.setFactorType(type);
            touchNum.setFactorName(data.getFactorName());
            nums.add(touchNum);
        }
        MicroCompanyEvDataStatModel dustModel = (MicroCompanyEvDataStatModel)map.get("\u7c89\u5c18");
        List nums = dustModel.getNums();
        HashMap<String, MicroCompanyEvFactorTouchNum> dustMap = new HashMap<String, MicroCompanyEvFactorTouchNum>();
        for (MicroCompanyEvFactorTouchNum ev : nums) {
            MicroCompanyEvFactorTouchNum ev1 = (MicroCompanyEvFactorTouchNum)dustMap.get(ev.getFactorId());
            if (ev1 == null) {
                if (ev.getFactorId().contains(",")) {
                    ev.setFactorName(ev.getFactorName());
                } else {
                    HarmFactor facName = this.harmFactorService.getThisById(Long.valueOf(Long.parseLong(ev.getFactorId())));
                    ev.setFactorName(facName.getNameCh());
                }
                dustMap.put(ev.getFactorId(), ev);
                continue;
            }
            if (ev.getTouchNum() <= ev1.getTouchNum()) continue;
            ev1.setTouchNum(ev.getTouchNum());
            dustMap.put(ev.getFactorId(), ev1);
        }
        ArrayList newList = new ArrayList(dustMap.values());
        dustModel.setNums(newList);
        map.put("\u7c89\u5c18", dustModel);
        return new ArrayList<MicroCompanyEvDataStatModel>(map.values());
    }

    public List<MicroCompanyRiskExposeEvaluateData> queryByEvId(Long evId) {
        List<MicroCompanyRiskExposeEvaluateData> list = ((MicroCompanyRiskExposeEvaluateDataMapper)this.baseMapper).getListByEvId(evId);
        return list;
    }

    public PageInfo<MicroCompanyRiskExposeEvaluateData> queryPageDataListOrderByLevel(MicroCompanyQueryPageRiskEvDataParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<MicroCompanyRiskExposeEvaluateData> list = ((MicroCompanyRiskExposeEvaluateDataMapper)this.baseMapper).queryPageDataListOrderByLevel(param);
        return new PageInfo(list);
    }

    public boolean isOverQuotaByEvId(Long evId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(MicroCompanyRiskExposeEvaluateData::getRiskExposeEvaluateId, (Object)evId)).eq(BaseEntity::getIsValid, (Object)true)).eq(MicroCompanyRiskExposeEvaluateData::getCheckTouchLevel, (Object)1)).orderByAsc(BaseEntity::getId);
        Long count = ((MicroCompanyRiskExposeEvaluateDataMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        return count != null && count > 0L;
    }

    private List<MicroCompanyRiskExposeEvaluateData> removeDuplicateCount(List<MicroCompanyRiskExposeEvaluateData> list) {
        HashMap<CallSite, MicroCompanyRiskExposeEvaluateData> dustMap = new HashMap<CallSite, MicroCompanyRiskExposeEvaluateData>();
        ArrayList<MicroCompanyRiskExposeEvaluateData> newList = new ArrayList<MicroCompanyRiskExposeEvaluateData>();
        for (MicroCompanyRiskExposeEvaluateData ev : list) {
            if (ev.getWorkshop() != null && ev.getWorkName() != null && ev.getWorkNum() != null && ev.getFactorId() != null) {
                String key = ev.getWorkshop() + "-" + ev.getWorkName() + "-" + ev.getWorkNum() + "-" + ev.getFactorId();
                dustMap.putIfAbsent((CallSite)((Object)key), ev);
                continue;
            }
            newList.add(ev);
        }
        ArrayList dustList = new ArrayList(dustMap.values());
        if (dustList.size() > 0) {
            newList.addAll(dustList);
        }
        return newList;
    }
}

