/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.services.hfi.api.model.BaseStatQueryModel;
import cn.smarthse.services.hfi.api.model.StatComModel;
import cn.smarthse.services.hfi.cache.IndustrialCache;
import cn.smarthse.services.hfi.cache.RegisterTypeCache;
import cn.smarthse.services.hfi.cache.StatComModelCache;
import cn.smarthse.services.hfi.mapper.HarmComCountMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatBaseService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected HarmComCountMapper harmComCountMapper;
    @Autowired
    protected ThreadPoolExecutor threadPoolExecutor;
    @Autowired
    protected RegisterTypeCache registerTypeMap;
    protected static Map<Long, String> scaleMap = new HashMap<Long, String>();
    protected static Map<Long, String> occMap = new HashMap<Long, String>();
    @Autowired
    private StatComModelCache comAreaModelCache;
    protected String[] chemicalTypes = new String[]{"C\u1d1b\u1d21\u1d00", "Cs\u1d1b\u1d07\u029f", "C\u1d0d\u1d00c", "C\u1d0d\u1d07", "Cs\u1d1b\u1d07"};
    protected String[] chemicalTypeIds = new String[]{"3", "4", "5", "6", "7"};
    protected String[] chemicalAttrNames = new String[]{"twa", "stel", "mac", "mac", "stel"};
    @Autowired
    protected IndustrialCache industrialMap;

    protected Map<String, Set<Long>> groupByType(BaseStatQueryModel baseStatQueryModel) {
        switch (baseStatQueryModel.getGroupType()) {
            case 1: {
                return this.group1(baseStatQueryModel);
            }
            case 2: {
                return this.group2(baseStatQueryModel);
            }
            case 3: {
                return this.group3(baseStatQueryModel);
            }
            case 4: {
                return this.group4(baseStatQueryModel);
            }
            case 5: {
                return this.group5(baseStatQueryModel);
            }
        }
        return new HashMap<String, Set<Long>>();
    }

    private Map<String, Set<Long>> group1(BaseStatQueryModel baseStatQueryModel) {
        if (baseStatQueryModel.getAreaLevel() == null || baseStatQueryModel.getAreaLevel().equals((byte)0) || baseStatQueryModel.getAreaLevel() < 0) {
            return this.groupByProvince(baseStatQueryModel);
        }
        if (baseStatQueryModel.getAreaLevel().equals((byte)1)) {
            return this.groupByCity(baseStatQueryModel);
        }
        if (baseStatQueryModel.getAreaLevel().equals((byte)2)) {
            return this.groupByArea(baseStatQueryModel);
        }
        if (baseStatQueryModel.getAreaLevel().equals((byte)3)) {
            return this.groupByStreet(baseStatQueryModel);
        }
        return new HashMap<String, Set<Long>>();
    }

    private Map<String, Set<Long>> groupByProvince(BaseStatQueryModel baseStatQueryModel) {
        long s = System.currentTimeMillis();
        LinkedHashMap<String, Set<Long>> map = new LinkedHashMap<String, Set<Long>>();
        List<StatComModel> list = this.getAllComAreaModel(baseStatQueryModel);
        for (StatComModel comAreaModel : list) {
            Object key = null;
            key = comAreaModel.getProvinceId() == null ? "0-\u672a\u5212\u5206\u533a\u57df" : comAreaModel.getProvinceId() + "-" + comAreaModel.getProvinceName() + "-true";
            Set cIds = map.computeIfAbsent((String)key, k -> new HashSet());
            cIds.add(comAreaModel.getCid());
        }
        this.logger.info("\u6309\u7701\u4efd\u5206\u7ec4\u8017\u65f6:" + (System.currentTimeMillis() - s) / 1000L + "\u79d2");
        return map;
    }

    private Map<String, Set<Long>> groupByCity(BaseStatQueryModel baseStatQueryModel) {
        LinkedHashMap<String, Set<Long>> map = new LinkedHashMap<String, Set<Long>>();
        List<StatComModel> list = this.getAllComAreaModel(baseStatQueryModel);
        for (StatComModel comAreaModel : list) {
            Set cIds;
            Object key = null;
            if (comAreaModel.getBelongType() != null && comAreaModel.getBelongType().equals((byte)1)) {
                key = comAreaModel.getProvinceId() + "-\u7701\u672c\u7ea7";
                cIds = map.computeIfAbsent((String)key, k -> new HashSet());
                cIds.add(comAreaModel.getCid());
                continue;
            }
            key = comAreaModel.getCityId() == null ? "0-\u672a\u5212\u5206\u533a\u57df" : comAreaModel.getCityId() + "-" + comAreaModel.getCityName() + "-true";
            cIds = map.computeIfAbsent((String)key, k -> new HashSet());
            cIds.add(comAreaModel.getCid());
        }
        return map;
    }

    private Map<String, Set<Long>> groupByArea(BaseStatQueryModel baseStatQueryModel) {
        LinkedHashMap<String, Set<Long>> map = new LinkedHashMap<String, Set<Long>>();
        List<StatComModel> list = this.getAllComAreaModel(baseStatQueryModel);
        for (StatComModel comAreaModel : list) {
            Set cIds;
            Object key = null;
            if (comAreaModel.getBelongType() != null && comAreaModel.getBelongType().equals((byte)2)) {
                key = comAreaModel.getCityId() + "-\u5e02\u672c\u7ea7";
                cIds = map.computeIfAbsent((String)key, k -> new HashSet());
                cIds.add(comAreaModel.getCid());
                continue;
            }
            key = comAreaModel.getAreaId() == null ? "0-\u672a\u5212\u5206\u533a\u57df" : comAreaModel.getAreaId() + "-" + comAreaModel.getAreaName() + "-true";
            cIds = map.computeIfAbsent((String)key, k -> new HashSet());
            cIds.add(comAreaModel.getCid());
        }
        return map;
    }

    private Map<String, Set<Long>> groupByStreet(BaseStatQueryModel baseStatQueryModel) {
        LinkedHashMap<String, Set<Long>> map = new LinkedHashMap<String, Set<Long>>();
        List<StatComModel> list = this.getAllComAreaModel(baseStatQueryModel);
        for (StatComModel comAreaModel : list) {
            Object key = null;
            key = comAreaModel.getStreetId() == null ? "0-\u672a\u5212\u5206\u533a\u57df" : comAreaModel.getStreetId() + "-" + comAreaModel.getStreetName() + "-false";
            Set cIds = map.computeIfAbsent((String)key, k -> new HashSet());
            cIds.add(comAreaModel.getCid());
        }
        return map;
    }

    private Map<String, Set<Long>> group2(BaseStatQueryModel baseStatQueryModel) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        String registerTypeName = null;
        List<StatComModel> list = this.getAllComAreaModel(baseStatQueryModel);
        for (StatComModel model : list) {
            Object key = null;
            key = model.getRegisterType() == null || (registerTypeName = this.registerTypeMap.get(model.getRegisterType())) == null ? "0-\u65e0\u7ecf\u6d4e\u7c7b\u578b" : model.getRegisterType() + "-" + registerTypeName;
            Set cIds = map.computeIfAbsent((String)key, k -> new HashSet());
            cIds.add(model.getCid());
        }
        return map;
    }

    private Map<String, Set<Long>> group3(BaseStatQueryModel baseStatQueryModel) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        String name = null;
        List<StatComModel> list = this.getAllComAreaModel(baseStatQueryModel);
        for (StatComModel model : list) {
            Object key = null;
            key = model.getIndustryCategory() == null || (name = this.industrialMap.get(model.getIndustryCategory())) == null ? "0-\u65e0\u884c\u4e1a\u7c7b\u522b" : model.getIndustryCategory() + "-" + name;
            Set cIds = map.computeIfAbsent((String)key, k -> new HashSet());
            cIds.add(model.getCid());
        }
        return map;
    }

    private Map<String, Set<Long>> group4(BaseStatQueryModel baseStatQueryModel) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        String name = null;
        List<StatComModel> list = this.getAllComAreaModel(baseStatQueryModel);
        for (StatComModel model : list) {
            Object key = null;
            key = model.getCompanyType() == null || (name = scaleMap.get(model.getCompanyType())) == null ? "0-\u65e0\u4f01\u4e1a\u89c4\u6a21" : model.getCompanyType() + "-" + name;
            Set cIds = map.computeIfAbsent((String)key, k -> new HashSet());
            cIds.add(model.getCid());
        }
        return map;
    }

    private Map<String, Set<Long>> group5(BaseStatQueryModel baseStatQueryModel) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        String name = null;
        List<StatComModel> list = this.getAllComAreaModel(baseStatQueryModel);
        for (StatComModel model : list) {
            Object key = null;
            key = model.getOccupationalRiskClassify() == null || (name = occMap.get(model.getOccupationalRiskClassify())) == null ? "0-\u65e0\u98ce\u9669\u5206\u7c7b" : model.getOccupationalRiskClassify() + "-" + name;
            Set cIds = map.computeIfAbsent((String)key, k -> new HashSet());
            cIds.add(model.getCid());
        }
        return map;
    }

    protected List<StatComModel> getAllComAreaModel(BaseStatQueryModel baseStatQueryModel) {
        List<StatComModel> all = this.comAreaModelCache.getAll();
        if (baseStatQueryModel.getAreaLevel() == null || baseStatQueryModel.getAreaLevel().equals((byte)0)) {
            return all;
        }
        LinkedList<StatComModel> rList = new LinkedList<StatComModel>();
        Long areaId = baseStatQueryModel.getAreaId();
        for (StatComModel model : all) {
            Long targetAreaId = this.getTargetAreaId(baseStatQueryModel.getAreaLevel(), model);
            if (!areaId.equals(targetAreaId)) continue;
            rList.add(model);
        }
        return rList;
    }

    private Long getTargetAreaId(byte level, StatComModel model) {
        switch (level) {
            case 1: {
                return model.getProvinceId();
            }
            case 2: {
                return model.getCityId();
            }
            case 3: {
                return model.getAreaId();
            }
            case 4: {
                return model.getStreetId();
            }
        }
        return null;
    }

    static {
        scaleMap.put(1L, "\u5927\u578b\u4f01\u4e1a");
        scaleMap.put(2L, "\u4e2d\u578b\u4f01\u4e1a");
        scaleMap.put(3L, "\u5c0f\u578b\u4f01\u4e1a");
        scaleMap.put(4L, "\u5fae\u578b\u4f01\u4e1a");
        occMap.put(0L, "\u4e25\u91cd");
        occMap.put(1L, "\u8f83\u91cd");
        occMap.put(2L, "\u4e00\u822c");
    }
}

