/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.model.BaseStatQueryModel;
import cn.smarthse.services.hfi.api.model.ChemicalJudgeModel;
import cn.smarthse.services.hfi.api.model.DustJudgeModel;
import cn.smarthse.services.hfi.api.model.HarmStatQueryModel;
import cn.smarthse.services.hfi.api.model.NoiseJudgeModel;
import cn.smarthse.services.hfi.api.pojo.vo.ChemicalHarmComStatVo;
import cn.smarthse.services.hfi.api.pojo.vo.DustHarmComStatVo;
import cn.smarthse.services.hfi.api.pojo.vo.HarmComStatBaseVo;
import cn.smarthse.services.hfi.api.pojo.vo.HarmComTotalCountVo;
import cn.smarthse.services.hfi.api.pojo.vo.NoiseHarmComStatVo;
import cn.smarthse.services.hfi.api.service.IFactorLimitValueService;
import cn.smarthse.services.hfi.api.service.IHarmComCountService;
import cn.smarthse.services.hfi.serviceimp.StatBaseService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class HarmComCountServiceImpl
extends StatBaseService
implements IHarmComCountService {
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    @Autowired
    private IFactorLimitValueService factorLimitValueService;

    public PageInfo<DustHarmComStatVo> dustCount(HarmStatQueryModel harmStatQueryModel) {
        if (harmStatQueryModel.getFilterEmpty() == null) {
            harmStatQueryModel.setFilterEmpty(Boolean.valueOf(true));
        }
        LinkedList<DustHarmComStatVo> list = new LinkedList<DustHarmComStatVo>();
        Map<String, Set<Long>> groupMap = this.groupByType((BaseStatQueryModel)harmStatQueryModel);
        List factors = this.harmFactorService.getOccupationalRiskFactors("\u7c89\u5c18", null, null);
        long s = System.currentTimeMillis();
        List<DustJudgeModel> dustJudgeModels = this.harmComCountMapper.getDustJudgeModel(harmStatQueryModel);
        long e = System.currentTimeMillis();
        this.logger.info("\u67e5\u8be2\u68c0\u6d4b\u7ed3\u679c\u83b7\u53d6\u5371\u5bb3\u56e0\u7d20\u603b\u5c18\u548c\u547c\u5c18,\u8017\u65f6:" + (e - s) / 1000L + "\u79d2");
        for (Map.Entry<String, Set<Long>> groupEntry : groupMap.entrySet()) {
            for (HarmFactor factor : factors) {
                if (!this.matchSearchKey(factor, harmStatQueryModel)) continue;
                DustHarmComStatVo vo1 = new DustHarmComStatVo();
                String key = groupEntry.getKey();
                String[] keys = key.split("-");
                vo1.setGroupKey(keys[0]);
                vo1.setGroupName(keys[1]);
                vo1.setHarmId("" + factor.getId());
                vo1.setHarmName(factor.getNameCh());
                vo1.setDustType("\u603b\u5c18");
                DustHarmComStatVo vo2 = new DustHarmComStatVo();
                vo2.setGroupKey(keys[0]);
                vo2.setGroupName(keys[1]);
                vo2.setHarmId("" + factor.getId());
                vo2.setHarmName(factor.getNameCh());
                vo2.setDustType("\u547c\u5c18");
                boolean isFind = false;
                for (DustJudgeModel dustJudgeModel : dustJudgeModels) {
                    Long cid = dustJudgeModel.getCid();
                    Long factorId = this.parseFactorId(dustJudgeModel.getFactorId());
                    if (!groupEntry.getValue().contains(cid) || !factor.getId().equals(factorId)) continue;
                    isFind = true;
                    vo1.getAllCids().add(dustJudgeModel.getCid());
                    vo2.getAllCids().add(dustJudgeModel.getCid());
                    if (dustJudgeModel.getDustType().equals("17") && dustJudgeModel.getJudge() != null) {
                        if (dustJudgeModel.getJudge().contains("3")) {
                            vo1.getOverProofCountCids().add(cid);
                        } else {
                            vo1.getNoOverProofCountCids().add(cid);
                        }
                    }
                    if (!dustJudgeModel.getDustType().equals("22") || dustJudgeModel.getJudge() == null) continue;
                    if (dustJudgeModel.getJudge().contains("3")) {
                        vo2.getOverProofCountCids().add(cid);
                        continue;
                    }
                    vo2.getNoOverProofCountCids().add(cid);
                }
                if (harmStatQueryModel.getFilterEmpty() != null && harmStatQueryModel.getFilterEmpty().booleanValue() && !isFind) continue;
                list.add(vo1);
                list.add(vo2);
            }
        }
        long e2 = System.currentTimeMillis();
        this.logger.info("\u5c06\u7c89\u5c18\u5371\u5bb3\u5371\u5bb3\u56e0\u7d20\u6dfb\u52a0\u5230\u6bcf\u4e2a\u5206\u7ec4\u4e2d,\u8017\u65f6:" + (e2 - e) / 1000L + "\u79d2");
        this.sortList(list, harmStatQueryModel);
        return PageUtil.getPageInfo(list, (int)harmStatQueryModel.getPage(), (int)harmStatQueryModel.getRows());
    }

    private void sortList(List<? extends HarmComStatBaseVo> list, HarmStatQueryModel harmStatQueryModel) {
        list.sort((o1, o2) -> {
            if (harmStatQueryModel.getGroupType().equals(1)) {
                if (o1.getGroupName().contains("\u672c\u7ea7") || o1.getGroupKey().equals("0")) {
                    return -1;
                }
                if (o2.getGroupName().contains("\u672c\u7ea7") || o2.getGroupKey().equals("0")) {
                    return 1;
                }
            }
            return o2.getTotalCount() - o1.getTotalCount();
        });
    }

    public PageInfo<ChemicalHarmComStatVo> chemicalCount(HarmStatQueryModel harmStatQueryModel) {
        if (harmStatQueryModel.getFilterEmpty() == null) {
            harmStatQueryModel.setFilterEmpty(Boolean.valueOf(true));
        }
        LinkedList<Object> list = new LinkedList<Object>();
        Map<String, Set<Long>> groupMap = this.groupByType((BaseStatQueryModel)harmStatQueryModel);
        List factors = this.harmFactorService.getOccupationalRiskFactors("\u5316\u5b66\u56e0\u7d20", null, null);
        List<ChemicalJudgeModel> chemicalJudgeModels = this.harmComCountMapper.getChemicalJudgeModel(harmStatQueryModel);
        for (Map.Entry<String, Set<Long>> groupEntry : groupMap.entrySet()) {
            for (HarmFactor factor : factors) {
                if (!this.matchSearchKey(factor, harmStatQueryModel)) continue;
                ArrayList<ChemicalHarmComStatVo> l = new ArrayList<ChemicalHarmComStatVo>(8);
                for (String type : this.chemicalTypes) {
                    ChemicalHarmComStatVo vo1 = new ChemicalHarmComStatVo();
                    String key = groupEntry.getKey();
                    String[] keys = key.split("-");
                    vo1.setGroupKey(keys[0]);
                    vo1.setGroupName(keys[1]);
                    vo1.setHarmId("" + factor.getId());
                    vo1.setHarmName(factor.getNameCh());
                    vo1.setChemicalType(type);
                    vo1.setIsExist(Boolean.valueOf(false));
                    l.add(vo1);
                }
                boolean isFind = false;
                for (ChemicalJudgeModel chemicalJudgeModel : chemicalJudgeModels) {
                    Long cid = chemicalJudgeModel.getCid();
                    Long factorId = this.parseFactorId(chemicalJudgeModel.getFactorId());
                    if (!groupEntry.getValue().contains(cid) || !factor.getId().equals(factorId)) continue;
                    isFind = true;
                    l.forEach(item -> item.getAllCids().add(cid));
                    for (int i = 0; i < this.chemicalTypeIds.length; ++i) {
                        String maxValue;
                        if (!chemicalJudgeModel.getChemicalType().equals(this.chemicalTypeIds[i]) || (maxValue = chemicalJudgeModel.getMaxValue()) == null || maxValue.isEmpty()) continue;
                        ((ChemicalHarmComStatVo)l.get(i)).setIsExist(Boolean.valueOf(true));
                        if (this.isChemicalOverProof(chemicalJudgeModel, chemicalJudgeModel.getChemicalType())) {
                            ((ChemicalHarmComStatVo)l.get(i)).getOverProofCountCids().add(cid);
                            continue;
                        }
                        ((ChemicalHarmComStatVo)l.get(i)).getNoOverProofCountCids().add(cid);
                    }
                }
                if (harmStatQueryModel.getFilterEmpty() != null && harmStatQueryModel.getFilterEmpty().booleanValue() && !isFind) continue;
                if (harmStatQueryModel.getFilterEmpty() != null && harmStatQueryModel.getFilterEmpty().booleanValue()) {
                    for (ChemicalHarmComStatVo vo : l) {
                        if (!vo.getIsExist().booleanValue()) continue;
                        list.add(vo);
                    }
                    continue;
                }
                list.addAll(l);
            }
        }
        this.sortList(list, harmStatQueryModel);
        return PageUtil.getPageInfo(list, (int)harmStatQueryModel.getPage(), (int)harmStatQueryModel.getRows());
    }

    private boolean isChemicalOverProof(ChemicalJudgeModel chemicalJudgeModel, String targetId) {
        try {
            String limitValue = this.factorLimitValueService.getByFactorAndTargetId(Long.valueOf(Long.parseLong(chemicalJudgeModel.getFactorId())), Integer.valueOf(Integer.parseInt(targetId)));
            if (limitValue == null) {
                return false;
            }
            return Double.parseDouble(chemicalJudgeModel.getMaxValue()) > Double.parseDouble(limitValue);
        }
        catch (Exception e) {
            this.logger.error("\u5316\u5b66\u56e0\u7d20\u68c0\u6d4b\u503c\u548c\u9650\u503c\u6bd4\u8f83\u5f02\u5e38::", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    public PageInfo<NoiseHarmComStatVo> noiseCount(HarmStatQueryModel harmStatQueryModel) {
        if (harmStatQueryModel.getFilterEmpty() == null) {
            harmStatQueryModel.setFilterEmpty(Boolean.valueOf(true));
        }
        LinkedList<NoiseHarmComStatVo> list = new LinkedList<NoiseHarmComStatVo>();
        Map<String, Set<Long>> groupMap = this.groupByType((BaseStatQueryModel)harmStatQueryModel);
        List<NoiseJudgeModel> noiseJudgeModels = this.harmComCountMapper.getNoiseJudgeModel(harmStatQueryModel);
        for (Map.Entry<String, Set<Long>> groupEntry : groupMap.entrySet()) {
            NoiseHarmComStatVo vo = new NoiseHarmComStatVo();
            String key = groupEntry.getKey();
            String[] keys = key.split("-");
            vo.setHarmId("567");
            vo.setHarmName("\u566a\u58f0");
            vo.setGroupKey(keys[0]);
            vo.setGroupName(keys[1]);
            boolean isFind = false;
            for (NoiseJudgeModel noiseJudgeModel : noiseJudgeModels) {
                Long cid = noiseJudgeModel.getCid();
                if (!groupEntry.getValue().contains(cid)) continue;
                isFind = true;
                vo.getAllCids().add(noiseJudgeModel.getCid());
                if (noiseJudgeModel.getJudges() != null && noiseJudgeModel.getJudges().contains("3")) {
                    vo.getOverProofCountCids().add(cid);
                    continue;
                }
                vo.getNoOverProofCountCids().add(cid);
            }
            if (harmStatQueryModel.getFilterEmpty() != null && harmStatQueryModel.getFilterEmpty().booleanValue() && !isFind) continue;
            list.add(vo);
        }
        this.sortList(list, harmStatQueryModel);
        return PageUtil.getPageInfo(list, (int)harmStatQueryModel.getPage(), (int)harmStatQueryModel.getRows());
    }

    public HarmComTotalCountVo allDustCount(HarmStatQueryModel harmStatQueryModel) {
        harmStatQueryModel.setPage(Integer.valueOf(1));
        harmStatQueryModel.setRows(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<DustHarmComStatVo> pageInfo = this.dustCount(harmStatQueryModel);
        List list = pageInfo.getList();
        HashSet allCids = new HashSet();
        HashSet overCids = new HashSet();
        for (DustHarmComStatVo vo : list) {
            allCids.addAll(vo.getAllCids());
            overCids.addAll(vo.getOverProofCountCids());
        }
        HarmComTotalCountVo vo = new HarmComTotalCountVo();
        vo.setAllTotalCount(Integer.valueOf(allCids.size()));
        vo.setAllOverProofCount(Integer.valueOf(overCids.size()));
        vo.setAllNoOverProofCount(Integer.valueOf(vo.getAllTotalCount() - vo.getAllOverProofCount()));
        return vo;
    }

    public HarmComTotalCountVo allChemicalCount(HarmStatQueryModel harmStatQueryModel) {
        harmStatQueryModel.setPage(Integer.valueOf(1));
        harmStatQueryModel.setRows(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<ChemicalHarmComStatVo> pageInfo = this.chemicalCount(harmStatQueryModel);
        List list = pageInfo.getList();
        HashSet allCids = new HashSet();
        HashSet overCids = new HashSet();
        for (ChemicalHarmComStatVo vo : list) {
            allCids.addAll(vo.getAllCids());
            overCids.addAll(vo.getOverProofCountCids());
        }
        HarmComTotalCountVo vo = new HarmComTotalCountVo();
        vo.setAllTotalCount(Integer.valueOf(allCids.size()));
        vo.setAllOverProofCount(Integer.valueOf(overCids.size()));
        vo.setAllNoOverProofCount(Integer.valueOf(vo.getAllTotalCount() - vo.getAllOverProofCount()));
        return vo;
    }

    public HarmComTotalCountVo allNoiseCount(HarmStatQueryModel harmStatQueryModel) {
        harmStatQueryModel.setPage(Integer.valueOf(1));
        harmStatQueryModel.setRows(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<NoiseHarmComStatVo> pageInfo = this.noiseCount(harmStatQueryModel);
        List list = pageInfo.getList();
        HashSet allCids = new HashSet();
        HashSet overCids = new HashSet();
        for (NoiseHarmComStatVo vo : list) {
            allCids.addAll(vo.getAllCids());
            overCids.addAll(vo.getOverProofCountCids());
        }
        HarmComTotalCountVo vo = new HarmComTotalCountVo();
        vo.setAllTotalCount(Integer.valueOf(allCids.size()));
        vo.setAllOverProofCount(Integer.valueOf(overCids.size()));
        vo.setAllNoOverProofCount(Integer.valueOf(vo.getAllTotalCount() - vo.getAllOverProofCount()));
        return vo;
    }

    private boolean matchSearchKey(HarmFactor factor, HarmStatQueryModel harmStatQueryModel) {
        if (factor == null || factor.getNameCh() == null) {
            return false;
        }
        if (harmStatQueryModel.getHarmName() != null && !harmStatQueryModel.getHarmName().isEmpty()) {
            return factor.getNameCh().contains(harmStatQueryModel.getHarmName());
        }
        return true;
    }

    private Long parseFactorId(String factorId) {
        try {
            return Long.parseLong(factorId);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }
}

