/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FactorService {
    @Autowired
    private ICheckPlanService checkPlanService;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;

    public Map<String, String> harmIdAndNameMap(Long checkId) {
        if (checkId == null) {
            return this.harmFactorService.getAllIdAndNameMapForCheckPlan();
        }
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkId);
        if (checkPlan == null || checkPlan.getTargetStandardId() == null) {
            return this.harmFactorService.getAllIdAndNameMapForCheckPlan();
        }
        if (checkPlan.getTargetStandardId().equals(1L)) {
            return this.harmFactorService.getAllIdAndNameMapIncludeInValid2007();
        }
        return this.harmFactorService.getAllIdAndNameMapIncludeInValid2019();
    }

    public Map<String, String> getAllIdAndNameMapForCheckPlan() {
        return this.harmFactorService.getAllIdAndNameMapForCheckPlan();
    }

    public Map<String, String> getAllNameAndIdMap2019() {
        return this.harmFactorService.getAllNameAndIdMap2019();
    }

    public Map<String, String> getAllNameAndIdMap2007() {
        return this.harmFactorService.getAllNameAndIdMap2007();
    }

    public Map<String, String> getAllNameAndIdMap2019(Long cid) {
        if (cid == null) {
            return this.getAllNameAndIdMap2019();
        }
        return this.harmFactorService.getAllNameAndIdMap2019(cid);
    }

    public Map<String, String> getAllNameAndIdMap2007(Long cid) {
        if (cid == null) {
            return this.getAllNameAndIdMap2007();
        }
        return this.harmFactorService.getAllNameAndIdMap2007(cid);
    }

    public Map<String, String> getAllNameAndIdMap2019ContailRay(Long cid) {
        if (cid == null) {
            return this.getAllNameAndIdMap2019();
        }
        return this.harmFactorService.getAllNameAndIdMap2019ContailRay(cid);
    }

    public Map<String, String> getAllNameAndIdMap2007ContailRay(Long cid) {
        if (cid == null) {
            return this.getAllNameAndIdMap2007();
        }
        return this.harmFactorService.getAllNameAndIdMap2007ContailRay(cid);
    }

    public String getHarmName(Long checkId, String harmId) {
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkId);
        if (StringUtils.isLong((String)harmId)) {
            HarmFactor h = this.harmFactorService.getThisById(Long.valueOf(Long.parseLong(harmId)));
            if (h == null) {
                return "";
            }
            if (h.getCid() != null) {
                return h.getNameCh();
            }
            if (checkPlan.getTargetStandardId().equals(1L)) {
                return h.getGbz22007Name();
            }
            return h.getGbz22019Name();
        }
        return "";
    }

    public Map<Long, String> getNatureMap() {
        return this.harmFactorService.getFactorNature();
    }

    public Map<Long, String> doGetAllIdAndTypeMap() {
        return this.harmFactorService.doGetAllIdAndTypeMap();
    }

    public Map<Long, String> doGetAllIdAndTypeFactorMap() {
        return this.harmFactorService.doGetAllIdAndTypeFactorMap();
    }

    public Map<String, String> getHarmTypeByIds(String ids) {
        List harmByIds = this.harmFactorService.getHarmByIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)harmByIds)) {
            Map<String, String> collect = harmByIds.stream().collect(Collectors.toMap(k -> "" + k.getId(), v -> v.getType()));
            return collect;
        }
        return new HashMap<String, String>();
    }
}

