/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.modules.datacentre.model.system.riskFactors.FactorLimitValue;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.model.system.riskFactors.OccupationalRiskAttrModel;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IOccupationalRiskAttrProvideService;
import cn.smarthse.services.hfi.api.service.IFactorLimitValueService;
import cn.smarthse.util.common.StringUtils;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class FactorLimitValueServiceImpl
implements IFactorLimitValueService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference(timeout=60000)
    private IOccupationalRiskAttrProvideService provideService;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    private Map<Long, List<OccupationalRiskAttrModel>> factorIdToOccupationalRiskAttrModelMap = new HashMap<Long, List<OccupationalRiskAttrModel>>();

    @PostConstruct
    public void init() {
        this.logger.info("\u83b7\u53d6\u6240\u6709\u5371\u5bb3\u56e0\u7d20\u9650\u503c...");
        this.refreshCache();
        this.logger.info("\u83b7\u53d6\u6240\u6709\u5371\u5bb3\u56e0\u7d20\u9650\u503c\u5b8c\u6210");
    }

    public String getByFactorAndTargetId(Long factorId, Integer targetId) {
        List<OccupationalRiskAttrModel> models;
        if (this.factorIdToOccupationalRiskAttrModelMap.isEmpty()) {
            this.refreshCache();
        }
        if ((models = this.factorIdToOccupationalRiskAttrModelMap.get(factorId)) == null || models.isEmpty()) {
            return null;
        }
        return this.parseLimitValue(targetId, models);
    }

    public String get(Long factorId, String key) {
        List<OccupationalRiskAttrModel> models;
        if (factorId.equals(567L)) {
            return "85";
        }
        if (this.factorIdToOccupationalRiskAttrModelMap.isEmpty()) {
            this.refreshCache();
        }
        if ((models = this.factorIdToOccupationalRiskAttrModelMap.get(factorId)) == null || models.isEmpty()) {
            return null;
        }
        return this.getByAttrName(models, key);
    }

    public List<String> getFactorLimitKeys(Long factorId) {
        List<OccupationalRiskAttrModel> models = this.factorIdToOccupationalRiskAttrModelMap.get(factorId);
        if (models == null) {
            HarmFactor fac = this.harmFactorService.getThisById(factorId);
            if (fac != null && fac.getType().equals("\u7c89\u5c18")) {
                models = this.factorIdToOccupationalRiskAttrModelMap.get(654L);
            }
            if (models == null) {
                models = new LinkedList<OccupationalRiskAttrModel>();
            }
        }
        return models.stream().map(OccupationalRiskAttrModel::getAttrName).collect(Collectors.toList());
    }

    public String containsZongHu(Long factorId) {
        StringBuffer result = new StringBuffer();
        List<String> factorLimitKeys = this.getFactorLimitKeys(factorId);
        if (CollectionUtils.isNotEmpty(factorLimitKeys)) {
            if (factorLimitKeys.contains("twa_total")) {
                result.append("1");
            }
            if (factorLimitKeys.contains("twa_respirabel")) {
                result.append("2");
            }
            return result.toString();
        }
        return "";
    }

    public Map<Long, List<String>> getFactorLimitKeys(List<Long> factorIds) {
        HashMap<Long, List<String>> map = new HashMap<Long, List<String>>();
        for (Long factorId : factorIds) {
            List<OccupationalRiskAttrModel> models = this.factorIdToOccupationalRiskAttrModelMap.get(factorId);
            if (models == null) {
                HarmFactor fac = this.harmFactorService.getThisById(factorId);
                if (fac != null && fac.getType().equals("\u7c89\u5c18")) {
                    models = this.factorIdToOccupationalRiskAttrModelMap.get(654L);
                }
                if (models == null) {
                    models = new LinkedList<OccupationalRiskAttrModel>();
                }
            }
            map.put(factorId, models.stream().map(OccupationalRiskAttrModel::getAttrName).collect(Collectors.toList()));
        }
        return map;
    }

    public synchronized void refreshCache() {
        this.factorIdToOccupationalRiskAttrModelMap.clear();
        List all = this.provideService.getAll();
        for (OccupationalRiskAttrModel occupationalRiskAttrModel : all) {
            List list = this.factorIdToOccupationalRiskAttrModelMap.computeIfAbsent(occupationalRiskAttrModel.getHazardId(), k -> new ArrayList());
            list.add(occupationalRiskAttrModel);
        }
    }

    public String getTargetNameByFactorAndTargetId(Long factorId, Integer targetId) {
        switch (targetId) {
            case 3: {
                return "PC-TWA";
            }
            case 4: 
            case 7: {
                return "PC-STEL";
            }
            case 5: 
            case 6: {
                return "MAC";
            }
            case 8: {
                return "PE";
            }
            case 9: {
                return "\u8d85\u9650\u500d\u6570";
            }
            case 13: {
                return "PC-TWA";
            }
            case 14: {
                return "\u6d53\u5ea6\u8303\u56f4";
            }
            case 15: {
                return "PE";
            }
            case 16: {
                return "\u8d85\u9650\u500d\u6570";
            }
            case 18: {
                return "PC-TWA";
            }
            case 19: {
                return "\u6d53\u5ea6\u8303\u56f4";
            }
            case 20: {
                return "PE";
            }
            case 21: {
                return "\u8d85\u9650\u500d\u6570";
            }
            case 99: 
            case 100: {
                return "MAC";
            }
            case 101: {
                return "PC-TWA";
            }
            case 102: 
            case 103: {
                return "PC-STEL";
            }
        }
        return null;
    }

    public Map<String, Map<String, String>> queryLimitValues(List<String> factorIds) {
        if (factorIds == null || factorIds.isEmpty()) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> factorMap = new HashMap<String, Map<String, String>>();
        for (String factorId : factorIds) {
            List<OccupationalRiskAttrModel> models;
            if (factorMap.containsKey(factorId)) continue;
            Long facId = null;
            if (StringUtils.isNotEmpty((String)factorId)) {
                if (!factorId.contains(",")) {
                    facId = Long.parseLong(factorId);
                } else {
                    List facIds = StringUtils.parseToLongList((String)factorId, (String)",");
                    if (facIds != null && facIds.size() > 0) {
                        facId = (Long)facIds.get(0);
                    }
                }
            }
            if ((models = this.factorIdToOccupationalRiskAttrModelMap.get(facId)) == null) {
                HarmFactor fac = this.harmFactorService.getThisById(facId);
                if (fac != null && fac.getType() != null && fac.getType().equals("\u7c89\u5c18")) {
                    models = this.factorIdToOccupationalRiskAttrModelMap.get(654L);
                }
                if (models == null) continue;
            }
            HashMap<String, String> valueMap = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty(models)) {
                for (OccupationalRiskAttrModel model : models) {
                    String key = model.getAttrName();
                    String val = model.getAttrValue();
                    valueMap.put(key, val);
                }
            }
            factorMap.put(factorId, valueMap);
        }
        return factorMap;
    }

    public List<FactorLimitValue> queryFCLimitValues() {
        return this.provideService.queryFCLimitValues();
    }

    private String parseLimitValue(Integer targetId, List<OccupationalRiskAttrModel> models) {
        switch (targetId) {
            case 3: {
                return this.getByAttrName(models, "twa");
            }
            case 4: 
            case 7: {
                return this.getByAttrName(models, "stel");
            }
            case 5: 
            case 6: {
                return this.getByAttrName(models, "mac");
            }
            case 8: {
                return null;
            }
            case 9: {
                return this.getByAttrName(models, "max_excursion_limit");
            }
            case 13: {
                return this.getByAttrName(models, "twa_total");
            }
            case 14: {
                return null;
            }
            case 15: {
                return null;
            }
            case 16: {
                return null;
            }
            case 18: {
                return this.getByAttrName(models, "twa_respirabel");
            }
            case 19: {
                return null;
            }
            case 20: {
                return null;
            }
            case 21: {
                return null;
            }
            case 99: 
            case 100: {
                return this.getByAttrName(models, "mac");
            }
            case 101: {
                return this.getByAttrName(models, "twa");
            }
            case 102: 
            case 103: {
                return this.getByAttrName(models, "stel");
            }
        }
        return null;
    }

    private String getByAttrName(List<OccupationalRiskAttrModel> models, String attrName) {
        if (models == null || models.isEmpty()) {
            return null;
        }
        for (OccupationalRiskAttrModel model : models) {
            if (!attrName.equals(model.getAttrName())) continue;
            return model.getAttrValue();
        }
        return null;
    }
}

