/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.common.util.PageUtil;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.ComOverRate;
import cn.smarthse.services.hfi.api.pojo.vo.ComOverRateVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.IComOverRateService;
import cn.smarthse.services.hfi.mapper.ComOverRateMapper;
import cn.smarthse.services.hfi.property.ProjectEnvEnum;
import cn.smarthse.services.hfi.property.ProjectProperties;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class ComOverRateServiceImpl
extends BaseServiceImp<ComOverRateMapper, ComOverRate>
implements IComOverRateService {
    private ICheckPlanService checkPlanService;
    private ICheckResultService checkResultService;
    private ThreadPoolExecutor threadPoolExecutor;
    private ProjectProperties projectProperties;

    @Autowired
    public void autowire(ICheckPlanService checkPlanService, ICheckResultService checkResultService, ThreadPoolExecutor threadPoolExecutor, ProjectProperties projectProperties) {
        this.checkPlanService = checkPlanService;
        this.checkResultService = checkResultService;
        this.threadPoolExecutor = threadPoolExecutor;
        this.projectProperties = projectProperties;
    }

    @PostConstruct
    public void init() {
        if (this.projectProperties.getEnvEnum().equals((Object)ProjectEnvEnum.PRO)) {
            // empty if block
        }
    }

    public void startStatistic() {
        this.logger.info("\u5f00\u59cb\u7edf\u8ba1\u4f01\u4e1a\u8d85\u6807\u7387\uff08\u6700\u8fd1\u4e00\u5e74\u7684\uff09:");
        Long start = System.currentTimeMillis();
        List list = this.checkPlanService.queryForOverRate();
        LinkedHashMap<Long, List> map = new LinkedHashMap<Long, List>();
        LinkedList<Long> cIds = new LinkedList<Long>();
        for (CheckPlan checkPlan : list) {
            cIds.add(checkPlan.getCid());
            List checkIds = map.computeIfAbsent(checkPlan.getCid(), k -> new LinkedList());
            checkIds.add(checkPlan.getId());
        }
        LinkedList<ComOverRate> resultList = new LinkedList<ComOverRate>();
        for (Map.Entry entry : map.entrySet()) {
            Long cid = (Long)entry.getKey();
            String chemicalRate = this.checkResultService.calculateChemicalOverRate((List)entry.getValue());
            String dustRate = this.checkResultService.calculateDustOverRate((List)entry.getValue());
            String noiseValues = this.checkResultService.getNoiseValues((List)entry.getValue());
            String totalRate = this.checkResultService.calculateTotalOverRate((List)entry.getValue());
            ComOverRate overRate = new ComOverRate();
            overRate.setChemicalRate(chemicalRate);
            overRate.setCid(cid);
            overRate.setDustRate(dustRate);
            overRate.setNoiseValues(noiseValues);
            overRate.setTotalRate(totalRate);
            overRate.setCreateDate(LocalDateTime.now());
            overRate.setUpdateDate(LocalDateTime.now());
            overRate.setCreateBy(Long.valueOf(0L));
            overRate.setUpdateBy(Long.valueOf(0L));
            resultList.add(overRate);
        }
        this.remove((Wrapper)Wrappers.emptyWrapper());
        this.saveBatch(resultList);
        this.logger.info("\u7edf\u8ba1\u4f01\u4e1a\u8d85\u6807\u7387\u7ed3\u675f\uff08\u6700\u8fd1\u4e00\u5e74\u7684\uff09,\u5171\u7edf\u8ba1\u4f01\u4e1a\u6570:" + resultList.size() + ",\u8017\u65f6:" + (System.currentTimeMillis() - start) / 1000L + "\u79d2");
    }

    public List<ComOverRateVo> queryByThresholdAndArea(Long areaId, Byte areaLevel, String chemicalRate, String dustRate, String noiseValue, String totalRate, Byte ownLevel) {
        List<ComOverRate> list = ((ComOverRateMapper)this.baseMapper).queryByArea(areaId, areaLevel, ownLevel);
        LinkedList<ComOverRateVo> rList = new LinkedList<ComOverRateVo>();
        int count = 0;
        for (ComOverRate overRate : list) {
            int noiseNum = this.compareNoiseNum(overRate.getNoiseValues(), noiseValue);
            if (this.compare(overRate.getChemicalRate(), chemicalRate) || this.compare(overRate.getDustRate(), dustRate) || this.compare(overRate.getTotalRate(), totalRate) || noiseNum > 0) {
                ComOverRateVo vo = new ComOverRateVo();
                try {
                    BeanUtils.copyProperties((Object)vo, (Object)overRate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("cn.smarthse.services.hfi.serviceimp.ComOverRateServiceImpl.queryByThreshold::", (Throwable)e);
                    throw new RuntimeException(e);
                }
                vo.setNoiseNum(noiseNum);
                rList.add(vo);
                continue;
            }
            ++count;
            this.logger.info("\u5316\u5b66\u8d85\u6807\u7387:{},\u7c89\u5c18\u8d85\u6807\u7387\uff1a{}\uff0c\u566a\u58f0\u8d85\u6807\u6570\uff1a{}\uff0c\u603b\u8d85\u6807\u7387\uff1a{}", new Object[]{overRate.getChemicalRate(), overRate.getDustRate(), overRate.getNoiseValues(), overRate.getTotalRate()});
        }
        this.logger.info("\u88ab\u8fc7\u6ee4\u7684\u6570\u91cf\uff1a{}", (Object)count);
        return rList;
    }

    public PageInfo<ComOverRateVo> queryPageByThresholdAndArea(Long areaId, Byte areaLevel, String chemicalRate, String dustRate, String noiseValue, String totalRate, int pageNum, int pageSize, Byte ownLevel) {
        List<ComOverRateVo> list = this.queryByThresholdAndArea(areaId, areaLevel, chemicalRate, dustRate, noiseValue, totalRate, ownLevel);
        return PageUtil.getPageInfo(list, (int)pageNum, (int)pageSize);
    }

    private boolean compare(String rate1, String rate2) {
        if (rate2 == null || rate2.isEmpty()) {
            return true;
        }
        if (rate1 == null || rate1.isEmpty()) {
            return false;
        }
        double r1 = 0.0;
        double r2 = 0.0;
        try {
            r1 = Double.parseDouble(rate1);
            r2 = Double.parseDouble(rate2);
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
            this.logger.error("\u8d85\u6807\u7387\u8f6cdouble\u5f02\u5e38", (Throwable)e1);
            return false;
        }
        return r1 > r2;
    }

    private int compareNoiseNum(String noiseValues, String noiseValue) {
        if (noiseValues == null || noiseValues.isEmpty()) {
            return 0;
        }
        String[] values = noiseValues.split(",");
        if (noiseValue == null || noiseValue.isEmpty()) {
            return values.length;
        }
        int count = 0;
        for (String value : values) {
            if (!this.compare(value, noiseValue)) continue;
            ++count;
        }
        return count;
    }
}

