/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.services.hfi.api.entity.CheckItem;
import cn.smarthse.services.hfi.api.entity.CheckTarget;
import cn.smarthse.services.hfi.api.service.ICheckItemService;
import cn.smarthse.services.hfi.api.service.ICheckTargetService;
import cn.smarthse.services.hfi.mapper.CheckTargetMapper;
import cn.smarthse.services.hfi.property.ProjectEnvEnum;
import cn.smarthse.services.hfi.property.ProjectProperties;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class CheckTargetServiceImpl
extends BaseServiceImp<CheckTargetMapper, CheckTarget>
implements ICheckTargetService {
    private ConcurrentHashMap<Long, List<CheckTarget>> itemToTargetMap = new ConcurrentHashMap();
    private HashMap<Long, CheckTarget> idToTargetMap = new HashMap();
    private ICheckItemService checkItemService;
    private ProjectProperties projectProperties;

    @Autowired
    public void autowired(ICheckItemService checkItemService, ProjectProperties projectProperties) {
        this.checkItemService = checkItemService;
        this.projectProperties = projectProperties;
    }

    @PostConstruct
    public void init() {
        if (this.projectProperties.getEnvEnum().equals((Object)ProjectEnvEnum.PRO)) {
            this.refreshCache();
        }
        List list = this.list();
        for (CheckTarget target : list) {
            this.idToTargetMap.put(target.getId(), target);
        }
    }

    public List<CheckTarget> getByItem(Long itemId) {
        if (itemId == null) {
            return new ArrayList<CheckTarget>(0);
        }
        List checkTargets = this.itemToTargetMap.get(itemId);
        if (checkTargets != null) {
            return checkTargets;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckTarget::getItemId, (Object)itemId)).orderByAsc(BaseEntity::getId);
        checkTargets = this.list((Wrapper)queryWrapper);
        this.itemToTargetMap.put(itemId, checkTargets);
        return checkTargets;
    }

    public CheckTarget getByIdFromCache(Long id) {
        return this.idToTargetMap.get(id);
    }

    public List<CheckTarget> getByItemAndStandard(Long itemId, Long standardId) {
        if (itemId == null || standardId == null) {
            return new ArrayList<CheckTarget>(0);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckTarget::getItemId, (Object)itemId)).and(standardIdWrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)standardIdWrapper.eq(CheckTarget::getStandardId, (Object)standardId)).or()).eq(CheckTarget::getStandardId, (Object)0))).orderByAsc(BaseEntity::getId);
        return this.list((Wrapper)queryWrapper);
    }

    public void refreshCache() {
        this.logger.info("\u5237\u65b0\u68c0\u6d4b\u6307\u6807\u7f13\u5b58");
        List all = this.checkItemService.getAll();
        for (CheckItem checkItem : all) {
            this.itemToTargetMap.put(checkItem.getId(), this.getByItem(checkItem.getId()));
        }
        this.logger.info("\u5237\u65b0\u68c0\u6d4b\u6307\u6807\u7f13\u5b58\u5b8c\u6210,\u5171\u6709\u68c0\u6d4b\u9879:" + this.itemToTargetMap.size() + "\u9879");
    }
}

