/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.services.hfi.api.pojo.vo.CompanyCheckListVo;
import cn.smarthse.services.hfi.api.service.ICheckStatisticService;
import cn.smarthse.services.hfi.mapper.CheckStatisticMapper;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class CheckStatisticServiceImpl
implements ICheckStatisticService {
    private CheckStatisticMapper statisticMapper;

    @Autowired
    public void autowired(CheckStatisticMapper checkStatisticMapper) {
        this.statisticMapper = checkStatisticMapper;
    }

    private Map<Integer, Integer> getCountMapGroupYear(Long cid) {
        List<String> datas = this.statisticMapper.countGroupYear(cid);
        Map<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (datas != null && datas.size() > 0) {
            map = datas.stream().collect(Collectors.toMap(s -> Integer.valueOf(s.split(":")[0]), s -> Integer.valueOf(s.split(":")[1])));
        }
        return map;
    }

    public CompanyCheckListVo countCheck(Long cid) {
        Map<Integer, Integer> map = this.getCountMapGroupYear(cid);
        Integer currentYearCount = map.get(LocalDate.now().getYear());
        Integer preYearCount = map.get(LocalDate.now().getYear() - 1);
        Integer pre3YearCount = map.get(LocalDate.now().getYear() - 2);
        Integer count = map.values().stream().collect(Collectors.summingInt(s -> s));
        Integer overPointNum = this.statisticMapper.countOverPoint(cid, LocalDate.now().getYear());
        CompanyCheckListVo vo = new CompanyCheckListVo();
        vo.setCurrentYearCount(currentYearCount);
        vo.setTotalCount(count);
        vo.setCurrentYearFailPoint(overPointNum);
        vo.setPreYearCount(preYearCount);
        vo.setPre3YearCount(pre3YearCount);
        return vo;
    }

    public Integer countByDateRange(Long cid, LocalDate start, LocalDate end) {
        Integer oneYearRangeTotalCount = this.statisticMapper.countByDateRange(cid, start, end);
        return oneYearRangeTotalCount;
    }

    public Integer countOverPoint(Long cid, Integer year, List<Long> checkIds) {
        if (checkIds != null && checkIds.isEmpty()) {
            return 0;
        }
        return this.statisticMapper.countOverPoints(cid, year, checkIds);
    }

    public List<LocalDate> getCheckBeginDates(Long cid) {
        return this.statisticMapper.getCheckBeginDates(cid);
    }
}

