/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.services.hfi.api.entity.CheckItem;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.CheckSelectItem;
import cn.smarthse.services.hfi.api.service.ICheckItemService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckSelectItemService;
import cn.smarthse.services.hfi.mapper.CheckSelectItemMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class CheckSelectItemServiceImpl
extends BaseServiceImp<CheckSelectItemMapper, CheckSelectItem>
implements ICheckSelectItemService {
    @Lazy
    @Autowired
    ICheckResultService checkResultService;
    @Autowired
    private ICheckItemService checkItemService;
    @Autowired
    private ICheckPlanService checkPlanService;

    public List<CheckSelectItem> getByCheck(Long checkId) {
        Integer flag;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckSelectItem::getCheckId, (Object)checkId)).orderByAsc(CheckSelectItem::getItemId);
        List list = this.list((Wrapper)wrapper);
        this.setItemName(list);
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkId);
        if (checkPlan != null && checkPlan.getRiskExposeEvaluateId() != null && (flag = ((CheckSelectItemMapper)this.dao).getIfHaveFangShe(checkPlan.getRiskExposeEvaluateId())) > 0) {
            CheckSelectItem selectItem = new CheckSelectItem();
            selectItem.setCheckId(checkPlan.getRiskExposeEvaluateId());
            selectItem.setItemId(Integer.valueOf(18));
            selectItem.setCid(checkPlan.getCid());
            selectItem.setItemName("\u653e\u5c04\u5371\u5bb3");
            selectItem.setIsValid(Boolean.valueOf(true));
            list.add(selectItem);
        }
        return list;
    }

    public List<CheckSelectItem> getByCheckFilterNoData(Long checkId) {
        List itemIds = this.checkResultService.getItemIds(checkId);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckSelectItem::getCheckId, (Object)checkId)).in(CheckSelectItem::getItemId, (Collection)itemIds)).orderByAsc(CheckSelectItem::getItemId);
        List list = this.list((Wrapper)wrapper);
        this.setItemName(list);
        return list;
    }

    private void setItemName(List<CheckSelectItem> list) {
        for (CheckSelectItem checkSelectItem : list) {
            CheckItem checkItem = this.checkItemService.getByIdFromCache(Long.valueOf(checkSelectItem.getItemId().intValue()));
            checkSelectItem.setItemName(checkItem.getName());
        }
    }

    public List<CheckSelectItem> getHaveOverPointItemByCheck(Long checkId) {
        List haveOverPointItemIds = this.checkResultService.getHaveOverPointItemIds(checkId);
        List<CheckSelectItem> all = this.getByCheck(checkId);
        all.removeIf(checkSelectItem -> !haveOverPointItemIds.contains(checkSelectItem.getItemId()));
        for (CheckSelectItem checkSelectItem2 : all) {
            CheckItem item = this.checkItemService.getByIdFromCache(Long.valueOf(checkSelectItem2.getItemId().longValue()));
            checkSelectItem2.setItemName(item.getName());
        }
        return all;
    }

    @Transactional(readOnly=false)
    public void updateCheckItems(List<CheckSelectItem> selectItems) {
        if (selectItems != null && selectItems.size() > 0) {
            this.deleteByCheck(selectItems.get(0).getCheckId(), null);
            this.saveBatch(selectItems);
        }
    }

    public List<CheckSelectItem> getByCid(Long cid) {
        if (cid == null) {
            return new ArrayList<CheckSelectItem>(0);
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckSelectItem::getCid, (Object)cid);
        return this.list((Wrapper)wrapper);
    }

    private void deleteByCheck(Long checkId, Long itemId) {
        if (checkId == null) {
            this.logger.warn("cn.smarthse.services.hfi.serviceimp.CheckSelectItemServiceImpl.deleteByCheck::checkId \u4e3a\u7a7a");
            return;
        }
        LambdaUpdateWrapper removeMapper = Wrappers.lambdaUpdate();
        removeMapper.eq(CheckSelectItem::getCheckId, (Object)checkId);
        if (itemId != null) {
            removeMapper.eq(CheckSelectItem::getItemId, (Object)itemId);
        }
        this.remove((Wrapper)removeMapper);
    }

    @Transactional(readOnly=false)
    public void deleteCheckItem(Long checkId, Long itemId) {
        this.deleteByCheck(checkId, itemId);
        this.checkResultService.deleteResultByCheckItem(checkId, itemId);
    }
}

