/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckItem;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.entity.CheckTarget;
import cn.smarthse.services.hfi.api.entity.RayDevice;
import cn.smarthse.services.hfi.api.entity.RaySourceDevice;
import cn.smarthse.services.hfi.api.model.CheckPointSelectVoParamModel;
import cn.smarthse.services.hfi.api.model.result.CheckResultFormModel;
import cn.smarthse.services.hfi.api.model.result.ListParamModel;
import cn.smarthse.services.hfi.api.model.result.RayDeviceFormModel;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import cn.smarthse.services.hfi.api.pojo.bo.CheckMsgAndResultBo;
import cn.smarthse.services.hfi.api.pojo.bo.CheckResultBo;
import cn.smarthse.services.hfi.api.pojo.bo.ChemicalCheckResultBo;
import cn.smarthse.services.hfi.api.pojo.bo.DustCheckResultBo;
import cn.smarthse.services.hfi.api.pojo.bo.FactorBo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckOverPointVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckPointSelectVo;
import cn.smarthse.services.hfi.api.pojo.vo.FactorTypeCheckPointVo;
import cn.smarthse.services.hfi.api.pojo.vo.HarmFactorCheckResultVo;
import cn.smarthse.services.hfi.api.pojo.vo.SelectPointVo;
import cn.smarthse.services.hfi.api.service.ICheckFactorService;
import cn.smarthse.services.hfi.api.service.ICheckItemService;
import cn.smarthse.services.hfi.api.service.ICheckOverPointService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckPointIgnoreService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckTargetService;
import cn.smarthse.services.hfi.api.service.IRayDeviceService;
import cn.smarthse.services.hfi.api.service.IRaySourceDeviceService;
import cn.smarthse.services.hfi.mapper.CheckResultMapper;
import cn.smarthse.services.hfi.property.ProjectEnvEnum;
import cn.smarthse.services.hfi.property.ProjectProperties;
import cn.smarthse.services.hfi.serviceimp.FactorService;
import cn.smarthse.services.hfi.sys.SysConstants;
import cn.smarthse.services.hfi.util.CheckUtils;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.JsonUtils;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@DubboService
public class CheckResultServiceImpl
extends BaseServiceImp<CheckResultMapper, CheckResult>
implements ICheckResultService {
    @Autowired
    private ICheckTargetService checkTargetService;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    @Autowired
    private IdWorker snowFlake;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ICheckPlanService checkPlanService;
    private DecimalFormat df = new DecimalFormat("0.0000");
    @Autowired
    private ICheckOverPointService checkOverPointService;
    @Autowired
    private ProjectProperties projectProperties;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @Autowired
    private ICheckItemService checkItemService;
    @Autowired
    private ICheckPointIgnoreService pointIgnoreService;
    @Autowired
    private IRaySourceDeviceService raySourceDeviceService;
    @Autowired
    private IRayDeviceService rayDeviceService;
    @Autowired
    @Lazy
    private ICheckFactorService checkFactorService;
    @Autowired
    private FactorService factorService;
    private static final Integer[] OLD_TARGET_IDS = new Integer[]{5, 4, 8, 15, 20, 99, 102};
    private static final Integer[] NEW_TARGET_IDS = new Integer[]{6, 7, 9, 16, 21, 100, 103};
    private static final Integer[] OLD_NEW_TARGET_IDS = new Integer[]{5, 4, 8, 15, 20, 99, 102, 6, 7, 9, 16, 21, 100, 103};

    @PostConstruct
    public void init() {
        if (this.projectProperties.getEnvEnum().equals((Object)ProjectEnvEnum.PRO)) {
            // empty if block
        }
    }

    @Transactional(readOnly=false)
    public void addOrUpdate(List<CheckResult> checkResults) {
        if (checkResults == null || checkResults.isEmpty()) {
            return;
        }
        ArrayList<CheckResult> fetchResults = new ArrayList<CheckResult>();
        List<CheckResult> oldResults = this.getByCheckIdAndTargets(checkResults.get(0).getCheckId(), Arrays.asList(OLD_NEW_TARGET_IDS));
        for (CheckResult checkResult : checkResults) {
            CheckResult fetchResult = this.createFetchResult(checkResult, oldResults);
            if (fetchResult == null) continue;
            fetchResults.add(fetchResult);
        }
        this.saveOrUpdateBatch(checkResults);
        this.saveOrUpdateBatch(fetchResults);
        this.logger.info("\u6dfb\u52a0\u68c0\u6d4b\u7ed3\u679c\u540e\uff0c\u5f00\u59cb\u7edf\u8ba1\u8d85\u6807\u70b9");
        this.updateStatisticMsg(checkResults.get(0).getCid(), checkResults.get(0).getCheckId());
    }

    private void updateStatisticMsg(Long cid, Long checkId) {
        this.statistic(cid, checkId);
        this.checkFactorService.startStatisticByCheckId(checkId, cid);
    }

    private CheckResult createFetchResult(CheckResult checkResult, List<CheckResult> oldResults) {
        Integer newTargetId = this.findFetchNewTargetId(checkResult.getTargetId());
        if (newTargetId != null) {
            return this.findOrCreateResult(newTargetId, checkResult, oldResults);
        }
        Integer oldTargetId = this.findFetchOldTargetId(checkResult.getTargetId());
        if (oldTargetId != null) {
            return this.findOrCreateResult(oldTargetId, checkResult, oldResults);
        }
        return null;
    }

    private CheckResult findOrCreateResult(Integer targetId, CheckResult checkResult, List<CheckResult> oldResults) {
        try {
            for (CheckResult oldResult : oldResults) {
                if (!targetId.equals(oldResult.getTargetId()) || !checkResult.getResultNo().equals(oldResult.getResultNo())) continue;
                Long id = oldResult.getId();
                BeanUtils.copyProperties((Object)checkResult, (Object)oldResult);
                oldResult.setId(id);
                oldResult.setTargetId(targetId);
                return oldResult;
            }
            CheckResult r = new CheckResult();
            BeanUtils.copyProperties((Object)checkResult, (Object)r);
            r.setId(null);
            r.setTargetId(targetId);
            return r;
        }
        catch (Exception e) {
            this.logger.error("\u628a\u68c0\u6d4b\u7ed3\u679c\u590d\u5236\u7ed9\u65b0\u7684\u6307\u6807\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Integer findFetchNewTargetId(Integer targetId) {
        if (targetId == null) {
            return null;
        }
        for (int i = 0; i < OLD_TARGET_IDS.length; ++i) {
            if (!targetId.equals(OLD_TARGET_IDS[i])) continue;
            return NEW_TARGET_IDS[i];
        }
        return null;
    }

    private Integer findFetchOldTargetId(Integer targetId) {
        if (targetId == null) {
            return null;
        }
        for (int i = 0; i < NEW_TARGET_IDS.length; ++i) {
            if (!targetId.equals(NEW_TARGET_IDS[i])) continue;
            return OLD_TARGET_IDS[i];
        }
        return null;
    }

    public List<CheckResult> queryResult(Long checkId, Long itemId) {
        LambdaQueryWrapper<CheckResult> queryWrapper = this.getCheckItemQuery(checkId, itemId);
        return this.list((Wrapper)queryWrapper);
    }

    private LambdaQueryWrapper<CheckResult> getCheckItemQuery(Long checkId, Long itemId) {
        List targets = this.checkTargetService.getByItem(itemId);
        ArrayList<Long> targetIds = new ArrayList<Long>(targets.size());
        for (CheckTarget target : targets) {
            targetIds.add(target.getId());
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)this.queryWrapperIn(queryWrapper, CheckResult::getTargetId, targetIds).eq(BaseEntity::getIsValid, (Object)true)).eq(CheckResult::getCheckId, (Object)checkId);
        return queryWrapper;
    }

    @Transactional(readOnly=false)
    public void deleteResultByCheckItem(Long checkId, Long itemId) {
        List<CheckResult> list = this.getByCheckId(checkId);
        Long cid = null;
        if (list == null || list.isEmpty()) {
            return;
        }
        cid = list.get(0).getCid();
        LambdaQueryWrapper<CheckResult> queryWrapper = this.getCheckItemQuery(checkId, itemId);
        this.remove((Wrapper)queryWrapper);
        this.updateStatisticMsg(cid, checkId);
    }

    public String calculateChemicalOverRate(List<Long> checkIds) {
        if (checkIds == null || checkIds.isEmpty()) {
            return "0";
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperIn(queryWrapper, CheckResult::getCheckId, checkIds).eq(BaseEntity::getIsValid, (Object)true)).eq(CheckResult::getTargetId, (Object)10)).orderByAsc(CheckResult::getResultNo);
        List list = this.list((Wrapper)queryWrapper);
        return this.calculateOverRate(list);
    }

    public String calculateDustOverRate(List<Long> checkIds) {
        if (checkIds == null || checkIds.isEmpty()) {
            return "0";
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperIn(queryWrapper, CheckResult::getCheckId, checkIds).eq(BaseEntity::getIsValid, (Object)true)).in(CheckResult::getTargetId, Arrays.asList(17, 22))).orderByAsc(CheckResult::getResultNo);
        List list = this.list((Wrapper)queryWrapper);
        return this.calculateOverRate(list);
    }

    public String getNoiseValues(List<Long> checkIds) {
        if (checkIds == null || checkIds.isEmpty()) {
            return "";
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperIn(queryWrapper, CheckResult::getCheckId, checkIds).eq(BaseEntity::getIsValid, (Object)true)).in(CheckResult::getTargetId, Arrays.asList(29, 31))).orderByAsc(CheckResult::getResultNo);
        List list = this.list((Wrapper)queryWrapper);
        StringBuilder sb = new StringBuilder();
        String checkValue = "";
        for (CheckResult checkResult : list) {
            checkValue = checkResult.getCheckValueMax();
            if (checkValue == null || checkValue.isEmpty()) {
                checkValue = checkResult.getCheckValueMin();
            }
            if (checkValue == null || checkValue.isEmpty()) continue;
            sb.append(checkValue);
            sb.append(",");
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String calculateTotalOverRate(List<Long> checkIds) {
        if (checkIds == null || checkIds.isEmpty()) {
            return "";
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperIn(queryWrapper, CheckResult::getCheckId, checkIds).eq(BaseEntity::getIsValid, (Object)true)).in(CheckResult::getTargetId, SysConstants.RESULT_JUDGE_TARGETS)).orderByAsc(CheckResult::getResultNo);
        List list = this.list((Wrapper)queryWrapper);
        return this.calculateOverRate(list);
    }

    public List<CheckResult> getByCidAndTargets(Long cid, List<Integer> targets) {
        if (targets == null || targets.isEmpty() || cid == null) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperIn(queryWrapper, CheckResult::getTargetId, targets).eq(BaseEntity::getIsValid, (Object)true)).eq(CheckResult::getCid, (Object)cid)).orderByAsc(CheckResult::getResultNo);
        return this.list((Wrapper)queryWrapper);
    }

    public List<CheckResult> getByCheckIdAndTargets(Long checkId, List<Integer> targets) {
        if (targets == null || targets.isEmpty() || checkId == null) {
            return new ArrayList<CheckResult>(0);
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckResult::getCheckId, (Object)checkId)).in(CheckResult::getTargetId, targets)).orderByAsc(CheckResult::getResultNo);
        return this.list((Wrapper)queryWrapper);
    }

    public Integer[] getPoint(List<CheckResult> results) {
        Integer[] r = new Integer[]{0, 0, 0};
        if (results == null || results.isEmpty()) {
            return r;
        }
        ArrayList<String> currentCheckValues = new ArrayList<String>(8);
        Long currentResultNo = results.get(0).getResultNo();
        for (CheckResult result : results) {
            String checkValue;
            if (!result.getResultNo().equals(currentResultNo)) {
                this.calculatePoint(r, currentCheckValues);
                currentCheckValues.clear();
                currentResultNo = result.getResultNo();
            }
            if ((checkValue = result.getCheckValue()) == null) {
                checkValue = "";
            }
            currentCheckValues.add(checkValue);
        }
        if (!currentCheckValues.isEmpty()) {
            this.calculatePoint(r, currentCheckValues);
        }
        return r;
    }

    public Integer[] getPointByCheck(Long checkId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperIn(queryWrapper, CheckResult::getTargetId, SysConstants.RESULT_JUDGE_TARGETS).eq(BaseEntity::getIsValid, (Object)true)).eq(CheckResult::getCheckId, (Object)checkId)).orderByAsc(CheckResult::getResultNo);
        List list = this.list((Wrapper)queryWrapper);
        return this.getPoint(list);
    }

    public List<CheckResult> getByCheckId(Long checkId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(CheckResult::getCheckId, (Object)checkId)).orderByAsc(CheckResult::getResultNo);
        return this.list((Wrapper)queryWrapper);
    }

    private void calculatePoint(Integer[] r, List<String> currentCheckValues) {
        Integer n;
        Integer[] integerArray;
        String result = CheckUtils.getCheckResult(currentCheckValues);
        if (result.equals("3")) {
            integerArray = r;
            n = integerArray[2];
            integerArray[2] = integerArray[2] + 1;
        } else if (result.equals("2")) {
            integerArray = r;
            n = integerArray[1];
            integerArray[1] = integerArray[1] + 1;
        }
        integerArray = r;
        n = integerArray[0];
        integerArray[0] = integerArray[0] + 1;
    }

    private String calculateOverRate(List<CheckResult> results) {
        if (results == null || results.isEmpty()) {
            return "0";
        }
        Integer[] points = this.getPoint(results);
        return this.df.format((double)points[2].intValue() / (double)points[0].intValue());
    }

    public List<CheckResult> queryIonizingRadiationResult(Long id, int type) {
        return ((CheckResultMapper)this.baseMapper).queryIonizingRadiationResult(id, type);
    }

    public Long queryResult(Long hcId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckResult::getCheckId, (Object)hcId);
        return this.count((Wrapper)queryWrapper);
    }

    @Transactional(readOnly=false)
    public void deleteByRowNum(Long dataId) {
        if (dataId == null) {
            return;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CheckResult::getResultNo, (Object)dataId);
        List list = this.list((Wrapper)queryWrapper);
        Long cid = null;
        Long checkId = null;
        if (list == null || list.isEmpty()) {
            return;
        }
        cid = ((CheckResult)list.get(0)).getCid();
        checkId = ((CheckResult)list.get(0)).getCheckId();
        this.remove((Wrapper)queryWrapper);
        this.updateStatisticMsg(cid, checkId);
    }

    @Transactional(readOnly=false)
    public void deleteByRowNums(Long[] dataIds) {
        if (dataIds == null || dataIds.length == 0) {
            return;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        this.queryWrapperIn(queryWrapper, CheckResult::getResultNo, Arrays.asList(dataIds));
        List list = this.list((Wrapper)queryWrapper);
        Long cid = null;
        Long checkId = null;
        if (list == null || list.isEmpty()) {
            return;
        }
        cid = ((CheckResult)list.get(0)).getCid();
        checkId = ((CheckResult)list.get(0)).getCheckId();
        this.remove((Wrapper)queryWrapper);
        this.updateStatisticMsg(cid, checkId);
    }

    public Map<String, CheckResult> getResultMapBydataId(Long dataId, Boolean clone) {
        HashMap<String, CheckResult> map = new HashMap<String, CheckResult>();
        if (dataId == null) {
            return map;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CheckResult::getResultNo, (Object)dataId);
        List results = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return map;
        }
        Map<String, String> idAndNameMap = this.factorService.harmIdAndNameMap(((CheckResult)results.get(0)).getCheckId());
        results.forEach(r -> {
            Integer targetId = r.getTargetId();
            String key = "target" + r.getTargetId();
            if (targetId == 2 || targetId == 12 || targetId == 98) {
                r.setHarmName((String)idAndNameMap.get(r.getCheckValue()));
            }
            if (targetId == 93 || targetId == 94 || targetId == 95) {
                r.setRadiationArr(ResultUtils.getRadiationArr((String)r.getCheckValue()));
            }
            if (clone != null && clone.booleanValue()) {
                r.setId(null);
                r.setResultNo(null);
            }
            map.put(key, (CheckResult)r);
        });
        return map;
    }

    @Transactional(readOnly=false)
    public void updateCheckResult(CheckResultFormModel form) {
        if (form == null) {
            return;
        }
        List checkResults = form.getList();
        if (CollectionUtils.isEmpty((Collection)checkResults)) {
            return;
        }
        long resultNo = form.getResultNo() == null ? this.snowFlake.nextId() : form.getResultNo().longValue();
        checkResults.forEach(c -> {
            if (c.getId() == null) {
                c.setCreateBy(form.getUserId());
                c.setCreateDate(LocalDateTime.now());
            }
            c.setCheckId(form.getCheckId());
            c.setCid(form.getCid());
            c.setResultNo(Long.valueOf(resultNo));
            c.setUpdateBy(form.getUserId());
            c.setUpdateDate(LocalDateTime.now());
        });
        this.addOrUpdate(checkResults);
    }

    @Transactional(readOnly=false)
    public void updateRayResult(RayDeviceFormModel model) {
        ((CheckResultMapper)this.baseMapper).deleteResultByTargetAndValue(model.getCheckId(), model.getType(), "" + model.getDeviceOrSourceId());
        if (model.getList() == null || model.getList().isEmpty()) {
            return;
        }
        List<CheckResult> checkResults = this.convertRayResult(model);
        for (CheckResult result : checkResults) {
            result.setCreateBy(model.getUserId());
            result.setUpdateBy(model.getUserId());
            result.setUpdateDate(LocalDateTime.now());
            result.setCreateDate(LocalDateTime.now());
            result.setId(null);
        }
        this.saveBatch(checkResults);
        this.updateStatisticMsg(model.getCid(), model.getCheckId());
    }

    public List<Integer> getHaveOverPointItemIds(Long checkId) {
        return ((CheckResultMapper)this.baseMapper).getHaveOverPointItemIds(checkId, SysConstants.RESULT_JUDGE_TARGETS);
    }

    public String getJudgeResult(List<CheckResult> row) {
        if (row == null || row.isEmpty()) {
            return "";
        }
        ArrayList<String> checkResults = new ArrayList<String>();
        for (CheckResult checkResult : row) {
            if (!SysConstants.RESULT_JUDGE_TARGETS.contains(checkResult.getTargetId())) continue;
            checkResults.add(checkResult.getCheckValue());
        }
        return CheckUtils.getCheckResult(checkResults);
    }

    @Transactional
    public void statisticAll(List<Long> cidList) {
        this.logger.info("\u7edf\u8ba1\u68c0\u6d4b\u7684\u672a\u7edf\u8ba1\u68c0\u6d4b\u70b9\u548c\u8d85\u6807\u70b9");
        long start = System.currentTimeMillis();
        List checkIds = this.checkPlanService.getUnCheckedOverPoint(cidList);
        if (CollectionUtils.isEmpty((Collection)checkIds)) {
            this.logger.info("\u7edf\u8ba1\u68c0\u6d4b\u7684\u672a\u7edf\u8ba1\u68c0\u6d4b\u70b9\u548c\u8d85\u6807\u70b9\u5b8c\u6210--\u65e0\u9700\u7edf\u8ba1\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - start) / 1000L + "s");
            return;
        }
        List splits = ListUtils.split((List)checkIds, (int)500);
        for (List list : splits) {
            List<CheckResult> results = this.getByCheckIdList(list);
            this.statisticBatch(results);
        }
        this.logger.info("\u7edf\u8ba1\u68c0\u6d4b\u7684\u672a\u7edf\u8ba1\u68c0\u6d4b\u70b9\u548c\u8d85\u6807\u70b9\u5b8c\u6210\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - start) / 1000L + "s");
    }

    private List<CheckResult> getByCheckIdList(List<Long> list) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).in(CheckResult::getTargetId, SysConstants.RESULT_JUDGE_TARGETS)).in(CheckResult::getCheckId, list)).orderByAsc(CheckResult::getCheckId)).orderByAsc(CheckResult::getResultNo)).orderByAsc(CheckResult::getTargetId);
        return this.list((Wrapper)wrapper);
    }

    @Transactional(readOnly=false)
    public void statisticBatch(List<CheckResult> checkResults) {
        ArrayList<CheckOverPoint> list = new ArrayList<CheckOverPoint>();
        HashMap<Long, List> map = new HashMap<Long, List>();
        for (CheckResult checkResult : checkResults) {
            if (checkResult == null) continue;
            List results = map.computeIfAbsent(checkResult.getCheckId(), k -> new ArrayList());
            results.add(checkResult);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (entry == null) continue;
            Integer[] points = this.getPoint((List)entry.getValue());
            list.add(this.createCheckOverPoint((Long)entry.getKey(), ((CheckResult)((List)entry.getValue()).get(0)).getCid(), points));
        }
        this.checkOverPointService.saveOrUpdateBatch(list);
    }

    @Async
    public CheckOverPoint statistic(Long cid, Long checkId) {
        this.logger.info("\u7edf\u8ba1\u68c0\u6d4b\u70b9:checkId\uff1a" + checkId);
        Integer[] r = this.getPointByCheck(checkId);
        CheckOverPoint checkOverPoint = this.createCheckOverPoint(checkId, cid, r);
        this.checkOverPointService.saveOrUpdate((Object)checkOverPoint);
        this.logger.info("\u7edf\u8ba1\u68c0\u6d4b\u70b9\u5b8c\u6210:checkId\uff1a" + checkId + JsonUtils.toJsonString((Object)checkOverPoint));
        return checkOverPoint;
    }

    private CheckOverPoint createCheckOverPoint(Long checkId, Long cid, Integer[] r) {
        CheckOverPoint checkOverPoint = new CheckOverPoint();
        checkOverPoint.setId(checkId);
        checkOverPoint.setCheckId(checkId);
        checkOverPoint.setCheckPoint(r[0]);
        checkOverPoint.setPassPoint(r[1]);
        checkOverPoint.setOverPoint(r[2]);
        checkOverPoint.setCreateBy(Long.valueOf(0L));
        checkOverPoint.setUpdateBy(Long.valueOf(0L));
        checkOverPoint.setCid(cid);
        checkOverPoint.setCreateDate(LocalDateTime.now());
        checkOverPoint.setUpdateDate(LocalDateTime.now());
        return checkOverPoint;
    }

    public List<CheckResultBo> queryChemicalFactorResult(LocalDateTime start, LocalDateTime end) {
        return ((CheckResultMapper)this.baseMapper).queryChemicalFactorResult(start, end);
    }

    public List<CheckResultBo> queryDustFactorResult(LocalDateTime start, LocalDateTime end) {
        return ((CheckResultMapper)this.baseMapper).queryDustFactorResult(start, end);
    }

    public List<ChemicalCheckResultBo> queryChemicalFactorResultGroupByFactor(LocalDateTime start, LocalDateTime end) {
        List<CheckResultBo> checkResultBos = this.queryChemicalFactorResult(start, end);
        List list = this.parseToFactorCheckResultBo(checkResultBos, 1);
        return this.groupByFactorAndCid(list);
    }

    public List<DustCheckResultBo> queryDustFactorResultGroupByFactor(LocalDateTime start, LocalDateTime end) {
        List<CheckResultBo> checkResultBos = this.queryDustFactorResult(start, end);
        List list = this.parseToFactorCheckResultBo(checkResultBos, 2);
        return this.groupByFactorAndCid(list);
    }

    public CheckResult getLatest(Long checkId, Long targetId) {
        return ((CheckResultMapper)this.baseMapper).getLatest(checkId, targetId);
    }

    public List<HarmFactorCheckResultVo> queryHarmFactorLatestCheckResult(Long cid, Long factorId, List<Long> checkIds) {
        if (checkIds == null || checkIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<HarmFactorCheckResultVo> list = null;
        list = SysConstants.CHECK_ITEM_FACTOR_IDS.contains(factorId) ? ((CheckResultMapper)this.baseMapper).queryHarmFactorLatestCheckResult1(cid, factorId, checkIds) : ((CheckResultMapper)this.baseMapper).queryHarmFactorLatestCheckResult2(cid, factorId, checkIds);
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<HarmFactorCheckResultVo> rList = new ArrayList<HarmFactorCheckResultVo>();
        Long resultNo = list.get(0).getResultNo();
        for (HarmFactorCheckResultVo vo : list) {
            if (!vo.getResultNo().equals(resultNo)) break;
            rList.add(vo);
        }
        return rList;
    }

    public List<FactorTypeCheckPointVo> queryFactorTypeCheckPoint(Long cid, Integer year) {
        List<FactorTypeCheckPointVo> list = this.createFactorTypeCheckPointVoList();
        for (FactorTypeCheckPointVo vo : list) {
            List<CheckResult> checkResults = ((CheckResultMapper)this.baseMapper).selectByCidAndItemAndTargetId(cid, year, 2, vo.getItemIds(), SysConstants.RESULT_JUDGE_TARGETS);
            Integer[] point = this.getPoint(checkResults);
            vo.setCheckPoint(point[0]);
            vo.setOverPoint(point[2]);
        }
        return list;
    }

    public List<FactorTypeCheckPointVo> queryFactorTypeCheckPoint2(Long cid, Integer year) {
        List<FactorTypeCheckPointVo> list = this.createFactorTypeCheckPointVoList2();
        for (FactorTypeCheckPointVo vo : list) {
            List<CheckResult> checkResults = ((CheckResultMapper)this.baseMapper).selectByCidAndItemAndTargetId(cid, year, 2, vo.getItemIds(), SysConstants.RESULT_JUDGE_TARGETS);
            Integer[] point = this.getPoint(checkResults);
            vo.setCheckPoint(point[0]);
            vo.setOverPoint(point[2]);
        }
        return list;
    }

    public PageInfo<SelectPointVo> querySelectPointVos(JqGridParam param, Long checkId, String searchKey) {
        int page = param.getPage();
        int rows = param.getRows();
        List<SelectPointVo> rList = this.getAllSelectPointVoByCheckId(checkId, searchKey);
        PageInfo pageInfo = PageUtil.getPageInfo(rList, (int)page, (int)rows);
        pageInfo.setList(rList);
        return pageInfo;
    }

    public PageInfo<SelectPointVo> querySelectPointVosGroupByCheckPoint(JqGridParam param, Long checkId, String searchKey) {
        List<SelectPointVo> list = this.getAllSelectPointVoByCheckId(checkId, searchKey);
        ArrayList<SelectPointVo> rList = new ArrayList<SelectPointVo>();
        HashMap<String, SelectPointVo> map = new HashMap<String, SelectPointVo>();
        for (SelectPointVo selectPointVo : list) {
            SelectPointVo vo = (SelectPointVo)map.get(selectPointVo.getPointName());
            if (vo == null) {
                selectPointVo.setRowId(selectPointVo.getPointName());
                map.put(selectPointVo.getPointName(), selectPointVo);
                rList.add(selectPointVo);
                continue;
            }
            vo.setFactorName(vo.getFactorName() + "," + selectPointVo.getFactorName());
            vo.setFactorId(vo.getFactorId() + "," + selectPointVo.getFactorId());
            vo.setHarmFactorNamesAndIds(vo.getHarmFactorNamesAndIds() + "~&~" + selectPointVo.getHarmFactorNamesAndIds());
        }
        PageInfo pageInfo = PageUtil.getPageInfo(rList, (int)param.getPage(), (int)param.getRows());
        pageInfo.setList(rList);
        return pageInfo;
    }

    private List<SelectPointVo> getAllSelectPointVoByCheckId(Long checkId, String searchKey) {
        Map<String, String> allIdAndNameMap = this.factorService.harmIdAndNameMap(checkId);
        List<SelectPointVo> list = ((CheckResultMapper)this.baseMapper).querySelectPoint(checkId, SysConstants.CHECK_POINT_TARGETS);
        LinkedList<SelectPointVo> rList = new LinkedList<SelectPointVo>();
        for (SelectPointVo vo : list) {
            if (vo.getTargetId().equals(1) || vo.getTargetId().equals(11) || vo.getTargetId().equals(97)) {
                String factorName;
                String factorId = ((CheckResultMapper)this.baseMapper).selectFactorId(vo.getResultNo(), Arrays.asList(2, 12, 98));
                if (factorId == null || factorId.isEmpty() || (factorName = allIdAndNameMap.get(factorId)) == null) continue;
                vo.setFactorId(factorId);
                vo.setFactorName(factorName);
                vo.setHarmFactorNamesAndIds(vo.getFactorName() + ":" + vo.getFactorId());
                if (!this.isCheckPointMatch(vo, searchKey, rList)) continue;
                rList.add(vo);
                continue;
            }
            if (vo.getItemId().intValue() < 3 || vo.getItemId().intValue() > 12) continue;
            CheckItem checkItem = this.checkItemService.getByIdFromCache(vo.getItemId());
            vo.setFactorId("" + checkItem.getFactorId());
            vo.setFactorName(checkItem.getName());
            vo.setHarmFactorNamesAndIds(vo.getFactorName() + ":" + vo.getFactorId());
            if (!this.isCheckPointMatch(vo, searchKey, rList)) continue;
            rList.add(vo);
        }
        for (SelectPointVo vo : rList) {
            vo.setRowId(vo.getPointName());
        }
        return rList;
    }

    private boolean isCheckPointMatch(SelectPointVo vo, String searchKey, List<SelectPointVo> list) {
        for (SelectPointVo selectPointVo : list) {
            if (!selectPointVo.getFactorId().equals(vo.getFactorId()) || !selectPointVo.getPointName().equals(vo.getPointName())) continue;
            return false;
        }
        if (searchKey == null || searchKey.isEmpty()) {
            return true;
        }
        if (vo.getFactorName() != null && vo.getFactorName().contains(searchKey)) {
            return true;
        }
        return vo.getPointName() != null && vo.getPointName().contains(searchKey);
    }

    private List<FactorTypeCheckPointVo> createFactorTypeCheckPointVoList() {
        LinkedList<FactorTypeCheckPointVo> list = new LinkedList<FactorTypeCheckPointVo>();
        FactorTypeCheckPointVo vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(1));
        vo.setFactorTypeName("\u7c89\u5c18");
        vo.setItemIds(Arrays.asList(2L));
        list.add(vo);
        vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(2));
        vo.setFactorTypeName("\u5316\u5b66\u7269\u8d28");
        vo.setItemIds(Arrays.asList(1L));
        list.add(vo);
        vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(3));
        vo.setFactorTypeName("\u7269\u7406\u56e0\u7d20");
        vo.setItemIds(Arrays.asList(3L, 4L, 5L, 6L, 7L, 8L, 9L, 11L, 12L));
        list.add(vo);
        vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(4));
        vo.setFactorTypeName("\u653e\u5c04\u6027\u56e0\u7d20");
        vo.setItemIds(Arrays.asList(10L));
        list.add(vo);
        vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(5));
        vo.setFactorTypeName("\u751f\u7269\u548c\u5176\u4ed6\u56e0\u7d20");
        vo.setItemIds(Arrays.asList(13L, 14L, 15L, 16L, 17L));
        list.add(vo);
        return list;
    }

    private List<FactorTypeCheckPointVo> createFactorTypeCheckPointVoList2() {
        LinkedList<FactorTypeCheckPointVo> list = new LinkedList<FactorTypeCheckPointVo>();
        FactorTypeCheckPointVo vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(1));
        vo.setFactorTypeName("\u7c89\u5c18");
        vo.setItemIds(Arrays.asList(2L));
        list.add(vo);
        vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(2));
        vo.setFactorTypeName("\u5316\u5b66\u7269\u8d28");
        vo.setItemIds(Arrays.asList(1L));
        list.add(vo);
        vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(3));
        vo.setFactorTypeName("\u7269\u7406\u56e0\u7d20");
        vo.setItemIds(Arrays.asList(3L, 4L, 5L, 6L, 7L, 8L, 9L, 11L, 12L));
        list.add(vo);
        vo = new FactorTypeCheckPointVo();
        vo.setSortNum(Integer.valueOf(4));
        vo.setFactorTypeName("\u5176\u4ed6\u56e0\u7d20");
        vo.setItemIds(Arrays.asList(10L, 13L, 14L, 15L, 16L, 17L));
        list.add(vo);
        return list;
    }

    private <T extends FactorBo> List<T> groupByFactorAndCid(List<T> list) {
        LinkedList<FactorBo> rList = new LinkedList<FactorBo>();
        if (list == null || list.isEmpty()) {
            return rList;
        }
        FactorBo currentBo = (FactorBo)list.get(0);
        rList.add(currentBo);
        for (FactorBo bo : list) {
            if (bo.getFactorId().equals(currentBo.getFactorId()) && bo.getCid().equals(currentBo.getCid())) {
                this.setFactorCheckResultMax(currentBo, bo);
                continue;
            }
            currentBo = bo;
            rList.add(currentBo);
        }
        return rList;
    }

    private void setFactorCheckResultMax(FactorBo currentBo, FactorBo bo) {
        PropertyDescriptor[] propertyDescriptors;
        String v1 = "";
        String v2 = "";
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors(currentBo.getClass())) {
            if (propertyDescriptor.getName().equals("factorId") || propertyDescriptor.getName().equals("cid") || propertyDescriptor.getName().equals("class")) continue;
            try {
                v1 = (String)propertyDescriptor.getReadMethod().invoke((Object)currentBo, new Object[0]);
                v2 = (String)propertyDescriptor.getReadMethod().invoke((Object)bo, new Object[0]);
                if (v1 != null && !v1.isEmpty() && (v2 == null || v2.isEmpty() || !(Double.parseDouble(v2) > Double.parseDouble(v1)))) continue;
                propertyDescriptor.getWriteMethod().invoke((Object)currentBo, v2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <T extends FactorBo> List<T> parseToFactorCheckResultBo(List<CheckResultBo> checkResultBos, int type) {
        if (checkResultBos == null || checkResultBos.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<FactorBo> rList = new LinkedList<FactorBo>();
        ArrayList<CheckResultBo> currentList = new ArrayList<CheckResultBo>();
        Long currentResultNo = checkResultBos.get(0).getResultNo();
        for (CheckResultBo checkResultBo : checkResultBos) {
            if (!checkResultBo.getResultNo().equals(currentResultNo)) {
                rList.add(this.convertToCheckResultBo(currentList, type));
                currentList.clear();
                currentResultNo = checkResultBo.getResultNo();
            }
            currentList.add(checkResultBo);
        }
        rList.add(this.convertToCheckResultBo(currentList, type));
        return rList;
    }

    private FactorBo convertToCheckResultBo(List<CheckResultBo> checkResultBos, int type) {
        if (type == 1) {
            return this.convertToChemicalCheckResultBo(checkResultBos);
        }
        return this.convertToDustCheckResultBo(checkResultBos);
    }

    private ChemicalCheckResultBo convertToChemicalCheckResultBo(List<CheckResultBo> checkResultBos) {
        ChemicalCheckResultBo bo = new ChemicalCheckResultBo();
        bo.setFactorId(checkResultBos.get(0).getFactorId());
        bo.setCid(checkResultBos.get(0).getCid());
        for (CheckResultBo checkResultBo : checkResultBos) {
            if (checkResultBo.getTargetId().equals(3)) {
                bo.setCtwa(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(4)) {
                bo.setCstel(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(5)) {
                bo.setCmac(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(6)) {
                bo.setCme(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(7)) {
                bo.setCste(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(8)) {
                bo.setConcentration(checkResultBo.getCheckValue());
                continue;
            }
            if (!checkResultBo.getTargetId().equals(9)) continue;
            bo.setLimitTimes(checkResultBo.getCheckValue());
        }
        return bo;
    }

    private DustCheckResultBo convertToDustCheckResultBo(List<CheckResultBo> checkResultBos) {
        DustCheckResultBo bo = new DustCheckResultBo();
        bo.setFactorId(checkResultBos.get(0).getFactorId());
        bo.setCid(checkResultBos.get(0).getCid());
        for (CheckResultBo checkResultBo : checkResultBos) {
            if (checkResultBo.getTargetId().equals(13)) {
                bo.setCtwaTotal(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(14)) {
                bo.setConcentrationRangeTotal(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(15)) {
                bo.setConcentrationTotal(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(16)) {
                bo.setLimitTimesTotal(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(18)) {
                bo.setCtwaRespirable(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(19)) {
                bo.setConcentrationRangeRespirable(checkResultBo.getCheckValue());
                continue;
            }
            if (checkResultBo.getTargetId().equals(20)) {
                bo.setConcentrationRespirable(checkResultBo.getCheckValue());
            }
            if (!checkResultBo.getTargetId().equals(21)) continue;
            bo.setLimitTimesRespirable(checkResultBo.getCheckValue());
        }
        return bo;
    }

    private List<CheckResult> convertRayResult(RayDeviceFormModel model) {
        ArrayList<CheckResult> checkResults = new ArrayList<CheckResult>();
        List list = model.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return checkResults;
        }
        list.forEach(l -> {
            Long resultNo = this.snowFlake.nextId();
            CheckResult result1 = null;
            CheckResult result2 = null;
            CheckResult result3 = null;
            CheckResult result4 = null;
            if (model.getType() == null || model.getType() == 76) {
                result1 = this.getResult(model.getCheckId(), model.getCid(), resultNo, 76, "" + model.getDeviceOrSourceId(), null, null, null);
                result2 = this.getResult(model.getCheckId(), model.getCid(), resultNo, 77, l.getPosition(), null, null, null);
                result3 = this.getResult(model.getCheckId(), model.getCid(), resultNo, 78, null, l.getCheckResultType(), l.getCheckResult(), l.getCheckResult());
                result4 = this.getResult(model.getCheckId(), model.getCid(), resultNo, 79, l.getJudged(), null, null, null);
            } else {
                result1 = this.getResult(model.getCheckId(), model.getCid(), resultNo, 80, "" + model.getDeviceOrSourceId(), null, null, null);
                result2 = this.getResult(model.getCheckId(), model.getCid(), resultNo, 81, l.getPosition(), null, null, null);
                result3 = this.getResult(model.getCheckId(), model.getCid(), resultNo, 82, null, l.getCheckResultType(), l.getCheckResult(), l.getCheckResult());
                result4 = this.getResult(model.getCheckId(), model.getCid(), resultNo, 83, l.getJudged(), null, null, null);
            }
            checkResults.add(result1);
            checkResults.add(result2);
            checkResults.add(result3);
            checkResults.add(result4);
        });
        return checkResults;
    }

    private CheckResult getResult(Long checkId, Long cid, Long resultNo, Integer targetId, String checkValue, Integer checkValueRangeType, String checkValueMin, String checkValueMax) {
        CheckResult result = new CheckResult();
        result.setCid(cid);
        result.setCheckId(checkId);
        result.setResultNo(resultNo);
        result.setTargetId(targetId);
        result.setCheckValue(checkValue);
        result.setCheckValueRangeType(checkValueRangeType);
        result.setCheckValueMin(checkValueMin);
        result.setCheckValueMax(checkValueMax);
        result.setCreateDate(LocalDateTime.now());
        result.setUpdateDate(LocalDateTime.now());
        return result;
    }

    private Long[] covertList(List<Long> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Long[] arr = new Long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = list.get(0);
        }
        return arr;
    }

    public List<HarmFactorCheckResultVo> queryHarmFactorByCheckAndHarms(Long checkId, List<Long> harms, List<String> source) {
        List<HarmFactorCheckResultVo> list = ((CheckResultMapper)this.baseMapper).queryHarmFactorByCheckAndHarms(checkId, harms, source);
        return list;
    }

    public List<HarmFactorCheckResultVo> queryHarmFactorByResultNo(Long resultNo) {
        List<HarmFactorCheckResultVo> list = ((CheckResultMapper)this.baseMapper).queryHarmFactorByResultNo(resultNo);
        return list;
    }

    public PageInfo<CheckPointSelectVo> queryCheckPointSelectVos(JqGridParam param, CheckPointSelectVoParamModel queryModel) {
        List<CheckMsgAndResultBo> resultBos = ((CheckResultMapper)this.baseMapper).queryCheckMsgAndResultBo(queryModel);
        List ignoreResultNo = this.pointIgnoreService.getByCid(queryModel.getCid());
        Map<String, String> factoIdToNameMap = this.factorService.harmIdAndNameMap(null);
        LinkedList<CheckPointSelectVo> list = new LinkedList<CheckPointSelectVo>();
        List<List<CheckMsgAndResultBo>> lists = CheckUtils.groupByResultNo(resultBos);
        for (List<CheckMsgAndResultBo> boList : lists) {
            CheckMsgAndResultBo bo = boList.get(0);
            CheckPointSelectVo vo = new CheckPointSelectVo();
            vo.setCheckDateBegin(bo.getCheckDateBegin());
            vo.setCheckId(bo.getCheckId());
            vo.setCheckProjectName(bo.getCheckWorkName());
            this.setCheckPointSelectVoResultProperties(vo, boList, factoIdToNameMap);
            if (queryModel.getJudgeResult() != null && !vo.getJudgeResult().equals(queryModel.getJudgeResult()) || queryModel.getIgnore() != null && queryModel.getIgnore().booleanValue() && !ignoreResultNo.contains(vo.getCheckPointResultNo()) || queryModel.getIgnore() != null && !queryModel.getIgnore().booleanValue() && ignoreResultNo.contains(vo.getCheckPointResultNo())) continue;
            list.add(vo);
        }
        return PageUtil.getPageInfo(list, (int)param.getPage(), (int)param.getRows());
    }

    public List<Long> queryFactorIdByCheckPoint(Long checkId, String checkPointName) {
        JqGridParam param = new JqGridParam();
        param.setPage(1);
        param.setRows(Integer.MAX_VALUE);
        PageInfo<SelectPointVo> selectPointVoPageInfo = this.querySelectPointVosGroupByCheckPoint(param, checkId, null);
        List list = selectPointVoPageInfo.getList();
        LinkedList<Long> factorIds = new LinkedList<Long>();
        for (SelectPointVo pointVo : list) {
            if (!pointVo.getPointName().equals(checkPointName)) continue;
            String factorId = pointVo.getFactorId();
            factorIds.addAll(CheckUtils.parseStrIds(factorId));
        }
        return factorIds;
    }

    public List<Long> getItemIds(Long checkId) {
        return ((CheckResultMapper)this.baseMapper).getItemIds(checkId);
    }

    public List<Long> queryHaveEmptyResultCheckIds() {
        return ((CheckResultMapper)this.baseMapper).queryHaveEmptyResultCheckIds(SysConstants.CHECK_RESULT_TARGET_IDS);
    }

    public List<CheckOverPointVo> queryCheckOverPointVo(Long checkId) {
        List<CheckOverPointVo> list = ((CheckResultMapper)this.baseMapper).queryCheckOverPoint(checkId, SysConstants.RESULT_JUDGE_TARGETS);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Long> resultNos = new LinkedList<Long>();
        HashMap<Long, CheckOverPointVo> map = new HashMap<Long, CheckOverPointVo>();
        Iterator<CheckOverPointVo> iterator = list.iterator();
        while (iterator.hasNext()) {
            CheckOverPointVo i = iterator.next();
            if (resultNos.contains(i.getResultNo())) {
                iterator.remove();
                continue;
            }
            resultNos.add(i.getResultNo());
            map.put(i.getResultNo(), i);
        }
        List<CheckResult> list2 = ((CheckResultMapper)this.baseMapper).queryByResultNo(resultNos);
        Map<String, String> factorMap = this.factorService.harmIdAndNameMap(checkId);
        for (CheckResult result : list2) {
            CheckOverPointVo vo = (CheckOverPointVo)map.get(result.getResultNo());
            if (vo == null) continue;
            if (SysConstants.CHECK_POINT_TARGETS.contains(result.getTargetId())) {
                vo.setCheckPointName(result.getCheckValue());
                continue;
            }
            if (!SysConstants.HARM_FACTOR_TARGETS.contains(result.getTargetId())) continue;
            String factor = factorMap.get(result.getCheckValue());
            vo.setCheckProject(factor);
            try {
                vo.setFactorId(Long.valueOf(Long.parseLong(result.getCheckValue())));
            }
            catch (NumberFormatException e) {
                this.logger.error("\u5371\u5bb3\u56e0\u7d20id\u8f6clong\u5f02\u5e38:{}", (Object)result.getCheckValue());
            }
        }
        return list;
    }

    private boolean isCheckPointSelectVoContains(List<CheckPointSelectVo> list, CheckPointSelectVo vo) {
        for (CheckPointSelectVo selectVo : list) {
            if (!selectVo.getCheckPointName().equals(vo.getCheckPointName())) continue;
            return true;
        }
        return false;
    }

    private void setCheckPointSelectVoResultProperties(CheckPointSelectVo vo, List<CheckMsgAndResultBo> boList, Map<String, String> factoIdToNameMap) {
        ArrayList<String> judgeResults = new ArrayList<String>(4);
        Integer targetId = null;
        Object deviceName = "";
        for (CheckMsgAndResultBo bo : boList) {
            RayDevice device;
            targetId = bo.getTargetId();
            if (targetId.equals(76) && (device = (RayDevice)this.rayDeviceService.getById((Serializable)((Object)bo.getCheckValue()))) != null) {
                deviceName = device.getName() + " ";
            }
            if (targetId.equals(80) && (device = (RaySourceDevice)this.raySourceDeviceService.getById((Serializable)((Object)bo.getCheckValue()))) != null) {
                deviceName = device.getName() + " ";
            }
            if (SysConstants.CHECK_POINT_TARGETS.contains(bo.getTargetId())) {
                vo.setCheckPointName((String)deviceName + bo.getCheckValue());
                vo.setCheckPointResultNo(bo.getResultNo());
            }
            if (SysConstants.RESULT_JUDGE_TARGETS.contains(bo.getTargetId())) {
                judgeResults.add(bo.getCheckValue());
            }
            if (SysConstants.HARM_FACTOR_TARGETS.contains(bo.getTargetId())) {
                String checkValue = bo.getCheckValue();
                vo.setFactorName(factoIdToNameMap.get(checkValue));
            }
            if (!SysConstants.HARM_FACTOR_CHECK_ITEM_IDS.contains(bo.getItemId())) continue;
            vo.setFactorName(bo.getItemName());
        }
        vo.setJudgeResult(CheckUtils.getCheckResult(judgeResults));
    }

    @Transactional(readOnly=false)
    public void getFetchResults(List<Long> checkId, List<CheckResult> checkResults) {
        if (checkResults == null || checkResults.isEmpty()) {
            return;
        }
        ArrayList<CheckResult> fetchResults = new ArrayList<CheckResult>();
        List<CheckResult> oldResults = this.getByCheckIdAndTargets2(checkId, Arrays.asList(OLD_NEW_TARGET_IDS));
        for (CheckResult checkResult : checkResults) {
            CheckResult fetchResult;
            if (checkResult.getTargetId() == null || (fetchResult = this.createFetchResult(checkResult, oldResults)) == null) continue;
            fetchResults.add(fetchResult);
        }
        checkResults = checkResults.stream().filter(item -> Objects.nonNull(item.getTargetId())).collect(Collectors.toList());
        this.saveOrUpdateBatch(checkResults);
        this.saveOrUpdateBatch(fetchResults);
    }

    public List<CheckResult> getByCheckIdAndTargets2(List<Long> checkId, List<Integer> targets) {
        if (targets == null || targets.isEmpty() || checkId == null) {
            return new ArrayList<CheckResult>(0);
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getIsValid, (Object)true)).in(CheckResult::getCheckId, checkId)).in(CheckResult::getTargetId, targets)).orderByAsc(CheckResult::getResultNo);
        return this.list((Wrapper)queryWrapper);
    }

    public List<Long> getResultIdByRiskId(Long riskId) {
        return ((CheckResultMapper)this.baseMapper).getResultIdByRiskId(riskId);
    }

    public List<CheckResult> queryResultToHse(ListParamModel param) {
        List targetIds = this.checkTargetService.getByItem(param.getItemId()).stream().filter(Objects::nonNull).map(BaseEntity::getId).collect(Collectors.toList());
        param.setTargetIds(targetIds);
        if (!param.getIsValid().booleanValue()) {
            param.setItemOpState("delete");
        }
        List<CheckResult> list = ((CheckResultMapper)this.baseMapper).queryResultToHse(param);
        return list;
    }
}

