/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.entity.RayDevice;
import cn.smarthse.services.hfi.api.entity.RaySourceDevice;
import cn.smarthse.services.hfi.api.enums.TouchLimitValueEnum;
import cn.smarthse.services.hfi.api.model.CheckComLevelClassifyResultVo;
import cn.smarthse.services.hfi.api.model.CheckResultParseQueryModel;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import cn.smarthse.services.hfi.api.pojo.vo.CheckFileVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileCheckResultVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultParseService;
import cn.smarthse.services.hfi.api.service.IFactorLimitValueService;
import cn.smarthse.services.hfi.api.service.IRayDeviceService;
import cn.smarthse.services.hfi.api.service.IRaySourceDeviceService;
import cn.smarthse.services.hfi.mapper.CheckResultParseMapper;
import cn.smarthse.services.hfi.serviceimp.FactorService;
import cn.smarthse.services.hfi.sys.SysConstants;
import cn.smarthse.services.hfi.util.CheckUtils;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class CheckResultParseServiceImpl
implements ICheckResultParseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private CheckResultParseMapper checkResultParseMapper;
    private IRaySourceDeviceService raySourceDeviceService;
    private IRayDeviceService rayDeviceService;
    private ICheckPlanService checkPlanService;
    private IFactorLimitValueService factorLimitValueService;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    @Autowired
    @Lazy
    private FactorService factorService;

    @Autowired
    public void autowire(CheckResultParseMapper checkResultParseMapper, IRaySourceDeviceService raySourceDeviceService, IRayDeviceService rayDeviceService, ICheckPlanService checkPlanService, IFactorLimitValueService factorLimitValueService) {
        this.checkResultParseMapper = checkResultParseMapper;
        this.raySourceDeviceService = raySourceDeviceService;
        this.rayDeviceService = rayDeviceService;
        this.checkPlanService = checkPlanService;
        this.factorLimitValueService = factorLimitValueService;
    }

    public List<CheckFileVo> queryCheckFileVos(CheckResultParseQueryModel queryModel) {
        List<CheckRecordFileVo> checkRecordFileVos = this.queryCheckRecordFileVos(queryModel);
        if (checkRecordFileVos.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CheckFileVo> rList = new LinkedList<CheckFileVo>();
        Long currentCheckId = checkRecordFileVos.get(0).getCheckId();
        LinkedList<Object> currentList = new LinkedList<CheckRecordFileVo>();
        for (CheckRecordFileVo vo : checkRecordFileVos) {
            if (!currentCheckId.equals(vo.getCheckId())) {
                rList.add(this.createCheckFileVo(currentList));
                currentList = new LinkedList();
                currentCheckId = vo.getCheckId();
            }
            currentList.add(vo);
        }
        rList.add(this.createCheckFileVo(currentList));
        return rList;
    }

    private CheckFileVo createCheckFileVo(List<CheckRecordFileVo> currentList) {
        CheckFileVo vo = new CheckFileVo();
        vo.setCheckId(currentList.get(0).getCheckId());
        vo.setPointResults(currentList);
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)vo.getCheckId());
        if (checkPlan != null) {
            vo.setCheckWorkName(checkPlan.getCheckWorkName());
            vo.setManagerName(checkPlan.getManagerName());
            vo.setCheckDate(currentList.get(0).getCheckDate());
            vo.setCid(currentList.get(0).getCid());
            vo.setComName(currentList.get(0).getComName());
        }
        return vo;
    }

    public List<CheckRecordFileVo> queryCheckRecordFileVos(CheckResultParseQueryModel queryModel) {
        Map<String, String> allIdAndNameMap = this.factorService.harmIdAndNameMap(queryModel.getCheckId());
        List<CheckRecordFileCheckResultVo> resultList = this.checkResultParseMapper.queryCheckRecordFileResults(queryModel);
        return this.parseToCheckRecordFileVo(resultList, allIdAndNameMap);
    }

    public List<CheckRecordFileVo> queryCheckRecordByArchive(CheckResultParseQueryModel queryModel) {
        List<CheckRecordFileVo> checkRecordFileVos = this.queryCheckRecordFileVos(queryModel);
        if (CollectionUtils.isEmpty(checkRecordFileVos)) {
            return Collections.emptyList();
        }
        Map<String, List<CheckRecordFileVo>> checkRecordGroupMap = checkRecordFileVos.stream().filter(f -> {
            String workName = f.getWorkName();
            String workshop = f.getWorkshop();
            return StringUtils.concatStr((String)"", (String[])new String[]{workshop, workName}) != null;
        }).collect(Collectors.groupingBy(k -> {
            String workName = k.getWorkName();
            String workshop = k.getWorkshop();
            return StringUtils.concatStr((String)"", (String[])new String[]{workshop, workName});
        }));
        ArrayList<CheckRecordFileVo> resultList = new ArrayList<CheckRecordFileVo>();
        for (List<CheckRecordFileVo> value : checkRecordGroupMap.values()) {
            CheckRecordFileVo vo = new CheckRecordFileVo();
            BeanUtils.copyProperties((Object)value.get(0), (Object)vo);
            List factorNames = value.stream().map(CheckRecordFileVo::getFactorName).distinct().collect(Collectors.toList());
            vo.setFactorName(StringUtils.join(factorNames, (String)","));
            resultList.add(vo);
        }
        return resultList;
    }

    public List<CheckRecordFileVo> queryComLatestCheckRecordFileVos(CheckResultParseQueryModel queryModel, Map<String, String> allIdAndNameMap) {
        List<CheckRecordFileCheckResultVo> resultList = this.checkResultParseMapper.queryCheckRecordFileResults(queryModel);
        List<CheckRecordFileVo> vos = this.parseToCheckRecordFileVo(resultList, allIdAndNameMap);
        Set factorIds = queryModel.getFactorIds();
        HashMap<CallSite, CheckRecordFileVo> map = new HashMap<CallSite, CheckRecordFileVo>();
        for (CheckRecordFileVo vo : vos) {
            String factorId = vo.getFactorId();
            if (factorId == null || factorId.isEmpty()) continue;
            try {
                long l = Long.parseLong(factorId);
                if (factorIds != null && !factorIds.contains(l)) {
                }
            }
            catch (NumberFormatException e) {}
            continue;
            String key = vo.getCid() + "-" + vo.getFactorId();
            CheckRecordFileVo vo1 = (CheckRecordFileVo)map.get(key);
            if (vo1 == null) {
                map.put((CallSite)((Object)key), vo);
                continue;
            }
            if (vo.getResultNo() <= vo1.getResultNo()) continue;
            map.put((CallSite)((Object)key), vo);
        }
        return new LinkedList<CheckRecordFileVo>(map.values());
    }

    public List<String> getAllFactorNames(Long cid, Integer checkYear) {
        CheckResultParseQueryModel queryModel = new CheckResultParseQueryModel();
        LinkedList<String> factorNames = new LinkedList<String>();
        queryModel.setCid(cid);
        queryModel.setCheckTypes(Arrays.asList(2L, 3L, 4L));
        queryModel.setCheckBeginStart(DateUtil.getLocalDateTime((int)checkYear, (int)1, (int)1, (int)0, (int)0, (int)0));
        queryModel.setCheckBeginEnd(DateUtil.getLocalDateTime((int)checkYear, (int)12, (int)31, (int)23, (int)59, (int)59));
        List<CheckRecordFileVo> checkFileVos = this.queryCheckRecordFileVos(queryModel);
        for (CheckRecordFileVo vo : checkFileVos) {
            factorNames.add(vo.getFactorName());
        }
        return factorNames;
    }

    public CheckComLevelClassifyResultVo parseComLevel1() {
        return this.parseComLevel("1", 0.5, 0.5);
    }

    public CheckComLevelClassifyResultVo parseComLevel2() {
        return this.parseComLevel("2", 0.1, 0.1);
    }

    public Map<String, CheckComLevelClassifyResultVo> parseComLevel3() {
        HashMap<String, CheckComLevelClassifyResultVo> map = new HashMap<String, CheckComLevelClassifyResultVo>();
        CheckComLevelClassifyResultVo vo1 = new CheckComLevelClassifyResultVo();
        CheckComLevelClassifyResultVo vo2 = new CheckComLevelClassifyResultVo();
        map.put("hx", vo1);
        map.put("xc", vo2);
        List<CheckResult> checkResults = this.checkResultParseMapper.getCheckResult(null);
        List all = this.harmFactorService.getByHazardRating(null);
        Map<Long, HarmFactor> idMap = this.toMap(all);
        HashSet<Long> cids1 = new HashSet<Long>();
        HashSet<Long> cids2 = new HashSet<Long>();
        List<List<CheckResult>> lists = CheckUtils.groupCheckResultByResultNo(checkResults);
        for (List<CheckResult> list : lists) {
            HarmFactor harmFactor;
            Long factorId = this.getFactorId(list);
            if (factorId == null || (harmFactor = idMap.get(factorId)) == null) continue;
            if (harmFactor.getType().contains("\u5316\u5b66\u56e0\u7d20") && this.isGtGtValue(list, 1.0)) {
                cids1.add(list.get(0).getCid());
            }
            if (!harmFactor.getNameCh().contains("\u77fd\u5c18") || !this.isGtGtValue(list, 1.0)) continue;
            cids2.add(list.get(0).getCid());
        }
        vo1.getCidsGtOrEq().addAll(cids1);
        vo2.getCidsGtOrEq().addAll(cids2);
        return map;
    }

    public Map<String, String> getHarmIdAndNameMap() {
        Map<String, String> allIdAndNameMap = this.factorService.harmIdAndNameMap(null);
        return allIdAndNameMap;
    }

    private Map<Long, HarmFactor> toMap(List<HarmFactor> list) {
        HashMap<Long, HarmFactor> map = new HashMap<Long, HarmFactor>();
        for (HarmFactor factor : list) {
            map.put(factor.getId(), factor);
        }
        return map;
    }

    public CheckComLevelClassifyResultVo parseComLevel(String hazardRating, Double gtValue, Double ltValue) {
        CheckComLevelClassifyResultVo vo = new CheckComLevelClassifyResultVo();
        List factorList = this.harmFactorService.getByHazardRating(hazardRating);
        List<Long> factorIds = this.getIds(factorList);
        if (factorIds == null || factorIds.isEmpty()) {
            return vo;
        }
        List<Long> queryFactorIds = null;
        if (factorIds.size() < 100) {
            queryFactorIds = factorIds;
        }
        List<CheckResult> checkResults = this.checkResultParseMapper.getCheckResult(queryFactorIds);
        List<List<CheckResult>> lists = CheckUtils.groupCheckResultByResultNo(checkResults);
        HashSet<Long> cids1 = new HashSet<Long>();
        HashSet<Long> cids2 = new HashSet<Long>();
        for (List<CheckResult> list : lists) {
            Long factorId = this.getFactorId(list);
            if (factorId == null || !factorIds.contains(factorId)) continue;
            if (this.isGtGtValue(list, gtValue)) {
                cids1.add(list.get(0).getCid());
            }
            if (!this.isLtLtValue(list, ltValue) || cids1.contains(list.get(0).getCid())) continue;
            cids2.add(list.get(0).getCid());
        }
        vo.getCidsGtOrEq().addAll(cids1);
        vo.getCidsLt().addAll(cids2);
        return vo;
    }

    private boolean isLtLtValue(List<CheckResult> list, Double ltValue) {
        Long factorId = this.getFactorId(list);
        if (factorId == null) {
            return false;
        }
        for (CheckResult result : list) {
            String value;
            String checkValueMax = result.getCheckValueMax();
            if (checkValueMax == null || checkValueMax.isEmpty() || (value = this.factorLimitValueService.getByFactorAndTargetId(factorId, result.getTargetId())) == null || (int)(Double.parseDouble(checkValueMax) * 1000.0) >= (int)(ltValue * Double.parseDouble(value) * 1000.0)) continue;
            return true;
        }
        return false;
    }

    private boolean isGtGtValue(List<CheckResult> list, Double gtValue) {
        Long factorId = this.getFactorId(list);
        if (factorId == null) {
            return false;
        }
        for (CheckResult result : list) {
            String value;
            String checkValueMax = result.getCheckValueMax();
            if (checkValueMax == null || checkValueMax.isEmpty() || (value = this.factorLimitValueService.getByFactorAndTargetId(factorId, result.getTargetId())) == null || (int)(Double.parseDouble(checkValueMax) * 10000.0) < (int)(gtValue * Double.parseDouble(value) * 10000.0)) continue;
            return true;
        }
        return false;
    }

    private Long getFactorId(List<CheckResult> list) {
        for (CheckResult result : list) {
            if (!Arrays.asList(2, 12, 98).contains(result.getTargetId())) continue;
            try {
                return Long.parseLong(result.getCheckValue());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private List<Long> getIds(List<HarmFactor> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<Long> ids = new ArrayList<Long>(list.size());
        for (HarmFactor factor : list) {
            ids.add(factor.getId());
        }
        return ids;
    }

    private List<CheckRecordFileVo> parseToCheckRecordFileVo(List<CheckRecordFileCheckResultVo> resultList, Map<String, String> factorIdToNameMap) {
        if (resultList.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CheckRecordFileVo> rList = new LinkedList<CheckRecordFileVo>();
        Long currentResultNo = resultList.get(0).getResultNo();
        ArrayList<CheckRecordFileCheckResultVo> currentList = new ArrayList<CheckRecordFileCheckResultVo>();
        for (CheckRecordFileCheckResultVo resultVo : resultList) {
            if (!resultVo.getResultNo().equals(currentResultNo)) {
                rList.add(this.parseOneRow(currentList, factorIdToNameMap));
                currentList.clear();
                currentResultNo = resultVo.getResultNo();
            }
            currentList.add(resultVo);
        }
        if (!currentList.isEmpty()) {
            rList.add(this.parseOneRow(currentList, factorIdToNameMap));
        }
        currentList.clear();
        return rList;
    }

    private CheckRecordFileVo parseOneRow(List<CheckRecordFileCheckResultVo> currentList, Map<String, String> factorIdToNameMap) {
        CheckRecordFileVo vo = new CheckRecordFileVo();
        CheckRecordFileCheckResultVo first = currentList.get(0);
        vo.setCheckId(first.getCheckId());
        vo.setSourceId(first.getSourceId());
        vo.setCid(first.getCid());
        vo.setItemId(first.getItemId());
        vo.setResultNo(first.getResultNo());
        vo.setCheckDate(first.getCheckDateBegin());
        vo.setComName(first.getComName());
        ArrayList<CheckRecordFileCheckResultVo> rList = new ArrayList<CheckRecordFileCheckResultVo>();
        Integer targetId = null;
        String deviceName = null;
        ArrayList<String> judgeS = new ArrayList<String>();
        for (CheckRecordFileCheckResultVo resultVo : currentList) {
            RayDevice device;
            targetId = resultVo.getTargetId();
            if (targetId.equals(76) && (device = (RayDevice)this.rayDeviceService.getById((Serializable)((Object)resultVo.getCheckValue()))) != null) {
                deviceName = device.getName();
            }
            if (targetId.equals(80) && (device = (RaySourceDevice)this.raySourceDeviceService.getById((Serializable)((Object)resultVo.getCheckValue()))) != null) {
                deviceName = device.getName();
            }
            if (SysConstants.CHECK_POINT_TARGETS.contains(targetId)) {
                if (deviceName != null) {
                    vo.setCheckPointName(deviceName + "(" + resultVo.getCheckValue() + ")");
                } else {
                    vo.setCheckPointName(resultVo.getCheckValue());
                }
            }
            if (resultVo.getItemType().equals(1) && (targetId.equals(2) || targetId.equals(12) || targetId.equals(98))) {
                vo.setFactorId(resultVo.getCheckValue());
            }
            if (resultVo.getItemType().equals(2)) {
                vo.setFactorId("" + resultVo.getFactorId());
            }
            if (resultVo.getItemType().equals(3)) {
                vo.setFactorName(resultVo.getItemName());
            }
            if (SysConstants.RESULT_JUDGE_TARGETS.contains(targetId)) {
                judgeS.add(resultVo.getCheckValue());
            }
            if (SysConstants.WORK_SHOP_TARGETS.contains(targetId)) {
                vo.setWorkshop(resultVo.getCheckValue());
            }
            if (SysConstants.WORK_TARGETS.contains(targetId)) {
                vo.setWorkName(resultVo.getCheckValue());
            }
            if (SysConstants.WORK_NUM_TARGETS.contains(targetId) && StringUtils.isNumber((String)resultVo.getCheckValue())) {
                vo.setWorkNum(Integer.valueOf(Integer.parseInt(resultVo.getCheckValue())));
            }
            if (!this.isNeedCheckResult(resultVo)) continue;
            this.setShowCheckValueAndUnit(resultVo);
            rList.add(resultVo);
        }
        if (vo.getFactorId() != null) {
            String factorName = factorIdToNameMap.get(vo.getFactorId());
            if (StringUtils.isBlank((CharSequence)factorName)) {
                factorName = this.harmFactorService.getHarmNames(vo.getFactorId());
            }
            vo.setFactorName(factorName);
        }
        vo.setJudgeResult(CheckUtils.getCheckResult(judgeS));
        vo.setShowJudgeResult(CheckUtils.getStrJudgeResult(vo.getJudgeResult()));
        vo.setResultList(rList);
        this.setTouchLimitValueAndUnit(vo);
        return vo;
    }

    private void setTouchLimitValueAndUnit(CheckRecordFileVo vo) {
        Long itemId = vo.getItemId();
        List resultList = vo.getResultList();
        if (itemId.intValue() > 2 && itemId.intValue() != 13) {
            String factorName = vo.getFactorName();
            this.setTouchLimitValueAndUnitByFactorName(factorName, resultList);
        } else {
            this.setTouchLimitValueAndUnitByFactorId(vo.getFactorId(), resultList);
        }
    }

    private void setTouchLimitValueAndUnitByFactorName(String factorName, List<CheckRecordFileCheckResultVo> resultList) {
        for (CheckRecordFileCheckResultVo resultVo : resultList) {
            TouchLimitValueEnum factorLimit = CheckUtils.getFactorLimit(factorName, resultVo.getTargetId());
            if (factorLimit == null) continue;
            resultVo.setShowTouchLimitValue(factorLimit.limitValue);
            resultVo.setShowTouchLimitUnit(factorLimit.limitUnit);
        }
    }

    private void setTouchLimitValueAndUnitByFactorId(String factorId, List<CheckRecordFileCheckResultVo> resultList) {
        try {
            Long.parseLong(factorId);
        }
        catch (NumberFormatException e) {
            this.logger.warn("\u5371\u5bb3\u56e0\u7d20id\u4e0d\u662f\u6570\u5b57,factorId:" + factorId);
            return;
        }
        for (CheckRecordFileCheckResultVo vo : resultList) {
            String limitValue = this.factorLimitValueService.getByFactorAndTargetId(Long.valueOf(Long.parseLong(factorId)), vo.getTargetId());
            String limitName = this.factorLimitValueService.getTargetNameByFactorAndTargetId(Long.valueOf(Long.parseLong(factorId)), vo.getTargetId());
            vo.setShowTouchLimitUnit(limitName + "(" + vo.getUnit() + ")");
            vo.setShowTouchLimitValue(limitValue);
        }
    }

    private boolean isNeedCheckResult(CheckRecordFileCheckResultVo resultVo) {
        return SysConstants.CHECK_FILE_RESULT_TARGETS.contains(resultVo.getTargetId());
    }

    private void setShowCheckValueAndUnit(CheckRecordFileCheckResultVo resultVo) {
        if (resultVo.getCheckValueType().equals(1)) {
            resultVo.setShowCheckValue(this.getShowCheckValue(resultVo));
        } else {
            resultVo.setShowCheckValue(ResultUtils.getRange((Integer)resultVo.getCheckValueRangeType(), (String)resultVo.getCheckValueMin(), (String)resultVo.getCheckValueMax()));
        }
        if (resultVo.getCheckUnit() != null && !resultVo.getCheckUnit().isEmpty()) {
            resultVo.setShowUnit(resultVo.getTargetName() + "(" + resultVo.getCheckUnit() + ")");
        } else if (resultVo.getUnit() != null && !resultVo.getUnit().isEmpty()) {
            if (resultVo.getUnit().contains("(") || resultVo.getUnit().contains("\uff08")) {
                resultVo.setShowUnit(resultVo.getTargetName() + "[" + resultVo.getUnit() + "]");
            } else {
                resultVo.setShowUnit(resultVo.getTargetName() + "(" + resultVo.getUnit() + ")");
            }
        } else {
            resultVo.setShowUnit(resultVo.getTargetName());
        }
    }

    private String getShowCheckValue(CheckRecordFileCheckResultVo resultVo) {
        Integer targetId = resultVo.getTargetId();
        switch (targetId) {
            case 25: {
                return CheckUtils.getNoiseType(resultVo.getCheckValue());
            }
            case 35: {
                return CheckUtils.getValue35(resultVo.getCheckValue());
            }
            case 39: {
                return CheckUtils.getValue39(resultVo.getCheckValue());
            }
            case 58: {
                return CheckUtils.getValue58(resultVo.getCheckValue());
            }
            case 71: {
                return CheckUtils.getValue71(resultVo.getCheckValue());
            }
            case 89: {
                return CheckUtils.getValue89(resultVo.getCheckValue());
            }
            case 91: {
                return CheckUtils.getValue91(resultVo.getCheckValue());
            }
            case 93: 
            case 94: 
            case 95: {
                return ResultUtils.getRadiation((Integer)resultVo.getCheckValueRangeType(), (String)resultVo.getCheckValue());
            }
            case 117: {
                return CheckUtils.getValue117(resultVo.getCheckValue());
            }
        }
        return resultVo.getCheckValue();
    }
}

