/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.entity.RayDevice;
import cn.smarthse.services.hfi.api.entity.RaySourceDevice;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import cn.smarthse.services.hfi.api.model.result.BiologicalListModel;
import cn.smarthse.services.hfi.api.model.result.ChemicalListModel;
import cn.smarthse.services.hfi.api.model.result.DustListModel;
import cn.smarthse.services.hfi.api.model.result.FreshAirRateListModel;
import cn.smarthse.services.hfi.api.model.result.HandTranSmittedListModel;
import cn.smarthse.services.hfi.api.model.result.HighFrequencyListModel;
import cn.smarthse.services.hfi.api.model.result.HighTemperatureListModel;
import cn.smarthse.services.hfi.api.model.result.IlluminancyListModel;
import cn.smarthse.services.hfi.api.model.result.IonizingRadiationListModel;
import cn.smarthse.services.hfi.api.model.result.LaserRadiationListModel;
import cn.smarthse.services.hfi.api.model.result.ListParamModel;
import cn.smarthse.services.hfi.api.model.result.MicroclimateListModel;
import cn.smarthse.services.hfi.api.model.result.MicrowaveRadiationListModel;
import cn.smarthse.services.hfi.api.model.result.NoiseListModel;
import cn.smarthse.services.hfi.api.model.result.PowerFrequencyListModel;
import cn.smarthse.services.hfi.api.model.result.RadiateRiskListModel;
import cn.smarthse.services.hfi.api.model.result.RayDeviceExportModel;
import cn.smarthse.services.hfi.api.model.result.RayDeviceFormModel;
import cn.smarthse.services.hfi.api.model.result.RaySourceDeviceExportModel;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import cn.smarthse.services.hfi.api.model.result.UltrahighFrequencyRadiationListModel;
import cn.smarthse.services.hfi.api.model.result.UltravioletLightListModel;
import cn.smarthse.services.hfi.api.model.result.WindSpeedListModel;
import cn.smarthse.services.hfi.api.service.ICheckResultPageService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.IRayDeviceService;
import cn.smarthse.services.hfi.api.service.IRaySourceDeviceService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.serviceimp.FactorService;
import cn.smarthse.services.hfi.sys.SysConstants;
import cn.smarthse.services.hfi.util.CheckUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@DubboService(timeout=50000)
public class CheckResultPageServiceImpl
implements ICheckResultPageService {
    @DubboReference(version="1.0.0", timeout=30000)
    IHarmFactorService harmFactorService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;
    @Autowired
    IRayDeviceService rayDeviceService;
    @Autowired
    IRaySourceDeviceService raySourceDeviceService;
    @Autowired
    @Lazy
    private ICheckResultService checkResultService;
    @Autowired
    private IRiskExposeEvaluateDataService evaluateDataService;
    @Autowired
    @Lazy
    private FactorService factorService;

    private List<CheckResult> getResults(ListParamModel param) {
        if (param == null || param.getCheckId() == null || param.getItemId() == null) {
            return Collections.emptyList();
        }
        return this.checkResultService.queryResult(param.getCheckId(), param.getItemId());
    }

    private List<CheckResult> getResults2(ListParamModel param) {
        if (param == null || param.getCheckId() == null || param.getItemId() == null) {
            return Collections.emptyList();
        }
        return this.checkResultService.queryResultToHse(param);
    }

    private Map<Long, List<CheckResult>> getRows(ListParamModel param) {
        List<CheckResult> list = this.getResults2(param);
        Map<Long, List<CheckResult>> longListMap = ResultUtils.splitByRowNum(list);
        longListMap = this.filterResult(longListMap, param);
        longListMap = this.filterHarm(longListMap, param);
        longListMap = this.filterCheckPoint(longListMap, param);
        return longListMap;
    }

    private Map<Long, List<CheckResult>> filterHarm(Map<Long, List<CheckResult>> longListMap, ListParamModel param) {
        Map<Long, List<CheckResult>> longListMap2 = longListMap;
        if (param.getHarmId() != null && param.getHarmId().length() > 0) {
            List<Integer> harmIdTargets = Arrays.asList(2, 12, 98);
            longListMap2 = new HashMap<Long, List<CheckResult>>();
            block0: for (Map.Entry<Long, List<CheckResult>> entry : longListMap.entrySet()) {
                List<CheckResult> results = entry.getValue();
                for (CheckResult result : results) {
                    if (!harmIdTargets.contains(result.getTargetId()) || !result.getCheckValue().equals(param.getHarmId())) continue;
                    longListMap2.put(entry.getKey(), entry.getValue());
                    continue block0;
                }
            }
        }
        return longListMap2;
    }

    private Map<Long, List<CheckResult>> filterResult(Map<Long, List<CheckResult>> longListMap, ListParamModel param) {
        Map<Long, List<CheckResult>> longListMap2 = longListMap;
        if (param.getJudgeResult() != null && !param.getJudgeResult().isEmpty()) {
            String judgeResult = "";
            longListMap2 = new HashMap<Long, List<CheckResult>>();
            for (Map.Entry<Long, List<CheckResult>> entry : longListMap.entrySet()) {
                judgeResult = this.checkResultService.getJudgeResult(entry.getValue());
                if (!judgeResult.equals(param.getJudgeResult())) continue;
                longListMap2.put(entry.getKey(), entry.getValue());
            }
        }
        return longListMap2;
    }

    private Map<Long, List<CheckResult>> filterCheckPoint(Map<Long, List<CheckResult>> longListMap, ListParamModel param) {
        Map<Long, List<CheckResult>> longListMap2 = longListMap;
        if (param.getCheckPoints() != null) {
            longListMap2 = new HashMap<Long, List<CheckResult>>();
            block0: for (Map.Entry<Long, List<CheckResult>> entry : longListMap.entrySet()) {
                List<CheckResult> results = entry.getValue();
                for (CheckResult result : results) {
                    if (!SysConstants.CHECK_POINT_TARGETS.contains(result.getTargetId()) || !param.getCheckPoints().contains(result.getCheckValue())) continue;
                    longListMap2.put(entry.getKey(), entry.getValue());
                    continue block0;
                }
            }
        }
        return longListMap2;
    }

    public PageInfo<BiologicalListModel> biologicalPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        Map<String, String> allHarmMap = this.factorService.harmIdAndNameMap(param.getCheckId());
        List pageList = BiologicalListModel.covertMap(map, allHarmMap);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<ChemicalListModel> chemicalPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        Map<String, String> allHarmMap = this.factorService.harmIdAndNameMap(param.getCheckId());
        List pageList = ChemicalListModel.covertMap(map, allHarmMap);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<DustListModel> dustPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        Map<String, String> allHarmMap = this.factorService.harmIdAndNameMap(param.getCheckId());
        List pageList = DustListModel.covertMap(map, allHarmMap);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<FreshAirRateListModel> freshAirRatePage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = FreshAirRateListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<HandTranSmittedListModel> handTranSmittedPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = HandTranSmittedListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<HighFrequencyListModel> highFrequencyPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = HighFrequencyListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<HighTemperatureListModel> highTemperaturePage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = HighTemperatureListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<IlluminancyListModel> illuminancyPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = IlluminancyListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<RayDevice> ionizingRadiationPage(Long checkId, int pageNum, int pageSize) {
        return this.rayDeviceService.pageByCheck(checkId, pageNum, pageSize);
    }

    public List<IonizingRadiationListModel> ionizingRadiationCheckPage(Long deviceId) {
        return this.rayDeviceList(deviceId, 76);
    }

    public List<IonizingRadiationListModel> rayDeviceList(Long deviceId, Integer i) {
        List list = this.checkResultService.queryIonizingRadiationResult(deviceId, i.intValue());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.EMPTY_LIST;
        }
        Map resultRowMap = ResultUtils.splitByRowNum((List)list);
        List models = IonizingRadiationListModel.covertMap((Map)resultRowMap);
        return models;
    }

    public List<IonizingRadiationListModel> ionizingRadiationCheckSourcePage(Long sourceId) {
        return this.rayDeviceList(sourceId, 80);
    }

    public PageInfo<RaySourceDevice> ionizingRadiationSourcePage(Long checkId, int pageNum, int pageSize) {
        return this.raySourceDeviceService.pageByCheck(checkId, pageNum, pageSize);
    }

    public PageInfo<LaserRadiationListModel> laserRadiationPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = LaserRadiationListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<MicroclimateListModel> microclimatePage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = MicroclimateListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<MicrowaveRadiationListModel> microwaveRadiationPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = MicrowaveRadiationListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<NoiseListModel> noisePage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = NoiseListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<PowerFrequencyListModel> powerFrequencyPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = PowerFrequencyListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<UltrahighFrequencyRadiationListModel> ultrahighFrequencyRadiationPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = UltrahighFrequencyRadiationListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<UltravioletLightListModel> ultravioletLightPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = UltravioletLightListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<WindSpeedListModel> windSpeedPage(JqGridParam jparam, ListParamModel param) {
        Map<Long, List<CheckResult>> map = this.getRows(param);
        List pageList = WindSpeedListModel.covertMap(map);
        pageList = pageList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseResultListMode::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList());
        return PageUtil.getPageInfo(pageList, (int)jparam.getPage(), (int)jparam.getRows());
    }

    public PageInfo<RadiateRiskListModel> radiateRiskPage(JqGridParam jparam, ListParamModel param) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<RadiateRiskListModel> radiateRiskListModels = this.radiateRiskList(param);
        return new PageInfo(radiateRiskListModels);
    }

    public List<BiologicalListModel> biologicalList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        Map<String, String> allHarmMap = this.factorService.harmIdAndNameMap(checkId);
        List resultList = BiologicalListModel.covertMap((Map)map, allHarmMap);
        return resultList;
    }

    public List<ChemicalListModel> chemicalList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        Map<String, String> allHarmMap = this.factorService.harmIdAndNameMap(checkId);
        List resultList = ChemicalListModel.covertMap((Map)map, allHarmMap);
        return resultList;
    }

    public List<DustListModel> dustList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        Map<String, String> allHarmMap = this.factorService.harmIdAndNameMap(checkId);
        List resultList = DustListModel.covertMap((Map)map, allHarmMap);
        return resultList;
    }

    public List<FreshAirRateListModel> freshAirRateList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = FreshAirRateListModel.covertMap((Map)map);
        return resultList;
    }

    public List<HandTranSmittedListModel> handTranSmittedList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = HandTranSmittedListModel.covertMap((Map)map);
        return resultList;
    }

    public List<HighFrequencyListModel> highFrequencyList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = HighFrequencyListModel.covertMap((Map)map);
        return resultList;
    }

    public List<HighTemperatureListModel> highTemperatureList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = HighTemperatureListModel.covertMap((Map)map);
        return resultList;
    }

    public List<IlluminancyListModel> illuminancyList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = IlluminancyListModel.covertMap((Map)map);
        return resultList;
    }

    public List<RayDeviceExportModel> ionizingRadiationList(Long checkId) {
        List rayDevices = this.rayDeviceService.listByCheck(checkId);
        ArrayList<RayDeviceExportModel> resultList = new ArrayList<RayDeviceExportModel>();
        if (CollectionUtils.isEmpty((Collection)rayDevices)) {
            return resultList;
        }
        rayDevices.forEach(ray -> {
            List<IonizingRadiationListModel> list = this.rayDeviceList(ray.getId(), 76);
            for (IonizingRadiationListModel listModel : list) {
                RayDeviceExportModel model = new RayDeviceExportModel();
                BeanUtils.copyProperties((Object)ray, (Object)model);
                model.setJudged(listModel.getJudged());
                String strRangeType = CheckUtils.getStrRangeType("" + listModel.getCheckResultType());
                if (strRangeType.equals("-")) {
                    strRangeType = "";
                }
                model.setCheckResult(strRangeType + listModel.getCheckResult());
                model.setCheckResultType(listModel.getCheckResultType());
                model.setPosition(listModel.getPosition());
                resultList.add(model);
            }
        });
        return resultList;
    }

    public List<RaySourceDeviceExportModel> ionizingRadiationSourceList(Long checkId) {
        List rayDevices = this.raySourceDeviceService.listByCheck(checkId);
        ArrayList<RaySourceDeviceExportModel> resultList = new ArrayList<RaySourceDeviceExportModel>();
        if (CollectionUtils.isEmpty((Collection)rayDevices)) {
            return resultList;
        }
        rayDevices.forEach(ray -> {
            List<IonizingRadiationListModel> list = this.rayDeviceList(ray.getId(), 80);
            for (IonizingRadiationListModel listModel : list) {
                RaySourceDeviceExportModel model = new RaySourceDeviceExportModel();
                BeanUtils.copyProperties((Object)ray, (Object)model);
                model.setJudged(listModel.getJudged());
                String strRangeType = CheckUtils.getStrRangeType("" + listModel.getCheckResultType());
                if (strRangeType.equals("-")) {
                    strRangeType = "";
                }
                model.setCheckResult(strRangeType + listModel.getCheckResult());
                model.setCheckResultType(listModel.getCheckResultType());
                model.setPosition(listModel.getPosition());
                resultList.add(model);
            }
        });
        return resultList;
    }

    public List<LaserRadiationListModel> laserRadiationList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = LaserRadiationListModel.covertMap((Map)map);
        return resultList;
    }

    public List<MicroclimateListModel> microclimateList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = MicroclimateListModel.covertMap((Map)map);
        return resultList;
    }

    public List<MicrowaveRadiationListModel> microwaveRadiationList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = MicrowaveRadiationListModel.covertMap((Map)map);
        return resultList;
    }

    public List<NoiseListModel> noiseList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = NoiseListModel.covertMap((Map)map);
        return resultList;
    }

    public List<PowerFrequencyListModel> powerFrequencyList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = PowerFrequencyListModel.covertMap((Map)map);
        return resultList;
    }

    public List<UltrahighFrequencyRadiationListModel> ultrahighFrequencyRadiationList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = UltrahighFrequencyRadiationListModel.covertMap((Map)map);
        return resultList;
    }

    public List<UltravioletLightListModel> ultravioletLightList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = UltravioletLightListModel.covertMap((Map)map);
        return resultList;
    }

    public List<WindSpeedListModel> windSpeedPList(Long checkId, Long itemId) {
        List list = this.checkResultService.queryResult(checkId, itemId);
        Map map = ResultUtils.splitByRowNum((List)list);
        List resultList = WindSpeedListModel.covertMap((Map)map);
        return resultList;
    }

    public List<RadiateRiskListModel> radiateRiskList(ListParamModel param) {
        return this.evaluateDataService.getRadiateRiskList(param);
    }

    public Integer getAllCountResultDataByHcId(Long hcId) {
        Long result = this.checkResultService.queryResult(hcId);
        List rayDevices = this.rayDeviceService.listByCheck(hcId);
        List ray2 = this.raySourceDeviceService.listByCheck(hcId);
        return result == null ? 0 : result.intValue() + (rayDevices == null ? 0 : rayDevices.size()) + (ray2 == null ? 0 : ray2.size());
    }

    @Transactional(readOnly=false)
    public void updateRayResult(RayDeviceFormModel model) {
        this.checkResultService.updateRayResult(model);
    }
}

