/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.entity.CheckSelectItem;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.api.service.ICheckOverPointService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultImportService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckSelectItemService;
import cn.smarthse.services.hfi.checkparser.CheckDataParser;
import cn.smarthse.services.hfi.checkparser.Parser10IonizingRadiationRayDevice;
import cn.smarthse.services.hfi.checkparser.Parser10IonizingRadiationRaySourceDevice;
import cn.smarthse.services.hfi.checkparser.Parser11HandVibration;
import cn.smarthse.services.hfi.checkparser.Parser12LaserRadiation;
import cn.smarthse.services.hfi.checkparser.Parser13Biology;
import cn.smarthse.services.hfi.checkparser.Parser14Illumination;
import cn.smarthse.services.hfi.checkparser.Parser15TinyWeather;
import cn.smarthse.services.hfi.checkparser.Parser16FreshAir;
import cn.smarthse.services.hfi.checkparser.Parser17AirSpeed;
import cn.smarthse.services.hfi.checkparser.Parser1Chemical;
import cn.smarthse.services.hfi.checkparser.Parser2Dust;
import cn.smarthse.services.hfi.checkparser.Parser3Noise;
import cn.smarthse.services.hfi.checkparser.Parser4HighTemperature;
import cn.smarthse.services.hfi.checkparser.Parser5UltravioletRay;
import cn.smarthse.services.hfi.checkparser.Parser6PowerFrequency;
import cn.smarthse.services.hfi.checkparser.Parser7MicrowaveRadiation;
import cn.smarthse.services.hfi.checkparser.Parser8HighFrequencyElectromagnetic;
import cn.smarthse.services.hfi.checkparser.Parser9UhfRadiation;
import cn.smarthse.services.hfi.checkparser.actualize.Parser10IonizingRadiationRayDeviceActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser10IonizingRadiationRaySourceDeviceActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser11HandVibrationActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser12LaserRadiationActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser13BiologyActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser14IlluminationActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser15TinyWeatherActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser16FreshAirActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser17AirSpeedActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser1ChemicalActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser2DustActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser3NoiseActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser4HighTemperatureActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser5UltravioletRayActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser6PowerFrequencyActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser7MicrowaveRadiationActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser8HighFrequencyElectromagneticActualize;
import cn.smarthse.services.hfi.checkparser.actualize.Parser9UhfRadiationActualize;
import cn.smarthse.services.hfi.serviceimp.FactorService;
import cn.smarthse.util.common.excel.model.ExcelModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class CheckResultImportServiceImpl
implements ICheckResultImportService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ICheckResultService checkResultService;
    private ICheckSelectItemService checkSelectItemService;
    private ICheckOverPointService checkOverPointService;
    private Map<String, CheckDataParser> parserMap = new HashMap<String, CheckDataParser>();
    private Map<String, CheckDataParser> parserActualizeMap = new HashMap<String, CheckDataParser>();
    private Map<String, Integer> sheetNameToItemIdMap = new HashMap<String, Integer>();
    private String[] sheetNames = new String[]{"\u5316\u5b66\u56e0\u7d20", "\u7c89\u5c18", "\u566a\u58f0", "\u9ad8\u6e29", "\u7d2b\u5916\u8f90\u5c04", "\u5de5\u9891\u7535\u573a", "\u5fae\u6ce2\u8f90\u5c04", "\u9ad8\u9891\u7535\u78c1\u573a", "\u8d85\u9ad8\u9891\u8f90\u5c04", "\u7535\u79bb\u8f90\u5c04-\u5c04\u7ebf\u88c5\u7f6e", "\u7535\u79bb\u8f90\u5c04-\u542b\u6e90\u88c5\u7f6e", "\u624b\u4f20\u632f\u52a8", "\u6fc0\u5149\u8f90\u5c04", "\u751f\u7269\u56e0\u7d20", "\u7167\u5ea6", "\u5fae\u5c0f\u6c14\u5019", "\u65b0\u98ce\u91cf", "\u63a7\u5236\u98ce\u901f"};
    @Autowired
    private Parser1Chemical parser1Chemical;
    @Autowired
    private Parser2Dust parser2Dust;
    @Autowired
    private Parser3Noise parser3Noise;
    @Autowired
    private Parser4HighTemperature parser4HighTemperature;
    @Autowired
    private Parser5UltravioletRay parser5UltravioletRay;
    @Autowired
    private Parser6PowerFrequency parser6PowerFrequency;
    @Autowired
    private Parser7MicrowaveRadiation parser7MicrowaveRadiation;
    @Autowired
    private Parser8HighFrequencyElectromagnetic parser8HighFrequencyElectromagnetic;
    @Autowired
    private Parser9UhfRadiation parser9UhfRadiation;
    @Autowired
    private Parser10IonizingRadiationRayDevice parser10IonizingRadiationRayDevice;
    @Autowired
    private Parser10IonizingRadiationRaySourceDevice parser10IonizingRadiationRaySourceDevice;
    @Autowired
    private Parser11HandVibration parser11HandVibration;
    @Autowired
    private Parser12LaserRadiation parser12LaserRadiation;
    @Autowired
    private Parser13Biology parser13Biology;
    @Autowired
    private Parser14Illumination parser14Illumination;
    @Autowired
    private Parser15TinyWeather parser15TinyWeather;
    @Autowired
    private Parser16FreshAir parser16FreshAir;
    @Autowired
    private Parser17AirSpeed parser17AirSpeed;
    @Autowired
    private Parser1ChemicalActualize parser1ChemicalActualize;
    @Autowired
    private Parser2DustActualize parser2DustActualize;
    @Autowired
    private Parser3NoiseActualize parser3NoiseActualize;
    @Autowired
    private Parser4HighTemperatureActualize parser4HighTemperatureActualize;
    @Autowired
    private Parser5UltravioletRayActualize parser5UltravioletRayActualize;
    @Autowired
    private Parser6PowerFrequencyActualize parser6PowerFrequencyActualize;
    @Autowired
    private Parser7MicrowaveRadiationActualize parser7MicrowaveRadiationActualize;
    @Autowired
    private Parser8HighFrequencyElectromagneticActualize parser8HighFrequencyElectromagneticActualize;
    @Autowired
    private Parser9UhfRadiationActualize parser9UhfRadiationActualize;
    @Autowired
    private Parser10IonizingRadiationRayDeviceActualize parser10IonizingRadiationRayDeviceActualize;
    @Autowired
    private Parser10IonizingRadiationRaySourceDeviceActualize parser10IonizingRadiationRaySourceDeviceActualize;
    @Autowired
    private Parser11HandVibrationActualize parser11HandVibrationActualize;
    @Autowired
    private Parser12LaserRadiationActualize parser12LaserRadiationActualize;
    @Autowired
    private Parser13BiologyActualize parser13BiologyActualize;
    @Autowired
    private Parser14IlluminationActualize parser14IlluminationActualize;
    @Autowired
    private Parser15TinyWeatherActualize parser15TinyWeatherActualize;
    @Autowired
    private Parser16FreshAirActualize parser16FreshAirActualize;
    @Autowired
    private Parser17AirSpeedActualize parser17AirSpeedActualize;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    @Autowired
    private ICheckPlanService checkPlanService;
    @Autowired
    private FactorService factorService;

    @Autowired
    public void autowired(ICheckResultService checkResultService, ICheckSelectItemService checkSelectItemService, ICheckOverPointService checkOverPointService) {
        this.checkResultService = checkResultService;
        this.checkSelectItemService = checkSelectItemService;
        this.checkOverPointService = checkOverPointService;
    }

    @PostConstruct
    public void init() {
        this.initParser();
        this.initSheetNameToItemIdMap();
    }

    @Transactional(readOnly=false)
    public void importResult(ExcelModel excelModel, ImportCheckParamBo param) throws ParseException {
        List sheets = excelModel.getSheets();
        LinkedList<CheckResult> rList = new LinkedList<CheckResult>();
        List oldSelectItems = this.checkSelectItemService.getByCheck(param.getCheckId());
        List<CheckSelectItem> checkSelectItems = new ArrayList<CheckSelectItem>(32);
        Object exceptionMsg = "";
        Map<String, String> factorNameToIdMap = null;
        factorNameToIdMap = param.getStandardId().equals(1L) ? this.factorService.getAllNameAndIdMap2007(param.getCid()) : (param.getStandardId().equals(2L) ? this.factorService.getAllNameAndIdMap2019(param.getCid()) : this.harmFactorService.getAllNameAndIdMap());
        for (SheetModel sheet : sheets) {
            String sheetName = sheet.getSheetName();
            CheckSelectItem checkSelectItem = this.buildSelectItem(oldSelectItems, sheetName, param.getCid(), param.getCheckId(), param.getCreateUserId());
            if (checkSelectItem != null) {
                checkSelectItems.add(checkSelectItem);
            }
            try {
                List<CheckResult> list = this.parseCheckData(sheet, param, factorNameToIdMap);
                rList.addAll(list);
            }
            catch (ParseException e) {
                exceptionMsg = (String)exceptionMsg + e.getMessage();
            }
        }
        if (((String)exceptionMsg).length() > 0) {
            throw new ParseException((String)exceptionMsg);
        }
        for (CheckResult checkResult : rList) {
            checkResult.setId(null);
            checkResult.setCheckId(param.getCheckId());
            checkResult.setCid(param.getCid());
            checkResult.setUpdateBy(param.getCreateUserId());
            checkResult.setCreateBy(param.getCreateUserId());
            checkResult.setCreateDate(LocalDateTime.now());
            checkResult.setUpdateDate(checkResult.getCreateDate());
            checkResult.setIsValid(Boolean.valueOf(true));
        }
        this.checkResultService.addOrUpdate(rList);
        checkSelectItems = this.delRepeat(checkSelectItems);
        this.checkSelectItemService.saveBatch(checkSelectItems);
    }

    public void importResultActualize(ExcelModel excelModel, ImportCheckParamBo param, String isActualize) throws ParseException {
        List sheets = excelModel.getSheets();
        LinkedList<CheckResult> rList = new LinkedList<CheckResult>();
        List oldSelectItems = this.checkSelectItemService.getByCheck(param.getCheckId());
        List<CheckSelectItem> checkSelectItems = new ArrayList<CheckSelectItem>(32);
        Object exceptionMsg = "";
        Map<String, String> factorNameToIdMap = null;
        factorNameToIdMap = param.getStandardId().equals(1L) ? this.factorService.getAllNameAndIdMap2007(param.getCid()) : (param.getStandardId().equals(2L) ? this.factorService.getAllNameAndIdMap2019(param.getCid()) : this.harmFactorService.getAllNameAndIdMap());
        for (SheetModel sheet : sheets) {
            String sheetName = sheet.getSheetName();
            CheckSelectItem checkSelectItem = this.buildSelectItem(oldSelectItems, sheetName, param.getCid(), param.getCheckId(), param.getCreateUserId());
            if (checkSelectItem != null) {
                checkSelectItems.add(checkSelectItem);
            }
            try {
                List<CheckResult> list = this.parseCheckData(sheet, param, factorNameToIdMap, isActualize);
                rList.addAll(list);
            }
            catch (ParseException e) {
                exceptionMsg = (String)exceptionMsg + e.getMessage();
            }
        }
        if (((String)exceptionMsg).length() > 0) {
            throw new ParseException((String)exceptionMsg);
        }
        for (CheckResult checkResult : rList) {
            checkResult.setId(null);
            checkResult.setCheckId(param.getCheckId());
            checkResult.setCid(param.getCid());
            checkResult.setUpdateBy(param.getCreateUserId());
            checkResult.setCreateBy(param.getCreateUserId());
            checkResult.setCreateDate(LocalDateTime.now());
            checkResult.setUpdateDate(checkResult.getCreateDate());
            checkResult.setIsValid(Boolean.valueOf(true));
        }
        this.checkResultService.addOrUpdate(rList);
        checkSelectItems = this.delRepeat(checkSelectItems);
        this.checkSelectItemService.saveBatch(checkSelectItems);
    }

    private List<CheckResult> parseCheckData(SheetModel sheetModel, ImportCheckParamBo param, Map<String, String> factorNameToIdMap) throws ParseException {
        CheckDataParser checkDataParser = this.selectParser(sheetModel.getSheetName());
        if (checkDataParser == null) {
            this.logger.warn("================================>\u68c0\u6d4b\u7ed3\u679c\u6570\u636e\u5bfc\u5165\u6ca1\u627e\u5230\u89e3\u6790\u5668sheetName:" + sheetModel.getSheetName() + "<============================");
            return Collections.emptyList();
        }
        return checkDataParser.parseData(sheetModel, param, factorNameToIdMap);
    }

    private List<CheckResult> parseCheckData(SheetModel sheetModel, ImportCheckParamBo param, Map<String, String> factorNameToIdMap, String isActualize) throws ParseException {
        CheckDataParser checkDataParser = this.selectActualizeParser(sheetModel.getSheetName());
        if (checkDataParser == null) {
            this.logger.warn("================================>\u68c0\u6d4b\u7ed3\u679c\u6570\u636e\u5bfc\u5165\u6ca1\u627e\u5230\u89e3\u6790\u5668sheetName:" + sheetModel.getSheetName() + "<============================");
            return Collections.emptyList();
        }
        return checkDataParser.parseData(sheetModel, param, factorNameToIdMap);
    }

    private CheckDataParser selectParser(String sheetName) {
        return this.parserMap.get(sheetName);
    }

    private CheckDataParser selectActualizeParser(String sheetName) {
        return this.parserActualizeMap.get(sheetName);
    }

    private CheckSelectItem buildSelectItem(List<CheckSelectItem> oldSelectItems, String sheetName, Long cid, Long checkId, Long createUserId) {
        Integer itemId = this.getItemIdBySheetName(sheetName);
        if (!this.exist(oldSelectItems, itemId) && itemId != null) {
            CheckSelectItem checkSelectItem = new CheckSelectItem();
            checkSelectItem.setCheckId(checkId);
            checkSelectItem.setCid(cid);
            checkSelectItem.setItemId(itemId);
            checkSelectItem.setCreateBy(createUserId);
            checkSelectItem.setUpdateBy(createUserId);
            checkSelectItem.setIsValid(Boolean.valueOf(true));
            checkSelectItem.setUpdateDate(LocalDateTime.now());
            checkSelectItem.setCreateDate(LocalDateTime.now());
            return checkSelectItem;
        }
        return null;
    }

    private boolean exist(List<CheckSelectItem> oldList, Integer itemId) {
        for (CheckSelectItem item : oldList) {
            if (!item.getItemId().equals(itemId)) continue;
            return true;
        }
        return false;
    }

    private Integer getItemIdBySheetName(String sheetName) {
        return this.sheetNameToItemIdMap.get(sheetName);
    }

    private void initParser() {
        this.logger.info("\u521d\u59cb\u5316\u68c0\u6d4b\u6570\u636e\u5bfc\u5165\u89e3\u6790\u5668");
        this.parserMap.put(this.sheetNames[0], this.parser1Chemical);
        this.parserMap.put(this.sheetNames[1], this.parser2Dust);
        this.parserMap.put(this.sheetNames[2], this.parser3Noise);
        this.parserMap.put(this.sheetNames[3], this.parser4HighTemperature);
        this.parserMap.put(this.sheetNames[4], this.parser5UltravioletRay);
        this.parserMap.put(this.sheetNames[5], this.parser6PowerFrequency);
        this.parserMap.put(this.sheetNames[6], this.parser7MicrowaveRadiation);
        this.parserMap.put(this.sheetNames[7], this.parser8HighFrequencyElectromagnetic);
        this.parserMap.put(this.sheetNames[8], this.parser9UhfRadiation);
        this.parserMap.put(this.sheetNames[9], this.parser10IonizingRadiationRayDevice);
        this.parserMap.put(this.sheetNames[10], this.parser10IonizingRadiationRaySourceDevice);
        this.parserMap.put(this.sheetNames[11], this.parser11HandVibration);
        this.parserMap.put(this.sheetNames[12], this.parser12LaserRadiation);
        this.parserMap.put(this.sheetNames[13], this.parser13Biology);
        this.parserMap.put(this.sheetNames[14], this.parser14Illumination);
        this.parserMap.put(this.sheetNames[15], this.parser15TinyWeather);
        this.parserMap.put(this.sheetNames[16], this.parser16FreshAir);
        this.parserMap.put(this.sheetNames[17], this.parser17AirSpeed);
        this.parserActualizeMap.put(this.sheetNames[0], this.parser1ChemicalActualize);
        this.parserActualizeMap.put(this.sheetNames[1], this.parser2DustActualize);
        this.parserActualizeMap.put(this.sheetNames[2], this.parser3NoiseActualize);
        this.parserActualizeMap.put(this.sheetNames[3], this.parser4HighTemperatureActualize);
        this.parserActualizeMap.put(this.sheetNames[4], this.parser5UltravioletRayActualize);
        this.parserActualizeMap.put(this.sheetNames[5], this.parser6PowerFrequencyActualize);
        this.parserActualizeMap.put(this.sheetNames[6], this.parser7MicrowaveRadiationActualize);
        this.parserActualizeMap.put(this.sheetNames[7], this.parser8HighFrequencyElectromagneticActualize);
        this.parserActualizeMap.put(this.sheetNames[8], this.parser9UhfRadiationActualize);
        this.parserActualizeMap.put(this.sheetNames[9], this.parser10IonizingRadiationRayDeviceActualize);
        this.parserActualizeMap.put(this.sheetNames[10], this.parser10IonizingRadiationRaySourceDeviceActualize);
        this.parserActualizeMap.put(this.sheetNames[11], this.parser11HandVibrationActualize);
        this.parserActualizeMap.put(this.sheetNames[12], this.parser12LaserRadiationActualize);
        this.parserActualizeMap.put(this.sheetNames[13], this.parser13BiologyActualize);
        this.parserActualizeMap.put(this.sheetNames[14], this.parser14IlluminationActualize);
        this.parserActualizeMap.put(this.sheetNames[15], this.parser15TinyWeatherActualize);
        this.parserActualizeMap.put(this.sheetNames[16], this.parser16FreshAirActualize);
        this.parserActualizeMap.put(this.sheetNames[17], this.parser17AirSpeedActualize);
    }

    private void initSheetNameToItemIdMap() {
        this.sheetNameToItemIdMap.put(this.sheetNames[0], 1);
        this.sheetNameToItemIdMap.put(this.sheetNames[1], 2);
        this.sheetNameToItemIdMap.put(this.sheetNames[2], 3);
        this.sheetNameToItemIdMap.put(this.sheetNames[3], 4);
        this.sheetNameToItemIdMap.put(this.sheetNames[4], 5);
        this.sheetNameToItemIdMap.put(this.sheetNames[5], 6);
        this.sheetNameToItemIdMap.put(this.sheetNames[6], 7);
        this.sheetNameToItemIdMap.put(this.sheetNames[7], 8);
        this.sheetNameToItemIdMap.put(this.sheetNames[8], 9);
        this.sheetNameToItemIdMap.put(this.sheetNames[9], 10);
        this.sheetNameToItemIdMap.put(this.sheetNames[10], 10);
        this.sheetNameToItemIdMap.put(this.sheetNames[11], 11);
        this.sheetNameToItemIdMap.put(this.sheetNames[12], 12);
        this.sheetNameToItemIdMap.put(this.sheetNames[13], 13);
        this.sheetNameToItemIdMap.put(this.sheetNames[14], 14);
        this.sheetNameToItemIdMap.put(this.sheetNames[15], 15);
        this.sheetNameToItemIdMap.put(this.sheetNames[16], 16);
        this.sheetNameToItemIdMap.put(this.sheetNames[17], 17);
    }

    private List<CheckSelectItem> delRepeat(List<CheckSelectItem> list) {
        ArrayList<CheckSelectItem> rList = new ArrayList<CheckSelectItem>(32);
        HashSet<Integer> itemIds = new HashSet<Integer>(32);
        for (CheckSelectItem item : list) {
            if (itemIds.contains(item.getItemId())) continue;
            itemIds.add(item.getItemId());
            rList.add(item);
        }
        return rList;
    }
}

