/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.services.hfi.api.entity.CheckPointIgnore;
import cn.smarthse.services.hfi.api.service.ICheckPointIgnoreService;
import cn.smarthse.services.hfi.mapper.CheckPointIgnoreMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class CheckPointIgnoreServiceImpl
extends BaseServiceImp<CheckPointIgnoreMapper, CheckPointIgnore>
implements ICheckPointIgnoreService {
    public void ignore(Long cid, List<Long> checkPointResultNos) {
        if (checkPointResultNos == null || checkPointResultNos.isEmpty() || cid == null) {
            return;
        }
        LinkedList<CheckPointIgnore> list = new LinkedList<CheckPointIgnore>();
        for (Long resultNo : checkPointResultNos) {
            CheckPointIgnore ignore = new CheckPointIgnore();
            ignore.setCid(cid);
            ignore.setResultNo(resultNo);
            ignore.setCreateBy(Long.valueOf(0L));
            ignore.setUpdateBy(Long.valueOf(0L));
            ignore.setIsValid(Boolean.valueOf(true));
            ignore.setCreateDate(LocalDateTime.now());
            ignore.setUpdateDate(LocalDateTime.now());
            list.add(ignore);
        }
        this.saveBatch(list);
    }

    public void removeIgnore(Long cid, List<Long> checkPointResultNos) {
        if (checkPointResultNos == null || checkPointResultNos.isEmpty() || cid == null) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(CheckPointIgnore::getCid, (Object)cid)).in(CheckPointIgnore::getResultNo, checkPointResultNos);
        this.remove((Wrapper)wrapper);
    }

    public List<Long> getByCid(Long cid) {
        return ((CheckPointIgnoreMapper)this.baseMapper).getByCid(cid);
    }
}

