/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.WandOpStateEnum;
import cn.smarthse.modules.health.provider.IHealthSysWorkRemindService;
import cn.smarthse.services.hfi.api.entity.CheckFactor;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.entity.CheckSelectItem;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.CheckPlanViewListModel;
import cn.smarthse.services.hfi.api.model.CheckPlanViewModel;
import cn.smarthse.services.hfi.api.model.ComCheckQueryModel;
import cn.smarthse.services.hfi.api.model.CountParamModel;
import cn.smarthse.services.hfi.api.model.OrgCheckNumModel;
import cn.smarthse.services.hfi.api.model.doc.Doc4CheckFile;
import cn.smarthse.services.hfi.api.model.list.CheckPlanList;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.model.smarthse.CheckPlanResultCountMdoel;
import cn.smarthse.services.hfi.api.model.smarthse.CountInfoModel;
import cn.smarthse.services.hfi.api.pojo.bo.CheckPlanCountBo;
import cn.smarthse.services.hfi.api.pojo.bo.CheckPointMonthCountBo;
import cn.smarthse.services.hfi.api.pojo.bo.ScaleCompanyCheckNumBo;
import cn.smarthse.services.hfi.api.pojo.vo.ComCheckPlanListVo;
import cn.smarthse.services.hfi.api.pojo.vo.ComLatestCheckDate;
import cn.smarthse.services.hfi.api.pojo.vo.HcCheckPlanCountDailyPageParamVo;
import cn.smarthse.services.hfi.api.pojo.vo.HcCheckPlanCountDailyPageVo;
import cn.smarthse.services.hfi.api.pojo.vo.HcCheckPlanCountMonthVo;
import cn.smarthse.services.hfi.api.pojo.vo.HcCheckPlanCountVo;
import cn.smarthse.services.hfi.api.service.ICheckFactorService;
import cn.smarthse.services.hfi.api.service.ICheckFactorTempService;
import cn.smarthse.services.hfi.api.service.ICheckHistoryDataService;
import cn.smarthse.services.hfi.api.service.ICheckOverPointService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckSelectItemService;
import cn.smarthse.services.hfi.api.service.ICheckSysService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.services.hfi.mapper.CheckPlanMapper;
import cn.smarthse.services.hfi.serviceimp.FactorService;
import cn.smarthse.services.wanda.api.entity.WandaBaseData;
import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheck;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheckFactors;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheckTarget;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@DubboService
public class CheckPlanServiceImpl
extends BaseServiceImp<CheckPlanMapper, CheckPlan>
implements ICheckPlanService {
    @Autowired
    private IdWorker snowFlake;
    @Autowired
    private ICheckSysService checkSysService;
    @Autowired
    private ICheckOverPointService checkOverPointService;
    @Autowired
    @Lazy
    private ICheckResultService resultService;
    @Autowired
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @Autowired
    private IRiskExposeEvaluateDataService evaluateDataService;
    @Autowired
    private ICheckPlanService checkPlanService;
    @Autowired
    private ICheckFactorService checkFactorService;
    @Autowired
    private FactorService factorService;
    @DubboReference(check=false)
    private IBusinessDataUpdateRefreshService refreshService;
    @Autowired
    private ICheckHistoryDataService checkHistoryDataService;
    @Autowired
    private ICheckSelectItemService checkSelectItemService;
    @Autowired
    private ICheckResultService checkResultService;
    @Autowired
    private IHarmFactorService harmFactorService;
    @DubboReference(check=false)
    private IHealthSysWorkRemindService healthSysWorkRemindService;
    @DubboReference(check=false)
    private IWandaCheckBackPushLogService backPushLogService;
    @Value(value="${spring.profiles.active:}")
    private String environment;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ICheckFactorTempService checkFactorTempService;
    @DubboReference
    private ISysFileProvideService fileProvideService;
    @Autowired
    protected IdWorker idworker;

    public boolean saveOrUpdate(CheckPlan entity) {
        this.healthSysWorkRemindService.checkPlanUpdateWorkRemind(entity.getCid());
        boolean b = super.saveOrUpdate((Object)entity);
        this.checkSysService.updateCid(entity.getId(), entity.getCid());
        return b;
    }

    public List<CheckPlan> queryForOverRate() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime lastYear = now.minusYears(1L);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(CheckPlan::getCheckType, (Object)2)).eq(CheckPlan::getCheckFrom, (Object)2)).eq(CheckPlan::getReportStatus, (Object)2)).eq(BaseEntity::getIsValid, (Object)true)).between(CheckPlan::getGiveReportDate, (Object)lastYear, (Object)now)).orderByAsc(CheckPlan::getCid);
        return this.list((Wrapper)queryWrapper);
    }

    public List<Long> getAllCid() {
        return ((CheckPlanMapper)this.baseMapper).getAllCid();
    }

    public List<Long> getCheckIdByDateRange(LocalDateTime startDate, LocalDateTime endDate, Integer reportStatus, Integer checkType) {
        return ((CheckPlanMapper)this.baseMapper).getCheckIdByDateRange(startDate, endDate, reportStatus, checkType);
    }

    public LocalDateTime getLastCheckStartTimeByOrg(Long orgId, List<Long> cids) {
        if (orgId == null || cids == null || cids.isEmpty()) {
            return null;
        }
        if (cids.size() > 200) {
            List<Long> allCid = this.getAllCid();
            cids.retainAll(allCid);
        }
        if (cids.isEmpty()) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.queryWrapperIn(queryWrapper, CheckPlan::getCid, cids).eq(CheckPlan::getCheckType, (Object)2)).eq(CheckPlan::getCheckFrom, (Object)2)).eq(BaseEntity::getIsValid, (Object)true)).eq(CheckPlan::getThirdOrgId, (Object)orgId)).orderByDesc(CheckPlan::getCheckDateBegin);
        Page page = new Page(1L, 1L);
        IPage rPage = this.page((IPage)page, (Wrapper)queryWrapper);
        List records = rPage.getRecords();
        if (records != null && !records.isEmpty()) {
            return ((CheckPlan)records.get(0)).getCheckDateBegin();
        }
        return null;
    }

    public List<ComLatestCheckDate> getComLatestCheckDate() {
        return ((CheckPlanMapper)this.baseMapper).getComLatestCheckDate();
    }

    public List<CheckPlanList> getCheckPlanList(CheckPlanListParam param) {
        Object harms;
        Map<Long, String> collect;
        List<Long> checkIds;
        List<CheckPlanList> list = ((CheckPlanMapper)this.baseMapper).getCheckPlanList(param);
        HashMap<Long, String> checkIdsAndHarms = new HashMap<Long, String>();
        if (param.getIfNeedHarms() != null && param.getIfNeedHarms().booleanValue() && !CollectionUtils.isEmpty(checkIds = list.stream().filter(Objects::nonNull).map(CheckPlanList::getId).distinct().collect(Collectors.toList())) && !CollectionUtils.isEmpty(collect = (harms = ((CheckPlanMapper)this.baseMapper).getContactCheckHarmsByCheckIds(checkIds)).stream().filter(Objects::nonNull).collect(Collectors.toMap(CheckPlanList::getId, CheckPlanList::getHarms, (k1, k2) -> k2)))) {
            checkIdsAndHarms.putAll(collect);
        }
        this.calculateCheckOverRate(list);
        ArrayList<Long> riskExposeEvaluateIds = new ArrayList<Long>();
        for (CheckPlanList item : list) {
            if (item == null) continue;
            if (item.getRiskExposeEvaluateId() != null) {
                riskExposeEvaluateIds.add(item.getRiskExposeEvaluateId());
            }
            if (item.getCheckType() != null && HcCheckTypeEnum.getThisEnumByValue((Long)item.getCheckType()) != null) {
                item.setCheckTypeName(HcCheckTypeEnum.getThisEnumByValue((Long)item.getCheckType()).getName());
            }
            if (item.getRate() != null) {
                DecimalFormat decimalFormat = new DecimalFormat("###################.###########");
                String rate = item.getRate();
                rate = decimalFormat.format(Double.parseDouble(rate) * 100.0);
                item.setRate(rate + "%");
            }
            if (item.getId() == null || CollectionUtils.isEmpty(checkIdsAndHarms)) continue;
            String s = (String)checkIdsAndHarms.get(item.getId());
            item.setHarms(s);
        }
        if (CollectionUtils.isNotEmpty(riskExposeEvaluateIds)) {
            Map collect2 = ((CheckPlanMapper)this.baseMapper).getFangSheCountByRiskExposeEvaluateIds(riskExposeEvaluateIds).stream().filter(Objects::nonNull).collect(Collectors.toMap(CheckOverPoint::getCheckId, Function.identity(), (o1, o2) -> o1));
            for (CheckPlanList item : list) {
                if (item == null || item.getRiskExposeEvaluateId() == null || collect2.get(item.getRiskExposeEvaluateId()) == null) continue;
                CheckOverPoint checkOverPoint = (CheckOverPoint)collect2.get(item.getRiskExposeEvaluateId());
                item.setCheckPoints(Integer.valueOf((item.getCheckPoints() == null ? 0 : item.getCheckPoints()) + checkOverPoint.getCheckPoint()));
                item.setOverPoints(Integer.valueOf((item.getOverPoints() == null ? 0 : item.getOverPoints()) + checkOverPoint.getOverPoint()));
            }
        }
        return list;
    }

    public PageInfo<CheckPlanList> getCheckPlanPage(JqGridParam jparam, CheckPlanListParam param, Boolean count) {
        if (param.getHasEemptyResult() != null && param.getHasEemptyResult().equals(true)) {
            List checkIds = this.resultService.queryHaveEmptyResultCheckIds();
            if (checkIds == null || checkIds.isEmpty()) {
                return new PageInfo();
            }
            param.setCheckIds(checkIds);
        }
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows(), (boolean)count);
        this.setSortColumn(jparam, param);
        List<CheckPlanList> list = this.getCheckPlanList(param);
        return new PageInfo(list);
    }

    public Long getCheckPlanIdBySearch(CheckPlanListParam param) {
        if (param.getHasEemptyResult() != null && param.getHasEemptyResult().equals(true)) {
            List checkIds = this.resultService.queryHaveEmptyResultCheckIds();
            if (checkIds == null || checkIds.isEmpty()) {
                return null;
            }
            param.setCheckIds(checkIds);
        }
        return ((CheckPlanMapper)this.baseMapper).getCheckPlanIdBySearch(param);
    }

    public List<CheckPlan> getLastCheckPlanInfo(CheckPlanListParam param) {
        if (param == null || param.getCid() == null && CollectionUtils.isEmpty((Collection)param.getCids())) {
            return Collections.emptyList();
        }
        return ((CheckPlanMapper)this.baseMapper).getLastCheckPlanInfo(param);
    }

    private void setSortColumn(JqGridParam jparam, CheckPlanListParam param) {
        String sidx;
        String sord = jparam.getSord();
        if (sord == null || sord.isEmpty()) {
            sord = "asc";
        }
        if ("reportStatus".equals(sidx = jparam.getSidx())) {
            param.setReportStatusSortType(sord);
            return;
        }
        if ("reportTime".equals(sidx)) {
            param.setReportDateSortType(sord);
            return;
        }
        if ("companyName".equals(sidx)) {
            param.setCompanyNameSortType(sord);
            return;
        }
        if ("giveReportTime".equals(sidx)) {
            param.setGiveReportTimeSortType(sord);
            return;
        }
        if ("checkBeginTime".equals(sidx)) {
            param.setCheckBeginTimeSortType(sord);
            return;
        }
        if ("checkPoints".equals(sidx)) {
            param.setCheckPointsSortType(sord);
            return;
        }
        if ("passPoints".equals(sidx)) {
            param.setPassPointsSortType(sord);
            return;
        }
        if ("overPoints".equals(sidx)) {
            param.setOverPointsSortType(sord);
            return;
        }
        if ("overRate".equals(sidx)) {
            param.setOverRateSortType(sord);
            return;
        }
    }

    public Integer countComNumByYearByArea(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return ((CheckPlanMapper)this.baseMapper).countComNumByYearByArea(areaId, areaLevel, year, ownLevel);
    }

    public Integer countComNumByTimeRangeByArea(Long areaId, Byte areaLevel, LocalDateTime start, LocalDateTime end, Byte ownLevel) {
        return ((CheckPlanMapper)this.baseMapper).countComNumByTimeRangeByArea(areaId, areaLevel, start, end, ownLevel);
    }

    public Integer countComNumByYearByIndustryByArea(Long areaId, Byte areaLevel, List<Long> industryIds, LocalDateTime start, LocalDateTime end, Byte ownLevel) {
        if (industryIds == null || industryIds.isEmpty()) {
            return 0;
        }
        return ((CheckPlanMapper)this.baseMapper).countComNumByYearByIndustryByArea(areaId, areaLevel, industryIds, start, end, ownLevel);
    }

    public Integer countComNumByTimeRangeByFactorByArea(Long areaId, Byte areaLevel, List<Long> cids, LocalDateTime start, LocalDateTime end, Byte ownLevel) {
        return ((CheckPlanMapper)this.baseMapper).countComNumByTimeRangeByFactorByArea(areaId, areaLevel, cids, start, end, ownLevel);
    }

    public List<ScaleCompanyCheckNumBo> countComNumByAreaGroupByScale(Long areaId, Byte areaLevel, LocalDateTime start, LocalDateTime end, Byte ownLevel) {
        return ((CheckPlanMapper)this.baseMapper).countComNumByAreaGroupByScale(areaId, areaLevel, start, end, ownLevel);
    }

    public CheckPlan getDetailById(Long id) {
        CheckPlan hc = (CheckPlan)this.getById(id);
        if (hc != null && hc.getThirdOrgId() != null) {
            hc.setThirdOrgName(((CheckPlanMapper)this.baseMapper).getOrgName(hc.getThirdOrgId()));
        }
        if (hc == null) {
            return new CheckPlan();
        }
        return hc;
    }

    @Transactional(readOnly=false)
    public void reback(Long id, Long updateBy) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BaseEntity::getId, (Object)id)).set(CheckPlan::getReportStatus, (Object)3)).set(BaseEntity::getUpdateBy, (Object)updateBy)).set(BaseEntity::getUpdateDate, (Object)new Date());
        this.update((Wrapper)wrapper);
        this.riskExposeEvaluateService.deleteByCheckId(id);
    }

    public CheckPlanResultCountMdoel smarthseCount(Integer year, Long cid) {
        List<CountInfoModel> infos = ((CheckPlanMapper)this.baseMapper).countSmarthseInfo(cid);
        return this.parseCheckPlanResultCountMdoel(infos, year);
    }

    private CheckPlanResultCountMdoel parseCheckPlanResultCountMdoel(List<CountInfoModel> infos, int year) {
        CheckPlanResultCountMdoel model = new CheckPlanResultCountMdoel();
        model.setTotalChecks(Integer.valueOf(0));
        model.setYearChecks(Integer.valueOf(0));
        model.setYearFails(Integer.valueOf(0));
        if (CollectionUtils.isEmpty(infos)) {
            return model;
        }
        HashSet<Long> yearIds = new HashSet<Long>();
        HashSet<Long> allIds = new HashSet<Long>();
        int yearOvers = 0;
        for (CountInfoModel info : infos) {
            int checkYear = info.getYear();
            Long id = info.getId();
            int overs = info.getOvers();
            if (checkYear == year) {
                yearIds.add(id);
                yearOvers += overs;
            }
            allIds.add(id);
        }
        model.setTotalChecks(Integer.valueOf(allIds.size()));
        model.setYearChecks(Integer.valueOf(yearIds.size()));
        model.setYearFails(Integer.valueOf(yearOvers));
        return model;
    }

    public CheckPlanResultCountMdoel comCheckPlanCount(Integer year, Long cid) {
        List<CountInfoModel> infos = ((CheckPlanMapper)this.baseMapper).comCheckPlanCount(cid);
        return this.parseCheckPlanResultCountMdoel(infos, year);
    }

    public void deleteById(Long id, Long userId) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BaseEntity::getId, (Object)id)).set(BaseEntity::getUpdateBy, (Object)userId)).set(BaseEntity::getUpdateDate, (Object)LocalDateTime.now())).set(BaseEntity::getIsValid, (Object)false);
        this.update((Wrapper)updateWrapper);
    }

    @Transactional(readOnly=false)
    public CheckPlan getNotValidHcCheckThirdOrgPlan(Long cid, Long createBy, Integer checkType, Integer from) {
        CheckPlan hc = new CheckPlan();
        hc.setId(Long.valueOf(this.snowFlake.nextId()));
        hc.setIsValid(Boolean.valueOf(true));
        hc.setCid(cid);
        hc.setCheckFrom(from);
        hc.setCheckPlanType(checkType);
        hc.setReportStatus(Integer.valueOf(1));
        hc.setCreateBy(createBy);
        hc.setUpdateBy(createBy);
        hc.setCreateDate(LocalDateTime.now());
        hc.setUpdateDate(LocalDateTime.now());
        return hc;
    }

    public CheckPlan getByEvaluateId(Long evaluateId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckPlan::getEvaluateId, (Object)evaluateId);
        return (CheckPlan)this.getOne((Wrapper)queryWrapper);
    }

    public void deleteByEvaluateId(Long evaluateId) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.eq(CheckPlan::getEvaluateId, (Object)evaluateId)).set(BaseEntity::getIsValid, (Object)false);
        this.update((Wrapper)updateWrapper);
    }

    public List<CheckPlan> getByStartDateAndEndDateRange(Long cid, LocalDateTime endDateMin, LocalDateTime startDateMax) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckPlan::getCid, (Object)cid)).gt(CheckPlan::getCheckDateEnd, (Object)endDateMin)).lt(CheckPlan::getCheckDateBegin, (Object)startDateMax)).orderByDesc(BaseEntity::getUpdateDate);
        return this.list((Wrapper)wrapper);
    }

    public CheckPlan getLatestByEndDateMin(Long cid, LocalDateTime endDateMax) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckPlan::getCid, (Object)cid)).eq(CheckPlan::getReportStatus, (Object)2)).lt(CheckPlan::getCheckDateEnd, (Object)endDateMax)).orderByDesc(CheckPlan::getCheckDateBegin, new SFunction[]{BaseEntity::getUpdateDate});
        List list = this.list((Wrapper)wrapper);
        if (list != null && !list.isEmpty()) {
            return (CheckPlan)list.get(0);
        }
        return null;
    }

    public CheckPlan getLatestOccHazardFac(Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckPlan::getCid, (Object)cid)).eq(CheckPlan::getReportStatus, (Object)2)).eq(CheckPlan::getCheckType, (Object)2)).orderByDesc(BaseEntity::getUpdateDate);
        List list = this.list((Wrapper)wrapper);
        if (list != null && !list.isEmpty()) {
            return (CheckPlan)list.get(0);
        }
        return null;
    }

    public CheckPlan getLatestByEndDateMinAndType(Long cid, LocalDateTime endDateMax, List<Long> checkTypes) {
        if (checkTypes == null || checkTypes.isEmpty()) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)true)).eq(CheckPlan::getCid, (Object)cid)).in(CheckPlan::getCheckType, checkTypes)).eq(CheckPlan::getReportStatus, (Object)2)).lt(CheckPlan::getCheckDateEnd, (Object)endDateMax)).orderByDesc(CheckPlan::getCheckDateBegin);
        List list = this.list((Wrapper)wrapper);
        if (list != null && !list.isEmpty()) {
            return (CheckPlan)list.get(0);
        }
        return null;
    }

    public Map<Long, Long> getCheckIdToStandardId() {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        List<CheckPlan> list = ((CheckPlanMapper)this.baseMapper).getCheckIdToStandardId();
        for (CheckPlan plan : list) {
            map.put(plan.getId(), plan.getTargetStandardId());
        }
        return map;
    }

    public List<Long> getCidList(Long areaId, Byte areaLevel, LocalDateTime start, LocalDateTime end) {
        return ((CheckPlanMapper)this.baseMapper).getCidList(areaId, areaLevel, start, end);
    }

    public List<Long> getUnCheckedOverPoint(List<Long> cidList) {
        return ((CheckPlanMapper)this.baseMapper).getUnCheckedOverPoint(cidList);
    }

    public Map<Long, Integer> countGroupByOrg(Long[] orgIds, Integer year, Long areaId, Byte areaLevel) {
        if (orgIds != null && orgIds.length == 0) {
            return new HashMap<Long, Integer>();
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        List<OrgCheckNumModel> list = ((CheckPlanMapper)this.baseMapper).countGroupByOrg(orgIds, year, areaId, areaLevel);
        for (OrgCheckNumModel orgCheckNumModel : list) {
            map.put(orgCheckNumModel.getOrgId(), orgCheckNumModel.getCheckNum());
        }
        return map;
    }

    public Integer countProjectNum(Integer year, Long areaId, Byte areaLevel, Byte ownLevel) {
        JqGridParam jqGridParam = new JqGridParam();
        jqGridParam.setPage(1);
        jqGridParam.setRows(10);
        CheckPlanListParam param = new CheckPlanListParam();
        param.setCheckTypes(Arrays.asList(2));
        param.setStatus(Arrays.asList(2));
        param.setAreaId(areaId);
        param.setAreaLevel(areaLevel);
        param.setOwnLevel(ownLevel);
        if (year != null) {
            try {
                param.setCheckDateBegin(cn.smarthse.util.common.date.DateUtils.parseDate((String)(year + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
                param.setCheckDateEnd(cn.smarthse.util.common.date.DateUtils.parseDate((String)(year + 1 + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        int num = (int)this.getCheckPlanPage(jqGridParam, param, true).getTotal();
        this.logger.info("\u5b9a\u671f\u68c0\u6d4b\u9879\u76ee\u6570:" + num);
        return num;
    }

    public Long[] getOrgIdByArea(Long areaId, Byte areaLevel, Byte ownLevel) {
        List<Long> longs = ((CheckPlanMapper)this.baseMapper).getOrgIdByArea(areaId, areaLevel, ownLevel);
        return longs.toArray(new Long[longs.size()]);
    }

    public List<Long> getOrgIdListByaArea(Long areaId, Byte areaLevel) {
        List<Long> list = ((CheckPlanMapper)this.baseMapper).getOrgIdListByArea(areaId, areaLevel);
        return list;
    }

    public PageInfo<ComCheckPlanListVo> comQueryList(ComCheckQueryModel queryModel, JqGridParam jqGridParam) {
        if (queryModel.getDeptIds() != null && queryModel.getDeptIds().isEmpty()) {
            return new PageInfo(Collections.EMPTY_LIST);
        }
        this.setQueryDeptIds(queryModel);
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<ComCheckPlanListVo> list = ((CheckPlanMapper)this.baseMapper).comQueryList(queryModel);
        return new PageInfo(list);
    }

    private void setQueryDeptIds(ComCheckQueryModel queryModel) {
        if (queryModel.getDeptIds() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Long deptId : queryModel.getDeptIds()) {
            sb.append(",");
            sb.append(deptId);
            sb.append(",");
            sb.append("|");
        }
        queryModel.setQueryDeptIds(sb.substring(0, sb.length() - 1));
    }

    public void removeCheckReport(Long checkId) {
        ((CheckPlanMapper)this.baseMapper).updateReportStatus(checkId, 4);
    }

    public void updateRelevanceStatus(Long checkId, Integer relevanceStatus) {
        ((CheckPlanMapper)this.baseMapper).updateRelevanceStatus(checkId, relevanceStatus);
    }

    private void calculateCheckOverRate(List<CheckPlanList> checkPlanList) {
        for (CheckPlanList planList : checkPlanList) {
            if (planList.getCheckPoints() == null || planList.getCheckPoints() <= 0 || planList.getOverPoints() == null) continue;
            planList.setOverRate(String.format("%.2f", (double)planList.getOverPoints().intValue() * 100.0 / (double)planList.getCheckPoints().intValue()) + "%");
        }
    }

    public List<Doc4CheckFile> getDoc4CheckFiles(Long cid, Integer year) {
        return ((CheckPlanMapper)this.baseMapper).getDoc4CheckFiles(cid, year);
    }

    public List<Long> getTpCompanyIdsFromHcCheck(Long cid, int year) {
        return ((CheckPlanMapper)this.baseMapper).getTpCompanyIdsFromHcCheck(cid, year);
    }

    public PageInfo<HcCheckPlanCountDailyPageVo> getHcCheckPlanCountDailyPage(JqGridParam jparam, HcCheckPlanCountDailyPageParamVo paramVo) {
        List<CheckPointMonthCountBo> checkPointMonthCountBos = this.queryCheckPointMonthCountBoByYear(paramVo.getCid(), paramVo.getYear());
        Map<Long, List<CheckPointMonthCountBo>> map = this.groupByDept(checkPointMonthCountBos, paramVo.getOrgIds());
        ArrayList<HcCheckPlanCountDailyPageVo> list = new ArrayList<HcCheckPlanCountDailyPageVo>();
        for (Map.Entry<Long, List<CheckPointMonthCountBo>> entry : map.entrySet()) {
            HcCheckPlanCountDailyPageVo vo = new HcCheckPlanCountDailyPageVo();
            list.add(vo);
            vo.setCheckOrgId(entry.getKey());
            List<CheckPointMonthCountBo> value = entry.getValue();
            for (CheckPointMonthCountBo bo : value) {
                Integer checkMonth;
                HcCheckPlanCountMonthVo monthVo = new HcCheckPlanCountMonthVo();
                monthVo.setTotal(bo.getCheckPoint() == null ? 0 : bo.getCheckPoint());
                monthVo.setFailed(bo.getOverPoint() == null ? 0 : bo.getOverPoint());
                if (monthVo.getTotal() == 0) {
                    monthVo.setRate(0.0);
                } else {
                    monthVo.setRate((double)monthVo.getFailed() / (double)monthVo.getTotal());
                    monthVo.setRate((double)Math.round(monthVo.getRate() * 10000.0) / 10000.0);
                }
                if ((checkMonth = bo.getCheckMonth()) == null) continue;
                try {
                    Method method = vo.getClass().getMethod("getMonth" + checkMonth, new Class[0]);
                    List monthList = (List)method.invoke((Object)vo, new Object[0]);
                    if (monthList.isEmpty()) {
                        monthList.add(monthVo);
                        continue;
                    }
                    HcCheckPlanCountMonthVo first = (HcCheckPlanCountMonthVo)monthList.get(0);
                    first.setTotal(first.getTotal() + monthVo.getTotal());
                    first.setFailed(first.getFailed() + monthVo.getFailed());
                    if (first.getTotal() == 0) {
                        first.setRate(0.0);
                        continue;
                    }
                    first.setRate((double)first.getFailed() / (double)first.getTotal());
                    first.setRate((double)Math.round(first.getRate() * 10000.0) / 10000.0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("\u53cd\u5c04\u83b7\u53d6\u65b9\u6cd5\u5f02\u5e38::::", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
        PageInfo pageInfo = PageUtil.getPageInfo(list, (int)jparam.getPage(), (int)jparam.getRows());
        pageInfo.setList(list);
        return pageInfo;
    }

    public HcCheckPlanCountVo getHcCheckPlanCompletedCountByYearAndType(Integer year, Long cid, Long checkType) {
        return ((CheckPlanMapper)this.baseMapper).getHcCheckPlanCompletedCountByYearAndType(year, cid, checkType);
    }

    public Integer getLatestCheckYear(Long cid) {
        return ((CheckPlanMapper)this.baseMapper).getLatestCheckYear(cid);
    }

    public LocalDateTime getLatestCheckDate(Long cid) {
        return ((CheckPlanMapper)this.baseMapper).getLatestCheckDate(cid);
    }

    public LocalDateTime getFirstCheckDateByYear(Long cid, Integer year) {
        return ((CheckPlanMapper)this.baseMapper).getFirstCheckDateByYear(cid, year);
    }

    public Map<Long, String> getWorkNameByIds(List<Long> ids) {
        List checkPlans = this.getByIds(ids);
        StringBuilder name = new StringBuilder();
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (CheckPlan plan : checkPlans) {
            if (plan.getCheckWorkName() != null) {
                name.append(plan.getCheckWorkName());
            }
            if (plan.getCheckDateBegin() != null) {
                name.append("(");
                name.append(cn.smarthse.util.common.date.DateUtils.formatDate((LocalDateTime)plan.getCheckDateBegin(), (String)"yyyy-MM-dd"));
                name.append("(");
            }
            map.put(plan.getId(), name.toString());
            name.delete(0, name.length());
        }
        return map;
    }

    public Map<Long, CheckPlan> getMapByIds(List<Long> ids) {
        List checkPlans = this.getByIds(ids);
        HashMap<Long, CheckPlan> map = new HashMap<Long, CheckPlan>();
        for (CheckPlan plan : checkPlans) {
            map.put(plan.getId(), plan);
        }
        return map;
    }

    public List<Long> getCidLatestYear() {
        LocalDateTime now = LocalDateTime.now();
        return this.getCidList(0L, null, now.plusYears(-1L), now);
    }

    public Integer countCheck(CountParamModel countParamModel) {
        return ((CheckPlanMapper)this.baseMapper).countCheck(countParamModel);
    }

    public List<Long> getReformIds(CountParamModel countParamModel) {
        return ((CheckPlanMapper)this.baseMapper).getReformIds(countParamModel);
    }

    public List<CheckPlan> getAllNeedIdAndCheckId() {
        ArrayList<CheckPlan> list = new ArrayList<CheckPlan>();
        for (int i = 1; i < 4; ++i) {
            List<CheckPlan> oneList = ((CheckPlanMapper)this.baseMapper).getAllNeedIdAndCheckId(i);
            list.addAll(oneList);
        }
        return list;
    }

    public String getCheckPointMapFileIds(Long cid, String timeStart, String timeEnd) {
        return ((CheckPlanMapper)this.baseMapper).getCheckPointMapFileIds(cid, timeStart, timeEnd);
    }

    public String getCheckReportFileIds(Long cid, String timeStart, String timeEnd) {
        return ((CheckPlanMapper)this.baseMapper).getCheckReportFileIds(cid, timeStart, timeEnd);
    }

    public List<Long> getThirdOrgId(Long cid, String timeStart, String timeEnd) {
        return ((CheckPlanMapper)this.baseMapper).getThirdOrgIds(cid, timeStart, timeEnd);
    }

    private List<CheckPointMonthCountBo> queryCheckPointMonthCountBoByYear(Long cid, Integer year) {
        return ((CheckPlanMapper)this.baseMapper).queryCheckPointMonthCountBoByYear(cid, year);
    }

    private Map<Long, List<CheckPointMonthCountBo>> groupByDept(List<CheckPointMonthCountBo> checkPointMonthCountBos, String deptIds) {
        HashMap<Long, List<CheckPointMonthCountBo>> map = new HashMap<Long, List<CheckPointMonthCountBo>>();
        LinkedList<CheckPointMonthCountBo> rList = new LinkedList<CheckPointMonthCountBo>();
        List<Object> deptS = new ArrayList();
        for (CheckPointMonthCountBo checkPointMonthCountBo : checkPointMonthCountBos) {
            if (!this.isDeptMatch(checkPointMonthCountBo.getOrgIds(), deptIds)) continue;
            rList.add(checkPointMonthCountBo);
            deptS.addAll(this.splitIds(checkPointMonthCountBo.getOrgIds()));
        }
        if (deptIds != null && !deptIds.isEmpty()) {
            deptS = this.splitIds(deptIds);
        }
        for (Long l : deptS) {
            for (CheckPointMonthCountBo bo : rList) {
                if (bo.getOrgIds() == null || !bo.getOrgIds().contains("" + l)) continue;
                List bos = map.computeIfAbsent(l, k -> new ArrayList());
                bos.add(bo);
            }
        }
        return map;
    }

    private boolean isDeptMatch(String ids, String needIds) {
        if (needIds == null || needIds.isEmpty()) {
            return true;
        }
        if (ids == null) {
            return false;
        }
        if (ids.equals(needIds)) {
            return true;
        }
        for (String s : needIds.split(",")) {
            for (String s1 : ids.split(",")) {
                if (!s.equals(s1)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Long> splitIds(String ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        String[] split = ids.split(",");
        ArrayList<Long> list = new ArrayList<Long>();
        for (String s : split) {
            list.add(Long.parseLong(s));
        }
        return list;
    }

    public List<Long> getCidListByFactorAndArea(Long areaId, Byte areaLevel, Integer checkYear, List<Long> harmIds) {
        if (harmIds == null) {
            return null;
        }
        return ((CheckPlanMapper)this.baseMapper).getCidListByFactorAndArea(areaId, areaLevel, checkYear, harmIds);
    }

    public CheckPlan getByWorkNo(String workNo) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(CheckPlan::getCheckWorkNo, (Object)workNo);
        List list = this.list((Wrapper)wrapper);
        return list == null || list.isEmpty() ? null : (CheckPlan)list.get(0);
    }

    public CheckPlan getLatestByOrgAndCom(Long orgId, Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(CheckPlan::getThirdOrgId, (Object)orgId)).eq(CheckPlan::getCid, (Object)cid)).eq(BaseEntity::getIsValid, (Object)true)).eq(CheckPlan::getReportStatus, (Object)2)).orderByDesc(CheckPlan::getCheckDateBegin, new SFunction[]{BaseEntity::getUpdateDate});
        List list = this.list((Wrapper)wrapper);
        return list == null || list.isEmpty() ? null : (CheckPlan)list.get(0);
    }

    public List<Long> getCidByOrgId(Long orgId) {
        return ((CheckPlanMapper)this.baseMapper).getCidByOrgId(orgId);
    }

    private void addCheckItem(Map<Integer, CheckSelectItem> itemMap, Integer i, Long checkId, Long cid) {
        CheckSelectItem item = itemMap.get(i);
        if (item == null) {
            item = new CheckSelectItem();
            item.setItemId(i);
            item.setCheckId(checkId);
            item.setCid(cid);
            itemMap.put(i, item);
        }
    }

    private CheckResult getResultBaseInfo(Long checkId, Long cid, Long resultNo) {
        CheckResult result = new CheckResult();
        result.setCheckId(checkId);
        result.setCid(cid);
        result.setResultNo(resultNo);
        result.setIsValid(Boolean.valueOf(true));
        return result;
    }

    private void getDustResultData(List<CheckResult> checkResultList, List<RiskExposeEvaluateData> datas, Long checkPlanId, Long cid, long resultNo) {
        if (datas != null && datas.size() > 0) {
            RiskExposeEvaluateData risk = datas.get(0);
            CheckResult harmResult = this.getResultBaseInfo(checkPlanId, cid, resultNo);
            harmResult.setCheckValue(risk.getFactorId());
            harmResult.setTargetId(Integer.valueOf(12));
            CheckResult checkPoint = this.getResultBaseInfo(checkPlanId, cid, resultNo);
            checkPoint.setCheckValue(risk.getCheckPoint());
            checkPoint.setTargetId(Integer.valueOf(11));
            CheckResult work = this.getResultBaseInfo(checkPlanId, cid, resultNo);
            work.setCheckValue(risk.getWorkName());
            work.setTargetId(Integer.valueOf(129));
            CheckResult workshop = this.getResultBaseInfo(checkPlanId, cid, resultNo);
            workshop.setCheckValue(risk.getWorkshop());
            workshop.setTargetId(Integer.valueOf(128));
            CheckResult workNum = this.getResultBaseInfo(checkPlanId, cid, resultNo);
            workNum.setCheckValue(risk.getWorkName());
            workNum.setTargetId(Integer.valueOf(130));
            checkResultList.add(checkPoint);
            checkResultList.add(work);
            checkResultList.add(workshop);
            checkResultList.add(workNum);
            checkResultList.add(harmResult);
            for (RiskExposeEvaluateData risk1 : datas) {
                CheckResult resultData;
                Integer result;
                CheckResult data;
                if (risk1.getFactorName() != null && risk1.getFactorName().contains("\u603b\u5c18")) {
                    if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getCtwa())) {
                        data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                        data.setCheckValue(risk1.getCtwa());
                        data.setCheckValueRangeType(Integer.valueOf(1));
                        data.setCheckValueMin(risk1.getCtwa());
                        data.setCheckValueMax(risk1.getCtwa());
                        data.setTargetId(Integer.valueOf(13));
                        checkResultList.add(data);
                    }
                    if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getCmac())) {
                        data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                        data.setCheckValue(risk1.getCmac());
                        data.setCheckValueMin(risk1.getCmac());
                        data.setCheckValueMax(risk1.getCmac());
                        data.setCheckValueRangeType(Integer.valueOf(1));
                        data.setTargetId(Integer.valueOf(14));
                        checkResultList.add(data);
                    }
                    if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getExceedLimit())) {
                        data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                        data.setCheckValue(risk1.getExceedLimit());
                        data.setCheckValueRangeType(Integer.valueOf(1));
                        data.setCheckValueMin(risk1.getExceedLimit());
                        data.setCheckValueMax(risk1.getExceedLimit());
                        data.setTargetId(Integer.valueOf(16));
                        checkResultList.add(data);
                    }
                    if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getPePcTwa())) {
                        data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                        data.setCheckValue(risk1.getPePcTwa());
                        data.setCheckValueRangeType(Integer.valueOf(1));
                        data.setCheckValueMin(risk1.getPePcTwa());
                        data.setCheckValueMax(risk1.getPePcTwa());
                        data.setTargetId(Integer.valueOf(15));
                        checkResultList.add(data);
                    }
                    if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getReductionFactor())) {
                        data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                        data.setCheckValue(risk1.getReductionFactor());
                        data.setTargetId(Integer.valueOf(193));
                        checkResultList.add(data);
                    }
                    result = 1;
                    if (risk1.getCheckTouchLevel() != null) {
                        result = risk1.getCheckTouchLevel() == 1 ? Integer.valueOf(3) : Integer.valueOf(2);
                    }
                    resultData = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                    resultData.setCheckValue(result.toString());
                    resultData.setTargetId(Integer.valueOf(17));
                    checkResultList.add(resultData);
                    continue;
                }
                if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getCtwa())) {
                    data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                    data.setCheckValue(risk1.getCtwa());
                    data.setCheckValueMin(risk1.getCtwa());
                    data.setCheckValueMax(risk1.getCtwa());
                    data.setCheckValueRangeType(Integer.valueOf(1));
                    data.setTargetId(Integer.valueOf(18));
                    checkResultList.add(data);
                }
                if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getCmac())) {
                    data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                    data.setCheckValue(risk1.getCmac());
                    data.setCheckValueRangeType(Integer.valueOf(1));
                    data.setCheckValueMin(risk1.getCmac());
                    data.setCheckValueMax(risk1.getCmac());
                    data.setTargetId(Integer.valueOf(19));
                    checkResultList.add(data);
                }
                if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getExceedLimit())) {
                    data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                    data.setCheckValue(risk1.getExceedLimit());
                    data.setCheckValueRangeType(Integer.valueOf(1));
                    data.setCheckValueMin(risk1.getExceedLimit());
                    data.setCheckValueMax(risk1.getExceedLimit());
                    data.setTargetId(Integer.valueOf(21));
                    checkResultList.add(data);
                }
                if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getPePcTwa())) {
                    data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                    data.setCheckValue(risk1.getPePcTwa());
                    data.setCheckValueRangeType(Integer.valueOf(1));
                    data.setCheckValueMin(risk1.getPePcTwa());
                    data.setCheckValueMax(risk1.getPePcTwa());
                    data.setTargetId(Integer.valueOf(20));
                    checkResultList.add(data);
                }
                if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk1.getReductionFactor())) {
                    data = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                    data.setCheckValue(risk1.getReductionFactor());
                    data.setTargetId(Integer.valueOf(195));
                    checkResultList.add(data);
                }
                result = 1;
                if (risk1.getCheckTouchLevel() != null) {
                    result = risk1.getCheckTouchLevel() == 1 ? Integer.valueOf(3) : Integer.valueOf(2);
                }
                resultData = this.getResultBaseInfo(checkPlanId, cid, resultNo);
                resultData.setCheckValue(result.toString());
                resultData.setTargetId(Integer.valueOf(22));
                checkResultList.add(resultData);
            }
        }
    }

    private void getBiologyResultData(List<CheckResult> checkResultList, RiskExposeEvaluateData risk, Long checkId, Long cid, long resultNo) {
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCtwa())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCtwa());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getCtwa());
            data.setCheckValueMax(risk.getCtwa());
            data.setTargetId(Integer.valueOf(101));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCstel())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCstel());
            data.setCheckValueMin(risk.getCstel());
            data.setCheckValueMax(risk.getCstel());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setTargetId(Integer.valueOf(102));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCste())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCste());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getCste());
            data.setCheckValueMax(risk.getCste());
            data.setTargetId(Integer.valueOf(103));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCmac())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCmac());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getCmac());
            data.setCheckValueMax(risk.getCmac());
            data.setTargetId(Integer.valueOf(99));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCme())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCme());
            data.setCheckValueMin(risk.getCme());
            data.setCheckValueMax(risk.getCme());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setTargetId(Integer.valueOf(100));
            checkResultList.add(data);
        }
    }

    private void getChemistryResultData(List<CheckResult> checkResultList, RiskExposeEvaluateData risk, Long checkId, Long cid, Long resultNo) {
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCtwa())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCtwa());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getCtwa());
            data.setCheckValueMax(risk.getCtwa());
            data.setTargetId(Integer.valueOf(3));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCstel())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCstel());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getCstel());
            data.setCheckValueMax(risk.getCstel());
            data.setTargetId(Integer.valueOf(4));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCste())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCste());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getCste());
            data.setCheckValueMax(risk.getCste());
            data.setTargetId(Integer.valueOf(7));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCmac())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCmac());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getCmac());
            data.setCheckValueMax(risk.getCmac());
            data.setTargetId(Integer.valueOf(5));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getCme())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getCme());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getCme());
            data.setCheckValueMax(risk.getCme());
            data.setTargetId(Integer.valueOf(6));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getPePcTwa())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getPePcTwa());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setCheckValueMin(risk.getPePcTwa());
            data.setCheckValueMax(risk.getPePcTwa());
            data.setTargetId(Integer.valueOf(8));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getExceedLimit())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getExceedLimit());
            data.setCheckValueMin(risk.getExceedLimit());
            data.setCheckValueMax(risk.getExceedLimit());
            data.setCheckValueRangeType(Integer.valueOf(1));
            data.setTargetId(Integer.valueOf(9));
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)risk.getReductionFactor())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(risk.getReductionFactor());
            data.setTargetId(Integer.valueOf(192));
            checkResultList.add(data);
        }
    }

    @Transactional
    public List<CheckPlan> autoAddAllRiskToCheck(List<Long> idList) {
        List<Long> riskIdList;
        this.logger.info("\u66b4\u9732\u98ce\u9669\u8f6c\u68c0\u6d4b\u6570\u636e,\u5f00\u59cb\u540c\u6b65....");
        long start = System.currentTimeMillis();
        HashMap<Long, Long> backRiskNoUpdateCheckMap = new HashMap();
        List<CheckPlan> backRiskNoUpdateCheckList = ((CheckPlanMapper)this.baseMapper).getBackRiskNoUpdateCheck(idList);
        if (CollectionUtils.isNotEmpty(backRiskNoUpdateCheckList)) {
            backRiskNoUpdateCheckMap = backRiskNoUpdateCheckList.stream().collect(Collectors.toMap(CheckPlan::getRiskExposeEvaluateId, BaseEntity::getId, (v1, v2) -> v2));
            List checkIdBackList = backRiskNoUpdateCheckList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            ((CheckPlanMapper)this.baseMapper).deleteBatchIds(checkIdBackList);
            LambdaQueryWrapper itemWrapper = new LambdaQueryWrapper();
            itemWrapper.in(CheckSelectItem::getCheckId, checkIdBackList);
            this.checkSelectItemService.remove((Wrapper)itemWrapper);
            LambdaQueryWrapper resultWrapper = new LambdaQueryWrapper();
            resultWrapper.in(CheckResult::getCheckId, checkIdBackList);
            this.checkResultService.remove((Wrapper)resultWrapper);
            LambdaQueryWrapper checkOverPointWrapper = new LambdaQueryWrapper();
            checkOverPointWrapper.in(CheckOverPoint::getCheckId, checkIdBackList);
            this.checkOverPointService.remove((Wrapper)checkOverPointWrapper);
            LambdaQueryWrapper checkFactorWrapper = new LambdaQueryWrapper();
            checkFactorWrapper.in(CheckFactor::getCheckId, checkIdBackList);
            this.checkFactorService.remove((Wrapper)checkFactorWrapper);
        }
        if (CollectionUtils.isEmpty(riskIdList = ((CheckPlanMapper)this.baseMapper).getAllRiskByNoChecked(idList))) {
            return Collections.emptyList();
        }
        Map<Long, String> typeMap = this.factorService.doGetAllIdAndTypeMap();
        ArrayList<CheckPlan> checkPlanList = new ArrayList<CheckPlan>();
        ArrayList<CheckResult> checkResultList = new ArrayList<CheckResult>();
        ArrayList<CheckSelectItem> checkSelectItemList = new ArrayList<CheckSelectItem>();
        List riskExposeEvaluateList = this.riskExposeEvaluateService.getInfoList(riskIdList);
        List riskExposeEvaluateDataList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.evaluateDataService.lambdaQuery().in(RiskExposeEvaluateData::getRiskExposeEvaluateId, riskIdList)).eq(BaseEntity::getIsValid, (Object)true)).list();
        Map<Object, Object> riskIdToDataMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)riskExposeEvaluateDataList)) {
            riskIdToDataMap = riskExposeEvaluateDataList.parallelStream().filter(Objects::nonNull).collect(Collectors.groupingBy(RiskExposeEvaluateData::getRiskExposeEvaluateId));
        }
        for (Object riskExposeEvaluate : riskExposeEvaluateList) {
            CheckPlan checkPlan = this.riskToCheck((RiskExposeEvaluate)riskExposeEvaluate, backRiskNoUpdateCheckMap);
            checkPlanList.add(checkPlan);
        }
        this.saveBatch(checkPlanList);
        List checkIdList = checkPlanList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        for (CheckPlan newCheck : checkPlanList) {
            this.riskDataDetailToCheckDataAll(newCheck.getId(), newCheck.getCid(), typeMap, (List)riskIdToDataMap.get(newCheck.getRiskExposeEvaluateId()), checkResultList, checkSelectItemList);
        }
        this.resultService.getFetchResults(checkIdList, checkResultList);
        this.checkSelectItemService.saveBatch(checkSelectItemList);
        List collect = checkPlanList.parallelStream().filter(Objects::nonNull).map(CheckPlan::getCid).collect(Collectors.toList());
        this.checkFactorService.startStatistic(collect);
        this.resultService.statisticAll(collect);
        long end = System.currentTimeMillis();
        this.logger.info("\u66b4\u9732\u98ce\u9669\u8f6c\u68c0\u6d4b\u6570\u636e\u7ed3\u675f,\u540c\u6b65\u8017\u65f6" + (end - start) / 1000L + "s");
        return checkPlanList;
    }

    public CheckPlan riskToCheck(RiskExposeEvaluate ev, Map<Long, Long> backRiskNoUpdateCheckMap) {
        CheckPlan convertCheck = new CheckPlan();
        if (backRiskNoUpdateCheckMap.containsKey(ev.getId())) {
            convertCheck.setId(backRiskNoUpdateCheckMap.get(ev.getId()));
        } else {
            convertCheck.setId(Long.valueOf(this.idworker.nextId()));
        }
        convertCheck.setRegisterName(ev.getOrgName());
        convertCheck.setCid(ev.getCid());
        convertCheck.setTargetStandardId(ev.getTargetStandardId());
        convertCheck.setCheckDateBegin(ev.getCheckDate());
        convertCheck.setCheckDateEnd(ev.getCheckDateEnd());
        convertCheck.setCheckType(ev.getCheckType());
        convertCheck.setCheckFrom(Integer.valueOf(2));
        convertCheck.setEditStatus(Integer.valueOf(2));
        convertCheck.setCheckWorkName(ev.getProjectName());
        convertCheck.setProjectName(ev.getProjectName());
        convertCheck.setProjectAreaId(ev.getProjectAreaId());
        convertCheck.setProjectAddress(ev.getProjectAddress());
        convertCheck.setReportStatus(Integer.valueOf(2));
        convertCheck.setThirdOrgId(ev.getOrgId());
        convertCheck.setCreateBy(ev.getCreateBy());
        convertCheck.setCreateDate(ev.getDataUpdateDate());
        convertCheck.setUpdateBy(ev.getUpdateBy());
        convertCheck.setUpdateDate(ev.getDataUpdateDate());
        convertCheck.setRiskLevel(ev.getRiskType());
        convertCheck.setRiskExposeEvaluateId(ev.getId());
        return convertCheck;
    }

    public void riskDataDetailToCheckDataAll(Long checkId, Long cid, Map<Long, String> typeMap, List<RiskExposeEvaluateData> riskExposeEvaluateDataList, List<CheckResult> allCheckResultList, List<CheckSelectItem> allCheckSelectItemList) {
        ArrayList<CheckResult> checkResultList = new ArrayList<CheckResult>();
        HashMap dustMap = new HashMap();
        HashMap itemMap = new HashMap();
        riskExposeEvaluateDataList.forEach(riskExposeEvaluateData -> {
            long resultNo = this.snowFlake.nextId();
            CheckResult harmResult = this.getResultBaseInfo(checkId, cid, resultNo);
            harmResult.setCheckValue(riskExposeEvaluateData.getFactorId());
            CheckResult checkPoint = this.getResultBaseInfo(checkId, cid, resultNo);
            checkPoint.setCheckValue(riskExposeEvaluateData.getCheckPoint());
            CheckResult work = this.getResultBaseInfo(checkId, cid, resultNo);
            work.setCheckValue(riskExposeEvaluateData.getWorkName());
            CheckResult workshop = this.getResultBaseInfo(checkId, cid, resultNo);
            workshop.setCheckValue(riskExposeEvaluateData.getWorkshop());
            CheckResult workNum = this.getResultBaseInfo(checkId, cid, resultNo);
            if (riskExposeEvaluateData.getWorkNum() != null) {
                workNum.setCheckValue(riskExposeEvaluateData.getWorkNum().toString());
            } else {
                workNum.setCheckValue(null);
            }
            int result = 1;
            if (riskExposeEvaluateData.getCheckTouchLevel() != null) {
                result = riskExposeEvaluateData.getCheckTouchLevel() == 1 ? 3 : 2;
            }
            CheckResult resultJudge = this.getResultBaseInfo(checkId, cid, resultNo);
            resultJudge.setCheckValue(String.valueOf(result));
            if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)riskExposeEvaluateData.getFactorId())) {
                Long harmId = null;
                if (!riskExposeEvaluateData.getFactorId().contains(",")) {
                    harmId = Long.parseLong(riskExposeEvaluateData.getFactorId());
                } else {
                    List facIds = cn.smarthse.util.common.StringUtils.parseToLongList((String)riskExposeEvaluateData.getFactorId(), (String)",");
                    if (facIds.size() > 0) {
                        harmId = (Long)facIds.get(0);
                    }
                }
                String harmType = (String)typeMap.get(harmId);
                if (cn.smarthse.util.common.StringUtils.isBlank((CharSequence)harmType)) {
                    HarmFactor harmFactor = this.harmFactorService.getThisById(harmId);
                    harmType = harmFactor == null ? harmType : harmFactor.getType();
                    this.logger.error("\u66b4\u9732\u98ce\u9669\u8f6c\u68c0\u6d4b\u83b7\u53d6\u5371\u5bb3\u56e0\u7d20\u7f13\u5b58\u4e2d\u6ca1\u6709\uff0c\u91cd\u65b0\u67e5\u8be2");
                }
                if ("\u7c89\u5c18".equals(harmType)) {
                    this.addCheckItem(itemMap, 2, checkId, cid);
                    String key = riskExposeEvaluateData.getWorkName() + "-" + riskExposeEvaluateData.getWorkshop() + "-" + riskExposeEvaluateData.getCheckPoint() + "-" + riskExposeEvaluateData.getFactorId();
                    ArrayList<RiskExposeEvaluateData> list = (ArrayList<RiskExposeEvaluateData>)dustMap.get(key);
                    if (list == null) {
                        list = new ArrayList<RiskExposeEvaluateData>();
                    }
                    list.add((RiskExposeEvaluateData)riskExposeEvaluateData);
                    dustMap.put(key, list);
                } else if ("\u7269\u7406\u56e0\u7d20".equals(harmType)) {
                    if (riskExposeEvaluateData.getFactorId().equals("567") || riskExposeEvaluateData.getFactorId().equals("1111111")) {
                        this.addCheckItem(itemMap, 3, checkId, cid);
                        checkPoint.setTargetId(Integer.valueOf(24));
                        work.setTargetId(Integer.valueOf(133));
                        workshop.setTargetId(Integer.valueOf(132));
                        workNum.setTargetId(Integer.valueOf(134));
                        resultJudge.setTargetId(Integer.valueOf(32));
                        data = this.getResultBaseInfo(checkId, cid, resultNo);
                        data.setTargetId(Integer.valueOf(26));
                        if (riskExposeEvaluateData.getFactorId().equals("1111111")) {
                            data.setCheckValue(riskExposeEvaluateData.getOtherFactorValue());
                            data.setCheckValueMin(riskExposeEvaluateData.getOtherFactorValue());
                            data.setCheckValueMax(riskExposeEvaluateData.getOtherFactorValue());
                        } else {
                            data.setCheckValue(riskExposeEvaluateData.getNoiseLevel());
                            data.setCheckValueMin(riskExposeEvaluateData.getNoiseLevel());
                            data.setCheckValueMax(riskExposeEvaluateData.getNoiseLevel());
                        }
                        checkResultList.add(data);
                    } else if (riskExposeEvaluateData.getFactorId().equals("568")) {
                        this.addCheckItem(itemMap, 4, checkId, cid);
                        checkPoint.setTargetId(Integer.valueOf(33));
                        work.setTargetId(Integer.valueOf(137));
                        workshop.setTargetId(Integer.valueOf(136));
                        workNum.setTargetId(Integer.valueOf(138));
                        resultJudge.setTargetId(Integer.valueOf(37));
                        data = this.getResultBaseInfo(checkId, cid, resultNo);
                        data.setCheckValue(riskExposeEvaluateData.getOtherFactorValue());
                        data.setTargetId(Integer.valueOf(36));
                        checkResultList.add(data);
                    } else if (riskExposeEvaluateData.getFactorId().equals("576") || riskExposeEvaluateData.getFactorId().equals("710") || riskExposeEvaluateData.getFactorId().equals("711") || riskExposeEvaluateData.getFactorId().equals("627") || riskExposeEvaluateData.getFactorId().equals("712")) {
                        this.addCheckItem(itemMap, 5, checkId, cid);
                        checkPoint.setTargetId(Integer.valueOf(38));
                        work.setTargetId(Integer.valueOf(141));
                        workshop.setTargetId(Integer.valueOf(140));
                        workNum.setTargetId(Integer.valueOf(142));
                        resultJudge.setTargetId(Integer.valueOf(43));
                        data = this.getResultBaseInfo(checkId, cid, resultNo);
                        data.setCheckValue(riskExposeEvaluateData.getOtherFactorValue());
                        data.setTargetId(Integer.valueOf(41));
                        data.setCheckValueMin(riskExposeEvaluateData.getOtherFactorValue());
                        data.setCheckValueMax(riskExposeEvaluateData.getOtherFactorValue());
                        checkResultList.add(data);
                        CheckResult type = this.getResultBaseInfo(checkId, cid, resultNo);
                        type.setCheckValue("1");
                        type.setTargetId(Integer.valueOf(39));
                        if (riskExposeEvaluateData.getFactorId().equals("710")) {
                            type.setCheckValue("1");
                        } else if (riskExposeEvaluateData.getFactorId().equals("711")) {
                            type.setCheckValue("4");
                        } else if (riskExposeEvaluateData.getFactorId().equals("712") || riskExposeEvaluateData.getFactorId().equals("627")) {
                            type.setCheckValue("3");
                        }
                        checkResultList.add(type);
                    } else if (riskExposeEvaluateData.getFactorId().equals("578")) {
                        this.addCheckItem(itemMap, 6, checkId, cid);
                        checkPoint.setTargetId(Integer.valueOf(53));
                        work.setTargetId(Integer.valueOf(145));
                        workshop.setTargetId(Integer.valueOf(144));
                        workNum.setTargetId(Integer.valueOf(146));
                        resultJudge.setTargetId(Integer.valueOf(56));
                        data = this.getResultBaseInfo(checkId, cid, resultNo);
                        data.setCheckValue(riskExposeEvaluateData.getOtherFactorValue());
                        data.setTargetId(Integer.valueOf(55));
                        data.setCheckValueMin(riskExposeEvaluateData.getOtherFactorValue());
                        data.setCheckValueMax(riskExposeEvaluateData.getOtherFactorValue());
                        checkResultList.add(data);
                    } else if (riskExposeEvaluateData.getFactorId().equals("575")) {
                        this.addCheckItem(itemMap, 7, checkId, cid);
                        checkPoint.setTargetId(Integer.valueOf(57));
                        work.setTargetId(Integer.valueOf(149));
                        workshop.setTargetId(Integer.valueOf(148));
                        workNum.setTargetId(Integer.valueOf(150));
                        resultJudge.setTargetId(Integer.valueOf(63));
                        data = this.getResultBaseInfo(checkId, cid, resultNo);
                        data.setCheckValue(riskExposeEvaluateData.getOtherFactorValue());
                        data.setTargetId(Integer.valueOf(60));
                        data.setCheckValueMin(riskExposeEvaluateData.getOtherFactorValue());
                        data.setCheckValueMax(riskExposeEvaluateData.getOtherFactorValue());
                        checkResultList.add(data);
                    } else if (riskExposeEvaluateData.getFactorId().equals("579")) {
                        this.addCheckItem(itemMap, 8, checkId, cid);
                        checkPoint.setTargetId(Integer.valueOf(64));
                        work.setTargetId(Integer.valueOf(153));
                        workshop.setTargetId(Integer.valueOf(152));
                        workNum.setTargetId(Integer.valueOf(154));
                        resultJudge.setTargetId(Integer.valueOf(69));
                        data = this.getResultBaseInfo(checkId, cid, resultNo);
                        data.setCheckValue(riskExposeEvaluateData.getOtherFactorValue());
                        data.setTargetId(Integer.valueOf(66));
                        data.setCheckValueMin(riskExposeEvaluateData.getOtherFactorValue());
                        data.setCheckValueMax(riskExposeEvaluateData.getOtherFactorValue());
                        checkResultList.add(data);
                    } else if (riskExposeEvaluateData.getFactorId().equals("580")) {
                        this.addCheckItem(itemMap, 9, checkId, cid);
                        checkPoint.setTargetId(Integer.valueOf(70));
                        work.setTargetId(Integer.valueOf(157));
                        workshop.setTargetId(Integer.valueOf(156));
                        workNum.setTargetId(Integer.valueOf(158));
                        resultJudge.setTargetId(Integer.valueOf(75));
                        data = this.getResultBaseInfo(checkId, cid, resultNo);
                        data.setCheckValue(riskExposeEvaluateData.getOtherFactorValue());
                        data.setTargetId(Integer.valueOf(73));
                        data.setCheckValueMin(riskExposeEvaluateData.getOtherFactorValue());
                        data.setCheckValueMax(riskExposeEvaluateData.getOtherFactorValue());
                        checkResultList.add(data);
                    } else if (riskExposeEvaluateData.getFactorId().equals("709")) {
                        this.addCheckItem(itemMap, 11, checkId, cid);
                        checkPoint.setTargetId(Integer.valueOf(84));
                        work.setTargetId(Integer.valueOf(165));
                        workshop.setTargetId(Integer.valueOf(164));
                        workNum.setTargetId(Integer.valueOf(166));
                        resultJudge.setTargetId(Integer.valueOf(87));
                        data = this.getResultBaseInfo(checkId, cid, resultNo);
                        data.setCheckValue(riskExposeEvaluateData.getOtherFactorValue());
                        data.setTargetId(Integer.valueOf(86));
                        data.setCheckValueMin(riskExposeEvaluateData.getOtherFactorValue());
                        data.setCheckValueMax(riskExposeEvaluateData.getOtherFactorValue());
                        checkResultList.add(data);
                    }
                } else if ("\u751f\u7269\u56e0\u7d20".equals(harmType)) {
                    this.addCheckItem(itemMap, 13, checkId, cid);
                    harmResult.setTargetId(Integer.valueOf(98));
                    checkResultList.add(harmResult);
                    checkPoint.setTargetId(Integer.valueOf(97));
                    work.setTargetId(Integer.valueOf(173));
                    workshop.setTargetId(Integer.valueOf(172));
                    workNum.setTargetId(Integer.valueOf(174));
                    resultJudge.setTargetId(Integer.valueOf(104));
                    this.getBiologyResultData((List<CheckResult>)checkResultList, (RiskExposeEvaluateData)riskExposeEvaluateData, checkId, cid, resultNo);
                } else if ("\u5316\u5b66\u56e0\u7d20".equals(harmType)) {
                    this.addCheckItem(itemMap, 1, checkId, cid);
                    harmResult.setTargetId(Integer.valueOf(2));
                    checkResultList.add(harmResult);
                    checkPoint.setTargetId(Integer.valueOf(1));
                    work.setTargetId(Integer.valueOf(125));
                    workshop.setTargetId(Integer.valueOf(124));
                    workNum.setTargetId(Integer.valueOf(126));
                    resultJudge.setTargetId(Integer.valueOf(10));
                    this.getChemistryResultData((List<CheckResult>)checkResultList, (RiskExposeEvaluateData)riskExposeEvaluateData, checkId, cid, (Long)resultNo);
                }
                if (!"\u7c89\u5c18".equals(harmType)) {
                    if (checkPoint.getTargetId() != null) {
                        checkResultList.add(checkPoint);
                    }
                    if (work.getTargetId() != null) {
                        checkResultList.add(work);
                    }
                    if (workshop.getTargetId() != null) {
                        checkResultList.add(workshop);
                    }
                    if (workNum.getTargetId() != null) {
                        checkResultList.add(workNum);
                    }
                    if (resultJudge.getTargetId() != null) {
                        checkResultList.add(resultJudge);
                    }
                }
            }
        });
        for (String key : dustMap.keySet()) {
            long resultNo = this.snowFlake.nextId();
            List datas = (List)dustMap.get(key);
            this.getDustResultData(checkResultList, datas, checkId, cid, resultNo);
        }
        ArrayList checkSelectItems = new ArrayList(itemMap.values());
        allCheckResultList.addAll(checkResultList);
        allCheckSelectItemList.addAll(checkSelectItems);
    }

    public List<CheckPlan> getUnCheckedFactor(List<Long> cidList) {
        return ((CheckPlanMapper)this.baseMapper).getUnCheckedFactor(cidList);
    }

    public List<Long> getLastCheckPlanGroupByCid(List<Long> cidList, Integer reportStatus) {
        return ((CheckPlanMapper)this.baseMapper).getLastCheckPlanGroupByCid(cidList, reportStatus);
    }

    public List<CheckPlan> getLastCheckPlanGroupByCid2(List<Long> cidList, Integer reportStatus) {
        return ((CheckPlanMapper)this.baseMapper).getLastCheckPlanGroupByCid2(cidList, reportStatus);
    }

    public CheckPlan getLastCheckPlanByCid(Long cid, Integer reportStatus) {
        if (cid == null) {
            return null;
        }
        return ((CheckPlanMapper)this.baseMapper).getLastCheckPlanByCid(cid, reportStatus);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void autoAddCheckPlanFromWandaCheck(List<Long> wandaCheckIdList) {
        this.logger.error("\u6dfb\u52a0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u5f00\u59cb");
        XxlJobHelper.log((String)"\u6dfb\u52a0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u5f00\u59cb", (Object[])new Object[0]);
        List<WandaZywsCheck> list = ((CheckPlanMapper)this.dao).getNotConvertWandaCheckList(wandaCheckIdList);
        list = this.removeErrorData(list);
        if (CollectionUtils.isEmpty(list)) {
            this.logger.error("\u6ca1\u6709\u9700\u8981\u6dfb\u52a0\u7684\u4e07\u8fbe\u68c0\u6d4b\u6570\u636e");
            XxlJobHelper.log((String)"\u6ca1\u6709\u9700\u8981\u6dfb\u52a0\u7684\u4e07\u8fbe\u68c0\u6d4b\u6570\u636e", (Object[])new Object[0]);
            return;
        }
        this.logger.error("\u6dfb\u52a0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u6570\u91cf\u5927\u6982\u4e3a{}", (Object)list.size());
        XxlJobHelper.log((String)"\u6dfb\u52a0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u6570\u91cf\u5927\u6982\u4e3a{}", (Object[])new Object[]{list.size()});
        List splitList = ListUtils.split(list, (int)200);
        for (List wandaZywsCheckList : splitList) {
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(transactionStatus -> {
                ArrayList<CheckPlan> checkPlanList = new ArrayList<CheckPlan>();
                for (WandaZywsCheck wandaZywsCheck : wandaZywsCheckList) {
                    CheckPlan checkPlan = new CheckPlan();
                    this.settingCheckPlanValue(wandaZywsCheck, checkPlan);
                    checkPlanList.add(checkPlan);
                }
                this.saveBatch(checkPlanList, 1000);
                this.autoAddSelectAndResult(checkPlanList);
                this.riskExposeEvaluateService.autoAddRiskExposeEvaluateFromWandaCheck(checkPlanList, new HashMap());
                this.backPushLogService.addPushLogByConvert(wandaZywsCheckList.stream().map(WandaZywsCheck::getSourceId).distinct().collect(Collectors.toList()), "\u4e07\u8fbe\u4ed3\u65b0\u4e0a\u4f20\u6570\u636e\u5df2\u6dfb\u52a0");
                return Boolean.TRUE;
            });
        }
        this.logger.error("\u6dfb\u52a0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u7ed3\u675f");
        XxlJobHelper.log((String)"\u6dfb\u52a0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u7ed3\u675f", (Object[])new Object[0]);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void autoUpdateCheckPlanFromWandaCheck(List<Long> wandaCheckIdList) {
        this.logger.error("\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u5f00\u59cb");
        XxlJobHelper.log((String)"\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u5f00\u59cb", (Object[])new Object[0]);
        List<WandaZywsCheck> wandaCheckAllList = ((CheckPlanMapper)this.dao).getNeedUpdateWandaCheckList(wandaCheckIdList);
        wandaCheckAllList = this.removeErrorData(wandaCheckAllList);
        if (CollectionUtils.isEmpty(wandaCheckAllList)) {
            this.logger.error("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\uff0c\u4f46\u662f\u521d\u59cb\u6570\u91cf\u6709\u5927\u6982{}", (Object)wandaCheckAllList.size());
            XxlJobHelper.log((String)"\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\uff0c\u4f46\u662f\u521d\u59cb\u6570\u91cf\u6709\u5927\u6982{}", (Object[])new Object[]{wandaCheckAllList.size()});
            return;
        }
        this.logger.error("\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u6570\u91cf\u5927\u6982\u4e3a{}", (Object)wandaCheckAllList.size());
        XxlJobHelper.log((String)"\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u6570\u91cf\u5927\u6982\u4e3a{}", (Object[])new Object[]{wandaCheckAllList.size()});
        Map<String, List<WandaZywsCheck>> stringListMap = wandaCheckAllList.stream().sorted(Comparator.comparing(WandaBaseData::getLoadTime)).collect(Collectors.groupingBy(WandaZywsCheck::getOldCheckId));
        List<List> positionGroups = IntStream.range(0, stringListMap.values().stream().mapToInt(List::size).max().orElse(0)).mapToObj(i -> stringListMap.values().stream().filter(list -> i < list.size()).map(list -> (WandaZywsCheck)list.get(i)).collect(Collectors.toList())).collect(Collectors.toList());
        positionGroups.forEach(positionGroup -> ListUtils.split((List)positionGroup, (int)200).forEach(wandaZywsChecks -> {
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(transactionStatus -> {
                this.updateCheckPlanFromWandaCheck((List<WandaZywsCheck>)wandaZywsChecks);
                return Boolean.TRUE;
            });
        }));
        this.logger.error("\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u7ed3\u675f");
        XxlJobHelper.log((String)"\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732\u7ed3\u675f", (Object[])new Object[0]);
    }

    public void updateCheckPlanFromWandaCheck(List<WandaZywsCheck> wandaCheckAllList) {
        List collect;
        List oldWandCheckIdList = wandaCheckAllList.stream().map(WandaZywsCheck::getOldCheckId).collect(Collectors.toList());
        List<String> wandaCheckAllIdList = wandaCheckAllList.stream().map(WandaZywsCheck::getSourceId).collect(Collectors.toList());
        Map<String, List<WandaZywsCheckFactors>> wandaDataMap = this.getWandaZywsCheckFactorsByWandaCheckIds(wandaCheckAllIdList, false);
        List oldCheckPlanList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CheckPlan::getWandaZywsCheckId, oldWandCheckIdList)).eq(BaseEntity::getIsValid, (Object)true)).list();
        if (CollectionUtils.isEmpty((Collection)oldCheckPlanList)) {
            this.logger.error("\u9700\u8981\u66f4\u65b0\u7684\u5386\u53f2\u68c0\u6d4b\u6570\u636e\u4e3a\u7a7a\uff0c\u5e94\u8be5\u662f\u4e0d\u4f1a\u51fa\u73b0\u8fd9\u6837\u7684\u60c5\u51b5\uff0c\u4e07\u8fbe\u7684sourceId\u5927\u6982\u4e3a{}", wandaCheckAllIdList);
            XxlJobHelper.log((String)"\u9700\u8981\u66f4\u65b0\u7684\u5386\u53f2\u68c0\u6d4b\u6570\u636e\u4e3a\u7a7a\uff0c\u5e94\u8be5\u662f\u4e0d\u4f1a\u51fa\u73b0\u8fd9\u6837\u7684\u60c5\u51b5\uff0c\u4e07\u8fbe\u7684sourceId\u5927\u6982\u4e3a{}", (Object[])new Object[]{wandaCheckAllIdList});
            return;
        }
        Map oldCheckPlanMap = oldCheckPlanList.stream().collect(Collectors.toMap(CheckPlan::getWandaZywsCheckId, Function.identity(), (a, b) -> {
            int dateCompare = a.getCreateDate().compareTo(b.getCreateDate());
            if (dateCompare != 0) {
                return dateCompare > 0 ? a : b;
            }
            return a.getId() > b.getId() ? a : b;
        }));
        List oldCheckIdList = oldCheckPlanMap.values().stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        Map<Long, List<Integer>> oldCheckSelectItemMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.checkSelectItemService.lambdaQuery().in(CheckSelectItem::getCheckId, oldCheckIdList)).eq(BaseEntity::getIsValid, (Object)true)).select(new SFunction[]{CheckSelectItem::getCheckId, CheckSelectItem::getItemId}).list().stream().filter(Objects::nonNull).collect(Collectors.groupingBy(CheckSelectItem::getCheckId, Collectors.mapping(CheckSelectItem::getItemId, Collectors.toList())));
        Map<Long, List<CheckResult>> oldCheckResultMap = this.checkResultService.list((Wrapper)((LambdaQueryWrapper)((QueryWrapper)new QueryWrapper().select((Object[])new String[]{"DISTINCT check_id,old_item_id,check_code"})).lambda().in(CheckResult::getCheckId, oldCheckIdList)).eq(BaseEntity::getIsValid, (Object)true)).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(CheckResult::getCheckId));
        ArrayList<CheckPlan> checkPlans = new ArrayList<CheckPlan>();
        ArrayList<CheckSelectItem> checkSelectItemList = new ArrayList<CheckSelectItem>();
        ArrayList<CheckResult> checkResultList = new ArrayList<CheckResult>();
        ArrayList<String> updateList = new ArrayList<String>();
        ArrayList<String> delList = new ArrayList<String>();
        HashSet<Long> delResultAndSelectList = new HashSet<Long>();
        Iterator<WandaZywsCheck> iterator = wandaCheckAllList.iterator();
        while (iterator.hasNext()) {
            WandaZywsCheck wandaCheck = iterator.next();
            CheckPlan checkPlan = (CheckPlan)oldCheckPlanMap.get(wandaCheck.getOldCheckId());
            if (checkPlan == null) {
                this.logger.error("\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732--\u5f02\u5e38\u6570\u636e\u627e\u4e0d\u5230checkPlan:{}", (Object)wandaCheck.getSourceId());
                XxlJobHelper.log((String)"\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732--\u5f02\u5e38\u6570\u636e\u627e\u4e0d\u5230checkPlan:{}", (Object[])new Object[]{wandaCheck.getSourceId()});
                continue;
            }
            this.settingCheckPlanValue(wandaCheck, checkPlan);
            boolean isContinue = this.compareEachItem(wandaCheck, oldCheckResultMap, checkPlan, oldCheckSelectItemMap, wandaDataMap, delResultAndSelectList, updateList, delList, checkSelectItemList, checkResultList);
            if (isContinue) {
                iterator.remove();
                continue;
            }
            checkPlans.add(checkPlan);
        }
        if (CollectionUtils.isEmpty(checkPlans)) {
            return;
        }
        List actUpdateList = wandaCheckAllList.stream().filter(Objects::nonNull).map(WandaZywsCheck::getSourceId).distinct().collect(Collectors.toList());
        this.checkPlanService.saveOrUpdateBatch(checkPlans);
        List checkIdList = checkPlans.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.checkOverPointService.remove((Wrapper)new QueryWrapper().lambda().in(CheckOverPoint::getCheckId, checkIdList));
        this.checkFactorService.remove((Wrapper)new QueryWrapper().lambda().in(CheckFactor::getCheckId, checkIdList));
        updateList.addAll(delList);
        if (CollectionUtils.isNotEmpty(updateList)) {
            ((CheckPlanMapper)this.dao).backUpWandCheckUpdateAndDel(updateList, null);
            updateList.removeAll(delList);
        }
        if (CollectionUtils.isNotEmpty(delResultAndSelectList)) {
            ((CheckPlanMapper)this.dao).backUpWandCheckUpdateAndDel(null, new ArrayList<Long>(delResultAndSelectList));
            this.checkResultService.remove((Wrapper)new QueryWrapper().lambda().in(CheckResult::getCheckId, delResultAndSelectList));
            this.checkSelectItemService.remove((Wrapper)new QueryWrapper().lambda().in(CheckSelectItem::getCheckId, delResultAndSelectList));
        }
        if (CollectionUtils.isNotEmpty(delList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.checkResultService.lambdaUpdate().set(BaseEntity::getIsValid, (Object)false)).set(CheckResult::getItemOpState, (Object)"delete")).set(BaseEntity::getUpdateDate, (Object)LocalDateTime.now())).in(CheckResult::getOldItemId, delList)).ne(BaseEntity::getIsValid, (Object)false)).update();
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.checkResultService.remove((Wrapper)new QueryWrapper().lambda().in(CheckResult::getOldItemId, updateList));
        }
        if (CollectionUtils.isNotEmpty(collect = checkSelectItemList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            this.checkSelectItemService.saveBatch(collect);
        }
        this.checkResultService.getFetchResults(checkIdList, checkResultList);
        Map<Long, Long> checkIdKeyRiskIdValue = this.riskExposeEvaluateService.getRiskByCheckIdAndDeleteOther(checkIdList).stream().distinct().collect(Collectors.toMap(RiskExposeEvaluate::getCheckPlanId, BaseEntity::getId, (k1, k2) -> k1));
        this.riskExposeEvaluateService.autoAddRiskExposeEvaluateFromWandaCheck(checkPlans, checkIdKeyRiskIdValue);
        this.backPushLogService.addPushLogByConvert(actUpdateList, "\u91cd\u65b0\u4e0a\u4f20\u7684\u6570\u636e\u5df2\u66f4\u65b0");
    }

    private boolean compareEachItem(WandaZywsCheck wandaCheck, Map<Long, List<CheckResult>> oldCheckResultMap, CheckPlan checkPlan, Map<Long, List<Integer>> oldCheckSelectItemMap, Map<String, List<WandaZywsCheckFactors>> wandaDataMap, Set<Long> delResultAndSelectList, List<String> updateList, List<String> delList, List<CheckSelectItem> checkSelectItemList, List<CheckResult> checkResultList) {
        List<WandaZywsCheckFactors> wandaZywsCheckFactorsList;
        Map<String, String> oldItemIdAndCheckCodeMap;
        ArrayList oldCheckSelectItem;
        ArrayList oldCheckResultList = oldCheckResultMap.get(checkPlan.getId()) == null ? new ArrayList() : oldCheckResultMap.get(checkPlan.getId());
        List<Object> list = oldCheckSelectItem = oldCheckSelectItemMap.get(checkPlan.getId()) == null ? new ArrayList() : oldCheckSelectItemMap.get(checkPlan.getId());
        if (CollectionUtils.isEmpty(oldCheckResultList)) {
            this.logger.error("\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732--\u6709\u5386\u53f2\u4e3b\u68c0\u9879\u76ee\uff0c\u4f46\u662f\u6ca1\u6709\u5b50\u8868\u6570\u636e\uff0c\u8fd9\u90e8\u5206\u6570\u636e\u5e94\u8be5\u4e0d\u6b63\u5e38\uff0c\u4f46\u662f\u4e5f\u8fdb\u884c\u4e86\u8f6c\u6362\uff0cwandaCheck:{}", (Object)wandaCheck.getSourceId());
            XxlJobHelper.log((String)"\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732--\u6709\u5386\u53f2\u4e3b\u68c0\u9879\u76ee\uff0c\u4f46\u662f\u6ca1\u6709\u5b50\u8868\u6570\u636e\uff0c\u8fd9\u90e8\u5206\u6570\u636e\u5e94\u8be5\u4e0d\u6b63\u5e38\uff0c\u4f46\u662f\u4e5f\u8fdb\u884c\u4e86\u8f6c\u6362\uff0cwandaCheck:{}", (Object[])new Object[]{wandaCheck.getSourceId()});
        }
        if (CollectionUtils.isEmpty(oldItemIdAndCheckCodeMap = oldCheckResultList.stream().filter(item -> item != null && cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)item.getOldItemId()) && cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)item.getCheckCode())).collect(Collectors.toMap(CheckResult::getOldItemId, CheckResult::getCheckCode, (a, b) -> a)))) {
            oldCheckSelectItem = new ArrayList();
            if (wandaCheck.getCheckOpState().equals(WandOpStateEnum.CHECK_OP_RECHECK.getState()) || wandaCheck.getCheckOpState().equals(WandOpStateEnum.CHECK_OP_REPLENISH.getState())) {
                this.logger.error("\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732--\u6709\u5386\u53f2\u4e3b\u68c0\u9879\u76ee\uff0c\u4f46\u662f\u662f\u8865\u68c0\u590d\u68c0\uff0c\u5fc5\u987b\u91cd\u65b0\u4e0a\u4f20\u4e3b\u68c0\u4e4b\u540e\uff0c\u518d\u91cd\u65b0\u4e0a\u4f20\u8865\u68c0\u590d\u68c0\u624d\u53ef\u4ee5{}", (Object)wandaCheck.getSourceId());
                XxlJobHelper.log((String)"\u66f4\u65b0\u4e07\u8fbe\u68c0\u6d4b\u8f6c\u66b4\u9732--\u6709\u5386\u53f2\u4e3b\u68c0\u9879\u76ee\uff0c\u4f46\u662f\u662f\u8865\u68c0\u590d\u68c0\uff0c\u5fc5\u987b\u91cd\u65b0\u4e0a\u4f20\u4e3b\u68c0\u4e4b\u540e\uff0c\u518d\u91cd\u65b0\u4e0a\u4f20\u8865\u68c0\u590d\u68c0\u624d\u53ef\u4ee5{}", (Object[])new Object[]{wandaCheck.getSourceId()});
                return true;
            }
        }
        if (CollectionUtils.isEmpty(wandaZywsCheckFactorsList = wandaDataMap.get(wandaCheck.getSourceId()))) {
            return false;
        }
        wandaZywsCheckFactorsList = new ArrayList(wandaZywsCheckFactorsList.stream().collect(Collectors.toMap(WandaZywsCheckFactors::getOldItemId, Function.identity(), (a, b) -> {
            int dateCompare = a.getLoadTime().compareTo(b.getLoadTime());
            if (dateCompare != 0) {
                return dateCompare > 0 ? a : b;
            }
            return a.getSourceId().hashCode() > b.getSourceId().hashCode() ? a : b;
        })).values());
        for (WandaZywsCheckFactors checkFactors : wandaZywsCheckFactorsList) {
            if (checkFactors == null) continue;
            if (checkFactors.getItemOpState().equals("delete")) {
                delList.add(checkFactors.getOldItemId());
                continue;
            }
            if (CollectionUtils.isEmpty(oldItemIdAndCheckCodeMap)) {
                checkFactors.setItemOpState(WandOpStateEnum.ITEM_OP_ADD.getState());
                delResultAndSelectList.add(checkPlan.getId());
            } else {
                String checkCode = oldItemIdAndCheckCodeMap.get(checkFactors.getOldItemId());
                if (checkCode == null) {
                    checkFactors.setItemOpState(WandOpStateEnum.ITEM_OP_ADD.getState());
                } else {
                    if (checkCode.equals(checkFactors.getCheckCode())) continue;
                    checkFactors.setItemOpState(WandOpStateEnum.ITEM_OP_UPDATE.getState());
                    updateList.add(checkFactors.getOldItemId());
                }
            }
            if (!oldCheckSelectItem.contains(checkFactors.getItemId())) {
                CheckSelectItem checkSelectItem = new CheckSelectItem();
                checkSelectItem.setCheckId(checkPlan.getId());
                checkSelectItem.setCid(checkPlan.getCid());
                checkSelectItem.setItemId(checkFactors.getItemId());
                checkSelectItem.setIsValid(Boolean.valueOf(true));
                checkSelectItemList.add(checkSelectItem);
            }
            List<CheckResult> results = this.settingCheckResultValue(checkFactors, checkPlan);
            for (CheckResult result : results) {
                result.setSourceId(checkFactors.getSourceId());
                result.setSourceCheckId(checkFactors.getCheckId());
                result.setItemOpState(checkFactors.getItemOpState());
                result.setOldItemId(checkFactors.getOldItemId());
                result.setCheckCode(checkFactors.getCheckCode());
                result.setIsRisk(checkFactors.getIsRisk());
                result.setReason(checkFactors.getOpReason());
                result.setCreateDate(DateUtil.getFromDate((Date)checkFactors.getLoadTime()));
                result.setUpdateDate(DateUtil.getFromDate((Date)checkFactors.getLoadTime()));
            }
            checkResultList.addAll(results);
        }
        return false;
    }

    private List<WandaZywsCheck> removeErrorData(List<WandaZywsCheck> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        List<String> collect = list.parallelStream().filter(Objects::nonNull).map(WandaZywsCheck::getSourceId).collect(Collectors.toList());
        List errorSourceIdList = ((CheckPlanMapper)this.dao).getWandaWorkShopNameAndNumDiffer(collect).parallelStream().filter(Objects::nonNull).map(WandaZywsCheckFactors::getCheckId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(errorSourceIdList)) {
            return list;
        }
        return list.stream().filter(item -> !errorSourceIdList.contains(item.getSourceId())).collect(Collectors.toList());
    }

    private void autoAddSelectAndResult(List<CheckPlan> checkPlanList) {
        ArrayList<CheckSelectItem> checkSelectItemList = new ArrayList<CheckSelectItem>();
        ArrayList<CheckResult> checkResultList = new ArrayList<CheckResult>();
        List<String> wandaZywsCheckIdAllList = checkPlanList.stream().map(CheckPlan::getWandaZywsCheckId).distinct().collect(Collectors.toList());
        Map<String, List<WandaZywsCheckFactors>> wandaDataMap = this.getWandaZywsCheckFactorsByWandaCheckIds(wandaZywsCheckIdAllList, true);
        for (CheckPlan checkPlan : checkPlanList) {
            List<WandaZywsCheckFactors> wandaZywsCheckFactorsList = wandaDataMap.get(checkPlan.getWandaZywsCheckId());
            if (wandaZywsCheckFactorsList == null) continue;
            for (WandaZywsCheckFactors checkFactors : wandaZywsCheckFactorsList) {
                CheckSelectItem checkSelectItem = new CheckSelectItem();
                checkSelectItem.setCheckId(checkPlan.getId());
                checkSelectItem.setCid(checkPlan.getCid());
                checkSelectItem.setItemId(checkFactors.getItemId());
                checkSelectItem.setIsValid(Boolean.valueOf(true));
                checkSelectItemList.add(checkSelectItem);
                List<CheckResult> results = this.settingCheckResultValue(checkFactors, checkPlan);
                for (CheckResult result : results) {
                    result.setSourceId(checkFactors.getSourceId());
                    result.setSourceCheckId(checkFactors.getCheckId());
                    result.setItemOpState(WandOpStateEnum.ITEM_OP_ADD.getState());
                    result.setIsRisk(checkFactors.getIsRisk());
                    result.setCheckCode(checkFactors.getCheckCode());
                    result.setOldItemId(checkFactors.getOldItemId());
                    result.setReason(checkFactors.getOpReason());
                    result.setCreateDate(DateUtil.getFromDate((Date)checkFactors.getLoadTime()));
                    result.setUpdateDate(DateUtil.getFromDate((Date)checkFactors.getLoadTime()));
                }
                checkResultList.addAll(results);
            }
        }
        List collect = checkSelectItemList.stream().distinct().collect(Collectors.toList());
        this.checkSelectItemService.saveBatch(collect);
        List checkIdList = checkPlanList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        this.checkResultService.getFetchResults(checkIdList, checkResultList);
    }

    private void settingCheckPlanValue(WandaZywsCheck wandaZywsCheck, CheckPlan checkPlan) {
        if (checkPlan.getId() == null) {
            checkPlan.setId(Long.valueOf(this.idworker.nextId()));
        }
        checkPlan.setIsValid(Boolean.valueOf(true));
        checkPlan.setCheckFrom(Integer.valueOf(3));
        checkPlan.setReportStatus(Integer.valueOf(2));
        checkPlan.setEditStatus(Integer.valueOf(2));
        checkPlan.setCreateDate(LocalDateTime.ofInstant(wandaZywsCheck.getLoadTime().toInstant(), ZoneId.systemDefault()));
        checkPlan.setUpdateDate(LocalDateTime.ofInstant(wandaZywsCheck.getLoadTime().toInstant(), ZoneId.systemDefault()));
        checkPlan.setIndustryCode(wandaZywsCheck.getIndustryCode());
        checkPlan.setIndustryName(wandaZywsCheck.getIndustryName2());
        if (checkPlan.getIndustryCode() == null || checkPlan.getIndustryCode().equals("null") || checkPlan.getIndustryCode().equals("NULL")) {
            checkPlan.setIndustryCode(null);
            checkPlan.setIndustryName(null);
        }
        checkPlan.setWandaZywsCheckId(wandaZywsCheck.getOldCheckId());
        checkPlan.setCid(wandaZywsCheck.getCid());
        checkPlan.setCheckWorkNo(wandaZywsCheck.getDetectName());
        checkPlan.setCheckWorkName(wandaZywsCheck.getProjectName());
        checkPlan.setProjectName(wandaZywsCheck.getProjectName());
        LocalDateTime wandCheckDateBegin = null;
        LocalDateTime wandCheckDateEnd = null;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandaZywsCheck.getCheckDate())) {
            wandCheckDateBegin = DateUtil.parseDateTime((String)(wandaZywsCheck.getCheckDate() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandaZywsCheck.getCheckDateEnd())) {
            wandCheckDateEnd = DateUtil.parseDateTime((String)(wandaZywsCheck.getCheckDateEnd() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (wandCheckDateBegin == null || checkPlan.getCheckDateBegin() == null || !checkPlan.getCheckDateBegin().isAfter(wandCheckDateBegin)) {
            checkPlan.setCheckDateBegin(wandCheckDateBegin);
            checkPlan.setCheckDateEnd(wandCheckDateEnd);
            checkPlan.setThirdOrgId(Long.valueOf(wandaZywsCheck.getOrgId()));
            checkPlan.setThirdOrgName(wandaZywsCheck.getOrgName2());
            checkPlan.setCheckType(Long.valueOf(Long.parseLong("" + wandaZywsCheck.getCheckType())));
            if (cn.smarthse.util.common.StringUtils.isEmpty((CharSequence)wandaZywsCheck.getProjectName()) && wandCheckDateBegin != null) {
                if (checkPlan.getCheckType() == 2L) {
                    checkPlan.setCheckWorkName(wandCheckDateBegin.getYear() + wandaZywsCheck.getComName2() + "\u5b9a\u671f\u68c0\u6d4b");
                    checkPlan.setProjectName(wandCheckDateBegin.getYear() + wandaZywsCheck.getComName2() + "\u5b9a\u671f\u68c0\u6d4b");
                } else if (checkPlan.getCheckType() == 3L) {
                    checkPlan.setCheckWorkName(wandCheckDateBegin.getYear() + wandaZywsCheck.getComName2() + "\u73b0\u72b6\u8bc4\u4ef7");
                    checkPlan.setProjectName(wandCheckDateBegin.getYear() + wandaZywsCheck.getComName2() + "\u73b0\u72b6\u8bc4\u4ef7");
                } else if (checkPlan.getCheckType() == 4L) {
                    checkPlan.setCheckWorkName(wandCheckDateBegin.getYear() + wandaZywsCheck.getComName2() + "\u63a7\u5236\u6548\u679c\u8bc4\u4ef7");
                    checkPlan.setProjectName(wandCheckDateBegin.getYear() + wandaZywsCheck.getComName2() + "\u63a7\u5236\u6548\u679c\u8bc4\u4ef7");
                }
            }
        }
        checkPlan.setTargetStandardId(wandaZywsCheck.getTargetStandardId());
        checkPlan.setProjectAreaId(wandaZywsCheck.getProjectAreaId());
        checkPlan.setProjectAddress(wandaZywsCheck.getProjectAddress());
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandaZywsCheck.getReportDate())) {
            checkPlan.setGiveReportDate(DateUtil.parseDateTime((String)(wandaZywsCheck.getReportDate() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        checkPlan.setRiskLevel(Integer.valueOf(wandaZywsCheck.getRiskLevel().byteValue()));
        checkPlan.setCheckReportFileIds(wandaZywsCheck.getReportFile());
        checkPlan.setContractFileIds(wandaZywsCheck.getContractFile());
        checkPlan.setCheckPointMapFileIds(wandaZywsCheck.getPointMapFile());
        checkPlan.setRegisterName(wandaZywsCheck.getRegisterName());
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandaZywsCheck.getRegisterTime())) {
            checkPlan.setReportDate(DateUtil.parseDateTime((String)(wandaZywsCheck.getRegisterTime() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    private List<CheckResult> settingCheckResultValue(WandaZywsCheckFactors wandaZywsCheckFactors, CheckPlan checkPlan) {
        ArrayList<CheckResult> checkResultList = new ArrayList<CheckResult>();
        Long checkId = checkPlan.getId();
        Long cid = checkPlan.getCid();
        long resultNo = this.idworker.nextId();
        CheckResult checkPoint = this.getResultBaseInfo(checkId, cid, resultNo);
        checkPoint.setCheckValue(wandaZywsCheckFactors.getCheckPoint());
        checkResultList.add(checkPoint);
        CheckResult work = this.getResultBaseInfo(checkId, cid, resultNo);
        work.setCheckValue(wandaZywsCheckFactors.getWorkName());
        checkResultList.add(work);
        CheckResult workshop = this.getResultBaseInfo(checkId, cid, resultNo);
        workshop.setCheckValue(wandaZywsCheckFactors.getWorkshop());
        checkResultList.add(workshop);
        CheckResult workNum = this.getResultBaseInfo(checkId, cid, resultNo);
        workNum.setCheckValue(wandaZywsCheckFactors.getWorkNum());
        checkResultList.add(workNum);
        CheckResult resultJudge = this.getResultBaseInfo(checkId, cid, resultNo);
        switch (wandaZywsCheckFactors.getItemId()) {
            case 1: {
                checkPoint.setTargetId(Integer.valueOf(1));
                workshop.setTargetId(Integer.valueOf(124));
                work.setTargetId(Integer.valueOf(125));
                workNum.setTargetId(Integer.valueOf(126));
                resultJudge.setTargetId(Integer.valueOf(10));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getChemistryResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, (Long)resultNo);
                break;
            }
            case 2: {
                checkPoint.setTargetId(Integer.valueOf(11));
                workshop.setTargetId(Integer.valueOf(128));
                work.setTargetId(Integer.valueOf(129));
                workNum.setTargetId(Integer.valueOf(130));
                this.getDustCheckResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 3: {
                checkPoint.setTargetId(Integer.valueOf(24));
                work.setTargetId(Integer.valueOf(133));
                workshop.setTargetId(Integer.valueOf(132));
                workNum.setTargetId(Integer.valueOf(134));
                resultJudge.setTargetId(Integer.valueOf(32));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getNoisesResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 4: {
                checkPoint.setTargetId(Integer.valueOf(33));
                work.setTargetId(Integer.valueOf(137));
                workshop.setTargetId(Integer.valueOf(136));
                workNum.setTargetId(Integer.valueOf(138));
                resultJudge.setTargetId(Integer.valueOf(37));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getHotResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 5: {
                checkPoint.setTargetId(Integer.valueOf(38));
                workshop.setTargetId(Integer.valueOf(140));
                work.setTargetId(Integer.valueOf(141));
                workNum.setTargetId(Integer.valueOf(142));
                this.getZYFSResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 6: {
                checkPoint.setTargetId(Integer.valueOf(53));
                work.setTargetId(Integer.valueOf(145));
                workshop.setTargetId(Integer.valueOf(144));
                workNum.setTargetId(Integer.valueOf(146));
                resultJudge.setTargetId(Integer.valueOf(56));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getGPDCResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 7: {
                checkPoint.setTargetId(Integer.valueOf(57));
                workshop.setTargetId(Integer.valueOf(148));
                work.setTargetId(Integer.valueOf(149));
                workNum.setTargetId(Integer.valueOf(150));
                resultJudge.setTargetId(Integer.valueOf(63));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getWBFSResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 8: {
                checkPoint.setTargetId(Integer.valueOf(64));
                workshop.setTargetId(Integer.valueOf(152));
                work.setTargetId(Integer.valueOf(153));
                workNum.setTargetId(Integer.valueOf(154));
                resultJudge.setTargetId(Integer.valueOf(69));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getGPDCCResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 9: {
                checkPoint.setTargetId(Integer.valueOf(70));
                workshop.setTargetId(Integer.valueOf(156));
                work.setTargetId(Integer.valueOf(157));
                workNum.setTargetId(Integer.valueOf(158));
                resultJudge.setTargetId(Integer.valueOf(75));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getCGPFSResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                checkPoint.setTargetId(Integer.valueOf(84));
                workshop.setTargetId(Integer.valueOf(164));
                work.setTargetId(Integer.valueOf(165));
                workNum.setTargetId(Integer.valueOf(166));
                resultJudge.setTargetId(Integer.valueOf(87));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getSCZDResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 12: {
                checkPoint.setTargetId(Integer.valueOf(88));
                workshop.setTargetId(Integer.valueOf(168));
                work.setTargetId(Integer.valueOf(169));
                workNum.setTargetId(Integer.valueOf(170));
                resultJudge.setTargetId(Integer.valueOf(96));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getJGFSResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 13: {
                checkPoint.setTargetId(Integer.valueOf(97));
                workshop.setTargetId(Integer.valueOf(172));
                work.setTargetId(Integer.valueOf(173));
                workNum.setTargetId(Integer.valueOf(174));
                resultJudge.setTargetId(Integer.valueOf(104));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getSWYSResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 14: {
                checkPoint.setTargetId(Integer.valueOf(105));
                workshop.setTargetId(Integer.valueOf(176));
                work.setTargetId(Integer.valueOf(177));
                workNum.setTargetId(Integer.valueOf(178));
                resultJudge.setTargetId(Integer.valueOf(107));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                if (!cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandaZywsCheckFactors.getCheckValue())) break;
                CheckResult data = this.getResultBaseInfo(checkId, cid, resultNo);
                data.setTargetId(Integer.valueOf(106));
                data.setCheckValueRangeType(this.valueDataGetRangType(wandaZywsCheckFactors.getCheckValue()));
                String value = this.valueDataRemoveLabel(wandaZywsCheckFactors.getCheckValue());
                data.setCheckValue(value);
                data.setCheckValueMax(value);
                data.setCheckValueMin(value);
                checkResultList.add(data);
                break;
            }
            case 15: {
                checkPoint.setTargetId(Integer.valueOf(108));
                workshop.setTargetId(Integer.valueOf(180));
                work.setTargetId(Integer.valueOf(181));
                workNum.setTargetId(Integer.valueOf(182));
                this.getWXQHResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 16: {
                checkPoint.setTargetId(Integer.valueOf(115));
                workshop.setTargetId(Integer.valueOf(187));
                work.setTargetId(Integer.valueOf(184));
                workNum.setTargetId(Integer.valueOf(185));
                resultJudge.setTargetId(Integer.valueOf(120));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                this.getXFLResultData(checkResultList, wandaZywsCheckFactors, checkId, cid, resultNo);
                break;
            }
            case 17: {
                checkPoint.setTargetId(Integer.valueOf(121));
                workshop.setTargetId(Integer.valueOf(191));
                work.setTargetId(Integer.valueOf(188));
                workNum.setTargetId(Integer.valueOf(189));
                resultJudge.setTargetId(Integer.valueOf(123));
                resultJudge.setCheckValue(wandaZywsCheckFactors.getJudgeResult().toString());
                checkResultList.add(resultJudge);
                if (!cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandaZywsCheckFactors.getCheckValue())) break;
                CheckResult data = this.getResultBaseInfo(checkId, cid, resultNo);
                data.setTargetId(Integer.valueOf(122));
                data.setCheckValueRangeType(this.valueDataGetRangType(wandaZywsCheckFactors.getCheckValue()));
                String value = this.valueDataRemoveLabel(wandaZywsCheckFactors.getCheckValue());
                data.setCheckValue(value);
                data.setCheckValueMax(value);
                data.setCheckValueMin(value);
                checkResultList.add(data);
            }
        }
        return checkResultList;
    }

    private void getChemistryResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCtwa())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(3));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCtwa()));
            value = this.valueDataRemoveLabel(wandFactors.getCtwa());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCsteCstel())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(4));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCsteCstel()));
            value = this.valueDataRemoveLabel(wandFactors.getCsteCstel());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCmeCmac())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(5));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCmeCmac()));
            value = this.valueDataRemoveLabel(wandFactors.getCmeCmac());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCmeCmac())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(6));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCmeCmac()));
            value = this.valueDataRemoveLabel(wandFactors.getCmeCmac());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCsteCstel())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(7));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCsteCstel()));
            value = this.valueDataRemoveLabel(wandFactors.getCsteCstel());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getExceedPeak())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(8));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getExceedPeak()));
            value = this.valueDataRemoveLabel(wandFactors.getExceedPeak());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getExceedPeak())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(9));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getExceedPeak()));
            value = this.valueDataRemoveLabel(wandFactors.getExceedPeak());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getReductionFactor())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setCheckValue(wandFactors.getReductionFactor());
            data.setTargetId(Integer.valueOf(192));
            checkResultList.add(data);
        }
        if (wandFactors.getFactorId() != null) {
            if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getFactorName())) {
                String factorName = StringUtils.toDBC((String)wandFactors.getFactorName());
                if (wandFactors.getFactorId().equals(655L) && !factorName.equals("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20")) {
                    HarmFactor factors = new HarmFactor();
                    factors.setType("\u5316\u5b66\u56e0\u7d20");
                    if (factorName.contains("(") && factorName.contains(")")) {
                        factors.setNameCh(factorName.substring(factorName.indexOf("(") + 1, factorName.indexOf(")")));
                    } else if (factorName.contains("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20")) {
                        factors.setNameCh(factorName.replace("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20", ""));
                    } else {
                        factors.setNameCh(factorName);
                    }
                    Map factorMap = this.harmFactorService.addOtherHarmFactorSubmit(factors, null, cid, false);
                    if (factorMap.get(false) != null) {
                        wandFactors.setFactorId(((HarmFactor)factorMap.get(false)).getId());
                    } else {
                        wandFactors.setFactorId(((HarmFactor)factorMap.get(true)).getId());
                    }
                }
            }
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(2));
            data.setCheckValue(wandFactors.getFactorId().toString());
            checkResultList.add(data);
        }
    }

    private void getDustCheckResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTotalCtwa())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(13));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTotalCtwa()));
            value = this.valueDataRemoveLabel(wandFactors.getTotalCtwa());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTotalRange())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(14));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTotalRange()));
            value = this.valueDataRemoveLabel(wandFactors.getTotalRange());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTotalExceedPeak())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(15));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTotalExceedPeak()));
            value = this.valueDataRemoveLabel(wandFactors.getTotalExceedPeak());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTotalExceedPeak())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(16));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTotalExceedPeak()));
            value = this.valueDataRemoveLabel(wandFactors.getTotalExceedPeak());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTotalReductionFactor())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(193));
            data.setCheckValue(wandFactors.getTotalReductionFactor());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTotalJudgeResult())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(17));
            data.setCheckValue(wandFactors.getTotalJudgeResult());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRespirableCtwa())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(18));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getRespirableCtwa()));
            value = this.valueDataRemoveLabel(wandFactors.getRespirableCtwa());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRespirableRange())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(19));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getRespirableRange()));
            value = this.valueDataRemoveLabel(wandFactors.getRespirableRange());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRespirableExceedPeak())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(20));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getRespirableExceedPeak()));
            value = this.valueDataRemoveLabel(wandFactors.getRespirableExceedPeak());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRespirableExceedPeak())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(21));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getRespirableExceedPeak()));
            value = this.valueDataRemoveLabel(wandFactors.getRespirableExceedPeak());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRespirableReductionFactor())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(195));
            data.setCheckValue(wandFactors.getRespirableReductionFactor());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRespirableJudgeResult())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(22));
            data.setCheckValue(wandFactors.getRespirableJudgeResult());
            checkResultList.add(data);
        }
        if (wandFactors.getFactorId() != null) {
            if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getFactorName())) {
                String factorName = StringUtils.toDBC((String)wandFactors.getFactorName());
                if (wandFactors.getFactorId().equals(654L) && !factorName.equals("\u5176\u4ed6\u7c89\u5c18")) {
                    HarmFactor factors = new HarmFactor();
                    factors.setType("\u7c89\u5c18");
                    if (factorName.contains("(") && factorName.contains(")")) {
                        factors.setNameCh(factorName.substring(factorName.indexOf("(") + 1, factorName.indexOf(")")));
                    } else if (factorName.contains("\u5176\u4ed6\u7c89\u5c18")) {
                        factors.setNameCh(factorName.replace("\u5176\u4ed6\u7c89\u5c18", ""));
                    } else {
                        factors.setNameCh(factorName);
                    }
                    Map factorMap = this.harmFactorService.addOtherHarmFactorSubmit(factors, null, cid, false);
                    if (factorMap.get(false) != null) {
                        wandFactors.setFactorId(((HarmFactor)factorMap.get(false)).getId());
                    } else {
                        wandFactors.setFactorId(((HarmFactor)factorMap.get(true)).getId());
                    }
                }
            }
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(12));
            data.setCheckValue(wandFactors.getFactorId().toString());
            checkResultList.add(data);
        }
    }

    private void getNoisesResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getNoiseType())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(25));
            data.setCheckValue(wandFactors.getNoiseType());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCheckValue())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(26));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCheckValue()));
            value = this.valueDataRemoveLabel(wandFactors.getCheckValue());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCheckValueMin())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(27));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCheckValueMin()));
            value = this.valueDataRemoveLabel(wandFactors.getCheckValueMin());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCheckValueMax())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(28));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCheckValueMax()));
            value = this.valueDataRemoveLabel(wandFactors.getCheckValueMax());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCheckValue840())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(29));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCheckValue840()));
            value = this.valueDataRemoveLabel(wandFactors.getCheckValue840());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchTimes())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(30));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchTimes()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchTimes());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getNoisePeak())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(31));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getNoisePeak()));
            value = this.valueDataRemoveLabel(wandFactors.getNoisePeak());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    private void getHotResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(34));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchTime()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getPhysicalStrength())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(35));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getPhysicalStrength()));
            value = this.valueDataRemoveLabel(wandFactors.getPhysicalStrength());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCheckValue())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(36));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCheckValue()));
            value = this.valueDataRemoveLabel(wandFactors.getCheckValue());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    private void getZYFSResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getUltraType())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(39));
            data.setCheckValue(wandFactors.getUltraType());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(40));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchTime()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getIrradiance())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(41));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getIrradiance()));
            value = this.valueDataRemoveLabel(wandFactors.getIrradiance());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getExposure())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(42));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getExposure()));
            value = this.valueDataRemoveLabel(wandFactors.getExposure());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getEyeIrradiance())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(44));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getEyeIrradiance()));
            value = this.valueDataRemoveLabel(wandFactors.getEyeIrradiance());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getEyeExposure())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(45));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getEyeExposure()));
            value = this.valueDataRemoveLabel(wandFactors.getEyeExposure());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getEyeJudgeResult())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(46));
            data.setCheckValue(wandFactors.getEyeJudgeResult());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getFaceIrradiance())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(47));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getFaceIrradiance()));
            value = this.valueDataRemoveLabel(wandFactors.getFaceIrradiance());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getFaceExposure())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(48));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getFaceExposure()));
            value = this.valueDataRemoveLabel(wandFactors.getFaceExposure());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getFaceJudgeResult())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(49));
            data.setCheckValue(wandFactors.getFaceJudgeResult());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getNoneIrradiance())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(50));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getNoneIrradiance()));
            value = this.valueDataRemoveLabel(wandFactors.getNoneIrradiance());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getNoneExposure())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(51));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getNoneExposure()));
            value = this.valueDataRemoveLabel(wandFactors.getNoneExposure());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getNoneJudgeResult())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(52));
            data.setCheckValue(wandFactors.getNoneJudgeResult());
            checkResultList.add(data);
        }
        if (wandFactors.getJudgeResult() != null) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(43));
            data.setCheckValue(wandFactors.getJudgeResult().toString());
            checkResultList.add(data);
        }
    }

    private void getGPDCResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(54));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchTime()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getFreqStrength())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(55));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getFreqStrength()));
            value = this.valueDataRemoveLabel(wandFactors.getFreqStrength());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    private void getWBFSResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        Object strType = "";
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRadiType())) {
            strType = wandFactors.getRadiType() + ",";
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getWaveType())) {
            strType = wandFactors.getRadiType();
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)strType)) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(58));
            data.setCheckValue((String)strType);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRadiTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(59));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getRadiTime()));
            value = this.valueDataRemoveLabel(wandFactors.getRadiTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getDaily())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(60));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getDaily()));
            value = this.valueDataRemoveLabel(wandFactors.getDaily());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getAverage())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(61));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getAverage()));
            value = this.valueDataRemoveLabel(wandFactors.getAverage());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchDensity())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(62));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchDensity()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchDensity());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    private void getGPDCCResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getFrequency())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(65));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getFrequency()));
            value = this.valueDataRemoveLabel(wandFactors.getFrequency());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(66));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchTime()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getEletricStrength())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(67));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getEletricStrength()));
            value = this.valueDataRemoveLabel(wandFactors.getEletricStrength());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getMagneticStrength())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(68));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getMagneticStrength()));
            value = this.valueDataRemoveLabel(wandFactors.getMagneticStrength());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    private void getCGPFSResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getUhfrType())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(71));
            data.setCheckValue(wandFactors.getUhfrType());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(72));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchTime()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getPowerDensity())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(73));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getPowerDensity()));
            value = this.valueDataRemoveLabel(wandFactors.getPowerDensity());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getUhfrStrength())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(74));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getUhfrStrength()));
            value = this.valueDataRemoveLabel(wandFactors.getUhfrStrength());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    private void getSCZDResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(85));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchTime()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getAccelet4h())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(86));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getAccelet4h()));
            value = this.valueDataRemoveLabel(wandFactors.getAccelet4h());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    private void getJGFSResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchPart())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(89));
            data.setCheckValue(wandFactors.getTouchPart());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTouchTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(90));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTouchTime()));
            value = this.valueDataRemoveLabel(wandFactors.getTouchTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRadiRange())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(91));
            data.setCheckValue(wandFactors.getRadiRange());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getWaveLength())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(92));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getWaveLength()));
            value = this.valueDataRemoveLabel(wandFactors.getWaveLength());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getExposTime())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(93));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getExposTime()));
            value = this.valueDataRemoveLabel(wandFactors.getExposTime());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getExposAmount())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(94));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getExposAmount()));
            value = this.valueDataRemoveLabel(wandFactors.getExposAmount());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getRadiance())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(95));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getRadiance()));
            value = this.valueDataRemoveLabel(wandFactors.getRadiance());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    private void getSWYSResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCmeCmac())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(99));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCmeCmac()));
            value = this.valueDataRemoveLabel(wandFactors.getCmeCmac());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCmeCmac())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(100));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCmeCmac()));
            value = this.valueDataRemoveLabel(wandFactors.getCmeCmac());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCtwa())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(101));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCtwa()));
            value = this.valueDataRemoveLabel(wandFactors.getCtwa());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCsteCstel())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(102));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCsteCstel()));
            value = this.valueDataRemoveLabel(wandFactors.getCsteCstel());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCsteCstel())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(103));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCsteCstel()));
            value = this.valueDataRemoveLabel(wandFactors.getCsteCstel());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getReductionFactor())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(194));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getReductionFactor()));
            value = this.valueDataRemoveLabel(wandFactors.getReductionFactor());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (wandFactors.getFactorId() != null) {
            String factorName;
            if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getFactorName()) && (factorName = StringUtils.toDBC((String)wandFactors.getFactorName())).contains("(") && factorName.contains(")") && wandFactors.getFactorId().equals(658L)) {
                HarmFactor factors = new HarmFactor();
                factors.setType("\u751f\u7269\u56e0\u7d20");
                factors.setNameCh(factorName.substring(factorName.indexOf("(") + 1, factorName.indexOf(")")));
                Map factorMap = this.harmFactorService.addOtherHarmFactorSubmit(factors, null, cid, false);
                if (factorMap.get(false) != null) {
                    wandFactors.setFactorId(((HarmFactor)factorMap.get(false)).getId());
                } else {
                    wandFactors.setFactorId(((HarmFactor)factorMap.get(true)).getId());
                }
            }
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(98));
            data.setCheckValue(wandFactors.getFactorId().toString());
            checkResultList.add(data);
        }
    }

    private void getWXQHResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        String value;
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTemperature())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(109));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getTemperature()));
            value = this.valueDataRemoveLabel(wandFactors.getTemperature());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getTempJudgeResult())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(110));
            data.setCheckValue(wandFactors.getTempJudgeResult());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getWindSpeed())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(111));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getWindSpeed()));
            value = this.valueDataRemoveLabel(wandFactors.getWindSpeed());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getWindJudgeResult())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(112));
            data.setCheckValue(wandFactors.getWindJudgeResult());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getHumidity())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(113));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getHumidity()));
            value = this.valueDataRemoveLabel(wandFactors.getHumidity());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getHumiJudgeResult())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(114));
            data.setCheckValue(wandFactors.getHumiJudgeResult());
            checkResultList.add(data);
        }
    }

    private void getXFLResultData(List<CheckResult> checkResultList, WandaZywsCheckFactors wandFactors, Long checkId, Long cid, Long resultNo) {
        CheckResult data;
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getStaffNum())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(118));
            data.setCheckValue(wandFactors.getStaffNum());
            checkResultList.add(data);
        }
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)wandFactors.getCheckValue())) {
            data = this.getResultBaseInfo(checkId, cid, resultNo);
            data.setTargetId(Integer.valueOf(116));
            data.setCheckValueRangeType(this.valueDataGetRangType(wandFactors.getCheckValue()));
            String value = this.valueDataRemoveLabel(wandFactors.getCheckValue());
            data.setCheckValue(value);
            data.setCheckValueMax(value);
            data.setCheckValueMin(value);
            checkResultList.add(data);
        }
    }

    public String valueDataRemoveLabel(String vaule) {
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)vaule)) {
            vaule = vaule.replace("<", "");
            vaule = vaule.replace("-", "");
            vaule = vaule.replace("<=", "");
            vaule = vaule.replace("\u2264", "");
            return vaule;
        }
        return "";
    }

    public Integer valueDataGetRangType(String vaule) {
        if (cn.smarthse.util.common.StringUtils.isNotEmpty((String)vaule)) {
            if (vaule.contains("-")) {
                return 1;
            }
            if (vaule.contains("<")) {
                return 2;
            }
            if (vaule.contains("<=") || vaule.contains("\u2264")) {
                return 3;
            }
        }
        return 1;
    }

    @Transactional(readOnly=false)
    public List<CheckPlan> getCheckPlanByWandaSourceIdAndDeleteOther(List<String> sourceIdList) {
        ArrayList<CheckPlan> list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CheckPlan::getWandaZywsCheckId, sourceIdList)).eq(BaseEntity::getIsValid, (Object)true)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        list = new ArrayList<CheckPlan>(list.stream().collect(Collectors.toMap(CheckPlan::getWandaZywsCheckId, Function.identity(), (a, b) -> {
            int dateCompare = a.getCreateDate().compareTo(b.getCreateDate());
            if (dateCompare != 0) {
                return dateCompare > 0 ? a : b;
            }
            return a.getId() > b.getId() ? a : b;
        })).values());
        List checkIdList = list.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper itemWrapper = new LambdaQueryWrapper();
        itemWrapper.in(CheckSelectItem::getCheckId, checkIdList);
        this.checkSelectItemService.remove((Wrapper)itemWrapper);
        LambdaQueryWrapper resultWrapper = new LambdaQueryWrapper();
        resultWrapper.in(CheckResult::getCheckId, checkIdList);
        this.checkResultService.remove((Wrapper)resultWrapper);
        LambdaQueryWrapper checkOverPointWrapper = new LambdaQueryWrapper();
        checkOverPointWrapper.in(CheckOverPoint::getCheckId, checkIdList);
        this.checkOverPointService.remove((Wrapper)checkOverPointWrapper);
        LambdaQueryWrapper checkFactorWrapper = new LambdaQueryWrapper();
        checkFactorWrapper.in(CheckFactor::getCheckId, checkIdList);
        this.checkFactorService.remove((Wrapper)checkFactorWrapper);
        return list;
    }

    public Map<String, List<WandaZywsCheckFactors>> getWandaZywsCheckFactorsByWandaCheckIds(List<String> wandaCheckIdList, Boolean isFilterDelete) {
        List<Object> list = ((CheckPlanMapper)this.dao).getWandaZywsCheckFactorsByWandaCheckIds(wandaCheckIdList);
        if (isFilterDelete.booleanValue()) {
            list = list.stream().filter(item -> !item.getItemOpState().equals("delete")).collect(Collectors.toList());
        }
        Map map = list.stream().collect(Collectors.toMap(WandaZywsCheckFactors::getSourceId, Function.identity(), (k1, k2) -> k2));
        List<String> factorsIdList = list.stream().map(WandaZywsCheckFactors::getSourceId).distinct().collect(Collectors.toList());
        List<WandaZywsCheckTarget> targetList = ((CheckPlanMapper)this.dao).getWandaZywsCheckTargetListByFactorsIds(factorsIdList);
        block2: for (WandaZywsCheckTarget target : targetList) {
            Field[] fields;
            WandaZywsCheckFactors factor = (WandaZywsCheckFactors)map.get(target.getFactorsId());
            String attrName = target.getAttrName();
            String attrValue = target.getAttrValue();
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)attrValue) && attrValue.equals("/")) {
                attrValue = null;
            }
            for (Field field : fields = factor.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    String name;
                    TableField exits = field.getAnnotation(TableField.class);
                    if (exits == null || exits.exist() || !(name = field.getName()).equals(attrName)) continue;
                    field.set(factor, attrValue);
                    continue block2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(WandaZywsCheckFactors::getCheckId));
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void inspectionAndReturnWanda(List<Long> wandaZywsCheckIdList) {
        this.logger.error("\u5b9a\u65f6\u4efb\u52a1->\u6821\u9a8c\u4e07\u8fbe\u4ed3\u6570\u636e\u5e76\u9000\u56de\u5f00\u59cb");
        XxlJobHelper.log((String)"\u5b9a\u65f6\u4efb\u52a1->\u6821\u9a8c\u4e07\u8fbe\u4ed3\u6570\u636e\u5e76\u9000\u56de\u5f00\u59cb", (Object[])new Object[0]);
        HashSet<Object> errorList = new HashSet<Object>();
        List<WandaZywsCheck> noCheckFactorys = ((CheckPlanMapper)this.dao).getHaveCheckNoCheckFactorys(wandaZywsCheckIdList);
        ArrayList<WandaCheckBackPushLog> pushLogNoDataList = new ArrayList<WandaCheckBackPushLog>();
        for (WandaZywsCheck wandaZywsCheck : noCheckFactorys) {
            if (wandaZywsCheck == null) continue;
            WandaCheckBackPushLog pushLog = new WandaCheckBackPushLog();
            pushLog.setCheckId(wandaZywsCheck.getSourceId());
            pushLog.setCreateDate(wandaZywsCheck.getLoadTime());
            pushLog.setReason("");
            pushLogNoDataList.add(pushLog);
            errorList.add(wandaZywsCheck.getSourceId());
        }
        if (CollectionUtils.isNotEmpty(pushLogNoDataList)) {
            this.backPushLogService.distinctAddPushLog(pushLogNoDataList, WandCheckBackTypeEnm.noData.getCode());
            String collect = pushLogNoDataList.stream().filter(item -> item != null && cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)item.getCheckId())).map(WandaCheckBackPushLog::getCheckId).collect(Collectors.joining(","));
            XxlJobHelper.log((String)"\u68c0\u6d4b\u4e3b\u8868\u6570\u636e\u5df2\u540c\u6b65\uff0c\u65e0\u6709\u6548\u5b50\u8868\u6570\u636e{}", (Object[])new Object[]{collect});
        }
        Map<String, List<WandaZywsCheckFactors>> workErrorList = ((CheckPlanMapper)this.baseMapper).getWandaWorkShopNameAndNumDiffer(wandaZywsCheckIdList.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(WandaZywsCheckFactors::getCheckId));
        ArrayList<WandaCheckBackPushLog> pushLogWorkErrorList = new ArrayList<WandaCheckBackPushLog>();
        for (Map.Entry entry : workErrorList.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (cn.smarthse.util.common.StringUtils.isBlank((CharSequence)key) || CollectionUtils.isEmpty((Collection)value)) continue;
            WandaZywsCheckFactors factors = (WandaZywsCheckFactors)value.get(0);
            WandaCheckBackPushLog pushLog = new WandaCheckBackPushLog();
            pushLog.setCheckId(key);
            pushLog.setCreateDate(factors.getLoadTime());
            String collect = value.stream().filter(Objects::nonNull).map(WandaZywsCheckFactors::getFactorName).filter(org.apache.commons.lang3.StringUtils::isBlank).collect(Collectors.joining());
            pushLog.setReason("\u90e8\u95e8\u8f66\u95f4\u5c97\u4f4d\u76f8\u540c\u4f46\u662f\u4eba\u5458\u4e0d\u540c:" + collect);
            pushLogWorkErrorList.add(pushLog);
            errorList.add(key);
        }
        if (CollectionUtils.isNotEmpty(pushLogWorkErrorList)) {
            this.backPushLogService.distinctAddPushLog(pushLogWorkErrorList, WandCheckBackTypeEnm.workError.getCode());
            String collect = pushLogWorkErrorList.stream().filter(item -> item != null && cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)item.getCheckId())).map(WandaCheckBackPushLog::getCheckId).collect(Collectors.joining(","));
            XxlJobHelper.log((String)"\u90e8\u95e8\u8f66\u95f4\u5c97\u4f4d\u76f8\u540c\u4f46\u662f\u4eba\u5458\u4e0d\u540c{}", (Object[])new Object[]{collect});
        }
        List<WandaZywsCheck> onlyRecheckAndReplenish = ((CheckPlanMapper)this.baseMapper).getOnlyRecheckAndReplenish(wandaZywsCheckIdList);
        ArrayList<WandaCheckBackPushLog> arrayList = new ArrayList<WandaCheckBackPushLog>();
        for (WandaZywsCheck wandaZywsCheck : onlyRecheckAndReplenish) {
            if (wandaZywsCheck == null || errorList.contains(wandaZywsCheck.getSourceId())) continue;
            WandaCheckBackPushLog pushLog = new WandaCheckBackPushLog();
            pushLog.setCheckId(wandaZywsCheck.getSourceId());
            pushLog.setCreateDate(wandaZywsCheck.getLoadTime());
            pushLog.setReason("\u8bf7\u786e\u8ba4\u4e0a\u4f20\u8865\u68c0\u590d\u68c0\u4e4b\u524d\u662f\u5426\u6709\u5df2\u540c\u6b65\u521d\u68c0\uff0c\u82e5\u6ca1\u6709\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6b64\u68c0\u6d4b\u548c\u521d\u68c0");
            arrayList.add(pushLog);
        }
        if (CollectionUtils.isNotEmpty(arrayList)) {
            this.backPushLogService.distinctAddPushLog(arrayList, WandCheckBackTypeEnm.verifyMain2.getCode());
            String collect = arrayList.stream().filter(item -> item != null && cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)item.getCheckId())).map(WandaCheckBackPushLog::getCheckId).collect(Collectors.joining(","));
            XxlJobHelper.log((String)"\u5b58\u5728\u53ea\u6709\u590d\u68c0\u8865\u68c0\uff0c\u65e0\u6709\u6548\u521d\u68c0\u7684{}", (Object[])new Object[]{collect});
        }
        this.backPushLogService.addPushLogByAlreadyPass(wandaZywsCheckIdList);
        this.backPushLogService.pushNotBackCheckData();
        this.logger.error("\u5b9a\u65f6\u4efb\u52a1->\u6821\u9a8c\u4e07\u8fbe\u4ed3\u6570\u636e\u5e76\u9000\u56de\u7ed3\u675f");
        XxlJobHelper.log((String)"\u5b9a\u65f6\u4efb\u52a1->\u6821\u9a8c\u4e07\u8fbe\u4ed3\u6570\u636e\u5e76\u9000\u56de\u7ed3\u675f", (Object[])new Object[0]);
    }

    public Integer getEarliestCheckYear(Long cid, List<String> checkTypes) {
        if (cid == null || !CollectionUtils.isEmpty(checkTypes)) {
            return null;
        }
        CheckPlan checkPlan = (CheckPlan)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CheckPlan::getCid, (Object)cid)).in(CheckPlan::getCheckType, checkTypes)).isNotNull(CheckPlan::getCheckDateBegin)).orderByDesc(CheckPlan::getCheckDateBegin)).last("limit 1")).one();
        if (checkPlan != null) {
            return checkPlan.getCheckDateBegin().getYear();
        }
        return null;
    }

    public List<CheckPlan> getLastUpdateCid(Date updateDate) {
        if (updateDate == null) {
            updateDate = DateUtils.getStartTime((Date)DateUtils.addDay((Date)new Date(), (int)-1));
        }
        return ((CheckPlanMapper)this.dao).getLastUpdateCid(updateDate);
    }

    public PageInfo<CheckPlan> getNeedConvertFile(int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<CheckPlan> list = ((CheckPlanMapper)this.dao).getNeedConvertFile();
        return new PageInfo(list);
    }

    public List<CheckPlan> selectCheckPlanList(CheckPlanListParam param) {
        if (param == null) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty((Collection)param.getReportStatusList())) {
            param.setReportStatusList(Arrays.asList(2, 3));
        }
        return ((CheckPlanMapper)this.baseMapper).selectCheckPlanList(param);
    }

    public Boolean exitOverStandardLastly(Long cid) {
        List<Long> lastCheckPlanGroupByCid = ((CheckPlanMapper)this.baseMapper).getLastCheckPlanGroupByCid(Collections.singletonList(cid), null);
        if (CollectionUtils.isEmpty(lastCheckPlanGroupByCid)) {
            return false;
        }
        Long checkId = lastCheckPlanGroupByCid.get(0);
        CheckOverPoint checkOverPoint = (CheckOverPoint)this.checkOverPointService.get((Number)checkId);
        if (Objects.isNull(checkOverPoint)) {
            return false;
        }
        return checkOverPoint.getOverPoint() > 0;
    }

    public List<CheckPlanCountBo> collectFinishCheck(List<Long> cidList) {
        return ((CheckPlanMapper)this.baseMapper).collectFinishCheck(cidList);
    }

    public String getEarlyCheckPlan(Long cid, List<Integer> typeList, Map<String, String> param) {
        if (cid == null) {
            return null;
        }
        CheckPlan one = (CheckPlan)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CheckPlan::getCid, (Object)cid)).in(CheckPlan::getCheckType, typeList)).in(CheckPlan::getReportStatus, Arrays.asList(2, 3))).isNotNull(CheckPlan::getCheckDateBegin)).orderByAsc(CheckPlan::getCheckDateBegin)).last("limit 1")).one();
        if (one != null && one.getCheckDateBegin() != null) {
            return DateUtil.formatDate((LocalDateTime)one.getCheckDateBegin());
        }
        return null;
    }

    public CheckPlanViewListModel getHcCheckPlanCheckingById(Long checkId) {
        List sourceCheckIds;
        CheckPlanViewListModel data = new CheckPlanViewListModel();
        if (checkId == null) {
            throw new RuntimeException("\u68c0\u6d4bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CheckPlan checkPlan = (CheckPlan)this.getById(checkId);
        if (checkPlan == null) {
            throw new RuntimeException("\u68c0\u6d4b\u4e0d\u5b58\u5728");
        }
        List<Object> wandaZywsChecks = new ArrayList();
        if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)checkPlan.getWandaZywsCheckId()) && CollectionUtils.isNotEmpty((Collection)(sourceCheckIds = this.resultService.listObjs((Wrapper)((LambdaQueryWrapper)((QueryWrapper)new QueryWrapper().select((Object[])new String[]{"DISTINCT source_check_id"})).lambda().eq(CheckResult::getCheckId, (Object)checkId)).isNotNull(CheckResult::getSourceCheckId), value -> String.valueOf(value.toString()))))) {
            wandaZywsChecks = ((CheckPlanMapper)this.baseMapper).getWandaCheckInfo(sourceCheckIds);
        }
        boolean present = wandaZywsChecks.stream().anyMatch(item -> item != null && item.getCheckOpState() != null && (item.getCheckOpState().equals("recheck") || item.getCheckOpState().equals("replenish")));
        if (cn.smarthse.util.common.StringUtils.isBlank((CharSequence)checkPlan.getWandaZywsCheckId()) || !present) {
            CheckPlanViewModel model = new CheckPlanViewModel();
            CheckPlanViewModel supplyModel = ((CheckPlanMapper)this.baseMapper).supplyCheckPlanViewModel(checkId);
            model.setThirdOrgName(supplyModel.getThirdOrgName());
            model.setCompanyName(supplyModel.getCompanyName());
            model.setId(checkId);
            this.setCheckPlanViewModel(model, checkPlan);
            data.setBaseCheck(model);
            return data;
        }
        ArrayList<CheckPlanViewModel> reChecks = new ArrayList<CheckPlanViewModel>();
        ArrayList<CheckPlanViewModel> replenishChecks = new ArrayList<CheckPlanViewModel>();
        for (WandaZywsCheck item2 : wandaZywsChecks) {
            if (item2 == null) continue;
            CheckPlan checkPlanTemp = new CheckPlan();
            this.settingCheckPlanValue(item2, checkPlanTemp);
            checkPlanTemp.setWandaZywsCheckId(item2.getSourceId());
            CheckPlanViewModel model = new CheckPlanViewModel();
            model.setCheckOpState(item2.getCheckOpState());
            model.setThirdOrgName(item2.getOrgName2());
            model.setCompanyName(item2.getComName2());
            this.setCheckPlanViewModel(model, checkPlanTemp);
            if (item2.getCheckOpState() == null || item2.getCheckOpState().equals("add") || item2.getCheckOpState().equals("update")) {
                model.setId(checkId);
                data.setBaseCheck(model);
                continue;
            }
            if (item2.getCheckOpState().equals("recheck")) {
                model.setId(null);
                reChecks.add(model);
                continue;
            }
            if (!item2.getCheckOpState().equals("replenish")) continue;
            model.setId(null);
            replenishChecks.add(model);
        }
        data.setReChecks(reChecks);
        data.setReplenishChecks(replenishChecks);
        return data;
    }

    public List<CheckPlanList> getCheckPlanListByCids(CheckPlanListParam checkPlanListParam) {
        List<CheckPlanList> list = this.getCheckPlanList(checkPlanListParam);
        return list;
    }

    public void setCheckPlanViewModel(CheckPlanViewModel model, CheckPlan checkPlan) {
        String url;
        int i;
        String[] urls;
        model.setCheckWorkName(checkPlan.getCheckWorkName());
        model.setRegisterName(checkPlan.getRegisterName());
        model.setCheckDateBegin(checkPlan.getCheckDateBegin());
        model.setCheckDateEnd(checkPlan.getCheckDateEnd());
        model.setTargetStandardId(checkPlan.getTargetStandardId());
        model.setCheckType(checkPlan.getCheckType());
        model.setCheckPointMapFileIds(checkPlan.getCheckPointMapFileIds());
        model.setCheckReportFileIds(checkPlan.getCheckReportFileIds());
        model.setGiveReportDate(checkPlan.getGiveReportDate());
        model.setWandaZywsCheckId(checkPlan.getWandaZywsCheckId());
        model.setIndustryName(checkPlan.getIndustryName());
        model.setCreateDate(checkPlan.getCreateDate());
        Object checkTime = "";
        if (model.getCheckDateBegin() != null) {
            checkTime = model.getCheckDateBegin().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        if (model.getCheckDateEnd() != null) {
            checkTime = (String)checkTime + "\u81f3" + model.getCheckDateEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        model.setCheckTime((String)checkTime);
        LocalDateTime giveReportDate = model.getGiveReportDate();
        if (giveReportDate != null) {
            model.setGiveReportDateStr(giveReportDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        }
        if (model.getTargetStandardId() == null) {
            model.setTargetStandardStr("/");
        } else if (model.getTargetStandardId().equals(1L)) {
            model.setTargetStandardStr("GBZ 2.1-2007");
        } else if (model.getTargetStandardId().equals(2L)) {
            model.setTargetStandardStr("GBZ 2.1-2019");
        }
        if (model.getCheckType() == null) {
            model.setCheckTypeStr("/");
        } else if (model.getCheckType().equals(2L)) {
            model.setCheckTypeStr("\u5b9a\u671f\u68c0\u6d4b");
        } else if (model.getCheckType().equals(3L)) {
            model.setCheckTypeStr("\u73b0\u72b6\u8bc4\u4ef7");
        } else if (model.getCheckType().equals(4L)) {
            model.setCheckTypeStr("\u63a7\u8bc4\u6548\u679c\u8bc4\u4ef7");
        }
        if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)model.getWandaZywsCheckId()) && cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)model.getCheckReportFileIds())) {
            urls = model.getCheckReportFileIds().split(",");
            HashMap<String, String> reportFileNameAndUrlMap = new HashMap<String, String>();
            for (i = 0; i < urls.length; ++i) {
                String[] reportFileName = urls[i].split("/");
                if (reportFileName.length <= 0) continue;
                url = urls[i];
                reportFileNameAndUrlMap.put(url, reportFileName[reportFileName.length - 1]);
            }
            model.setReportFileNameAndUrlMap(reportFileNameAndUrlMap);
        }
        if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)model.getWandaZywsCheckId()) && cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)model.getCheckPointMapFileIds())) {
            urls = model.getCheckPointMapFileIds().split(",");
            HashMap<String, String> pointMapFileNameAndUrlMap = new HashMap<String, String>();
            for (i = 0; i < urls.length; ++i) {
                String[] pointMapFileName = urls[i].split("/");
                if (pointMapFileName.length <= 0) continue;
                url = urls[i];
                pointMapFileNameAndUrlMap.put(url, pointMapFileName[pointMapFileName.length - 1]);
            }
            model.setPointMapFileNameAndUrlMap(pointMapFileNameAndUrlMap);
        }
    }
}

