/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.services.hfi.api.entity.CheckHistoryData;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.CheckHistoryDataModel;
import cn.smarthse.services.hfi.api.service.ICheckHistoryDataService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.mapper.CheckHistoryDataMapper;
import cn.smarthse.util.common.JsonUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class CheckHistoryDataServiceImpl
extends BaseServiceImp<CheckHistoryDataMapper, CheckHistoryData>
implements ICheckHistoryDataService {
    private ICheckPlanService checkPlanService;
    private ICheckResultService checkResultService;

    @Lazy
    @Autowired
    public void autowired(ICheckPlanService checkPlanService, ICheckResultService checkResultService) {
        this.checkPlanService = checkPlanService;
        this.checkResultService = checkResultService;
    }

    @Async
    public void saveSnapshoot(Long checkId) {
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkId);
        if (checkPlan == null) {
            this.logger.warn("\u8b66\u544a:::\u4fdd\u5b58\u68c0\u6d4b\u6570\u636e\u5feb\u7167\uff0c\u68c0\u6d4b\u6570\u636e\u4e0d\u5b58\u5728,\u68c0\u6d4bid:" + checkId);
            return;
        }
        List checkResultList = this.checkResultService.getByCheckId(checkId);
        CheckHistoryDataModel model = new CheckHistoryDataModel();
        model.setCheckPlan(checkPlan);
        model.setCheckResults(checkResultList);
        CheckHistoryData data = new CheckHistoryData();
        data.setCheckId(checkId);
        data.setCid(checkPlan.getCid());
        data.setData(JsonUtils.toJsonString((Object)model));
        data.setCreateBy(Long.valueOf(0L));
        data.setCreateDate(LocalDateTime.now());
        data.setUpdateBy(Long.valueOf(0L));
        data.setUpdateDate(LocalDateTime.now());
        data.setIsValid(Boolean.valueOf(true));
        this.save(data);
    }

    public List<CheckHistoryDataModel> getByCheckId(Long checkId, LocalDateTime startDate, LocalDateTime endDate) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(CheckHistoryData::getCheckId, (Object)checkId);
        if (startDate != null) {
            if (endDate == null) {
                endDate = LocalDateTime.now();
            }
            wrapper.between(CheckHistoryData::getCreateDate, (Object)startDate, (Object)endDate);
        }
        List list = this.list((Wrapper)wrapper);
        return this.parse(list);
    }

    public List<CheckHistoryDataModel> getByCid(Long cid, LocalDateTime startDate, LocalDateTime endDate) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(CheckHistoryData::getCid, (Object)cid);
        if (startDate != null) {
            if (endDate == null) {
                endDate = LocalDateTime.now();
            }
            wrapper.between(CheckHistoryData::getCreateDate, (Object)startDate, (Object)endDate);
        }
        List list = this.list((Wrapper)wrapper);
        return this.parse(list);
    }

    private List<CheckHistoryDataModel> parse(List<CheckHistoryData> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CheckHistoryDataModel> rList = new LinkedList<CheckHistoryDataModel>();
        for (CheckHistoryData data : list) {
            CheckHistoryDataModel model = (CheckHistoryDataModel)JSON.parseObject((String)data.getData(), CheckHistoryDataModel.class);
            rList.add(model);
        }
        return rList;
    }
}

