/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckFactorTemp;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.entity.riskev.RiskPickUpReports;
import cn.smarthse.services.hfi.api.model.riskev.EvDataStatModel;
import cn.smarthse.services.hfi.api.model.riskev.EvFactorTouchNum;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskExposeEvaluateDataVo;
import cn.smarthse.services.hfi.api.service.ICheckFactorTempService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.services.hfi.mapper.CheckFactorTempMapper;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional
public class CheckFactorTempServiceImpl
extends BaseServiceImp<CheckFactorTempMapper, CheckFactorTemp>
implements ICheckFactorTempService {
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @Autowired
    private IHarmFactorService harmFactorService;

    @Transactional
    public void generatePickUpReportsAndCheckFactorTemp(List<Long> cidList) {
        this.logger.info("\u751f\u6210\u62a5\u8868:\u5371\u5bb3\u56e0\u7d20\u63a5\u89e6\u60c5\u51b5,\u68c0\u6d4b\u60c5\u51b5\u5f00\u59cb");
        if (CollectionUtils.isNotEmpty(cidList)) {
            this.remove((Wrapper)Wrappers.lambdaUpdate().in(CheckFactorTemp::getCid, cidList));
        } else {
            this.remove((Wrapper)Wrappers.lambdaUpdate());
        }
        ((CheckFactorTempMapper)this.dao).delRiskPickUpReports(cidList);
        List lastEv = this.riskExposeEvaluateService.getLastEv(new EvQueryParam().setCidList(cidList).setCheckTypeList(Arrays.asList(2L, 3L, 4L)).setIsIgnore(Boolean.valueOf(true)));
        if (CollectionUtils.isEmpty((Collection)lastEv)) {
            return;
        }
        List<Long> allCidList = lastEv.stream().filter(Objects::nonNull).map(RiskExposeEvaluate::getCid).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(allCidList)) {
            Map<Long, Long> overCheckIdMap = ((CheckFactorTempMapper)this.dao).getLastOverCheck(allCidList).stream().filter(Objects::nonNull).collect(Collectors.toMap(CheckOverPoint::getCid, CheckOverPoint::getCheckId, (k1, k2) -> k1));
            lastEv.stream().filter(Objects::nonNull).filter(item -> overCheckIdMap.containsKey(item.getCid())).forEach(item -> item.setSourceId((Long)overCheckIdMap.get(item.getCid())));
        }
        ListUtils.split((List)lastEv, (int)5000).forEach(this::doHandPickUpReportsAndCheckFactorTemp);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CheckFactorTemp::getResult, (Object)"\u4e0d\u5b58\u5728\u8d85\u6807")).like(CheckFactorTemp::getType, (Object)"\u653e\u5c04")).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List<Long> haveHistoryFangSheHaveOverList = ((CheckFactorTempMapper)this.dao).getHistoryFangSheHaveOver(list.stream().map(CheckFactorTemp::getCid).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(haveHistoryFangSheHaveOverList)) {
            return;
        }
        boolean i = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(CheckFactorTemp::getCid, haveHistoryFangSheHaveOverList)).eq(CheckFactorTemp::getResult, (Object)"\u4e0d\u5b58\u5728\u8d85\u6807")).set(CheckFactorTemp::getResult, (Object)"\u5386\u6b21\u68c0\u6d4b\u5b58\u5728\u8d85\u6807")).set(BaseEntity::getUpdateDate, (Object)LocalDateTime.now())).update();
        this.logger.info("\u751f\u6210\u62a5\u8868:\u5371\u5bb3\u56e0\u7d20\u63a5\u89e6\u60c5\u51b5,\u68c0\u6d4b\u60c5\u51b5\u7ed3\u675f");
    }

    public void doHandPickUpReportsAndCheckFactorTemp(List<RiskExposeEvaluate> lastEv) {
        if (CollectionUtils.isEmpty(lastEv)) {
            return;
        }
        List<Long> riskIdList = lastEv.stream().filter(Objects::nonNull).map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, List<RiskExposeEvaluateDataVo>> listMap = ((CheckFactorTempMapper)this.dao).getEvaluateDataList(riskIdList).stream().filter(f -> f != null && StringUtils.isNotBlank((CharSequence)f.getFactorId()) && StringUtils.isNotBlank((CharSequence)f.getWorkName()) && StringUtils.isNotBlank((CharSequence)f.getWorkshop())).collect(Collectors.groupingBy(RiskExposeEvaluateDataVo::getCid));
        this.doHandPickUpReports(listMap);
        this.doHandCheckFactorTemp(lastEv, listMap);
    }

    public void doHandPickUpReports(Map<Long, List<RiskExposeEvaluateDataVo>> listMap) {
        if (MapUtils.isEmpty(listMap)) {
            return;
        }
        ArrayList<RiskPickUpReports> riskPickUpReportsList = new ArrayList<RiskPickUpReports>();
        for (Long cidItem : listMap.keySet()) {
            List<RiskExposeEvaluateDataVo> riskExposeEvaluateDataVos = listMap.get(cidItem);
            if (CollectionUtils.isEmpty(riskExposeEvaluateDataVos)) continue;
            RiskPickUpReports rickPickUpdate = new RiskPickUpReports();
            BeanUtils.copyProperties((Object)riskExposeEvaluateDataVos.get(0), (Object)rickPickUpdate);
            rickPickUpdate.setId(Long.valueOf(this.idworker.nextId()));
            rickPickUpdate.setRiskId(riskExposeEvaluateDataVos.get(0).getRiskExposeEvaluateId());
            rickPickUpdate.setCreateDate(LocalDateTime.now());
            List importantOrg = riskExposeEvaluateDataVos.stream().filter(f -> {
                Integer checkTouchLevel = f.getCheckTouchLevel();
                if (!Objects.equals(checkTouchLevel, 1)) {
                    return false;
                }
                String factorId = f.getFactorId();
                String type = f.getType();
                return "567".equals(factorId) || "\u5316\u5b66\u56e0\u7d20".equals(type) || "\u7c89\u5c18".equals(type);
            }).collect(Collectors.toList());
            rickPickUpdate.setHarmOverNum(Integer.valueOf(importantOrg.size()));
            Map<String, List<RiskExposeEvaluateDataVo>> sameTypeWorkMap = riskExposeEvaluateDataVos.stream().collect(Collectors.groupingBy(g -> {
                String workshop = g.getWorkshop();
                String workName = g.getWorkName();
                String type = g.getType();
                return workshop + workName + type;
            }));
            sameTypeWorkMap.forEach((key, riskExposeEvaluateDataVoList) -> {
                String type;
                RiskExposeEvaluateDataVo riskExposeEvaluateDataVo = (RiskExposeEvaluateDataVo)riskExposeEvaluateDataVoList.get(0);
                Integer workNum = riskExposeEvaluateDataVo.getWorkNum();
                switch (type = riskExposeEvaluateDataVo.getType()) {
                    case "\u5316\u5b66\u56e0\u7d20": {
                        rickPickUpdate.setHx(Integer.valueOf(this.addInt(rickPickUpdate.getHx(), workNum)));
                        riskExposeEvaluateDataVoList.stream().filter(f -> f.getFactorName().contains("\u94c5\u70df") || f.getFactorName().contains("\u94c5\u5c18")).findFirst().ifPresent(f -> rickPickUpdate.setQNum(Integer.valueOf(this.addInt(rickPickUpdate.getQNum(), workNum))));
                        riskExposeEvaluateDataVoList.stream().filter(f -> f.getFactorName().equals("\u82ef")).findFirst().ifPresent(f -> rickPickUpdate.setBNum(Integer.valueOf(this.addInt(rickPickUpdate.getBNum(), workNum))));
                        break;
                    }
                    case "\u7c89\u5c18": {
                        rickPickUpdate.setFc(Integer.valueOf(this.addInt(rickPickUpdate.getFc(), workNum)));
                        riskExposeEvaluateDataVoList.stream().filter(f -> f.getFactorName().contains("\u77fd\u5c18")).findFirst().ifPresent(f -> rickPickUpdate.setXcNum(Integer.valueOf(this.addInt(rickPickUpdate.getXcNum(), workNum))));
                        riskExposeEvaluateDataVoList.stream().filter(f -> f.getFactorName().contains("\u7164\u5c18")).findFirst().ifPresent(f -> rickPickUpdate.setMcNum(Integer.valueOf(this.addInt(rickPickUpdate.getMcNum(), workNum))));
                        riskExposeEvaluateDataVoList.stream().filter(f -> f.getFactorId().equals("5") || f.getFactorId().equals("61") || f.getFactorId().equals("62")).findFirst().ifPresent(f -> rickPickUpdate.setSmcNum(Integer.valueOf(this.addInt(rickPickUpdate.getSmcNum(), workNum))));
                        break;
                    }
                    case "\u7269\u7406\u56e0\u7d20": {
                        rickPickUpdate.setWl(Integer.valueOf(this.addInt(rickPickUpdate.getWl(), workNum)));
                        riskExposeEvaluateDataVoList.stream().filter(f -> f.getFactorId().equals("567")).findFirst().ifPresent(f -> rickPickUpdate.setZy(Integer.valueOf(this.addInt(rickPickUpdate.getZy(), workNum))));
                        riskExposeEvaluateDataVoList.stream().filter(f -> f.getFactorId().equals("567") && NumberUtil.isNumber((CharSequence)riskExposeEvaluateDataVo.getNoiseLevel()) && Double.parseDouble(riskExposeEvaluateDataVo.getNoiseLevel()) >= 80.0).findFirst().ifPresent(f -> rickPickUpdate.setZsNum(Integer.valueOf(this.addInt(rickPickUpdate.getZsNum(), workNum))));
                        break;
                    }
                    case "\u653e\u5c04\u56e0\u7d20": {
                        rickPickUpdate.setFs(Integer.valueOf(this.addInt(rickPickUpdate.getFs(), workNum)));
                        break;
                    }
                    case "\u751f\u7269\u56e0\u7d20": {
                        rickPickUpdate.setSw(Integer.valueOf(this.addInt(rickPickUpdate.getSw(), workNum)));
                        break;
                    }
                    default: {
                        rickPickUpdate.setQt(Integer.valueOf(this.addInt(rickPickUpdate.getQt(), workNum)));
                    }
                }
            });
            Map<String, List<RiskExposeEvaluateDataVo>> sameWorkMap = riskExposeEvaluateDataVos.stream().collect(Collectors.groupingBy(g -> {
                String workshop = g.getWorkshop();
                String workName = g.getWorkName();
                return workshop + workName;
            }));
            sameWorkMap.forEach((k, vlist) -> {
                Integer workNum = ((RiskExposeEvaluateDataVo)vlist.get(0)).getWorkNum();
                rickPickUpdate.setJhrs(Integer.valueOf(this.addInt(rickPickUpdate.getJhrs(), workNum)));
                vlist.stream().filter(f -> Objects.equals(f.getFactorNature(), 1)).findFirst().ifPresent(f -> rickPickUpdate.setNormal(Integer.valueOf(this.addInt(rickPickUpdate.getNormal(), workNum))));
                vlist.stream().filter(f -> Objects.equals(f.getFactorNature(), 2)).findFirst().ifPresent(f -> rickPickUpdate.setSerious(Integer.valueOf(this.addInt(rickPickUpdate.getSerious(), workNum))));
            });
            riskPickUpReportsList.add(rickPickUpdate);
        }
        if (CollectionUtils.isNotEmpty(riskPickUpReportsList)) {
            ((CheckFactorTempMapper)this.dao).insertRiskPickUpReports(riskPickUpReportsList);
        }
    }

    private int addInt(Integer a, Integer b) {
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        return a + b;
    }

    public void doHandCheckFactorTemp(List<RiskExposeEvaluate> lastEv, Map<Long, List<RiskExposeEvaluateDataVo>> listMap) {
        ArrayList<CheckFactorTemp> checkFactorTempList = new ArrayList<CheckFactorTemp>();
        for (RiskExposeEvaluate evaluate : lastEv) {
            if (evaluate == null) continue;
            LocalDateTime date = LocalDateTime.now();
            Long cid = evaluate.getCid();
            CheckFactorTemp factorTemp = new CheckFactorTemp();
            factorTemp.setId(Long.valueOf(this.idworker.nextId()));
            factorTemp.setRiskId(evaluate.getId());
            factorTemp.setCheckId(evaluate.getCheckPlanId());
            factorTemp.setCid(cid);
            factorTemp.setCheckDate(evaluate.getCheckDate());
            factorTemp.setDataUpdateDate(evaluate.getUpdateDate());
            factorTemp.setCreateDate(date);
            factorTemp.setUpdateDate(date);
            factorTemp.setIsValid(Boolean.valueOf(true));
            if (evaluate.getSourceId() == null) {
                factorTemp.setResult("\u4e0d\u5b58\u5728\u8d85\u6807");
            } else if (Objects.equals(evaluate.getSourceId(), evaluate.getCheckPlanId())) {
                factorTemp.setResult("\u6700\u8fd1\u4e00\u6b21\u68c0\u6d4b\u5b58\u5728\u8d85\u6807");
            } else {
                factorTemp.setResult("\u5386\u6b21\u68c0\u6d4b\u5b58\u5728\u8d85\u6807");
            }
            List<RiskExposeEvaluateDataVo> riskExposeEvaluateDataVos = listMap.get(cid);
            if (CollectionUtils.isEmpty(riskExposeEvaluateDataVos)) continue;
            HashSet<String> harmsNameSet = new HashSet<String>();
            HashSet<CallSite> harmsIdSet = new HashSet<CallSite>();
            HashSet<String> paramCodeSet = new HashSet<String>();
            HashSet<String> typeSet = new HashSet<String>();
            int isOver = 0;
            for (RiskExposeEvaluateDataVo dataVo : riskExposeEvaluateDataVos) {
                if (StringUtils.isNotBlank((CharSequence)dataVo.getFactorName())) {
                    harmsNameSet.add(dataVo.getFactorName());
                }
                if (StringUtils.isNotBlank((CharSequence)dataVo.getFactorId())) {
                    harmsIdSet.add((CallSite)((Object)("," + dataVo.getFactorId() + ",")));
                }
                if (StringUtils.isNotBlank((CharSequence)dataVo.getParamCode())) {
                    paramCodeSet.add(dataVo.getParamCode());
                }
                if (StringUtils.isNotBlank((CharSequence)dataVo.getType())) {
                    typeSet.add(dataVo.getType());
                }
                if (!Objects.equals(dataVo.getCheckTouchLevel(), 1)) continue;
                ++isOver;
            }
            factorTemp.setHarmsName(StringUtils.join(harmsNameSet, (String)","));
            factorTemp.setHarmsId(StringUtils.join(harmsIdSet, (String)","));
            factorTemp.setParamCode(StringUtils.join(paramCodeSet, (String)","));
            factorTemp.setType(StringUtils.join(typeSet, (String)","));
            if (!"\u6700\u8fd1\u4e00\u6b21\u68c0\u6d4b\u5b58\u5728\u8d85\u6807".equals(factorTemp.getResult()) && isOver > 0) {
                factorTemp.setResult("\u6700\u8fd1\u4e00\u6b21\u68c0\u6d4b\u5b58\u5728\u8d85\u6807");
            }
            checkFactorTempList.add(factorTemp);
        }
        if (CollectionUtils.isNotEmpty(checkFactorTempList)) {
            this.saveBatch(checkFactorTempList);
        }
    }

    public List<EvDataStatModel> getEvDataStatModels(Long cid) {
        HashMap<String, EvDataStatModel> map = new HashMap<String, EvDataStatModel>();
        for (String type : Arrays.asList("\u7c89\u5c18", "\u5316\u5b66\u56e0\u7d20", "\u7269\u7406\u56e0\u7d20", "\u653e\u5c04\u56e0\u7d20", "\u751f\u7269\u56e0\u7d20")) {
            EvDataStatModel model = new EvDataStatModel();
            model.setFactorType(type);
            model.setNums(new ArrayList());
            map.put(type, model);
        }
        List lastEv = this.riskExposeEvaluateService.getLastEv(new EvQueryParam().setCidList(Collections.singletonList(cid)));
        if (CollectionUtils.isEmpty((Collection)lastEv) || lastEv.get(0) == null) {
            return new ArrayList<EvDataStatModel>(map.values());
        }
        List<RiskExposeEvaluateDataVo> evaluateDataList = ((CheckFactorTempMapper)this.dao).getEvaluateDataList(Collections.singletonList(((RiskExposeEvaluate)lastEv.get(0)).getId()));
        if (CollectionUtils.isEmpty(evaluateDataList)) {
            return new ArrayList<EvDataStatModel>(map.values());
        }
        Map<String, List<RiskExposeEvaluateDataVo>> sameTypeWorkMap = evaluateDataList.stream().filter(f -> f != null && StringUtils.isNotBlank((CharSequence)f.getFactorId()) && StringUtils.isNotBlank((CharSequence)f.getWorkName()) && StringUtils.isNotBlank((CharSequence)f.getWorkshop())).collect(Collectors.groupingBy(RiskExposeEvaluateData::getFactorId));
        sameTypeWorkMap.forEach((key, dataVos) -> {
            if (dataVos == null || dataVos.isEmpty()) {
                return;
            }
            RiskExposeEvaluateDataVo common = (RiskExposeEvaluateDataVo)dataVos.get(0);
            EvDataStatModel model = (EvDataStatModel)map.get(common.getType());
            if (model == null) {
                return;
            }
            if (key.contains(",")) {
                String harmNames = this.harmFactorService.getHarmNames(key);
                common.setFactorName(harmNames);
            }
            EvFactorTouchNum detail = new EvFactorTouchNum();
            detail.setFactorId(common.getFactorId());
            detail.setFactorType(common.getType());
            int workNum = dataVos.stream().collect(Collectors.groupingBy(f -> f.getWorkshop() + f.getWorkName(), Collectors.summingInt(RiskExposeEvaluateData::getWorkNum))).values().stream().mapToInt(Integer::intValue).sum();
            detail.setTouchNum(Integer.valueOf(workNum));
            detail.setFactorName(common.getFactorName() + "\u66b4\u9732\u4eba\u6570:" + workNum);
            model.getNums().add(detail);
        });
        return new ArrayList<EvDataStatModel>(map.values());
    }
}

