/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.db.common.service.imp.BaseServiceImp;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckFactor;
import cn.smarthse.services.hfi.api.entity.CheckItem;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.entity.CheckSelectItem;
import cn.smarthse.services.hfi.api.model.ComFactorQueryModel;
import cn.smarthse.services.hfi.api.service.ICheckFactorService;
import cn.smarthse.services.hfi.api.service.ICheckItemService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckSelectItemService;
import cn.smarthse.services.hfi.mapper.CheckFactorMapper;
import cn.smarthse.services.hfi.pojo.ComFactorIdBo;
import cn.smarthse.services.hfi.property.ProjectEnvEnum;
import cn.smarthse.services.hfi.property.ProjectProperties;
import cn.smarthse.services.hfi.sys.SysConstants;
import cn.smarthse.util.common.JsonUtils;
import cn.smarthse.util.common.ListUtils;
import cn.smarthse.util.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class CheckFactorServiceImpl
extends BaseServiceImp<CheckFactorMapper, CheckFactor>
implements ICheckFactorService {
    @Autowired
    @Lazy
    private ICheckResultService checkResultService;
    @Autowired
    private ICheckSelectItemService checkSelectItemService;
    @Autowired
    private ICheckItemService checkItemService;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @Autowired
    private ICheckPlanService checkPlanService;
    @Autowired
    private ProjectProperties projectProperties;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;

    @PostConstruct
    public void init() {
        if (this.projectProperties.getEnvEnum().equals((Object)ProjectEnvEnum.PRO)) {
            // empty if block
        }
    }

    public void startStatistic(List<Long> cidList) {
        long start = System.currentTimeMillis();
        this.logger.info("\u5f00\u59cb\u7edf\u8ba1\u4f01\u4e1a\u68c0\u6d4b\u6d89\u53ca\u7684\u5371\u5bb3\u56e0\u7d20(\u53ea\u7edf\u8ba1\u672a\u7edf\u8ba1\u7684):");
        List<CheckFactor> list = this.getComFactorIds(cidList);
        List splitList = ListUtils.split(list, (int)200);
        for (List checkFactors : splitList) {
            this.logger.info("\u4fdd\u5b58\u4f01\u4e1a\u68c0\u6d4b\u6d89\u53ca\u7684\u5371\u5bb3\u56e0\u7d20(" + checkFactors.size() + ")");
            this.saveBatch(checkFactors);
        }
        this.logger.info("\u7edf\u8ba1\u4f01\u4e1a\u68c0\u6d4b\u6d89\u53ca\u7684\u5371\u5bb3\u56e0\u7d20\u5b8c\u6210(\u53ea\u7edf\u8ba1\u672a\u7edf\u8ba1\u7684),\u8017\u65f6:" + (System.currentTimeMillis() - start) / 1000L + "\u79d2");
    }

    @Async
    public void startStatisticByCheckId(Long checkId, Long cid) {
        Long start = System.currentTimeMillis();
        this.logger.info("\u5f00\u59cb\u6839\u636e\u68c0\u6d4bid\u7edf\u8ba1 \u4f01\u4e1a\u68c0\u6d4b\u6d89\u53ca\u7684\u5371\u5bb3\u56e0\u7d20,checkId:" + checkId);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(CheckFactor::getCheckId, (Object)checkId);
        this.remove((Wrapper)wrapper);
        List<CheckFactor> list = this.getComFactorIdsByCheckId(checkId, cid);
        this.logger.info("\u6839\u636e\u68c0\u6d4bid\u7edf\u8ba1 \u4fdd\u5b58\u4f01\u4e1a\u68c0\u6d4b\u6d89\u53ca\u7684\u5371\u5bb3\u56e0\u7d20(" + list.size() + ")\uff0ccheckId:" + checkId);
        this.saveBatch(list);
        this.logger.info("\u6839\u636e\u68c0\u6d4bid\u7edf\u8ba1 \u7edf\u8ba1\u4f01\u4e1a\u68c0\u6d4b\u6d89\u53ca\u7684\u5371\u5bb3\u56e0\u7d20\u5b8c\u6210,\u8017\u65f6:" + (System.currentTimeMillis() - start) / 1000L + "\u79d2");
    }

    private List<CheckFactor> getComFactorIds(List<Long> cidList) {
        LocalDateTime now = LocalDateTime.now();
        List all = this.checkPlanService.getUnCheckedFactor(cidList);
        Map nameMap2007 = this.harmFactorService.getAllIdAndNameMapIncludeInValid2007();
        Map nameMap2019 = this.harmFactorService.getAllIdAndNameMapIncludeInValid2019();
        int count = 0;
        LinkedList<CheckFactor> rList = new LinkedList<CheckFactor>();
        for (CheckPlan checkPlan : all) {
            Set<Long> factorIds = this.getFactorIdsByCheck(checkPlan.getId());
            for (Long factorId : factorIds) {
                CheckFactor checkFactor = new CheckFactor();
                checkFactor.setCheckId(checkPlan.getId());
                checkFactor.setCid(checkPlan.getCid());
                checkFactor.setFactorId(factorId);
                if (checkPlan.getTargetStandardId().equals(1L)) {
                    checkFactor.setFactorName((String)nameMap2007.get("" + factorId));
                } else if (checkPlan.getTargetStandardId().equals(2L)) {
                    checkFactor.setFactorName((String)nameMap2019.get("" + factorId));
                }
                checkFactor.setIsValid(Boolean.valueOf(true));
                checkFactor.setCreateBy(Long.valueOf(0L));
                checkFactor.setUpdateBy(Long.valueOf(0L));
                checkFactor.setUpdateDate(now);
                checkFactor.setCreateDate(now);
                rList.add(checkFactor);
            }
            if (++count % 100 != 0) continue;
            this.logger.info("\u7edf\u8ba1\u68c0\u6d4b\u6d89\u53ca\u7684\u5371\u5bb3\u56e0\u7d20\u8fdb\u5ea6(" + all.size() + "):" + count);
        }
        return rList;
    }

    private List<CheckFactor> getComFactorIdsByCheckId(Long checkId, Long cid) {
        LocalDateTime now = LocalDateTime.now();
        Map nameMap = new HashMap();
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkId);
        nameMap = checkPlan.getTargetStandardId().equals(1L) ? this.harmFactorService.getAllIdAndNameMapIncludeInValid2007() : this.harmFactorService.getAllIdAndNameMapIncludeInValid2019();
        LinkedList<CheckFactor> rList = new LinkedList<CheckFactor>();
        Set<Long> factorIds = this.getFactorIdsByCheck(checkId);
        this.logger.info("\u68c0\u6d4b:" + checkId + "\u6d89\u53ca\u7684\u5371\u5bb3\u56e0\u7d20id:" + JsonUtils.toJsonString(factorIds));
        for (Long factorId : factorIds) {
            CheckFactor checkFactor = new CheckFactor();
            checkFactor.setCheckId(checkId);
            checkFactor.setCid(cid);
            checkFactor.setFactorId(factorId);
            checkFactor.setFactorName((String)nameMap.get("" + factorId));
            checkFactor.setIsValid(Boolean.valueOf(true));
            checkFactor.setCreateBy(Long.valueOf(0L));
            checkFactor.setUpdateBy(Long.valueOf(0L));
            checkFactor.setUpdateDate(now);
            checkFactor.setCreateDate(now);
            rList.add(checkFactor);
        }
        return rList;
    }

    private Set<Long> getFactorIdsByCheck(Long checkId) {
        HashSet<Long> set = new HashSet<Long>();
        List list = this.checkResultService.getByCheckIdAndTargets(checkId, SysConstants.HARM_FACTOR_TARGETS);
        for (CheckResult result : list) {
            String checkValue = result.getCheckValue();
            if (checkValue == null || "".equals(checkValue)) continue;
            try {
                if (!StringUtils.isNumber((String)checkValue)) continue;
                set.add(Long.parseLong(checkValue));
            }
            catch (NumberFormatException e) {
                this.logger.warn("\u5371\u5bb3\u56e0\u7d20\u4e0d\u662fid", (Throwable)e);
            }
        }
        List items = this.checkSelectItemService.getByCheck(checkId);
        for (CheckSelectItem item : items) {
            long itemId = item.getItemId().intValue();
            CheckItem checkItem = this.checkItemService.getByIdFromCache(Long.valueOf(itemId));
            if (checkItem == null || !checkItem.getItemType().equals(2)) continue;
            set.add(checkItem.getFactorId());
        }
        return set;
    }

    public Map<Long, List<Long>> getComFactorIds(LocalDateTime startDate, LocalDateTime endDate, Integer reportStatus, Integer checkType) {
        List checkIds = this.checkPlanService.getCheckIdByDateRange(startDate, endDate, reportStatus, checkType);
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        if (checkIds == null || checkIds.isEmpty()) {
            return map;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        this.queryWrapperIn(wrapper, CheckFactor::getCheckId, checkIds);
        List list = this.list((Wrapper)wrapper);
        for (CheckFactor checkFactor : list) {
            List ids = map.computeIfAbsent(checkFactor.getCid(), k -> new LinkedList());
            ids.add(checkFactor.getFactorId());
        }
        return map;
    }

    public Map<Long, List<Long>> getComFactorIds(ComFactorQueryModel queryModel) {
        List<ComFactorIdBo> list = ((CheckFactorMapper)this.baseMapper).getComFactorIds(queryModel);
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        if (list == null || list.isEmpty()) {
            return map;
        }
        for (ComFactorIdBo bo : list) {
            List ids = map.computeIfAbsent(bo.getCid(), k -> new LinkedList());
            if (ids.contains(bo.getFactorId())) continue;
            ids.add(bo.getFactorId());
        }
        return map;
    }

    public List<String> getCheckFactor(Long cid, Integer checkYear) {
        return ((CheckFactorMapper)this.baseMapper).getCheckFactor(cid, checkYear);
    }
}

