/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.common.util.PageUtil;
import cn.smarthse.services.hfi.api.model.BaseStatQueryModel;
import cn.smarthse.services.hfi.api.model.CheckComStatQueryModel;
import cn.smarthse.services.hfi.api.model.StatComModel;
import cn.smarthse.services.hfi.api.pojo.bo.ComCheckPointBo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckPointCountVo;
import cn.smarthse.services.hfi.api.service.ICheckComCountService;
import cn.smarthse.services.hfi.api.service.ICheckOverPointService;
import cn.smarthse.services.hfi.cache.CheckPointCountVoCache;
import cn.smarthse.services.hfi.serviceimp.StatBaseService;
import com.github.pagehelper.PageInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class CheckComCountServiceImpl
extends StatBaseService
implements ICheckComCountService {
    @Autowired
    private ICheckOverPointService checkOverPointService;
    @Autowired
    private CheckPointCountVoCache cache;
    private List<String> sortFields = Arrays.asList("totalComCount", "checkComCount", "checkRate", "failComCount", "checkPointCount", "failPointCount", "overRate");

    public PageInfo<CheckPointCountVo> comCount(CheckComStatQueryModel queryModel) {
        return PageUtil.getPageInfo(this.comCountListFromCache(queryModel), (int)queryModel.getPage(), (int)queryModel.getRows());
    }

    public CheckPointCountVo allComCount(CheckComStatQueryModel queryModel) {
        HashSet<Long> cids = new HashSet<Long>();
        List<StatComModel> list = this.getAllComAreaModel((BaseStatQueryModel)queryModel);
        list.forEach(model -> cids.add(model.getCid()));
        List comCheckPointBos = this.checkOverPointService.countByCom(queryModel.getStartBegin(), queryModel.getStartEnd());
        Map<Long, ComCheckPointBo> map = this.toMap(comCheckPointBos);
        return this.createCheckPointCountVo(map, cids);
    }

    private List<CheckPointCountVo> comCountListFromCache(CheckComStatQueryModel queryModel) {
        List<CheckPointCountVo> list = this.comCountList(queryModel);
        this.filterList(list, queryModel);
        this.sortList(list, queryModel);
        return list;
    }

    private void sortList(List<CheckPointCountVo> list, CheckComStatQueryModel queryModel) {
        String sortField = queryModel.getSidx();
        if (sortField == null || sortField.isEmpty() || !this.sortFields.contains(sortField)) {
            list.sort((o1, o2) -> {
                if (queryModel.getGroupType().equals(1)) {
                    if (o1.getGroupName().contains("\u672c\u7ea7") || o1.getGroupKey().equals("0")) {
                        return -1;
                    }
                    if (o2.getGroupName().contains("\u672c\u7ea7") || o2.getGroupKey().equals("0")) {
                        return 1;
                    }
                }
                return o2.getCheckComCount() - o1.getCheckComCount();
            });
            return;
        }
        list.sort((o1, o2) -> {
            try {
                PropertyDescriptor propDesc1 = new PropertyDescriptor(sortField, o1.getClass());
                Method readMethod1 = propDesc1.getReadMethod();
                Object r1 = readMethod1.invoke(o1, new Object[0]);
                PropertyDescriptor propDesc2 = new PropertyDescriptor(sortField, o2.getClass());
                Method readMethod2 = propDesc2.getReadMethod();
                Object r2 = readMethod2.invoke(o2, new Object[0]);
                if ("asc".equals(queryModel.getSord())) {
                    if (r2 instanceof String) {
                        if (((String)r1).length() != ((String)r2).length()) {
                            return ((String)r1).length() - ((String)r2).length();
                        }
                        return ((String)r1).compareTo((String)r2);
                    }
                    if (r2 instanceof Integer) {
                        return ((Integer)r1).compareTo((Integer)r2);
                    }
                    return o1.getCheckComCount().compareTo(o2.getCheckComCount());
                }
                if ("desc".equals(queryModel.getSord())) {
                    if (r2 instanceof String) {
                        if (((String)r1).length() != ((String)r2).length()) {
                            return ((String)r2).length() - ((String)r1).length();
                        }
                        return ((String)r2).compareTo((String)r1);
                    }
                    if (r2 instanceof Integer) {
                        return ((Integer)r2).compareTo((Integer)r1);
                    }
                    return o2.getCheckComCount().compareTo(o1.getCheckComCount());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return o2.getCheckComCount().compareTo(o1.getCheckComCount());
        });
    }

    private void filterList(List<CheckPointCountVo> list, CheckComStatQueryModel queryModel) {
        String keyWord = queryModel.getKeyWord();
        Iterator<CheckPointCountVo> iterator = list.iterator();
        if (keyWord != null && keyWord.length() > 0) {
            while (iterator.hasNext()) {
                CheckPointCountVo next = iterator.next();
                if (next.getGroupName().contains(keyWord)) continue;
                iterator.remove();
            }
        }
    }

    private List<CheckPointCountVo> comCountList(CheckComStatQueryModel queryModel) {
        LinkedList<CheckPointCountVo> list = new LinkedList<CheckPointCountVo>();
        long start = System.currentTimeMillis();
        Map<String, Set<Long>> groupMap = this.groupByType((BaseStatQueryModel)queryModel);
        this.logger.info("\u4f01\u4e1a\u5206\u7ec4\u8017\u65f6:" + (System.currentTimeMillis() - start) / 1000L + "\u79d2");
        List comCheckPointBos = this.checkOverPointService.countByCom(queryModel.getStartBegin(), queryModel.getStartEnd());
        Map<Long, ComCheckPointBo> map = this.toMap(comCheckPointBos);
        for (Map.Entry<String, Set<Long>> entry : groupMap.entrySet()) {
            CheckPointCountVo vo = this.createCheckPointCountVo(map, entry.getValue());
            String key = entry.getKey();
            String[] keys = key.split("-");
            vo.setGroupKey(keys[0]);
            vo.setGroupName(keys[1]);
            if (keys.length >= 3) {
                vo.setTag(keys[2]);
            }
            if (queryModel.getFilterEmpty().booleanValue() && vo.getCheckComCount() == 0) continue;
            list.add(vo);
        }
        return list;
    }

    protected CheckPointCountVo createCheckPointCountVo(Map<Long, ComCheckPointBo> map, Set<Long> needComSet) {
        CheckPointCountVo vo = new CheckPointCountVo();
        vo.setTotalComCount(Integer.valueOf(needComSet.size()));
        for (Map.Entry<Long, ComCheckPointBo> entry : map.entrySet()) {
            Long cid = entry.getKey();
            ComCheckPointBo bo = entry.getValue();
            if (!needComSet.contains(cid)) continue;
            vo.setCheckComCount(Integer.valueOf(vo.getCheckComCount() + 1));
            vo.getCheckComIds().add(cid);
            if (bo.getOverPoint() > 0) {
                vo.setFailComCount(Integer.valueOf(vo.getFailComCount() + 1));
            }
            vo.setCheckPointCount(Integer.valueOf(vo.getCheckPointCount() + bo.getCheckPoint()));
            vo.setFailPointCount(Integer.valueOf(vo.getFailPointCount() + bo.getOverPoint()));
        }
        return vo;
    }

    private Map<Long, ComCheckPointBo> toMap(List<ComCheckPointBo> list) {
        HashMap<Long, ComCheckPointBo> map = new HashMap<Long, ComCheckPointBo>();
        for (ComCheckPointBo bo : list) {
            map.put(bo.getCid(), bo);
        }
        return map;
    }
}

