/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.serviceimp;

import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.services.hfi.api.entity.CheckItem;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.entity.CheckTarget;
import cn.smarthse.services.hfi.api.entity.RayDevice;
import cn.smarthse.services.hfi.api.entity.RaySourceDevice;
import cn.smarthse.services.hfi.api.pojo.vo.AppCheckDetailVo;
import cn.smarthse.services.hfi.api.pojo.vo.AppJudgeResultVo;
import cn.smarthse.services.hfi.api.service.IAppCheckDetailService;
import cn.smarthse.services.hfi.api.service.ICheckItemService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckTargetService;
import cn.smarthse.services.hfi.api.service.IRayDeviceService;
import cn.smarthse.services.hfi.api.service.IRaySourceDeviceService;
import cn.smarthse.services.hfi.mapper.AppCheckDetailMapper;
import cn.smarthse.services.hfi.sys.SysConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class AppCheckDetailServiceImpl
implements IAppCheckDetailService {
    private AppCheckDetailMapper checkDetailMapper;
    private ICheckTargetService checkTargetService;
    private ICheckItemService checkItemService;
    private ICheckResultService checkResultService;
    private IRayDeviceService rayDeviceService;
    private IRaySourceDeviceService raySourceDeviceService;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;

    @Autowired
    public void autowired(AppCheckDetailMapper checkDetailMapper, ICheckTargetService checkTargetService, ICheckItemService checkItemService, ICheckResultService checkResultService, IRayDeviceService rayDeviceService, IRaySourceDeviceService raySourceDeviceService) {
        this.checkDetailMapper = checkDetailMapper;
        this.checkTargetService = checkTargetService;
        this.checkItemService = checkItemService;
        this.checkResultService = checkResultService;
        this.rayDeviceService = rayDeviceService;
        this.raySourceDeviceService = raySourceDeviceService;
    }

    public List<AppCheckDetailVo> getDetailByCheck(Long checkId) {
        List<AppJudgeResultVo> resultVoList = this.checkDetailMapper.getJudgeResultListByCheck(checkId, SysConstants.CHECK_POINT_TARGETS, SysConstants.RESULT_JUDGE_TARGETS);
        return this.parse(checkId, resultVoList);
    }

    private List<AppCheckDetailVo> parse(Long checkId, List<AppJudgeResultVo> list) {
        List allResult = this.checkResultService.getByCheckId(checkId);
        List<HarmFactor> factorAttrs = this.getAllCheckFactorByCheck(allResult);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        AppJudgeResultVo currentVo = new AppJudgeResultVo();
        LinkedList<AppCheckDetailVo> rList = new LinkedList<AppCheckDetailVo>();
        ArrayList<Object> currentList = new ArrayList<AppJudgeResultVo>();
        for (AppJudgeResultVo resultVo : list) {
            if (resultVo.getJudgeResult() == null || resultVo.getJudgeResult().isEmpty()) continue;
            if (!resultVo.getCheckPointName().equals(currentVo.getCheckPointName())) {
                this.addToRList(allResult, currentList, rList);
                currentVo = resultVo;
                currentList = new ArrayList();
            }
            this.setJudgeName(allResult, factorAttrs, resultVo);
            if (resultVo.getJudgeName() == null) continue;
            resultVo.createSortNo();
            currentList.add(resultVo);
        }
        this.addToRList(allResult, currentList, rList);
        return rList;
    }

    private void addToRList(List<CheckResult> allResult, List<AppJudgeResultVo> currentList, List<AppCheckDetailVo> rList) {
        RaySourceDevice raySourceDevice;
        RayDevice rayDevice;
        if (currentList.isEmpty()) {
            return;
        }
        currentList.sort(Comparator.comparing(AppJudgeResultVo::getSortNo));
        AppCheckDetailVo vo = new AppCheckDetailVo();
        vo.setCheckPointName(currentList.get(0).getCheckPointName());
        if (currentList.get(0).getJudgeTargetId().equals(79) && (rayDevice = this.getRayDevice(allResult, currentList.get(0).getResultNo())) != null) {
            vo.setCheckPointName(rayDevice.getName() + "(" + vo.getCheckPointName() + ")");
        }
        if (currentList.get(0).getJudgeTargetId().equals(83) && (raySourceDevice = this.getRaySourceDevice(allResult, currentList.get(0).getResultNo())) != null) {
            vo.setCheckPointName(raySourceDevice.getName() + "(" + vo.getCheckPointName() + ")");
        }
        vo.setResults(currentList);
        rList.add(vo);
    }

    private RayDevice getRayDevice(List<CheckResult> allResult, Long resultNo) {
        for (CheckResult checkResult : allResult) {
            if (!checkResult.getResultNo().equals(resultNo) || !checkResult.getTargetId().equals(76)) continue;
            RayDevice rayDevice = (RayDevice)this.rayDeviceService.getById((Serializable)Long.valueOf(Long.parseLong(checkResult.getCheckValue())));
            return rayDevice;
        }
        return null;
    }

    private RaySourceDevice getRaySourceDevice(List<CheckResult> allResult, Long resultNo) {
        for (CheckResult checkResult : allResult) {
            if (!checkResult.getResultNo().equals(resultNo) || !checkResult.getTargetId().equals(80)) continue;
            RaySourceDevice rayDevice = (RaySourceDevice)this.raySourceDeviceService.getById((Serializable)Long.valueOf(Long.parseLong(checkResult.getCheckValue())));
            return rayDevice;
        }
        return null;
    }

    private void setJudgeName(List<CheckResult> checkResultList, List<HarmFactor> factorAttrs, AppJudgeResultVo vo) {
        CheckTarget target = this.checkTargetService.getByIdFromCache(Long.valueOf(vo.getJudgeTargetId().longValue()));
        CheckItem checkItem = this.checkItemService.getByIdFromCache(Long.valueOf(target.getItemId().longValue()));
        String judgeName = null;
        if (checkItem.getId().equals(1L) || checkItem.getId().equals(2L) || checkItem.getId().equals(13L)) {
            judgeName = this.getFactorJudgeName(checkResultList, factorAttrs, vo);
            vo.setJudgeName(judgeName);
            return;
        }
        if (checkItem.getId().equals(3L)) {
            judgeName = this.getNoiseJudgeName(checkResultList, vo);
            vo.setJudgeName(judgeName);
            return;
        }
        if (checkItem.getId().equals(5L)) {
            judgeName = this.getUltravioletRayJudgeName(checkResultList, vo);
            vo.setJudgeName(judgeName);
            return;
        }
        if (checkItem.getId().equals(7L)) {
            judgeName = this.getMicroJudgeName(checkResultList, vo);
            vo.setJudgeName(judgeName);
            return;
        }
        if (checkItem.getId().equals(9L)) {
            judgeName = this.geUhfJudgeName(checkResultList, vo);
            vo.setJudgeName(judgeName);
            return;
        }
        if (checkItem.getId().equals(10L)) {
            judgeName = this.getIonizJudgeName(checkResultList, vo);
            vo.setJudgeName(judgeName);
            return;
        }
        if (checkItem.getId().equals(12L)) {
            judgeName = this.getLaserJudgeName(checkResultList, vo);
            vo.setJudgeName(judgeName);
            return;
        }
        vo.setJudgeName(checkItem.getName());
    }

    private List<HarmFactor> getAllCheckFactorByCheck(List<CheckResult> checkResultList) {
        StringBuilder factorIds = new StringBuilder();
        for (CheckResult result : checkResultList) {
            if (result.getCheckValue() == null || result.getCheckValue().isEmpty() || !result.getTargetId().equals(2) && !result.getTargetId().equals(12) && !result.getTargetId().equals(98)) continue;
            try {
                long factorId = Long.parseLong(result.getCheckValue());
                factorIds.append(factorId + ",");
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (factorIds.length() == 0) {
            return Collections.emptyList();
        }
        return this.harmFactorService.getHarmByIds(factorIds.substring(0, factorIds.length() - 1));
    }

    private String getFactorJudgeName(List<CheckResult> checkResultList, List<HarmFactor> factorAttrs, AppJudgeResultVo vo) {
        for (CheckResult result : checkResultList) {
            if (!result.getTargetId().equals(2) && !result.getTargetId().equals(12) && !result.getTargetId().equals(98) || !result.getResultNo().equals(vo.getResultNo())) continue;
            String checkValue = result.getCheckValue();
            if (checkValue == null || checkValue.isEmpty()) {
                return null;
            }
            Object nameCh = "";
            try {
                long factorId = Long.parseLong(checkValue);
                HarmFactor factor = this.getFactor(factorId, factorAttrs);
                if (factor == null) {
                    return null;
                }
                nameCh = factor.getNameCh();
            }
            catch (NumberFormatException e) {
                nameCh = checkValue;
            }
            if (vo.getJudgeTargetId().equals(17)) {
                nameCh = (String)nameCh + "(\u603b\u5c18)";
            }
            if (vo.getJudgeTargetId().equals(22)) {
                nameCh = (String)nameCh + "(\u547c\u5c18)";
            }
            return nameCh;
        }
        return null;
    }

    private HarmFactor getFactor(Long id, List<HarmFactor> factorAttrs) {
        for (HarmFactor factorAttr : factorAttrs) {
            if (!factorAttr.getId().equals(id)) continue;
            return factorAttr;
        }
        return null;
    }

    private String getNoiseJudgeName(List<CheckResult> checkResultList, AppJudgeResultVo vo) {
        for (CheckResult result : checkResultList) {
            if (!result.getTargetId().equals(25) || !result.getResultNo().equals(vo.getResultNo())) continue;
            String checkValue = result.getCheckValue();
            if (checkValue == null || checkValue.isEmpty()) {
                return null;
            }
            if (checkValue.equals("1")) {
                return "\u566a\u58f0(\u4e2a\u4f53)";
            }
            if (checkValue.equals("2")) {
                return "\u566a\u58f0(\u7a33\u6001)";
            }
            if (checkValue.equals("3")) {
                return "\u566a\u58f0(\u975e\u7a33\u6001)";
            }
            if (checkValue.equals("4")) {
                return "\u566a\u58f0(\u8109\u51b2)";
            }
            return null;
        }
        return null;
    }

    private String getUltravioletRayJudgeName(List<CheckResult> checkResultList, AppJudgeResultVo vo) {
        for (CheckResult result : checkResultList) {
            if (!result.getTargetId().equals(39) || !result.getResultNo().equals(vo.getResultNo())) continue;
            String checkValue = result.getCheckValue();
            if (checkValue == null || checkValue.isEmpty()) {
                return null;
            }
            String type = "";
            if (checkValue.equals("1")) {
                type = "\u4e2d\u6ce2\u7d2b\u5916\u7ebf";
            }
            if (checkValue.equals("2")) {
                type = "\u77ed\u6ce2\u7d2b\u5916\u7ebf";
            }
            if (checkValue.equals("3")) {
                type = "\u7535\u710a\u5f27\u5149";
            }
            if (vo.getJudgeTargetId().equals(43)) {
                return type;
            }
            if (vo.getJudgeTargetId().equals(46)) {
                return type + "(\u7f69\u5185\u773c\u90e8)";
            }
            if (vo.getJudgeTargetId().equals(49)) {
                return type + "(\u7f69\u5185\u9762\u90e8)";
            }
            if (vo.getJudgeTargetId().equals(52)) {
                return type + "(\u65e0\u9632\u62a4)";
            }
            return null;
        }
        return null;
    }

    private String getMicroJudgeName(List<CheckResult> checkResultList, AppJudgeResultVo vo) {
        for (CheckResult result : checkResultList) {
            if (!result.getTargetId().equals(58) || !result.getResultNo().equals(vo.getResultNo())) continue;
            String checkValue = result.getCheckValue();
            if (checkValue == null || checkValue.isEmpty()) {
                return null;
            }
            Object judgeName = "";
            String[] split = checkValue.split(",");
            if (split.length == 2) {
                judgeName = split[0].equals("1") ? (String)judgeName + "\u5168\u8eab\u8f90\u5c04," : (String)judgeName + "\u80a2\u4f53\u5c40\u90e8\u8f90\u5c04,";
                judgeName = split[1].equals("1") ? (String)judgeName + "\u8fde\u7eed\u5fae\u6ce2" : (String)judgeName + "\u8109\u51b2\u5fae\u6ce2";
                return judgeName;
            }
            return null;
        }
        return null;
    }

    private String geUhfJudgeName(List<CheckResult> checkResultList, AppJudgeResultVo vo) {
        for (CheckResult result : checkResultList) {
            if (!result.getTargetId().equals(71) || !result.getResultNo().equals(vo.getResultNo())) continue;
            String checkValue = result.getCheckValue();
            if (checkValue == null || checkValue.isEmpty()) {
                return null;
            }
            if (checkValue.equals("1")) {
                return "\u8fde\u7eed\u6ce2";
            }
            if (checkValue.equals("2")) {
                return "\u8109\u51b2\u6ce2";
            }
            return null;
        }
        return null;
    }

    private String getIonizJudgeName(List<CheckResult> checkResultList, AppJudgeResultVo vo) {
        if (vo.getJudgeTargetId().equals(79)) {
            return "\u7535\u79bb\u8f90\u5c04(\u5c04\u7ebf\u88c5\u7f6e)";
        }
        if (vo.getJudgeTargetId().equals(83)) {
            return "\u7535\u79bb\u8f90\u5c04(\u542b\u6e90\u88c5\u7f6e)";
        }
        return null;
    }

    private String getLaserJudgeName(List<CheckResult> checkResultList, AppJudgeResultVo vo) {
        for (CheckResult result : checkResultList) {
            if (!result.getTargetId().equals(89) || !result.getResultNo().equals(vo.getResultNo())) continue;
            String checkValue = result.getCheckValue();
            if (checkValue == null || checkValue.isEmpty()) {
                return null;
            }
            if (checkValue.equals("1")) {
                return "\u6fc0\u5149\u8f90\u5c04\uff08\u773c\uff09";
            }
            if (checkValue.equals("2")) {
                return "\u6fc0\u5149\u8f90\u5c04\uff08\u76ae\u80a4\uff09";
            }
            return null;
        }
        return null;
    }
}

