/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.schedu;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.smarthse.modules.datacentre.provider.system.ISysFileConvertProvideService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TempTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TempTask.class);
    @Autowired
    ICheckPlanService checkPlanService;
    @DubboReference
    private ISysFileConvertProvideService fileProvideService;
    ThreadPoolExecutor executorService = new ThreadPoolExecutor(4, 8, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(20), new ThreadFactoryBuilder().setNamePrefix("\u4e34\u65f6\u9644\u4ef6\u8f6c\u6362\u4efb\u52a1\u7ebf\u7a0b-").setUncaughtExceptionHandler((thread, throwable) -> log.error("\u7ebf\u7a0b\uff1a{}\uff0c \u4e34\u65f6\u9644\u4ef6\u8f6c\u6362\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff0ce:", (Object)thread, (Object)throwable)).build(), new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    });

    private boolean allowConvert() {
        LocalTime currentTime = LocalTime.now();
        return currentTime.isAfter(LocalTime.of(1, 20)) && currentTime.isBefore(LocalTime.of(6, 0));
    }

    @XxlJob(value="TempTask-convertCheckPlanFile")
    public void convertCheckPlanFile() {
        log.info("\u68c0\u6d4boss\u9644\u4ef6\u8f6c\u6362\u5f00\u59cb");
        int pageNum = 1;
        PageInfo needConvertFile = this.checkPlanService.getNeedConvertFile(pageNum, 100);
        if (needConvertFile == null || CollectionUtils.isEmpty((Collection)needConvertFile.getList())) {
            return;
        }
        this.convert(needConvertFile.getList());
        while (needConvertFile.isHasNextPage() && this.allowConvert()) {
            XxlJobHelper.log((String)"\u5df2\u8f6c\u6362\u9875\u6570\uff1a{}", (Object[])new Object[]{++pageNum});
            log.info("\u5df2\u8f6c\u6362\u9875\u6570\uff1a{}", (Object)pageNum);
            needConvertFile = this.checkPlanService.getNeedConvertFile(pageNum, 100);
            this.convert(needConvertFile.getList());
        }
        log.info("\u68c0\u6d4boss\u9644\u4ef6\u8f6c\u6362\u7ed3\u675f");
    }

    public void convert(List<CheckPlan> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (CheckPlan checkPlan : list) {
                this.executorService.execute(() -> this.handConvert(checkPlan));
            }
        }
    }

    public void handConvert(CheckPlan checkPlan) {
        CheckPlan updater = new CheckPlan();
        updater.setId(checkPlan.getId());
        String checkReportFileIds = checkPlan.getCheckReportFileIds();
        String checkPointMapFileIds = checkPlan.getCheckPointMapFileIds();
        String contractFileIds = checkPlan.getContractFileIds();
        try {
            String osscheckReportFileIds = this.fileProvideService.uploadOutUrlFile2OssMore(checkReportFileIds, ",");
            String osscheckPointMapFileIds = this.fileProvideService.uploadOutUrlFile2OssMore(checkPointMapFileIds, ",");
            String osscontractFileIds = this.fileProvideService.uploadOutUrlFile2OssMore(contractFileIds, ",");
            updater.setCheckReportFileIds(osscheckReportFileIds);
            updater.setCheckPointMapFileIds(osscheckPointMapFileIds);
            updater.setContractFileIds(osscontractFileIds);
            this.checkPlanService.updateById((Object)updater);
        }
        catch (Exception e) {
            log.error("\u9644\u4ef6\u8f6c\u6362\u5f02\u5e38..", (Throwable)e);
        }
    }
}

