/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.schedu;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.hfi.api.model.grade.GradeSearchBaseModel;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.FactorTouchNumVo;
import cn.smarthse.services.hfi.api.service.ICheckFactorService;
import cn.smarthse.services.hfi.api.service.ICheckFactorTempService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckSysService;
import cn.smarthse.services.hfi.api.service.IComOverRateService;
import cn.smarthse.services.hfi.api.service.IFactorLimitValueService;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.services.hfi.cache.RiskTouchNumStatCache;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@EnableScheduling
public class ScheduleTask {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckFactorService checkFactorService;
    @Autowired
    private IComOverRateService comOverRateService;
    @Autowired
    private IFactorLimitValueService factorLimitValueService;
    @Autowired
    private ICheckResultService checkResultService;
    @Autowired
    private ICheckPlanService checkPlanService;
    @Autowired
    private ICheckSysService checkSysService;
    @Autowired
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @Autowired
    private IMicroCompanyRiskExposeEvaluateService microCompanyRiskExposeEvaluateService;
    @Autowired
    private ICheckFactorTempService checkFactorTempService;
    @Autowired
    private RiskTouchNumStatCache riskTouchNumStatCache;
    @Value(value="${spring.profiles.active:}")
    private String environment;

    @XxlJob(value="ScheduleTask-statisticCheckComOverRate")
    public void statisticCheckComOverRate() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u7edf\u8ba1\u4f01\u68c0\u6d4b\u8d85\u6807\u7387");
        this.comOverRateService.startStatistic();
    }

    @XxlJob(value="ScheduleTask-refreshFactorAttrCached")
    public void refreshFactorAttrCached() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5371\u5bb3\u56e0\u7d20\u9650\u503c");
        this.factorLimitValueService.refreshCache();
    }

    @XxlJob(value="ScheduleTask-updateCid")
    public void updateCid() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u66f4\u6b63\u68c0\u6d4b\u6570\u636e\u8868\u7684cid");
        this.checkSysService.updateAllCid();
    }

    @XxlJob(value="ScheduleTask-autoAddRiskExposeEvaluateFromCheck")
    public void autoAddRiskExposeEvaluateFromCheck() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u751f\u6210\u66b4\u9732\u98ce\u9669\u4e0a\u62a5\u6570\u636e");
    }

    @Transactional
    @XxlJob(value="ScheduleTask-autoConvertWandaCheckToRisk")
    public void autoConvertWandaCheckToRisk() {
        JSONObject jsonObj;
        String jobParam = XxlJobHelper.getJobParam();
        List list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            list = StringUtils.parseToLongList((String)jsonObj.getString("id"));
            XxlJobHelper.log((String)list.toString(), (Object[])new Object[0]);
        }
        this.checkPlanService.autoAddCheckPlanFromWandaCheck(list);
        this.checkPlanService.autoUpdateCheckPlanFromWandaCheck(list);
        this.checkPlanService.inspectionAndReturnWanda(list);
    }

    @XxlJob(value="ScheduleTask-statisticCheckOverPoint")
    public void statisticCheckOverPoint() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u7edf\u8ba1\u4f01\u68c0\u6d4b\u7684\u8d85\u6807\u70b9");
        this.checkResultService.statisticAll(null);
    }

    @XxlJob(value="ScheduleTask-statisticCheckFactor")
    public void statisticCheckFactor() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u7edf\u8ba1\u4f01\u68c0\u6d4b\u6d89\u53ca\u5230\u7684\u5371\u5bb3\u56e0\u7d20");
        this.checkFactorService.startStatistic(null);
    }

    @XxlJob(value="ScheduleTask-autoAddAllRiskToCheck")
    public void autoAddAllRiskToCheck() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u68c0\u6d4b\u66b4\u9732\u6ca1\u6709\u540c\u6b65\u81f3\u68c0\u6d4b\u7684\u6570\u636e");
        this.checkPlanService.autoAddAllRiskToCheck(null);
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u7edf\u8ba1\u4f01\u68c0\u6d4b\u6d89\u53ca\u5230\u7684\u5371\u5bb3\u56e0\u7d20");
        this.checkFactorService.startStatistic(null);
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u7edf\u8ba1\u4f01\u68c0\u6d4b\u7684\u68c0\u6d4b\u70b9\uff0c\u8d85\u6807\u70b9");
        this.checkResultService.statisticAll(null);
    }

    @XxlJob(value="ScheduleTask-generatePickUpReports")
    public void generatePickUpReports() {
        this.logger.info("\u751f\u6210\u62a5\u8868:\u5371\u5bb3\u56e0\u7d20\u63a5\u89e6\u60c5\u51b5,\u68c0\u6d4b\u60c5\u51b5\u5f00\u59cb");
        this.checkFactorTempService.generatePickUpReportsAndCheckFactorTemp(null);
        this.logger.info("\u751f\u6210\u62a5\u8868:\u5371\u5bb3\u56e0\u7d20\u63a5\u89e6\u60c5\u51b5,\u68c0\u6d4b\u60c5\u51b5\u7ed3\u675f");
    }

    @XxlJob(value="ScheduleTask-preloadTouchNumStat")
    public void preloadTouchNumStat() {
        Long[] areaIdArr = new Long[]{330000000000L, 330100000000L, 330500000000L, 330900000000L, 330522000000L};
        Byte[] areaLevel = new Byte[]{(byte)1, (byte)2, (byte)2, (byte)2, (byte)3};
        long s = System.currentTimeMillis();
        this.riskTouchNumStatCache.clear();
        for (int i = 0; i < areaIdArr.length; ++i) {
            GradeSearchBaseModel gradeSearchBaseModel = new GradeSearchBaseModel();
            gradeSearchBaseModel.setAreaId(areaIdArr[i]);
            gradeSearchBaseModel.setAreaLevel(areaLevel[i]);
            String key = gradeSearchBaseModel.getAreaId() + "-" + gradeSearchBaseModel.getIsBelongType() + "-" + gradeSearchBaseModel.getOrgAreaId();
            FactorTouchNumVo vo = this.riskExposeEvaluateService.touchNumStat2(gradeSearchBaseModel);
            this.riskTouchNumStatCache.put(key, vo);
        }
        long e = System.currentTimeMillis();
        this.logger.info("\u83b7\u53d6\u6307\u5b9a\u884c\u653f\u533a\u5212\u804c\u4e1a\u75c5\u5371\u5bb3\u63a5\u89e6\u60c5\u51b5\u5206\u6790\u6570\u636e\u5230\u7f13\u5b58,\u8017\u65f6:" + (e - s) / 1000L + "\u79d2");
    }

    @Transactional
    @XxlJob(value="ScheduleTask-autoCopyToYcqRisk")
    public void autoCopyToYcqRisk() {
        JSONObject jsonObj;
        String jobParam = XxlJobHelper.getJobParam();
        List list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            list = StringUtils.parseToLongList((String)jsonObj.getString("cid"));
            XxlJobHelper.log((String)list.toString(), (Object[])new Object[0]);
        }
        this.microCompanyRiskExposeEvaluateService.syncData(list);
    }
}

