/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import cn.smarthse.util.common.date.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import8HighFrequencyElectromagneticMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import8HighFrequencyElectromagneticMain.importHighFrequencyElectromagnetic();
    }

    private static void importHighFrequencyElectromagnetic() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 5 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import8HighFrequencyElectromagneticMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date) values (uuid_short(),?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[10];
        ArrayList<HcCheckResultCollectData> frequencyList = new ArrayList<HcCheckResultCollectData>(2);
        if (result == null || result.isEmpty()) {
            return;
        }
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                if (!frequencyList.isEmpty()) {
                    Import8HighFrequencyElectromagneticMain.setFrequencyValue(params, frequencyList, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                frequencyList.clear();
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            if (o.getData_key().equals("frequency1") || o.getData_key().equals("frequency2")) {
                frequencyList.add(o);
                continue;
            }
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import8HighFrequencyElectromagneticMain.getChemicalTargetId(o);
            params[4] = Import8HighFrequencyElectromagneticMain.getChemicalCheckValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            qr.update(conn, insertSql, params);
            if (count % 100 != 0) continue;
            System.out.println("\u8fdb\u5ea6:" + count + "\u6761");
        }
        if (!frequencyList.isEmpty()) {
            Import8HighFrequencyElectromagneticMain.setFrequencyValue(params, frequencyList, currentResultNo);
            qr.update(conn, insertSql, params);
        }
        frequencyList.clear();
        conn.close();
    }

    private static void setFrequencyValue(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (!list.isEmpty()) {
            params[0] = list.get(0).getHc_id();
            params[1] = list.get(0).getCid();
            params[2] = resultNo;
            params[3] = Import8HighFrequencyElectromagneticMain.getChemicalTargetId(list.get(0));
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = list.get(0).getCreate_date();
            params[9] = list.get(0).getCreate_date();
            if (list.size() == 2 || list.size() == 1) {
                String value1 = "";
                String value2 = "";
                for (HcCheckResultCollectData data : list) {
                    if (data.getData_key().equals("frequency1")) {
                        value1 = data.getData_value();
                    }
                    if (!data.getData_key().equals("frequency2")) continue;
                    value2 = data.getData_value();
                }
                if (value1.equals("")) {
                    value1 = "0";
                }
                if (value2.equals("")) {
                    value2 = "0";
                }
                params[6] = Import8HighFrequencyElectromagneticMain.parseValue(value1);
                params[7] = Import8HighFrequencyElectromagneticMain.parseValue(value2);
            } else {
                throw new RuntimeException("frequency\u7684\u503c\u4e2a\u6570\u4e0d\u6b63\u786e,row_flag=" + list.get(0).getRow_flag());
            }
        }
    }

    private static int getChemicalTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 64;
            }
            case "frequency1": 
            case "frequency2": {
                return 65;
            }
            case "time": {
                return 66;
            }
            case "estrong": {
                return 67;
            }
            case "mstrong": {
                return 68;
            }
            case "result": {
                return 69;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getChemicalCheckValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result")) {
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "1";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("reportname") || o.getData_key().equals("checkproj")) {
            return o.getData_value();
        }
        return Import8HighFrequencyElectromagneticMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        try {
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    private static boolean isEarlyStandard(HcCheckResultCollectData o) {
        Date date = o.getCreate_date();
        if (date == null) {
            date = o.getUpdate_date();
        }
        if (date == null) {
            return true;
        }
        return DateUtils.getFromDate((Date)date).toLocalDate().compareTo(DateUtils.getDate((int)2020, (int)4, (int)1)) < 0;
    }
}

