/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import cn.smarthse.util.common.date.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import7MicrowaveRadiationMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import7MicrowaveRadiationMain.importMicrowaveRadiation();
    }

    public static void importMicrowaveRadiation() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 9 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import7MicrowaveRadiationMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date) values (uuid_short(),?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[10];
        ArrayList<HcCheckResultCollectData> typeList = new ArrayList<HcCheckResultCollectData>(2);
        if (result == null || result.isEmpty()) {
            return;
        }
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                if (!typeList.isEmpty()) {
                    Import7MicrowaveRadiationMain.setTypeValue(params, typeList, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                typeList.clear();
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            if (o.getData_key().equals("type1") || o.getData_key().equals("type2")) {
                typeList.add(o);
                continue;
            }
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import7MicrowaveRadiationMain.getChemicalTargetId(o);
            params[4] = Import7MicrowaveRadiationMain.getChemicalCheckValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            qr.update(conn, insertSql, params);
            if (count % 100 != 0) continue;
            System.out.println("\u8fdb\u5ea6:" + count + "\u6761");
        }
        if (!typeList.isEmpty()) {
            Import7MicrowaveRadiationMain.setTypeValue(params, typeList, currentResultNo);
            qr.update(conn, insertSql, params);
        }
        typeList.clear();
        conn.close();
    }

    private static void setTypeValue(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (!list.isEmpty()) {
            params[0] = list.get(0).getHc_id();
            params[1] = list.get(0).getCid();
            params[2] = resultNo;
            params[3] = Import7MicrowaveRadiationMain.getChemicalTargetId(list.get(0));
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = list.get(0).getCreate_date();
            params[9] = list.get(0).getCreate_date();
            if (list.size() == 2) {
                String value1 = "";
                String value2 = "";
                for (HcCheckResultCollectData data : list) {
                    if (data.getData_key().equals("type1")) {
                        value1 = data.getData_value();
                    }
                    if (!data.getData_key().equals("type2")) continue;
                    value2 = data.getData_value();
                }
                if (value1.equals("\u5168\u8eab\u8f90\u5c04")) {
                    value1 = "0";
                }
                if (value1.equals("\u80a2\u4f53\u5c40\u90e8\u8f90\u5c04")) {
                    value1 = "1";
                }
                if (value2.equals("\u8fde\u7eed\u5fae\u6ce2")) {
                    value2 = "0";
                }
                if (value2.equals("\u8109\u51b2\u5fae\u6ce2")) {
                    value2 = "1";
                }
                if (value1.equals("")) {
                    value1 = "0";
                }
                if (value2.equals("")) {
                    value2 = "0";
                }
                value1 = String.valueOf(Integer.parseInt(value1) + 1);
                value2 = String.valueOf(Integer.parseInt(value2) + 1);
                params[4] = value1 + "," + value2;
            } else {
                throw new RuntimeException("type\u7684\u503c\u4e2a\u6570\u4e0d\u6b63\u786e,row_flag=" + list.get(0).getRow_flag());
            }
        }
    }

    private static int getChemicalTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 57;
            }
            case "type1": 
            case "type2": {
                return 58;
            }
            case "time": {
                return 59;
            }
            case "amount": {
                return 60;
            }
            case "avgdensity": {
                return 61;
            }
            case "powerdensity": {
                return 62;
            }
            case "result": {
                return 63;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getChemicalCheckValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result")) {
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "1";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("reportname") || o.getData_key().equals("checkproj")) {
            return o.getData_value();
        }
        return Import7MicrowaveRadiationMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        try {
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    private static boolean isEarlyStandard(HcCheckResultCollectData o) {
        Date date = o.getCreate_date();
        if (date == null) {
            date = o.getUpdate_date();
        }
        if (date == null) {
            return true;
        }
        return DateUtils.getFromDate((Date)date).toLocalDate().compareTo(DateUtils.getDate((int)2020, (int)4, (int)1)) < 0;
    }
}

