/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import cn.smarthse.util.common.date.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import5UltravioletRayMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import5UltravioletRayMain.importUltravioletRay();
    }

    private static void importUltravioletRay() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 10 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import5UltravioletRayMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date) values (uuid_short(),?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[10];
        if (result == null || result.isEmpty()) {
            return;
        }
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import5UltravioletRayMain.getTargetId(o);
            params[4] = Import5UltravioletRayMain.getCheckValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            qr.update(conn, insertSql, params);
            if (count % 1000 != 0) continue;
            System.out.println("\u8fdb\u5ea6:" + count + "\u6761");
        }
        conn.close();
    }

    private static int getTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 38;
            }
            case "classify": {
                return 39;
            }
            case "time": {
                return 40;
            }
            case "irradiance": {
                return 41;
            }
            case "exposure": {
                return 42;
            }
            case "result": {
                return 43;
            }
            case "irradiance1": {
                return 44;
            }
            case "exposure1": {
                return 45;
            }
            case "result1": {
                return 46;
            }
            case "irradiance2": {
                return 47;
            }
            case "exposure2": {
                return 48;
            }
            case "result2": {
                return 49;
            }
            case "irradiance3": {
                return 50;
            }
            case "exposure3": {
                return 51;
            }
            case "result3": {
                return 52;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getCheckValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result") || o.getData_key().equals("result1") || o.getData_key().equals("result2") || o.getData_key().equals("result3")) {
            if (o.getData_value() == null) {
                return "";
            }
            if (o.getData_value().equals("\u4e0d\u5408\u683c")) {
                return "3";
            }
            if (o.getData_value().equals("\u7b26\u5408")) {
                return "2";
            }
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("classify")) {
            if (o.getData_value() == null || o.getData_value().equals("")) {
                return "1";
            }
            if (o.getData_value().equals("\u7535\u710a\u5f27\u5149")) {
                return "3";
            }
            if (o.getData_value().equals("\u4e2d\u6ce2\u7d2b\u5916\u7ebf")) {
                return "1";
            }
            if (o.getData_value().equals("\u77ed\u6ce2\u7d2b\u5916\u7ebf")) {
                return "2";
            }
            return String.valueOf(Integer.parseInt(o.getData_value()) + 1);
        }
        if (o.getData_key().equals("reportname")) {
            return o.getData_value();
        }
        return Import5UltravioletRayMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        value = value.trim();
        try {
            if (value.contains("\u500d")) {
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("\u500d"))));
            }
            if (value.contains("~")) {
                if (value.startsWith("<") || value.startsWith("\uff1c")) {
                    return String.valueOf(Double.parseDouble(value.substring(1, value.indexOf("~"))));
                }
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("~"))));
            }
            if (value.contains("-")) {
                if (value.startsWith("<") || value.startsWith("\uff1c")) {
                    return String.valueOf(Double.parseDouble(value.substring(1, value.indexOf("-"))));
                }
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("-"))));
            }
            if (value.contains("*")) {
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("*"))));
            }
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u2264")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    private static boolean isEarlyStandard(HcCheckResultCollectData o) {
        Date date = o.getCreate_date();
        if (date == null) {
            date = o.getUpdate_date();
        }
        if (date == null) {
            return true;
        }
        return DateUtils.getFromDate((Date)date).toLocalDate().compareTo(DateUtils.getDate((int)2020, (int)4, (int)1)) < 0;
    }
}

