/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import3NoiseMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import3NoiseMain.importNoise();
    }

    private static void importNoise() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 4 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import3NoiseMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date) values (uuid_short(),?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[10];
        ArrayList<HcCheckResultCollectData> noseTypeList = new ArrayList<HcCheckResultCollectData>(2);
        ArrayList<HcCheckResultCollectData> valueRangeList = new ArrayList<HcCheckResultCollectData>(3);
        if (result == null || result.isEmpty()) {
            return;
        }
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                if (!noseTypeList.isEmpty()) {
                    Import3NoiseMain.setNoseTypeValue(params, noseTypeList, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                if (!valueRangeList.isEmpty()) {
                    Import3NoiseMain.setRangeValue(params, valueRangeList, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                noseTypeList.clear();
                valueRangeList.clear();
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            if (o.getData_key().equals("checkvalue00") || o.getData_key().equals("checkvalue0") || o.getData_key().equals("checkvalue")) {
                valueRangeList.add(o);
                continue;
            }
            if (o.getData_key().equals("noisetype1") || o.getData_key().equals("noisetype")) {
                noseTypeList.add(o);
                continue;
            }
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import3NoiseMain.getTargetId(o);
            params[4] = Import3NoiseMain.getCheckValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            qr.update(conn, insertSql, params);
            if (count % 1000 != 0) continue;
            System.out.println("\u8fdb\u5ea6:" + count + "\u6761");
        }
        if (!noseTypeList.isEmpty()) {
            Import3NoiseMain.setNoseTypeValue(params, noseTypeList, currentResultNo);
            qr.update(conn, insertSql, params);
        }
        if (!valueRangeList.isEmpty()) {
            Import3NoiseMain.setRangeValue(params, valueRangeList, currentResultNo);
            qr.update(conn, insertSql, params);
        }
        noseTypeList.clear();
        valueRangeList.clear();
        conn.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setNoseTypeValue(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (list.isEmpty()) return;
        params[0] = list.get(0).getHc_id();
        params[1] = list.get(0).getCid();
        params[2] = resultNo;
        params[3] = 25;
        params[4] = "";
        params[5] = null;
        params[6] = "";
        params[7] = "";
        params[8] = list.get(0).getCreate_date();
        params[9] = list.get(0).getCreate_date();
        if (list.size() == 2) {
            HcCheckResultCollectData d0 = list.get(0);
            HcCheckResultCollectData d1 = list.get(1);
            HcCheckResultCollectData type1 = null;
            HcCheckResultCollectData type2 = null;
            if (d0.getData_key().equals("noisetype1")) {
                type1 = d0;
                type2 = d1;
            } else {
                if (!d0.getData_key().equals("noisetype")) throw new RuntimeException("\u566a\u58f0\u7c7b\u578b\u503c\u4e0d\u5408\u6cd5,row_flag=" + list.get(0).getRow_flag());
                type1 = d1;
                type2 = d0;
            }
            if (type1.getData_value() == null || type1.getData_value().equals("")) {
                params[4] = "1";
                return;
            } else if (type1.getData_value().equals("1")) {
                params[4] = "1";
                return;
            } else if (type2.getData_value() == null || type2.getData_value().equals("")) {
                params[4] = "2";
                return;
            } else if (type2.getData_value().equals("0")) {
                params[4] = "2";
                return;
            } else if (type2.getData_value().equals("1")) {
                params[4] = "3";
                return;
            } else {
                if (!type2.getData_value().equals("2")) return;
                params[4] = "4";
            }
            return;
        } else {
            if (list.size() != 1) throw new RuntimeException("\u566a\u58f0\u7c7b\u578b\u503c\u4e2a\u6570\u4e0d\u6b63\u786e,row_flag=" + list.get(0).getRow_flag());
            if (list.get(0).getData_key().equals("noisetype")) {
                if (list.get(0).getData_value().equals("0")) {
                    params[4] = "2";
                    return;
                } else if (list.get(0).getData_value().equals("1")) {
                    params[4] = "3";
                    return;
                } else if (list.get(0).getData_value().equals("2")) {
                    params[4] = "4";
                    return;
                } else {
                    if (!list.get(0).getData_value().equals("")) throw new RuntimeException("\u566a\u58f0\u7c7b\u578b\u503c\u4e0d\u5408\u6cd5, row_flag=" + list.get(0).getRow_flag());
                    params[4] = "1";
                }
                return;
            } else {
                if (!list.get(0).getData_key().equals("noisetype1")) return;
                if (!list.get(0).getData_value().equals("1")) throw new RuntimeException("\u566a\u58f0\u7c7b\u578b\u503c(\u4e2a\u4f53)\u4e0d\u5408\u6cd5row_flag=" + list.get(0).getRow_flag());
                params[4] = "1";
            }
        }
    }

    private static void setRangeValue(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (!list.isEmpty()) {
            params[0] = list.get(0).getHc_id();
            params[1] = list.get(0).getCid();
            params[2] = resultNo;
            params[3] = 26;
            params[4] = null;
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = list.get(0).getCreate_date();
            params[9] = list.get(0).getCreate_date();
            if (list.size() == 3 || list.size() == 2) {
                for (HcCheckResultCollectData data : list) {
                    if (data.getData_key().equals("checkvalue00")) {
                        params[5] = Import3NoiseMain.getValueRangeType(data);
                        continue;
                    }
                    if (data.getData_key().equals("checkvalue0")) {
                        params[6] = Import3NoiseMain.parseValue(data.getData_value());
                        continue;
                    }
                    if (data.getData_key().equals("checkvalue")) {
                        params[7] = Import3NoiseMain.parseValue(data.getData_value());
                        continue;
                    }
                    throw new RuntimeException("\u8303\u56f4\u503ckey\u4e0d\u6b63\u786e");
                }
            } else if (list.size() == 1) {
                if (list.get(0).getData_key().equals("checkvalue0") || list.get(0).getData_key().equals("checkvalue")) {
                    params[5] = "1";
                    params[6] = Import3NoiseMain.parseValue(list.get(0).getData_value());
                    params[7] = params[6];
                }
            } else {
                throw new RuntimeException("\u8303\u56f4\u7684\u503c\u4e2a\u6570\u4e0d\u6b63\u786e,row_flag=" + list.get(0).getRow_flag());
            }
        }
    }

    private static int getTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 24;
            }
            case "minvalue": {
                return 27;
            }
            case "maxvalue": {
                return 28;
            }
            case "equallevel": {
                return 29;
            }
            case "times": {
                return 30;
            }
            case "maxnoise": {
                return 31;
            }
            case "result": {
                return 32;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getValueRangeType(HcCheckResultCollectData o) {
        if (o.getData_value().equals("0")) {
            return "1";
        }
        if (o.getData_value().equals("1")) {
            return "2";
        }
        if (o.getData_value().equals("2")) {
            return "3";
        }
        if (o.getData_value().equals("")) {
            return "1";
        }
        throw new RuntimeException("\u68c0\u6d4b\u7ed3\u679c\u503c\u7684\u8303\u56f4\u7c7b\u578b\u4e0d\u6b63\u786e: " + o.getData_value() + " row_flag=" + o.getRow_flag());
    }

    private static String getCheckValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result") || o.getData_key().equals("result1")) {
            if (o.getData_value() == null) {
                return "";
            }
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "1";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("reportname") || o.getData_key().equals("checkproj")) {
            return o.getData_value();
        }
        return Import3NoiseMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        value = value.trim();
        try {
            if (value.contains("\u500d")) {
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("\u500d"))));
            }
            if (value.contains("~")) {
                if (value.startsWith("<") || value.startsWith("\uff1c")) {
                    return String.valueOf(Double.parseDouble(value.substring(1, value.indexOf("~"))));
                }
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("~"))));
            }
            if (value.contains("-")) {
                if (value.startsWith("<") || value.startsWith("\uff1c")) {
                    return String.valueOf(Double.parseDouble(value.substring(1, value.indexOf("-"))));
                }
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("-"))));
            }
            if (value.contains("*")) {
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("*"))));
            }
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u2264")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }
}

