/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import cn.smarthse.util.common.date.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import2DustMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import2DustMain.importDust();
    }

    private static void importDust() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 2 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import2DustMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date) values (uuid_short(),?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[10];
        if (result == null || result.isEmpty()) {
            return;
        }
        ArrayList<HcCheckResultCollectData> z_list = new ArrayList<HcCheckResultCollectData>(3);
        ArrayList<HcCheckResultCollectData> h_list = new ArrayList<HcCheckResultCollectData>(3);
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                if (!z_list.isEmpty()) {
                    Import2DustMain.setZRangeValue(params, z_list, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                if (!h_list.isEmpty()) {
                    Import2DustMain.setHRangeValue(params, h_list, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                z_list.clear();
                h_list.clear();
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            if (o.getData_key().equals("ctwa1range00") || o.getData_key().equals("ctwa1range") || o.getData_key().equals("ctwa1range0")) {
                z_list.add(o);
                continue;
            }
            if (o.getData_key().equals("ctwa2range00") || o.getData_key().equals("ctwa2range") || o.getData_key().equals("ctwa2range0")) {
                h_list.add(o);
                continue;
            }
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import2DustMain.getTargetId(o);
            params[4] = Import2DustMain.getCheckValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            qr.update(conn, insertSql, params);
            if (count % 1000 != 0) continue;
            System.out.println("\u8fdb\u5ea6:" + count + "\u6761");
        }
        if (!z_list.isEmpty()) {
            Import2DustMain.setZRangeValue(params, z_list, currentResultNo);
            qr.update(conn, insertSql, params);
        }
        if (!h_list.isEmpty()) {
            Import2DustMain.setHRangeValue(params, h_list, currentResultNo);
            qr.update(conn, insertSql, params);
        }
        z_list.clear();
        h_list.clear();
        conn.close();
    }

    private static void setZRangeValue(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (!list.isEmpty()) {
            params[0] = list.get(0).getHc_id();
            params[1] = list.get(0).getCid();
            params[2] = resultNo;
            params[3] = 14;
            params[4] = null;
            params[5] = "";
            params[6] = "";
            params[7] = "";
            params[8] = list.get(0).getCreate_date();
            params[9] = list.get(0).getCreate_date();
            if (list.size() == 3) {
                for (HcCheckResultCollectData data : list) {
                    if (data.getData_key().equals("ctwa1range00")) {
                        params[5] = Import2DustMain.getValueRangeType(data);
                        continue;
                    }
                    if (data.getData_key().equals("ctwa1range0")) {
                        params[6] = Import2DustMain.parseValue(data.getData_value());
                        continue;
                    }
                    if (!data.getData_key().equals("ctwa1range")) continue;
                    params[7] = Import2DustMain.parseValue(data.getData_value());
                }
            } else if (list.size() == 1) {
                if (list.get(0).getData_key().equals("ctwa1range") || list.get(0).getData_key().equals("ctwa1range0")) {
                    params[5] = "1";
                    params[6] = Import2DustMain.parseValue(list.get(0).getData_value());
                    params[7] = params[6];
                }
            } else {
                throw new RuntimeException("\u603b\u5c18\u6d53\u5ea6\u8303\u56f4\u7684\u503c\u4e2a\u6570\u4e0d\u6b63\u786e,row_flag=" + list.get(0).getRow_flag());
            }
        }
    }

    private static void setHRangeValue(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (!list.isEmpty()) {
            params[0] = list.get(0).getHc_id();
            params[1] = list.get(0).getCid();
            params[2] = resultNo;
            params[3] = 19;
            params[4] = null;
            params[5] = "";
            params[6] = "";
            params[7] = "";
            params[8] = list.get(0).getCreate_date();
            params[9] = list.get(0).getCreate_date();
            if (list.size() == 3) {
                for (HcCheckResultCollectData data : list) {
                    if (data.getData_key().equals("ctwa2range00")) {
                        params[5] = Import2DustMain.getValueRangeType(data);
                        continue;
                    }
                    if (data.getData_key().equals("ctwa2range0")) {
                        params[6] = Import2DustMain.parseValue(data.getData_value());
                        continue;
                    }
                    if (!data.getData_key().equals("ctwa2range")) continue;
                    params[7] = Import2DustMain.parseValue(data.getData_value());
                }
            } else if (list.get(0).getData_key().equals("ctwa2range") || list.get(0).getData_key().equals("ctwa2range0")) {
                params[5] = "1";
                params[6] = Import2DustMain.parseValue(list.get(0).getData_value());
                params[7] = params[6];
            } else {
                throw new RuntimeException("\u547c\u5c18\u6d53\u5ea6\u8303\u56f4\u7684\u503c\u4e2a\u6570\u4e0d\u6b63\u786e,row_flag=" + list.get(0).getRow_flag());
            }
        }
    }

    private static int getTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 11;
            }
            case "checkproj": {
                return 12;
            }
            case "ctwa1": {
                return 13;
            }
            case "peakcontactconcentration1": {
                return 15;
            }
            case "times1": {
                return 16;
            }
            case "result": {
                return 17;
            }
            case "ctwa2": {
                return 18;
            }
            case "times2": {
                return 21;
            }
            case "peakcontactconcentration2": {
                return 20;
            }
            case "result1": {
                return 22;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getValueRangeType(HcCheckResultCollectData o) {
        if (o.getData_value().equals("0")) {
            return "1";
        }
        if (o.getData_value().equals("1")) {
            return "2";
        }
        if (o.getData_value().equals("2")) {
            return "3";
        }
        return "1";
    }

    private static String getCheckValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result") || o.getData_key().equals("result1")) {
            if (o.getData_value() == null) {
                return "";
            }
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "1";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("reportname")) {
            return o.getData_value();
        }
        if (o.getData_key().equals("checkproj")) {
            try {
                long l = Long.parseLong(o.getData_value());
                return "" + l;
            }
            catch (Exception e) {
                System.out.println("\u5371\u5bb3\u56e0\u7d20\u4e0d\u662fid\uff0c " + o.getData_value());
                return "";
            }
        }
        return Import2DustMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        value = value.trim();
        try {
            if (value.contains("\u500d")) {
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("\u500d"))));
            }
            if (value.contains("~")) {
                if (value.startsWith("<") || value.startsWith("\uff1c")) {
                    return String.valueOf(Double.parseDouble(value.substring(1, value.indexOf("~"))));
                }
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("~"))));
            }
            if (value.contains("-")) {
                if (value.startsWith("<") || value.startsWith("\uff1c")) {
                    return String.valueOf(Double.parseDouble(value.substring(1, value.indexOf("-"))));
                }
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("-"))));
            }
            if (value.contains("*")) {
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("*"))));
            }
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u2264")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    private static boolean isEarlyStandard(HcCheckResultCollectData o) {
        Date date = o.getCreate_date();
        if (date == null) {
            date = o.getUpdate_date();
        }
        if (date == null) {
            return true;
        }
        return DateUtils.getFromDate((Date)date).toLocalDate().compareTo(DateUtils.getDate((int)2020, (int)4, (int)1)) < 0;
    }
}

