/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import cn.smarthse.util.common.date.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import1ChemicalMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import1ChemicalMain.importChemical();
    }

    private static void importChemical() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 1 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import1ChemicalMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date) values (uuid_short(),?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[10];
        ArrayList<HcCheckResultCollectData> cstelList = new ArrayList<HcCheckResultCollectData>(3);
        if (result == null || result.isEmpty()) {
            return;
        }
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                if (!cstelList.isEmpty()) {
                    Import1ChemicalMain.setStelValue(params, cstelList, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                cstelList.clear();
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            if (o.getData_key().equals("cstel1") || o.getData_key().equals("cstel2") || o.getData_key().equals("cstel3")) {
                cstelList.add(o);
                continue;
            }
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import1ChemicalMain.getChemicalTargetId(o);
            params[4] = Import1ChemicalMain.getChemicalCheckValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            qr.update(conn, insertSql, params);
            if (count % 1000 != 0) continue;
            System.out.println("\u8fdb\u5ea6:" + count + "\u6761");
        }
        if (!cstelList.isEmpty()) {
            Import1ChemicalMain.setStelValue(params, cstelList, currentResultNo);
            qr.update(conn, insertSql, params);
        }
        cstelList.clear();
        conn.close();
    }

    private static void setStelValue(Object[] params, List<HcCheckResultCollectData> cstelList, Long resultNo) {
        if (!cstelList.isEmpty()) {
            params[0] = cstelList.get(0).getHc_id();
            params[1] = cstelList.get(0).getCid();
            params[2] = resultNo;
            params[3] = Import1ChemicalMain.getChemicalTargetId(cstelList.get(0));
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = cstelList.get(0).getCreate_date();
            params[9] = cstelList.get(0).getCreate_date();
            if (cstelList.size() == 1) {
                String value = cstelList.get(0).getData_value();
                if (value.contains("~")) {
                    params[5] = "2";
                    params[6] = Import1ChemicalMain.parseValue(value.substring(1, value.indexOf("~")));
                    params[7] = value.substring(value.indexOf("~") + 1);
                } else if (value.contains("\uff1c") || value.contains("<")) {
                    params[5] = "2";
                    params[6] = Import1ChemicalMain.parseValue(value.substring(1));
                    params[7] = params[6];
                } else {
                    params[5] = "1";
                    params[6] = Import1ChemicalMain.parseValue(value);
                    params[7] = params[6];
                }
                System.out.println("\u53ea\u6709\u4e00\u4e2astel\u503c\uff0c\u89e3\u6790\u7ed3\u679c\u4e3a" + String.valueOf(params[5]) + "," + String.valueOf(params[6]) + "," + String.valueOf(params[7]));
            } else if (cstelList.size() == 3) {
                for (HcCheckResultCollectData cstel : cstelList) {
                    if (cstel.getData_key().equals("cstel1")) {
                        params[5] = Import1ChemicalMain.getChemicalValueRangeType(cstel);
                        continue;
                    }
                    if (cstel.getData_key().equals("cstel2")) {
                        params[6] = Import1ChemicalMain.parseValue(cstel.getData_value());
                        continue;
                    }
                    if (!cstel.getData_key().equals("cstel3")) continue;
                    params[7] = Import1ChemicalMain.parseValue(cstel.getData_value());
                }
            } else if (cstelList.size() == 2) {
                for (HcCheckResultCollectData cstel : cstelList) {
                    if (cstel.getData_key().equals("cstel1")) {
                        params[5] = Import1ChemicalMain.getChemicalValueRangeType(cstel);
                        continue;
                    }
                    if (cstel.getData_key().equals("cstel2")) {
                        params[6] = Import1ChemicalMain.parseValue(cstel.getData_value());
                        continue;
                    }
                    if (!cstel.getData_key().equals("cstel3")) continue;
                    params[7] = Import1ChemicalMain.parseValue(cstel.getData_value());
                }
            } else {
                throw new RuntimeException("cstel\u7684\u503c\u4e2a\u6570\u4e0d\u6b63\u786e,row_flag=" + cstelList.get(0).getRow_flag());
            }
        }
    }

    private static int getChemicalTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 1;
            }
            case "checkproj": {
                return 2;
            }
            case "cmac": {
                if (Import1ChemicalMain.isEarlyStandard(o)) {
                    return 5;
                }
                return 6;
            }
            case "ctwa": {
                return 3;
            }
            case "times": {
                return 9;
            }
            case "result": {
                return 10;
            }
            case "peakcontactconcentration": {
                return 8;
            }
            case "cstel1": 
            case "cstel2": 
            case "cstel3": {
                if (Import1ChemicalMain.isEarlyStandard(o)) {
                    return 4;
                }
                return 7;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getChemicalValueRangeType(HcCheckResultCollectData o) {
        if (!o.getData_key().equals("cstel1")) {
            throw new RuntimeException("\u83b7\u53d6\u68c0\u6d4b\u7ed3\u679c\u503c\u7684\u8303\u56f4\u7c7b\u578b \u975e\u6cd5");
        }
        if (o.getData_value().equals("0")) {
            return "1";
        }
        if (o.getData_value().equals("1")) {
            return "2";
        }
        if (o.getData_value().equals("2")) {
            return "3";
        }
        if (o.getData_value().length() == 0) {
            return "2";
        }
        throw new RuntimeException("\u68c0\u6d4b\u7ed3\u679c\u503c\u7684\u8303\u56f4\u7c7b\u578b\u4e0d\u6b63\u786e:" + o.getData_value() + "row_flag=" + o.getRow_flag());
    }

    private static String getChemicalCheckValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result")) {
            if (o.getData_value() == null) {
                return "";
            }
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "1";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("reportname")) {
            return o.getData_value();
        }
        if (o.getData_key().equals("checkproj")) {
            try {
                long l = Long.parseLong(o.getData_value());
                return "" + l;
            }
            catch (Exception e) {
                System.out.println("\u5371\u5bb3\u56e0\u7d20\u4e0d\u662fid\uff0c " + o.getData_value());
                return "";
            }
        }
        return Import1ChemicalMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        try {
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    private static boolean isEarlyStandard(HcCheckResultCollectData o) {
        Date date = o.getCreate_date();
        if (date == null) {
            date = o.getUpdate_date();
        }
        if (date == null) {
            return true;
        }
        return DateUtils.getFromDate((Date)date).toLocalDate().compareTo(DateUtils.getDate((int)2020, (int)4, (int)1)) < 0;
    }
}

