/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import17AirSpeedMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import17AirSpeedMain.importAirSpeed();
    }

    private static void importAirSpeed() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 16 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import17AirSpeedMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date) values (uuid_short(),?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[10];
        if (result == null || result.isEmpty()) {
            return;
        }
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import17AirSpeedMain.getTargetId(o);
            params[4] = Import17AirSpeedMain.getCheckValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            qr.update(conn, insertSql, params);
            if (count % 100 != 0) continue;
            System.out.println("\u8fdb\u5ea6:" + count + "\u6761");
        }
        conn.close();
    }

    private static int getTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 121;
            }
            case "checkresult": {
                return 122;
            }
            case "result": {
                return 123;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getValueRangeType(HcCheckResultCollectData o) {
        if (o.getData_value().equals("0")) {
            return "1";
        }
        if (o.getData_value().equals("1")) {
            return "2";
        }
        if (o.getData_value().equals("2")) {
            return "3";
        }
        if (o.getData_value().equals("")) {
            return "1";
        }
        throw new RuntimeException("\u68c0\u6d4b\u7ed3\u679c\u503c\u7684\u8303\u56f4\u7c7b\u578b\u4e0d\u6b63\u786e: " + o.getData_value() + " row_flag=" + o.getRow_flag());
    }

    private static String getCheckValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result")) {
            if (o.getData_value() == null) {
                return "";
            }
            if (o.getData_value().equals("\u4e0d\u5408\u683c")) {
                return "3";
            }
            if (o.getData_value().equals("\u7b26\u5408")) {
                return "2";
            }
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "1";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("reportname")) {
            return o.getData_value();
        }
        return Import17AirSpeedMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        value = value.trim();
        try {
            if (value.contains("\u500d")) {
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("\u500d"))));
            }
            if (value.contains("~")) {
                if (value.startsWith("<") || value.startsWith("\uff1c")) {
                    return String.valueOf(Double.parseDouble(value.substring(1, value.indexOf("~"))));
                }
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("~"))));
            }
            if (value.contains("-")) {
                if (value.startsWith("<") || value.startsWith("\uff1c")) {
                    return String.valueOf(Double.parseDouble(value.substring(1, value.indexOf("-"))));
                }
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("-"))));
            }
            if (value.contains("*")) {
                return String.valueOf(Double.parseDouble(value.substring(0, value.indexOf("*"))));
            }
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u2264")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }
}

