/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import cn.smarthse.util.common.date.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import13BiologyMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import13BiologyMain.importBiology();
    }

    private static void importBiology() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 3 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import13BiologyMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date, unit) values (uuid_short(),?,?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[11];
        ArrayList<HcCheckResultCollectData> cstelList = new ArrayList<HcCheckResultCollectData>(4);
        ArrayList<HcCheckResultCollectData> cmacList = new ArrayList<HcCheckResultCollectData>(2);
        ArrayList<HcCheckResultCollectData> ctwalList = new ArrayList<HcCheckResultCollectData>(2);
        if (result == null || result.isEmpty()) {
            return;
        }
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                if (!cstelList.isEmpty()) {
                    Import13BiologyMain.setStelValue(params, cstelList, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                cstelList.clear();
                if (!cmacList.isEmpty()) {
                    Import13BiologyMain.setCmacValue(params, cmacList, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                cmacList.clear();
                if (!ctwalList.isEmpty()) {
                    Import13BiologyMain.setCtwaValue(params, ctwalList, currentResultNo);
                    qr.update(conn, insertSql, params);
                }
                ctwalList.clear();
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            if (o.getData_key().equals("cstel1") || o.getData_key().equals("cstel2") || o.getData_key().equals("cstel3") || o.getData_key().equals("cstel4")) {
                cstelList.add(o);
                continue;
            }
            if (o.getData_key().equals("cmac1") || o.getData_key().equals("cmac2")) {
                cmacList.add(o);
                continue;
            }
            if (o.getData_key().equals("ctwa1") || o.getData_key().equals("ctwa2")) {
                ctwalList.add(o);
                continue;
            }
            if (o.getData_key().equals("times") || o.getData_key().equals("cstel15")) continue;
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import13BiologyMain.getTargetId(o);
            params[4] = Import13BiologyMain.getValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            params[10] = null;
            qr.update(conn, insertSql, params);
            if (!cstelList.isEmpty()) {
                Import13BiologyMain.setStelValue(params, cstelList, currentResultNo);
                qr.update(conn, insertSql, params);
            }
            cstelList.clear();
            if (!cmacList.isEmpty()) {
                Import13BiologyMain.setCmacValue(params, cmacList, currentResultNo);
                qr.update(conn, insertSql, params);
            }
            cmacList.clear();
            if (!ctwalList.isEmpty()) {
                Import13BiologyMain.setCtwaValue(params, ctwalList, currentResultNo);
                qr.update(conn, insertSql, params);
            }
            ctwalList.clear();
        }
        if (!cstelList.isEmpty()) {
            Import13BiologyMain.setStelValue(params, cstelList, currentResultNo);
            qr.update(conn, insertSql, params);
        }
        cstelList.clear();
        conn.close();
    }

    private static void setStelValue(Object[] params, List<HcCheckResultCollectData> cstelList, Long resultNo) {
        if (!cstelList.isEmpty()) {
            params[0] = cstelList.get(0).getHc_id();
            params[1] = cstelList.get(0).getCid();
            params[2] = resultNo;
            params[3] = Import13BiologyMain.getTargetId(cstelList.get(0));
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = cstelList.get(0).getCreate_date();
            params[9] = cstelList.get(0).getCreate_date();
            for (HcCheckResultCollectData cstel : cstelList) {
                if (cstel.getData_key().equals("cstel1")) {
                    params[5] = Import13BiologyMain.getValueRangeType(cstel);
                    continue;
                }
                if (cstel.getData_key().equals("cstel2")) {
                    params[6] = Import13BiologyMain.parseValue(cstel.getData_value());
                    continue;
                }
                if (cstel.getData_key().equals("cstel3")) {
                    params[7] = Import13BiologyMain.parseValue(cstel.getData_value());
                    continue;
                }
                if (!cstel.getData_key().equals("cstel4")) continue;
                params[10] = cstel.getData_value();
            }
        }
    }

    private static void setCmacValue(Object[] params, List<HcCheckResultCollectData> cstelList, Long resultNo) {
        if (!cstelList.isEmpty()) {
            params[0] = cstelList.get(0).getHc_id();
            params[1] = cstelList.get(0).getCid();
            params[2] = resultNo;
            params[3] = Import13BiologyMain.getTargetId(cstelList.get(0));
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = cstelList.get(0).getCreate_date();
            params[9] = cstelList.get(0).getCreate_date();
            for (HcCheckResultCollectData cmac : cstelList) {
                if (cmac.getData_key().equals("cmac1")) {
                    params[4] = cmac.getData_value();
                    continue;
                }
                if (!cmac.getData_key().equals("cmac2")) continue;
                params[10] = cmac.getData_value();
            }
        }
    }

    private static void setCtwaValue(Object[] params, List<HcCheckResultCollectData> cstelList, Long resultNo) {
        if (!cstelList.isEmpty()) {
            params[0] = cstelList.get(0).getHc_id();
            params[1] = cstelList.get(0).getCid();
            params[2] = resultNo;
            params[3] = Import13BiologyMain.getTargetId(cstelList.get(0));
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = cstelList.get(0).getCreate_date();
            params[9] = cstelList.get(0).getCreate_date();
            for (HcCheckResultCollectData ctwa : cstelList) {
                if (ctwa.getData_key().equals("ctwa1")) {
                    params[4] = ctwa.getData_value();
                    continue;
                }
                if (!ctwa.getData_key().equals("ctwa2")) continue;
                params[10] = ctwa.getData_value();
            }
        }
    }

    private static int getTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 97;
            }
            case "checkproj": {
                return 98;
            }
            case "cmac1": 
            case "cmac2": {
                if (Import13BiologyMain.isEarlyStandard(o)) {
                    return 99;
                }
                return 100;
            }
            case "ctwa1": 
            case "ctwa2": {
                return 101;
            }
            case "cstel1": 
            case "cstel2": 
            case "cstel3": 
            case "cstel4": {
                if (Import13BiologyMain.isEarlyStandard(o)) {
                    return 102;
                }
                return 103;
            }
            case "result": {
                return 104;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getValueRangeType(HcCheckResultCollectData o) {
        if (!o.getData_key().equals("cstel1")) {
            throw new RuntimeException("\u83b7\u53d6\u68c0\u6d4b\u7ed3\u679c\u503c\u7684\u8303\u56f4\u7c7b\u578b \u975e\u6cd5");
        }
        if (o.getData_value().equals("0")) {
            return "1";
        }
        if (o.getData_value().equals("1")) {
            return "2";
        }
        if (o.getData_value().equals("2")) {
            return "3";
        }
        if (o.getData_value().length() == 0) {
            return "2";
        }
        return "1";
    }

    private static String getValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result")) {
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "1";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("reportname")) {
            return o.getData_value();
        }
        if (o.getData_key().equals("checkproj")) {
            try {
                long l = Long.parseLong(o.getData_value());
                return "" + l;
            }
            catch (Exception e) {
                System.out.println("\u5371\u5bb3\u56e0\u7d20\u4e0d\u662fid\uff0c " + o.getData_value());
                return "";
            }
        }
        return Import13BiologyMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        try {
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    private static boolean isEarlyStandard(HcCheckResultCollectData o) {
        Date date = o.getCreate_date();
        if (date == null) {
            date = o.getUpdate_date();
        }
        if (date == null) {
            return true;
        }
        return DateUtils.getFromDate((Date)date).toLocalDate().compareTo(DateUtils.getDate((int)2020, (int)4, (int)1)) < 0;
    }
}

