/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.importold;

import cn.smarthse.services.hfi.importold.BaseImportMain;
import cn.smarthse.services.hfi.importold.HcCheckResultCollectData;
import cn.smarthse.util.common.date.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class Import12LaserRadiationMain
extends BaseImportMain {
    public static void importResultData() throws SQLException {
        Import12LaserRadiationMain.importLaserRadiation();
    }

    private static void importLaserRadiation() throws SQLException {
        QueryRunner qr = new QueryRunner();
        String sql = "select cid, hc_id, data_key,row_flag, data_value,result_collect_id,create_date,update_date from hc_check_result_collect_data  where collect_type = 13 and  is_valid=true order by hc_id,row_flag";
        Connection conn = Import12LaserRadiationMain.getConnection();
        List result = (List)qr.query(conn, sql, (ResultSetHandler)new BeanListHandler(HcCheckResultCollectData.class));
        String insertSql = "insert into check_result(id, check_id, cid, result_no, target_id,check_value, check_value_range_type,  check_value_min, check_value_max,create_date,update_date) values (uuid_short(),?,?,?,?,?,?,?,?,?,?);";
        Object[] params = new Object[10];
        ArrayList<HcCheckResultCollectData> list1 = new ArrayList<HcCheckResultCollectData>(4);
        ArrayList<HcCheckResultCollectData> list2 = new ArrayList<HcCheckResultCollectData>(4);
        ArrayList<HcCheckResultCollectData> list3 = new ArrayList<HcCheckResultCollectData>(4);
        if (result == null || result.isEmpty()) {
            return;
        }
        String currentRowflag = ((HcCheckResultCollectData)result.get(0)).getRow_flag();
        Long currentResultNo = snowFlake.nextId();
        int count = 0;
        for (HcCheckResultCollectData o : result) {
            ++count;
            if (!currentRowflag.equals(o.getRow_flag())) {
                if (!list1.isEmpty()) {
                    Import12LaserRadiationMain.setList1Value(params, list1, currentResultNo);
                    qr.update(conn, insertSql, params);
                    list1.clear();
                }
                if (!list2.isEmpty()) {
                    Import12LaserRadiationMain.setList2Value(params, list2, currentResultNo);
                    qr.update(conn, insertSql, params);
                    list2.clear();
                }
                if (!list3.isEmpty()) {
                    Import12LaserRadiationMain.setList3Value(params, list3, currentResultNo);
                    qr.update(conn, insertSql, params);
                    list3.clear();
                }
                currentRowflag = o.getRow_flag();
                currentResultNo = snowFlake.nextId();
            }
            if (o.getData_key().equals("irradiationtime1") || o.getData_key().equals("irradiationtime2") || o.getData_key().equals("irradiationtime3") || o.getData_key().equals("irradiationtime4")) {
                list1.add(o);
                continue;
            }
            if (o.getData_key().equals("exposure1") || o.getData_key().equals("exposure2") || o.getData_key().equals("exposure3") || o.getData_key().equals("exposure4")) {
                list2.add(o);
                continue;
            }
            if (o.getData_key().equals("irradiance1") || o.getData_key().equals("irradiance2") || o.getData_key().equals("irradiance3") || o.getData_key().equals("irradiance4")) {
                list3.add(o);
                continue;
            }
            params[0] = o.getHc_id();
            params[1] = o.getCid();
            params[2] = currentResultNo;
            params[3] = Import12LaserRadiationMain.getTargetId(o);
            params[4] = Import12LaserRadiationMain.getCheckValue(o);
            params[5] = null;
            params[6] = "";
            params[7] = "";
            params[8] = o.getCreate_date();
            params[9] = o.getCreate_date();
            qr.update(conn, insertSql, params);
            if (count % 1000 != 0) continue;
            System.out.println("\u8fdb\u5ea6:" + count + "\u6761");
        }
        if (!list1.isEmpty()) {
            Import12LaserRadiationMain.setList1Value(params, list1, currentResultNo);
            qr.update(conn, insertSql, params);
            list1.clear();
        }
        if (!list2.isEmpty()) {
            Import12LaserRadiationMain.setList2Value(params, list2, currentResultNo);
            qr.update(conn, insertSql, params);
            list2.clear();
        }
        if (!list3.isEmpty()) {
            Import12LaserRadiationMain.setList3Value(params, list3, currentResultNo);
            qr.update(conn, insertSql, params);
            list3.clear();
        }
        conn.close();
    }

    private static void setList1Value(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (!list.isEmpty()) {
            params[0] = list.get(0).getHc_id();
            params[1] = list.get(0).getCid();
            params[2] = resultNo;
            params[3] = 93;
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = list.get(0).getCreate_date();
            params[9] = list.get(0).getCreate_date();
            String v1 = "";
            String v2 = "";
            String v3 = "";
            String v4 = "";
            for (HcCheckResultCollectData data : list) {
                if (data.getData_key().equals("irradiationtime1")) {
                    v1 = data.getData_value();
                }
                if (data.getData_key().equals("irradiationtime2")) {
                    v2 = data.getData_value();
                }
                if (data.getData_key().equals("irradiationtime3")) {
                    v3 = data.getData_value();
                }
                if (!data.getData_key().equals("irradiationtime4")) continue;
                v4 = data.getData_value();
            }
            params[4] = v1 + "," + v2 + "," + v3 + "," + v4;
        }
    }

    private static void setList2Value(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (!list.isEmpty()) {
            params[0] = list.get(0).getHc_id();
            params[1] = list.get(0).getCid();
            params[2] = resultNo;
            params[3] = 94;
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = list.get(0).getCreate_date();
            params[9] = list.get(0).getCreate_date();
            String v1 = "";
            String v2 = "";
            String v3 = "";
            String v4 = "";
            for (HcCheckResultCollectData data : list) {
                if (data.getData_key().equals("exposure1")) {
                    v1 = data.getData_value();
                }
                if (data.getData_key().equals("exposure2")) {
                    v2 = data.getData_value();
                }
                if (data.getData_key().equals("exposure3")) {
                    v3 = data.getData_value();
                }
                if (!data.getData_key().equals("exposure4")) continue;
                v4 = data.getData_value();
            }
            params[4] = v1 + "," + v2 + "," + v3 + "," + v4;
        }
    }

    private static void setList3Value(Object[] params, List<HcCheckResultCollectData> list, Long resultNo) {
        if (!list.isEmpty()) {
            params[0] = list.get(0).getHc_id();
            params[1] = list.get(0).getCid();
            params[2] = resultNo;
            params[3] = 95;
            params[4] = null;
            params[5] = null;
            params[6] = null;
            params[7] = null;
            params[8] = list.get(0).getCreate_date();
            params[9] = list.get(0).getCreate_date();
            String v1 = "";
            String v2 = "";
            String v3 = "";
            String v4 = "";
            for (HcCheckResultCollectData data : list) {
                if (data.getData_key().equals("irradiance1")) {
                    v1 = data.getData_value();
                }
                if (data.getData_key().equals("irradiance2")) {
                    v2 = data.getData_value();
                }
                if (data.getData_key().equals("irradiance3")) {
                    v3 = data.getData_value();
                }
                if (!data.getData_key().equals("irradiance4")) continue;
                v4 = data.getData_value();
            }
            params[4] = v1 + "," + v2 + "," + v3 + "," + v4;
        }
    }

    private static int getTargetId(HcCheckResultCollectData o) {
        String dataKey;
        switch (dataKey = o.getData_key()) {
            case "reportname": {
                return 88;
            }
            case "location": {
                return 89;
            }
            case "time": {
                return 90;
            }
            case "range": {
                return 91;
            }
            case "wavelength": {
                return 92;
            }
            case "result": {
                return 96;
            }
        }
        throw new RuntimeException("\u6307\u6807\u672a\u627e\u5230:" + dataKey);
    }

    private static String getCheckValue(HcCheckResultCollectData o) {
        if (o.getData_key().equals("result")) {
            if (o.getData_value().equals("0")) {
                return "2";
            }
            if (o.getData_value().equals("1")) {
                return "3";
            }
            if (o.getData_value().equals("2")) {
                return "1";
            }
            if (o.getData_value().length() == 0) {
                return "1";
            }
            if (o.getData_value().equals("-1")) {
                return "";
            }
            throw new RuntimeException("\u5224\u5b9a\u7ed3\u679c\u503c\u4e0d\u6b63\u786e:" + o.getData_value());
        }
        if (o.getData_key().equals("reportname")) {
            return o.getData_value();
        }
        if (o.getData_key().equals("location")) {
            if (o.getData_value() == null || o.getData_value().equals("") || o.getData_value().equals("0")) {
                return "1";
            }
            return "2";
        }
        if (o.getData_key().equals("range")) {
            if (o.getData_value() == null || o.getData_value().equals("")) {
                return "1";
            }
            if (o.getData_value().equals("\u7d2b\u5916\u7ebf")) {
                return "1";
            }
            if (o.getData_value().equals("\u53ef\u89c1\u5149")) {
                return "2";
            }
            if (o.getData_value().equals("\u7ea2\u5916\u7ebf")) {
                return "3";
            }
            if (o.getData_value().equals("\u8fdc\u7ea2\u5916\u7ebf")) {
                return "4";
            }
            return String.valueOf(Integer.parseInt(o.getData_value()) + 1);
        }
        return Import12LaserRadiationMain.parseValue(o.getData_value());
    }

    private static String parseValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return value;
        }
        try {
            if (value.startsWith("<")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            if (value.startsWith("\u5c0f\u4e8e")) {
                return String.valueOf(Double.parseDouble(value.substring(2)));
            }
            if (value.startsWith("\uff1c")) {
                return String.valueOf(Double.parseDouble(value.substring(1)));
            }
            String.valueOf(Double.parseDouble(value));
            return value;
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6570\u5b57\u5f02\u5e38,value=" + value);
            return "";
        }
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    private static boolean isEarlyStandard(HcCheckResultCollectData o) {
        Date date = o.getCreate_date();
        if (date == null) {
            date = o.getUpdate_date();
        }
        if (date == null) {
            return true;
        }
        return DateUtils.getFromDate((Date)date).toLocalDate().compareTo(DateUtils.getDate((int)2020, (int)4, (int)1)) < 0;
    }
}

