/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.controller;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.services.hfi.api.entity.RaySourceDevice;
import cn.smarthse.services.hfi.api.service.IRaySourceDeviceService;
import cn.smarthse.services.hfi.controller.BaseController;
import cn.smarthse.services.hfi.pojo.CheckIdDto;
import cn.smarthse.services.hfi.util.WebUtils;
import cn.smarthse.web.common.exception.FieldValueIllegalException;
import cn.smarthse.web.common.model.ResponseData;
import cn.smarthse.web.common.util.FieldCheckUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/raySourceDevice"})
public class RaySourceDeviceController
extends BaseController {
    private IRaySourceDeviceService sourceDeviceService;

    @Autowired
    public void autowired(IRaySourceDeviceService sourceDeviceService) {
        this.sourceDeviceService = sourceDeviceService;
    }

    @GetMapping(value={"/delete"})
    public ResponseData<Object> delete(Long id) {
        this.sourceDeviceService.logicDel((Number)id);
        return ResponseData.success(null);
    }

    @PostMapping(value={"/addOrUpdate"})
    public ResponseData<RaySourceDevice> addOrUpdate(@RequestBody RaySourceDevice raySourceDevice) {
        try {
            FieldCheckUtils.checkEmptyFields((Object)raySourceDevice, (String[])new String[]{"checkId", "name", "raySourceNo", "signNo", "nucleusEl", "nowActiveDegree", "factoryActiveDegree", "installLocation"});
        }
        catch (FieldValueIllegalException e) {
            e.printStackTrace();
            return ResponseData.fail((String)e.getMessage());
        }
        WebUtils.setCreateOrUpdateCommonProperties((BaseEntity)raySourceDevice);
        this.sourceDeviceService.saveOrUpdate((Object)raySourceDevice);
        return ResponseData.success((Object)raySourceDevice);
    }

    @PostMapping(value={"/queryByCheck"})
    public ResponseData<IPage<RaySourceDevice>> queryByCheck(@RequestBody CheckIdDto checkIdDto) {
        try {
            FieldCheckUtils.checkEmptyFields((Object)((Object)checkIdDto), (String[])new String[]{"checkId", "pageNum", "pageSize"});
        }
        catch (FieldValueIllegalException e) {
            e.printStackTrace();
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success((Object)this.sourceDeviceService.queryByCheck(checkIdDto.getCheckId(), checkIdDto.getPageNum(), checkIdDto.getPageSize()));
    }
}

