/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.controller;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.services.hfi.api.entity.RayDevice;
import cn.smarthse.services.hfi.api.service.IRayDeviceService;
import cn.smarthse.services.hfi.controller.BaseController;
import cn.smarthse.services.hfi.pojo.CheckIdDto;
import cn.smarthse.services.hfi.util.WebUtils;
import cn.smarthse.web.common.exception.FieldValueIllegalException;
import cn.smarthse.web.common.model.ResponseData;
import cn.smarthse.web.common.util.FieldCheckUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rayDevice"})
public class RayDeviceController
extends BaseController {
    private IRayDeviceService rayDeviceService;

    @Autowired
    public void autowired(IRayDeviceService rayDeviceService) {
        this.rayDeviceService = rayDeviceService;
    }

    @PostMapping(value={"/addOrUpdate"})
    public ResponseData<RayDevice> addOrUpdate(@RequestBody RayDevice rayDevice) {
        try {
            FieldCheckUtils.checkEmptyFields((Object)rayDevice, (String[])new String[]{"checkId", "name", "modelNo", "capacity", "checkCondition", "siteName"});
        }
        catch (FieldValueIllegalException e) {
            e.printStackTrace();
            return ResponseData.fail((String)e.getMessage());
        }
        WebUtils.setCreateOrUpdateCommonProperties((BaseEntity)rayDevice);
        this.rayDeviceService.saveOrUpdate((Object)rayDevice);
        return ResponseData.success((Object)rayDevice);
    }

    @GetMapping(value={"/delete"})
    public ResponseData<Object> delete(Long id) {
        this.rayDeviceService.logicDel((Number)id);
        return ResponseData.success(null);
    }

    @PostMapping(value={"/queryByCheck"})
    public ResponseData<IPage<RayDevice>> queryByCheck(@RequestBody CheckIdDto checkIdDto) {
        try {
            FieldCheckUtils.checkEmptyFields((Object)((Object)checkIdDto), (String[])new String[]{"checkId", "pageNum", "pageSize"});
        }
        catch (FieldValueIllegalException e) {
            e.printStackTrace();
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success((Object)this.rayDeviceService.queryByCheck(checkIdDto.getCheckId(), checkIdDto.getPageNum(), checkIdDto.getPageSize()));
    }
}

