/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.controller;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.services.hfi.api.entity.CheckSelectItem;
import cn.smarthse.services.hfi.api.service.ICheckSelectItemService;
import cn.smarthse.services.hfi.controller.BaseController;
import cn.smarthse.services.hfi.util.WebUtils;
import cn.smarthse.web.common.exception.FieldValueIllegalException;
import cn.smarthse.web.common.model.ResponseData;
import cn.smarthse.web.common.util.FieldCheckUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/targetStandard"})
public class CheckSelectItemController
extends BaseController {
    private ICheckSelectItemService selectItemService;

    @Autowired
    public void autowired(ICheckSelectItemService checkSelectItemService) {
        this.selectItemService = checkSelectItemService;
    }

    @GetMapping(value={"/query"})
    public ResponseData<List<CheckSelectItem>> getByItemAndStandard(@RequestParam(value="checkId") Long checkId) {
        return ResponseData.success((Object)this.selectItemService.getByCheck(checkId));
    }

    @PostMapping(value={"/update"})
    public ResponseData<List<CheckSelectItem>> update(@RequestBody List<CheckSelectItem> selectItems) {
        if (selectItems == null || selectItems.isEmpty()) {
            return ResponseData.success(new ArrayList(0));
        }
        for (CheckSelectItem selectItem : selectItems) {
            try {
                FieldCheckUtils.checkEmptyFields((Object)selectItem, (String[])new String[]{"checkId", "itemId"});
                WebUtils.setCreateCommonProperties((BaseEntity)selectItem);
            }
            catch (FieldValueIllegalException e) {
                e.printStackTrace();
                return ResponseData.fail((String)e.getMessage());
            }
        }
        this.selectItemService.updateCheckItems(selectItems);
        return ResponseData.success(selectItems);
    }
}

