/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.controller;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.controller.BaseController;
import cn.smarthse.services.hfi.util.WebUtils;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.web.common.exception.FieldValueIllegalException;
import cn.smarthse.web.common.model.ResponseData;
import cn.smarthse.web.common.util.FieldCheckUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/checkResult"})
public class CheckResultController
extends BaseController {
    private ICheckResultService checkResultService;
    @Autowired
    private IdWorker snowFlake;

    @Autowired
    public void autowired(ICheckResultService checkResultService) {
        this.checkResultService = checkResultService;
    }

    @PostMapping(value={"/addOrUpdate"})
    public ResponseData<Object> addOrUpdate(@RequestBody List<CheckResult> checkResults) {
        if (checkResults == null || checkResults.isEmpty()) {
            this.logger.warn("cn.smarthse.services.hfi.controller.CheckResultController.add::\u6dfb\u52a0\u68c0\u6d4b\u7ed3\u679c\uff0c\u53c2\u6570\u4e3a\u4e3a\u7a7a");
            return ResponseData.success(null);
        }
        long resultNo = this.snowFlake.nextId();
        for (CheckResult checkResult : checkResults) {
            try {
                FieldCheckUtils.checkEmptyFields((Object)checkResult, (String[])new String[]{"checkId", "cid", "targetId"});
                checkResult.setResultNo(Long.valueOf(resultNo));
                WebUtils.setCreateOrUpdateCommonProperties((BaseEntity)checkResult);
            }
            catch (FieldValueIllegalException e) {
                e.printStackTrace();
            }
        }
        this.checkResultService.addOrUpdate(checkResults);
        return ResponseData.success(null);
    }

    @GetMapping(value={"/getByItem"})
    public ResponseData<List<CheckResult>> getByItem(@RequestParam(value="checkId") Long checkId, @RequestParam(value="itemId") Long itemId) {
        if (checkId == null || itemId == null) {
            return ResponseData.fail((String)"checkId\u6216itemId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.checkResultService.queryResult(checkId, itemId);
        return ResponseData.success((Object)list);
    }
}

