/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.comservice;

import cn.smarthse.services.hfi.api.model.StatComModel;
import cn.smarthse.services.hfi.property.ComDbProperties;
import cn.smarthse.snowflake.IdWorker;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ComDbDataService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static String driver = "com.mysql.cj.jdbc.Driver";
    @Autowired
    private IdWorker snowFlake;
    @Autowired
    private ComDbProperties dbProperties;
    private String getAllStatComModelSql = " select t1.id as cid, t1.area_id as comAreaId,t1.belong_type as belongType,        t1.register_type AS registerType, t1.industry_category AS industryCategory,t1.company_type as companyType,t1.occupational_risk_classify as occupationalRiskClassify,        t2.province_id as provinceId,t2.province_name AS provinceName,        t2.city_id AS cityId,t2.city_name as cityName, t2.area_id AS areaId, t2.area_name AS areaName, t2.street_id AS streetId, t2.street_name AS streetName        from company_supervise_view t1 left join sys_area t2 on t1.area_id=t2.id        where t1.is_valid=true";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StatComModel> getAllStatComModel() {
        QueryRunner qr = new QueryRunner();
        String connId = "" + this.snowFlake.nextId();
        Connection conn = this.getConnection(connId);
        try {
            List result;
            List list = result = (List)qr.query(conn, this.getAllStatComModelSql, (ResultSetHandler)new BeanListHandler(StatComModel.class));
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.error("ComDbDataService::\u67e5\u8be2\u4f01\u4e1a\u7aef\u6570\u636egetAllStatComModel\u5f02\u5e38::", (Throwable)e);
            List<StatComModel> list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                conn.close();
                this.logger.info("\u4f01\u4e1a\u7aef\u6570\u636e\u5e93\u8fde\u63a5\u5df2\u5173\u95ed,connId=" + connId);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.logger.error("ComDbDataService::\u5173\u95ed\u8fde\u63a5\u5f02\u5e38:", (Throwable)e);
            }
        }
    }

    private Connection getConnection(String connId) {
        try {
            this.logger.info("\u83b7\u53d6\u4f01\u4e1a\u7aef\u6570\u636e\u8fde\u63a5,connId=" + connId);
            return DriverManager.getConnection(this.dbProperties.getUrl(), this.dbProperties.getUsername(), this.dbProperties.getPassword());
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.error("ComDbDataService::\u4f01\u4e1a\u7aef\u6570\u636e\u5e93\u83b7\u53d6\u8fde\u63a5\u5f02\u5e38::", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

