/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.checkparser.actualize;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.checkparser.BaseCheckDataParser;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class Parser7MicrowaveRadiationActualize
extends BaseCheckDataParser {
    private Integer[] targetIds = new Integer[]{57, 58, 58, 59, 60, 61, 62, 63, 148, 149, 150, 151};

    @Override
    protected List<CheckResult> doParseData(SheetModel sheetModel, ImportCheckParamBo param) throws ParseException {
        String sheetName = sheetModel.getSheetName();
        this.logger.info("\u89e3\u6790\u68c0\u6d4b\u6570\u636e->" + sheetName);
        List rows = sheetModel.getRows();
        if (rows.size() <= 1) {
            this.logger.warn(sheetName + "\u65e0\u68c0\u6d4b\u6570\u636e");
            return Collections.emptyList();
        }
        Long resultNo = null;
        Object exceptionMsg = "";
        LinkedList<CheckResult> list = new LinkedList<CheckResult>();
        for (int i = 1; i < rows.size(); ++i) {
            RowModel row = (RowModel)rows.get(i);
            resultNo = this.snowFlake.nextId();
            String type1 = "";
            String type2 = "";
            for (int j = 0; j < row.size(); ++j) {
                CheckResult result = new CheckResult();
                if (j != 1) {
                    list.add(result);
                }
                result.setTargetId(this.targetIds[j]);
                result.setResultNo(resultNo);
                Object value = (String)row.get(j);
                if (!(j != 0 && j != 1 && j != 2 && j != 3 && j != 7 || value != null && ((String)value).length() != 0)) {
                    exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue;
                }
                if (j == 1) {
                    type1 = this.getType1((String)value);
                }
                if (j == 2) {
                    type2 = this.getType2((String)value);
                    value = type1 + "," + type2;
                }
                if (j == 7) {
                    value = this.getJudgeResult((String)value);
                }
                if (j == 3 || j == 4 || j == 5 || j == 6) {
                    if (value != null) {
                        value = ((String)value).replaceAll(" ", "");
                    }
                    if (this.setRangeValue(result, (String)value)) continue;
                    exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u683c\u5f0f\u4e0d\u6b63\u786e";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue;
                }
                result.setCheckValue((String)value);
            }
        }
        if (((String)exceptionMsg).length() > 0) {
            throw new ParseException((String)exceptionMsg);
        }
        return list;
    }

    private String getType1(String value) {
        switch (value) {
            case "\u5168\u8eab\u8f90\u5c04": {
                return "1";
            }
            case "\u80a2\u4f53\u5c40\u90e8\u8f90\u5c04": {
                return "2";
            }
        }
        return "";
    }

    private String getType2(String value) {
        switch (value) {
            case "\u8fde\u7eed\u5fae\u6ce2": {
                return "1";
            }
            case "\u8109\u51b2\u5fae\u6ce2": {
                return "2";
            }
        }
        return "";
    }
}

