/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.checkparser.actualize;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.checkparser.BaseCheckDataParser;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class Parser4HighTemperatureActualize
extends BaseCheckDataParser {
    private Integer[] targetIds = new Integer[]{33, 34, 35, 36, 37, 136, 137, 138, 139};

    @Override
    protected List<CheckResult> doParseData(SheetModel sheetModel, ImportCheckParamBo param) throws ParseException {
        String sheetName = sheetModel.getSheetName();
        this.logger.info("\u89e3\u6790\u68c0\u6d4b\u6570\u636e->" + sheetName);
        List rows = sheetModel.getRows();
        if (rows.size() <= 1) {
            this.logger.warn(sheetName + "\u65e0\u68c0\u6d4b\u6570\u636e");
            return Collections.emptyList();
        }
        Long resultNo = null;
        LinkedList<CheckResult> list = new LinkedList<CheckResult>();
        Object exceptionMsg = "";
        for (int i = 1; i < rows.size(); ++i) {
            RowModel row = (RowModel)rows.get(i);
            resultNo = this.snowFlake.nextId();
            for (int j = 0; j < row.size(); ++j) {
                CheckResult result = new CheckResult();
                list.add(result);
                result.setTargetId(this.targetIds[j]);
                result.setResultNo(resultNo);
                String value = (String)row.get(j);
                if (j != 1 && (value == null || value.length() == 0)) {
                    exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue;
                }
                if (j == 2) {
                    value = "\u2160".equals(value) ? "1" : ("\u2161".equals(value) ? "2" : ("\u2162".equals(value) ? "3" : ("\u2163".equals(value) ? "4" : "")));
                }
                if (j == 4) {
                    value = this.getJudgeResult(value);
                }
                if (j == 1 || j == 3) {
                    if (value != null) {
                        value = value.replaceAll(" ", "");
                    }
                    if (this.setRangeValue(result, value)) continue;
                    exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u683c\u5f0f\u4e0d\u6b63\u786e";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue;
                }
                result.setCheckValue(value);
            }
        }
        if (((String)exceptionMsg).length() > 0) {
            throw new ParseException((String)exceptionMsg);
        }
        return list;
    }
}

