/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.hfi.checkparser.actualize;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.checkparser.BaseCheckDataParser;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class Parser13BiologyActualize
extends BaseCheckDataParser {
    private Integer[] odlTargetIds = new Integer[]{97, 98, 99, 101, 102, 104, 172, 173, 174, 175};
    private Integer[] newTargetIds = new Integer[]{97, 98, 100, 101, 103, 104, 172, 173, 174, 175};

    @Override
    protected List<CheckResult> doParseData(SheetModel sheetModel, ImportCheckParamBo param) throws ParseException {
        Integer[] targetIds = null;
        if (param.getStandardId().equals(1L)) {
            targetIds = this.odlTargetIds;
        } else if (param.getStandardId().equals(2L)) {
            targetIds = this.newTargetIds;
        }
        String sheetName = sheetModel.getSheetName();
        this.logger.info("\u89e3\u6790\u68c0\u6d4b\u6570\u636e->" + sheetName);
        List rows = sheetModel.getRows();
        if (rows.size() <= 2) {
            this.logger.warn(sheetName + "\u65e0\u68c0\u6d4b\u6570\u636e");
            return Collections.emptyList();
        }
        Long resultNo = null;
        LinkedList<CheckResult> list = new LinkedList<CheckResult>();
        Object exceptionMsg = "";
        block2: for (int i = 2; i < rows.size(); ++i) {
            RowModel row = (RowModel)rows.get(i);
            resultNo = this.snowFlake.nextId();
            int n = 0;
            for (int j = 0; j < row.size(); ++j) {
                CheckResult result = new CheckResult();
                list.add(result);
                result.setTargetId(targetIds[j]);
                result.setResultNo(resultNo);
                String value = (String)row.get(j);
                if (!(j != 0 && j != 1 && j != 5 || value != null && value.length() != 0)) {
                    exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue block2;
                }
                if (j == 1) {
                    try {
                        value = this.getFactorIdValue(value, "\u751f\u7269\u56e0\u7d20", param);
                    }
                    catch (ParseException e) {
                        exceptionMsg = (String)exceptionMsg + e.getMessage();
                        exceptionMsg = (String)exceptionMsg + "<br/>";
                        continue block2;
                    }
                }
                if (j == 5) {
                    value = this.getJudgeResult(value);
                }
                if (j == 2 || j == 3 || j == 4) {
                    if (value == null || value.isEmpty()) continue;
                    ++n;
                    if (value.contains("(") && value.contains(")")) {
                        String unit = value.substring(value.indexOf("(") + 1, value.length() - 1);
                        result.setUnit(unit);
                    }
                    if (value != null) {
                        value = value.replaceAll(" ", "");
                    }
                    if (this.setRangeValue(result, value)) continue;
                    exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u683c\u5f0f\u4e0d\u6b63\u786e";
                    exceptionMsg = (String)exceptionMsg + "<br/>";
                    continue;
                }
                result.setCheckValue(value);
            }
            if (n != 0) continue;
            exceptionMsg = (String)exceptionMsg + sheetName + "\u7b2c" + (i + 2) + "\u884c\u68c0\u6d4b\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a";
            exceptionMsg = (String)exceptionMsg + "<br/>";
        }
        if (((String)exceptionMsg).length() > 0) {
            throw new ParseException(ParseException.NO_FACTOR, (String)exceptionMsg);
        }
        return list;
    }
}

